/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.impl.SoftWrapModelImpl;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapDrawingType;
import com.intellij.openapi.editor.impl.view.EditorView;
import com.intellij.openapi.editor.impl.view.VisualLineFragmentsIterator;
import com.intellij.openapi.editor.impl.view.VisualLinesIterator;
import com.intellij.util.DocumentUtil;
import java.awt.geom.Point2D;
import java.util.Iterator;
import java.util.List;
import javax.swing.JScrollBar;
import org.jetbrains.annotations.NotNull;

class EditorCoordinateMapper {
    private static final Logger LOG = Logger.getInstance(EditorCoordinateMapper.class);
    private final EditorView myView;
    private final Document myDocument;
    private final FoldingModelImpl myFoldingModel;

    EditorCoordinateMapper(EditorView view) {
        this.myView = view;
        this.myDocument = this.myView.getEditor().getDocument();
        this.myFoldingModel = this.myView.getEditor().getFoldingModel();
    }

    int visualLineToY(int line) {
        return this.myView.getInsets().top + Math.max(0, line) * this.myView.getLineHeight();
    }

    int yToVisualLine(int y) {
        return Math.max(0, y - this.myView.getInsets().top) / this.myView.getLineHeight();
    }

    @NotNull
    LogicalPosition offsetToLogicalPosition(int offset) {
        LogicalPosition logicalPosition = this.myView.getLogicalPositionCache().offsetToLogicalPosition(offset);
        if (logicalPosition == null) {
            EditorCoordinateMapper.$$$reportNull$$$0(0);
        }
        return logicalPosition;
    }

    int logicalPositionToOffset(@NotNull LogicalPosition pos) {
        if (pos == null) {
            EditorCoordinateMapper.$$$reportNull$$$0(1);
        }
        return this.myView.getLogicalPositionCache().logicalPositionToOffset(pos);
    }

    @NotNull
    VisualPosition logicalToVisualPosition(@NotNull LogicalPosition pos, boolean beforeSoftWrap) {
        if (pos == null) {
            EditorCoordinateMapper.$$$reportNull$$$0(2);
        }
        int line = pos.line;
        int column = pos.column;
        int logicalLineCount = this.myDocument.getLineCount();
        if (line >= logicalLineCount) {
            VisualPosition visualPosition = new VisualPosition(line - logicalLineCount + this.myView.getEditor().getVisibleLineCount(), column, pos.leansForward);
            if (visualPosition == null) {
                EditorCoordinateMapper.$$$reportNull$$$0(3);
            }
            return visualPosition;
        }
        int offset = this.logicalPositionToOffset(pos);
        int visualLine = this.offsetToVisualLine(offset, beforeSoftWrap);
        int maxVisualColumn = 0;
        int maxLogicalColumn = 0;
        for (VisualLineFragmentsIterator.Fragment fragment : VisualLineFragmentsIterator.create(this.myView, offset, beforeSoftWrap)) {
            if (!pos.leansForward && offset == fragment.getVisualLineStartOffset()) {
                VisualPosition visualPosition = new VisualPosition(visualLine, fragment.getStartVisualColumn());
                if (visualPosition == null) {
                    EditorCoordinateMapper.$$$reportNull$$$0(4);
                }
                return visualPosition;
            }
            if (fragment.isCollapsedFoldRegion()) {
                int startLogicalLine = fragment.getStartLogicalLine();
                int endLogicalLine = fragment.getEndLogicalLine();
                int startLogicalColumn = fragment.getStartLogicalColumn();
                int endLogicalColumn = fragment.getEndLogicalColumn();
                if ((line > startLogicalLine || line == startLogicalLine && (column > startLogicalColumn || column == startLogicalColumn && pos.leansForward)) && (line < endLogicalLine || line == endLogicalLine && column < endLogicalColumn)) {
                    VisualPosition visualPosition = new VisualPosition(visualLine, fragment.getStartVisualColumn(), true);
                    if (visualPosition == null) {
                        EditorCoordinateMapper.$$$reportNull$$$0(5);
                    }
                    return visualPosition;
                }
                if (line == endLogicalLine && column == endLogicalColumn && !pos.leansForward) {
                    VisualPosition visualPosition = new VisualPosition(visualLine, fragment.getEndVisualColumn());
                    if (visualPosition == null) {
                        EditorCoordinateMapper.$$$reportNull$$$0(6);
                    }
                    return visualPosition;
                }
                maxLogicalColumn = startLogicalLine == endLogicalLine ? Math.max(maxLogicalColumn, endLogicalColumn) : endLogicalColumn;
            } else if (fragment.getCurrentInlay() == null) {
                int minColumn = fragment.getMinLogicalColumn();
                int maxColumn = fragment.getMaxLogicalColumn();
                if (line == fragment.getStartLogicalLine() && (column > minColumn && column < maxColumn || column == minColumn && pos.leansForward || column == maxColumn && !pos.leansForward)) {
                    VisualPosition visualPosition = new VisualPosition(visualLine, fragment.logicalToVisualColumn(column), fragment.isRtl() ^ pos.leansForward);
                    if (visualPosition == null) {
                        EditorCoordinateMapper.$$$reportNull$$$0(7);
                    }
                    return visualPosition;
                }
                maxLogicalColumn = Math.max(maxLogicalColumn, maxColumn);
            }
            maxVisualColumn = fragment.getEndVisualColumn();
        }
        int resultColumn = column - maxLogicalColumn + maxVisualColumn;
        if (resultColumn < 0) {
            if (maxVisualColumn > maxLogicalColumn) {
                resultColumn = Integer.MAX_VALUE;
            } else {
                LOG.error("Error converting " + pos + " to visual position", new Attachment[]{new Attachment("details.txt", String.format("offset: %d, visual line: %d, max logical column: %d, max visual column: %d", offset, visualLine, maxLogicalColumn, maxVisualColumn)), new Attachment("dump.txt", this.myView.getEditor().dumpState())});
                resultColumn = 0;
            }
        }
        VisualPosition visualPosition = new VisualPosition(visualLine, resultColumn, pos.leansForward);
        if (visualPosition == null) {
            EditorCoordinateMapper.$$$reportNull$$$0(8);
        }
        return visualPosition;
    }

    @NotNull
    LogicalPosition visualToLogicalPosition(@NotNull VisualPosition pos) {
        if (pos == null) {
            EditorCoordinateMapper.$$$reportNull$$$0(9);
        }
        int line = pos.line;
        int column = pos.column;
        int visualLineCount = this.myView.getEditor().getVisibleLineCount();
        if (line >= visualLineCount) {
            LogicalPosition logicalPosition = new LogicalPosition(line - visualLineCount + this.myDocument.getLineCount(), column, pos.leansRight);
            if (logicalPosition == null) {
                EditorCoordinateMapper.$$$reportNull$$$0(10);
            }
            return logicalPosition;
        }
        int offset = this.visualLineToOffset(line);
        int logicalLine = this.myDocument.getLineNumber(offset);
        int maxVisualColumn = 0;
        int maxLogicalColumn = 0;
        int maxOffset = offset;
        LogicalPosition delayedResult = null;
        for (VisualLineFragmentsIterator.Fragment fragment : VisualLineFragmentsIterator.create(this.myView, offset, false)) {
            if (delayedResult != null) {
                LogicalPosition logicalPosition = delayedResult.leanForward(fragment.getCurrentInlay() == null);
                if (logicalPosition == null) {
                    EditorCoordinateMapper.$$$reportNull$$$0(11);
                }
                return logicalPosition;
            }
            int minColumn = fragment.getStartVisualColumn();
            int maxColumn = fragment.getEndVisualColumn();
            if (column < minColumn || column == minColumn && !pos.leansRight) {
                LogicalPosition logicalPosition = this.offsetToLogicalPosition(offset);
                if (logicalPosition == null) {
                    EditorCoordinateMapper.$$$reportNull$$$0(12);
                }
                return logicalPosition;
            }
            if (column > minColumn && column < maxColumn || column == minColumn || column == maxColumn && !pos.leansRight) {
                if (column == maxColumn && fragment.getCurrentInlay() != null) {
                    delayedResult = new LogicalPosition(fragment.getEndLogicalLine(), fragment.getEndLogicalColumn(), true);
                } else {
                    LogicalPosition logicalPosition = new LogicalPosition(column == maxColumn ? fragment.getEndLogicalLine() : fragment.getStartLogicalLine(), fragment.visualToLogicalColumn(column), fragment.isCollapsedFoldRegion() ? column < maxColumn : fragment.getCurrentInlay() == null && fragment.isRtl() ^ pos.leansRight);
                    if (logicalPosition == null) {
                        EditorCoordinateMapper.$$$reportNull$$$0(13);
                    }
                    return logicalPosition;
                }
            }
            maxLogicalColumn = logicalLine == fragment.getEndLogicalLine() ? Math.max(maxLogicalColumn, fragment.getMaxLogicalColumn()) : fragment.getMaxLogicalColumn();
            maxVisualColumn = maxColumn;
            logicalLine = fragment.getEndLogicalLine();
            maxOffset = Math.max(maxOffset, fragment.getMaxOffset());
        }
        if (this.myView.getEditor().getSoftWrapModel().getSoftWrap(maxOffset) == null) {
            int resultColumn = column - maxVisualColumn + maxLogicalColumn;
            if (resultColumn < 0 && maxLogicalColumn > maxVisualColumn) {
                resultColumn = Integer.MAX_VALUE;
            }
            LogicalPosition logicalPosition = new LogicalPosition(logicalLine, resultColumn, true);
            if (logicalPosition == null) {
                EditorCoordinateMapper.$$$reportNull$$$0(14);
            }
            return logicalPosition;
        }
        LogicalPosition logicalPosition = this.offsetToLogicalPosition(maxOffset).leanForward(true);
        if (logicalPosition == null) {
            EditorCoordinateMapper.$$$reportNull$$$0(15);
        }
        return logicalPosition;
    }

    @NotNull
    VisualPosition offsetToVisualPosition(int offset, boolean leanTowardsLargerOffsets, boolean beforeSoftWrap) {
        VisualPosition visualPosition = this.logicalToVisualPosition(this.offsetToLogicalPosition(offset).leanForward(leanTowardsLargerOffsets), beforeSoftWrap);
        if (visualPosition == null) {
            EditorCoordinateMapper.$$$reportNull$$$0(16);
        }
        return visualPosition;
    }

    int visualPositionToOffset(VisualPosition visualPosition) {
        return this.logicalPositionToOffset(this.visualToLogicalPosition(visualPosition));
    }

    int offsetToVisualLine(int offset, boolean beforeSoftWrap) {
        int wrapIndex;
        int textLength = this.myDocument.getTextLength();
        if (offset < 0 || textLength == 0) {
            return 0;
        }
        offset = Math.min(offset, textLength);
        FoldRegion outermostCollapsed = this.myFoldingModel.getCollapsedRegionAtOffset(offset = DocumentUtil.alignToCodePointBoundary(this.myDocument, offset));
        if (outermostCollapsed != null && offset > outermostCollapsed.getStartOffset()) {
            assert (outermostCollapsed.isValid());
            offset = outermostCollapsed.getStartOffset();
            beforeSoftWrap = false;
        }
        int softWrapsBeforeOrAtOffset = (wrapIndex = this.myView.getEditor().getSoftWrapModel().getSoftWrapIndex(offset)) < 0 ? -wrapIndex - 1 : wrapIndex + (beforeSoftWrap ? 0 : 1);
        return this.myDocument.getLineNumber(offset) - this.myFoldingModel.getFoldedLinesCountBefore(offset) + softWrapsBeforeOrAtOffset;
    }

    int visualLineToOffset(int visualLine) {
        int start = 0;
        int end = this.myDocument.getTextLength();
        if (visualLine <= 0) {
            return start;
        }
        if (visualLine >= this.myView.getEditor().getVisibleLineCount()) {
            return end;
        }
        int current = 0;
        while (start <= end) {
            current = (start + end) / 2;
            int line = this.offsetToVisualLine(current, false);
            if (line < visualLine) {
                start = current + 1;
                continue;
            }
            if (line <= visualLine) break;
            end = current - 1;
        }
        return this.visualLineStartOffset(current, true);
    }

    private int visualLineStartOffset(int offset, boolean leanForward) {
        SoftWrap currentOrPrevWrap;
        EditorImpl editor = this.myView.getEditor();
        offset = DocumentUtil.alignToCodePointBoundary(this.myDocument, offset);
        int result2 = EditorUtil.getNotFoldedLineStartOffset(editor, offset);
        SoftWrapModelImpl softWrapModel = editor.getSoftWrapModel();
        List<? extends SoftWrap> softWraps = softWrapModel.getRegisteredSoftWraps();
        int currentOrPrevWrapIndex = softWrapModel.getSoftWrapIndex(offset);
        if (currentOrPrevWrapIndex < 0) {
            currentOrPrevWrap = (currentOrPrevWrapIndex = -currentOrPrevWrapIndex - 2) < 0 || currentOrPrevWrapIndex >= softWraps.size() ? null : softWraps.get(currentOrPrevWrapIndex);
        } else {
            SoftWrap softWrap = currentOrPrevWrap = leanForward ? softWraps.get(currentOrPrevWrapIndex) : null;
        }
        if (currentOrPrevWrap != null && currentOrPrevWrap.getStart() > result2) {
            result2 = currentOrPrevWrap.getStart();
        }
        return result2;
    }

    private float getStartX(int line) {
        return this.myView.getEditor().isRightAligned() ? this.getRightAlignmentLineStartX(line) : (float)this.myView.getInsets().left + (line == 0 ? this.myView.getPrefixTextWidthInPixels() : 0.0f);
    }

    float getRightAlignmentLineStartX(int visualLine) {
        float shift;
        this.checkRightAlignment();
        EditorImpl editor = this.myView.getEditor();
        int max = this.getRightAlignmentMarginX();
        float f = shift = visualLine == 0 ? this.myView.getPrefixTextWidthInPixels() : 0.0f;
        if (visualLine >= editor.getVisibleLineCount()) {
            return (float)max - shift;
        }
        int lineWidth = this.myView.getSizeManager().getVisualLineWidth(new VisualLinesIterator(editor, visualLine), false);
        return Math.max(max - lineWidth, 0);
    }

    int getRightAlignmentMarginX() {
        this.checkRightAlignment();
        EditorImpl editor = this.myView.getEditor();
        JScrollBar vsb = editor.getScrollPane().getVerticalScrollBar();
        int vsbWidth = vsb != null && editor.getVerticalScrollbarOrientation() == 1 ? vsb.getWidth() : 0;
        return editor.getContentComponent().getWidth() - this.myView.getInsets().right - editor.getSettings().getLineCursorWidth() - vsbWidth;
    }

    private void checkRightAlignment() {
        if (!this.myView.getEditor().isRightAligned()) {
            throw new IllegalStateException("Editor is not right-aligned");
        }
    }

    @NotNull
    VisualPosition xyToVisualPosition(@NotNull Point2D p) {
        if (p == null) {
            EditorCoordinateMapper.$$$reportNull$$$0(17);
        }
        int visualLine = this.yToVisualLine((int)p.getY());
        int lastColumn = 0;
        float x = this.getStartX(visualLine);
        float px = (float)p.getX();
        if (visualLine < this.myView.getEditor().getVisibleLineCount()) {
            int visualLineStartOffset = this.visualLineToOffset(visualLine);
            int maxOffset = 0;
            for (VisualLineFragmentsIterator.Fragment fragment : VisualLineFragmentsIterator.create(this.myView, visualLineStartOffset, false, true)) {
                if (px <= fragment.getStartX()) {
                    if (fragment.getStartVisualColumn() == 0) {
                        VisualPosition visualPosition = new VisualPosition(visualLine, 0);
                        if (visualPosition == null) {
                            EditorCoordinateMapper.$$$reportNull$$$0(18);
                        }
                        return visualPosition;
                    }
                    int markerWidth = this.myView.getEditor().getSoftWrapModel().getMinDrawingWidthInPixels(SoftWrapDrawingType.AFTER_SOFT_WRAP);
                    float indent = fragment.getStartX() - (float)markerWidth;
                    if (px <= indent) break;
                    boolean after2 = px >= indent + (float)(markerWidth / 2);
                    VisualPosition visualPosition = new VisualPosition(visualLine, fragment.getStartVisualColumn() - (after2 ? 0 : 1), !after2);
                    if (visualPosition == null) {
                        EditorCoordinateMapper.$$$reportNull$$$0(19);
                    }
                    return visualPosition;
                }
                float nextX = fragment.getEndX();
                if (px <= nextX) {
                    int[] column = fragment.xToVisualColumn(px);
                    VisualPosition visualPosition = new VisualPosition(visualLine, column[0], column[1] > 0);
                    if (visualPosition == null) {
                        EditorCoordinateMapper.$$$reportNull$$$0(20);
                    }
                    return visualPosition;
                }
                x = nextX;
                lastColumn = fragment.getEndVisualColumn();
                maxOffset = Math.max(maxOffset, fragment.getMaxOffset());
            }
            if (this.myView.getEditor().getSoftWrapModel().getSoftWrap(maxOffset) != null) {
                int markerWidth = this.myView.getEditor().getSoftWrapModel().getMinDrawingWidthInPixels(SoftWrapDrawingType.BEFORE_SOFT_WRAP_LINE_FEED);
                if (px <= x + (float)markerWidth) {
                    boolean after3 = px >= x + (float)(markerWidth / 2);
                    VisualPosition visualPosition = new VisualPosition(visualLine, lastColumn + (after3 ? 1 : 0), !after3);
                    if (visualPosition == null) {
                        EditorCoordinateMapper.$$$reportNull$$$0(21);
                    }
                    return visualPosition;
                }
                px -= (float)markerWidth;
                ++lastColumn;
            }
        }
        int plainSpaceWidth = this.myView.getPlainSpaceWidth();
        int remainingShift = (int)(px - x);
        int additionalColumns = remainingShift <= 0 ? 0 : (remainingShift + plainSpaceWidth / 2) / plainSpaceWidth;
        VisualPosition visualPosition = new VisualPosition(visualLine, lastColumn + additionalColumns, remainingShift > 0 && additionalColumns == (remainingShift - 1) / plainSpaceWidth);
        if (visualPosition == null) {
            EditorCoordinateMapper.$$$reportNull$$$0(22);
        }
        return visualPosition;
    }

    @NotNull
    Point2D visualPositionToXY(@NotNull VisualPosition pos) {
        if (pos == null) {
            EditorCoordinateMapper.$$$reportNull$$$0(23);
        }
        int visualLine = pos.line;
        int column = pos.column;
        int y = this.visualLineToY(visualLine);
        float x = this.getStartX(visualLine);
        int lastColumn = 0;
        if (visualLine < this.myView.getEditor().getVisibleLineCount()) {
            VisualLineFragmentsIterator.Fragment fragment;
            int startVisualColumn;
            int visualLineStartOffset = this.visualLineToOffset(visualLine);
            int maxOffset = 0;
            Iterator<VisualLineFragmentsIterator.Fragment> iterator = VisualLineFragmentsIterator.create(this.myView, visualLineStartOffset, false, true).iterator();
            while (iterator.hasNext() && column >= (startVisualColumn = (fragment = iterator.next()).getStartVisualColumn()) && (column != startVisualColumn || pos.leansRight)) {
                int endColumn = fragment.getEndVisualColumn();
                if (column < endColumn || column == endColumn && !pos.leansRight) {
                    Point2D.Double double_ = new Point2D.Double(fragment.visualColumnToX(column), y);
                    if (double_ == null) {
                        EditorCoordinateMapper.$$$reportNull$$$0(24);
                    }
                    return double_;
                }
                x = fragment.getEndX();
                lastColumn = endColumn;
                maxOffset = Math.max(maxOffset, fragment.getMaxOffset());
            }
            if (column > lastColumn && this.myView.getEditor().getSoftWrapModel().getSoftWrap(maxOffset) != null) {
                --column;
                x += (float)this.myView.getEditor().getSoftWrapModel().getMinDrawingWidthInPixels(SoftWrapDrawingType.BEFORE_SOFT_WRAP_LINE_FEED);
            }
        }
        int additionalShift = column <= lastColumn ? 0 : (column - lastColumn) * this.myView.getPlainSpaceWidth();
        Point2D.Double double_ = new Point2D.Double(x + (float)additionalShift, y);
        if (double_ == null) {
            EditorCoordinateMapper.$$$reportNull$$$0(25);
        }
        return double_;
    }

    @NotNull
    Point2D offsetToXY(int offset, boolean leanTowardsLargerOffsets, boolean beforeSoftWrap) {
        offset = Math.max(0, Math.min(this.myDocument.getTextLength(), offset));
        offset = DocumentUtil.alignToCodePointBoundary(this.myDocument, offset);
        int logicalLine = this.myDocument.getLineNumber(offset);
        int visualLine = this.offsetToVisualLine(offset, beforeSoftWrap);
        int visualLineStartOffset = this.visualLineToOffset(visualLine);
        int y = this.visualLineToY(visualLine);
        float x = this.getStartX(logicalLine);
        if (this.myDocument.getTextLength() > 0) {
            boolean firstFragment = true;
            for (VisualLineFragmentsIterator.Fragment fragment : VisualLineFragmentsIterator.create(this.myView, offset, beforeSoftWrap, true)) {
                if (firstFragment && offset == visualLineStartOffset && !leanTowardsLargerOffsets) {
                    x = fragment.getStartX();
                    break;
                }
                firstFragment = false;
                int minOffset = fragment.getMinOffset();
                int maxOffset = fragment.getMaxOffset();
                if (fragment.getCurrentInlay() == null && (offset > minOffset && offset < maxOffset || offset == minOffset && leanTowardsLargerOffsets || offset == maxOffset && !leanTowardsLargerOffsets)) {
                    x = fragment.offsetToX(offset);
                    break;
                }
                x = fragment.getEndX();
            }
        }
        Point2D.Double double_ = new Point2D.Double(x, y);
        if (double_ == null) {
            EditorCoordinateMapper.$$$reportNull$$$0(26);
        }
        return double_;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 17: 
            case 23: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 17: 
            case 23: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/view/EditorCoordinateMapper";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "offsetToLogicalPosition";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 17: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/view/EditorCoordinateMapper";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "logicalToVisualPosition";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "visualToLogicalPosition";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "offsetToVisualPosition";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "xyToVisualPosition";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "visualPositionToXY";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "offsetToXY";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "logicalPositionToOffset";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "logicalToVisualPosition";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "visualToLogicalPosition";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "xyToVisualPosition";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "visualPositionToXY";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 17: 
            case 23: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

