/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.richcopy;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.editorActions.CopyPastePostProcessor;
import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.MarkupIterator;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.FontFallbackIterator;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.editor.richcopy.FontMapper;
import com.intellij.openapi.editor.richcopy.model.SyntaxInfo;
import com.intellij.openapi.editor.richcopy.settings.RichCopySettings;
import com.intellij.openapi.editor.richcopy.view.HtmlTransferableData;
import com.intellij.openapi.editor.richcopy.view.RawTextWithMarkup;
import com.intellij.openapi.editor.richcopy.view.RtfTransferableData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.CharArrayUtil;
import java.awt.Color;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextWithMarkupProcessor
extends CopyPastePostProcessor<RawTextWithMarkup> {
    private static final Logger LOG = Logger.getInstance(TextWithMarkupProcessor.class);
    private List<RawTextWithMarkup> myResult;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<RawTextWithMarkup> collectTransferableData(PsiFile file2, Editor editor, int[] startOffsets, int[] endOffsets) {
        List list2;
        if (!RichCopySettings.getInstance().isEnabled()) {
            List<RawTextWithMarkup> list3 = Collections.emptyList();
            if (list3 == null) {
                TextWithMarkupProcessor.$$$reportNull$$$0(0);
            }
            return list3;
        }
        EditorHighlighter highlighter = null;
        try {
            int indentSymbolsToStrip;
            int firstLineStartOffset;
            RichCopySettings settings = RichCopySettings.getInstance();
            List carets = editor.getCaretModel().getAllCarets();
            Caret firstCaret = (Caret)carets.get(0);
            if (Registry.is((String)"editor.richcopy.strip.indents") && carets.size() == 1) {
                Pair<Integer, Integer> p = TextWithMarkupProcessor.calcIndentSymbolsToStrip(editor.getDocument(), firstCaret.getSelectionStart(), firstCaret.getSelectionEnd());
                firstLineStartOffset = (Integer)p.first;
                indentSymbolsToStrip = (Integer)p.second;
            } else {
                firstLineStartOffset = firstCaret.getSelectionStart();
                indentSymbolsToStrip = 0;
            }
            TextWithMarkupProcessor.logInitial(editor, startOffsets, endOffsets, indentSymbolsToStrip, firstLineStartOffset);
            CharSequence text2 = editor.getDocument().getCharsSequence();
            EditorColorsScheme schemeToUse = settings.getColorsScheme(editor.getColorsScheme());
            highlighter = HighlighterFactory.createHighlighter((VirtualFile)file2.getViewProvider().getVirtualFile(), (EditorColorsScheme)schemeToUse, (Project)file2.getProject());
            highlighter.setText(text2);
            MarkupModel markupModel = DocumentMarkupModel.forDocument(editor.getDocument(), file2.getProject(), false);
            Context context = new Context(text2, schemeToUse, indentSymbolsToStrip);
            int endOffset = 0;
            Caret prevCaret = null;
            for (Caret caret : carets) {
                int startOffsetToUse;
                int caretSelectionStart = caret.getSelectionStart();
                int caretSelectionEnd = caret.getSelectionEnd();
                int additionalShift = 0;
                if (caret == firstCaret) {
                    startOffsetToUse = firstLineStartOffset;
                } else {
                    startOffsetToUse = caretSelectionStart;
                    assert (prevCaret != null);
                    String prevCaretSelectedText = prevCaret.getSelectedText();
                    int fillStringLength = prevCaretSelectedText == null ? 0 : prevCaretSelectedText.length() - (prevCaret.getSelectionEnd() - prevCaret.getSelectionStart());
                    context.addCharacter(endOffset + fillStringLength);
                    additionalShift = fillStringLength + 1;
                }
                context.reset(endOffset - caretSelectionStart + additionalShift);
                endOffset = caretSelectionEnd;
                prevCaret = caret;
                if (endOffset <= startOffsetToUse) continue;
                MyMarkupIterator markupIterator = new MyMarkupIterator(text2, new CompositeRangeIterator(schemeToUse, new HighlighterRangeIterator(highlighter, startOffsetToUse, endOffset), new MarkupModelRangeIterator(markupModel, schemeToUse, startOffsetToUse, endOffset)), schemeToUse);
                try {
                    context.iterate(markupIterator, endOffset);
                }
                finally {
                    markupIterator.dispose();
                }
            }
            SyntaxInfo syntaxInfo = context.finish();
            TextWithMarkupProcessor.logSyntaxInfo(syntaxInfo);
            this.createResult(syntaxInfo, editor);
            list2 = (List)ObjectUtils.notNull(this.myResult, Collections.emptyList());
        }
        catch (Throwable t) {
            LOG.error("Error generating text with markup", new Attachment[]{new Attachment("exception", t), new Attachment("highlighter.txt", String.valueOf(highlighter))});
            List<RawTextWithMarkup> list4 = Collections.emptyList();
            if (list4 == null) {
                TextWithMarkupProcessor.$$$reportNull$$$0(2);
            }
            return list4;
        }
        if (list2 == null) {
            TextWithMarkupProcessor.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @Override
    public void processTransferableData(Project project2, Editor editor, RangeMarker bounds, int caretOffset, Ref<Boolean> indented, List<RawTextWithMarkup> values) {
    }

    void createResult(SyntaxInfo syntaxInfo, Editor editor) {
        this.myResult = new ArrayList<RawTextWithMarkup>(2);
        this.myResult.add(new HtmlTransferableData(syntaxInfo, EditorUtil.getTabSize(editor)));
        this.myResult.add(new RtfTransferableData(syntaxInfo));
    }

    private void setRawText(String rawText) {
        if (this.myResult == null) {
            return;
        }
        for (RawTextWithMarkup data : this.myResult) {
            data.setRawText(rawText);
        }
        this.myResult = null;
    }

    private static void logInitial(@NotNull Editor editor, @NotNull int[] startOffsets, @NotNull int[] endOffsets, int indentSymbolsToStrip, int firstLineStartOffset) {
        if (editor == null) {
            TextWithMarkupProcessor.$$$reportNull$$$0(3);
        }
        if (startOffsets == null) {
            TextWithMarkupProcessor.$$$reportNull$$$0(4);
        }
        if (endOffsets == null) {
            TextWithMarkupProcessor.$$$reportNull$$$0(5);
        }
        if (!LOG.isDebugEnabled()) {
            return;
        }
        StringBuilder buffer = new StringBuilder();
        Document document = editor.getDocument();
        CharSequence text2 = document.getCharsSequence();
        for (int i = 0; i < startOffsets.length; ++i) {
            int start = startOffsets[i];
            int lineStart = document.getLineStartOffset(document.getLineNumber(start));
            int end = endOffsets[i];
            int lineEnd = document.getLineEndOffset(document.getLineNumber(end));
            buffer.append("    region #").append(i).append(": ").append(start).append('-').append(end).append(", text at range ").append(lineStart).append('-').append(lineEnd).append(": \n'").append(text2.subSequence(lineStart, lineEnd)).append("'\n");
        }
        if (buffer.length() > 0) {
            buffer.setLength(buffer.length() - 1);
        }
        LOG.debug(String.format("Preparing syntax-aware text. Given: %s selection, indent symbols to strip=%d, first line start offset=%d, selected text:%n%s", startOffsets.length > 1 ? "block" : "regular", indentSymbolsToStrip, firstLineStartOffset, buffer));
    }

    private static void logSyntaxInfo(@NotNull SyntaxInfo info) {
        if (info == null) {
            TextWithMarkupProcessor.$$$reportNull$$$0(6);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Constructed syntax info: " + info);
        }
    }

    private static Pair<Integer, Integer> calcIndentSymbolsToStrip(@NotNull Document document, int startOffset, int endOffset) {
        if (document == null) {
            TextWithMarkupProcessor.$$$reportNull$$$0(7);
        }
        int startLine = document.getLineNumber(startOffset);
        int endLine = document.getLineNumber(endOffset);
        CharSequence text2 = document.getCharsSequence();
        int maximumCommonIndent = Integer.MAX_VALUE;
        int firstLineStart = startOffset;
        int firstLineEnd = startOffset;
        for (int line = startLine; line <= endLine; ++line) {
            int indent;
            int lineStartOffset = document.getLineStartOffset(line);
            int lineEndOffset = document.getLineEndOffset(line);
            if (line == startLine) {
                firstLineStart = lineStartOffset;
                firstLineEnd = lineEndOffset;
            }
            int nonWsOffset = lineEndOffset;
            for (int i = lineStartOffset; i < lineEndOffset && i - lineStartOffset < maximumCommonIndent && i < endOffset; ++i) {
                char c = text2.charAt(i);
                if (c == ' ' || c == '\t') continue;
                nonWsOffset = i;
                break;
            }
            if (nonWsOffset < lineEndOffset && (maximumCommonIndent = Math.min(maximumCommonIndent, indent = nonWsOffset - lineStartOffset)) == 0) break;
        }
        int startOffsetToUse = Math.min(firstLineEnd, Math.max(startOffset, firstLineStart + maximumCommonIndent));
        return Pair.create((Object)startOffsetToUse, (Object)maximumCommonIndent);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/richcopy/TextWithMarkupProcessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startOffsets";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endOffsets";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTransferableData";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/richcopy/TextWithMarkupProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "logInitial";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "logSyntaxInfo";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "calcIndentSymbolsToStrip";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class RawTextSetter
    implements CopyPastePreProcessor {
        private final TextWithMarkupProcessor myProcessor;

        public RawTextSetter(TextWithMarkupProcessor processor2) {
            this.myProcessor = processor2;
        }

        @Override
        @Nullable
        public String preprocessOnCopy(PsiFile file2, int[] startOffsets, int[] endOffsets, String text2) {
            this.myProcessor.setRawText(text2);
            return null;
        }

        @Override
        @NotNull
        public String preprocessOnPaste(Project project2, PsiFile file2, Editor editor, String text2, RawText rawText) {
            String string = text2;
            if (string == null) {
                RawTextSetter.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/richcopy/TextWithMarkupProcessor$RawTextSetter", "preprocessOnPaste"));
        }
    }

    private static class SegmentIterator {
        private final FontFallbackIterator myIterator = new FontFallbackIterator();
        private final CharSequence myCharSequence;
        private int myEndOffset;
        private boolean myAdvanceCalled;

        private SegmentIterator(CharSequence charSequence, FontPreferences fontPreferences) {
            this.myCharSequence = charSequence;
            this.myIterator.setPreferredFonts(fontPreferences);
        }

        public void reset(int startOffset, int endOffset, int fontStyle) {
            this.myIterator.setFontStyle(fontStyle);
            this.myIterator.start(this.myCharSequence, startOffset, endOffset);
            this.myEndOffset = endOffset;
            this.myAdvanceCalled = false;
        }

        public boolean atEnd() {
            return this.myIterator.atEnd() || this.myIterator.getEnd() == this.myEndOffset;
        }

        public void advance() {
            if (!this.myAdvanceCalled) {
                this.myAdvanceCalled = true;
                return;
            }
            this.myIterator.advance();
        }

        public int getCurrentStartOffset() {
            return this.myIterator.getStart();
        }

        public int getCurrentEndOffset() {
            return this.myIterator.getEnd();
        }

        public String getCurrentFontFamilyName() {
            return this.myIterator.getFont().getFamily();
        }
    }

    private static interface RangeIterator {
        public boolean atEnd();

        public void advance();

        public int getRangeStart();

        public int getRangeEnd();

        public TextAttributes getTextAttributes();

        public void dispose();
    }

    private static class HighlighterRangeIterator
    implements RangeIterator {
        private static final TextAttributes EMPTY_ATTRIBUTES = new TextAttributes();
        private final HighlighterIterator myIterator;
        private final int myStartOffset;
        private final int myEndOffset;
        private int myCurrentStart;
        private int myCurrentEnd;
        private TextAttributes myCurrentAttributes;

        public HighlighterRangeIterator(@NotNull EditorHighlighter highlighter, int startOffset, int endOffset) {
            if (highlighter == null) {
                HighlighterRangeIterator.$$$reportNull$$$0(0);
            }
            this.myStartOffset = startOffset;
            this.myEndOffset = endOffset;
            this.myIterator = highlighter.createIterator(startOffset);
        }

        @Override
        public boolean atEnd() {
            return this.myIterator.atEnd() || this.getCurrentStart() >= this.myEndOffset;
        }

        private int getCurrentStart() {
            return Math.max(this.myIterator.getStart(), this.myStartOffset);
        }

        private int getCurrentEnd() {
            return Math.min(this.myIterator.getEnd(), this.myEndOffset);
        }

        @Override
        public void advance() {
            this.myCurrentStart = this.getCurrentStart();
            this.myCurrentEnd = this.getCurrentEnd();
            this.myCurrentAttributes = this.myIterator.getTokenType() == TokenType.BAD_CHARACTER ? EMPTY_ATTRIBUTES : this.myIterator.getTextAttributes();
            this.myIterator.advance();
        }

        @Override
        public int getRangeStart() {
            return this.myCurrentStart;
        }

        @Override
        public int getRangeEnd() {
            return this.myCurrentEnd;
        }

        @Override
        public TextAttributes getTextAttributes() {
            return this.myCurrentAttributes;
        }

        @Override
        public void dispose() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/openapi/editor/richcopy/TextWithMarkupProcessor$HighlighterRangeIterator", "<init>"));
        }
    }

    private static class MarkupModelRangeIterator
    implements RangeIterator {
        private final boolean myUnsupportedModel;
        private final int myStartOffset;
        private final int myEndOffset;
        private final EditorColorsScheme myColorsScheme;
        private final Color myDefaultForeground;
        private final Color myDefaultBackground;
        private final MarkupIterator<RangeHighlighterEx> myIterator;
        private int myCurrentStart;
        private int myCurrentEnd;
        private TextAttributes myCurrentAttributes;
        private int myNextStart;
        private int myNextEnd;
        private TextAttributes myNextAttributes;

        private MarkupModelRangeIterator(@Nullable MarkupModel markupModel, @NotNull EditorColorsScheme colorsScheme, int startOffset, int endOffset) {
            if (colorsScheme == null) {
                MarkupModelRangeIterator.$$$reportNull$$$0(0);
            }
            this.myStartOffset = startOffset;
            this.myEndOffset = endOffset;
            this.myColorsScheme = colorsScheme;
            this.myDefaultForeground = colorsScheme.getDefaultForeground();
            this.myDefaultBackground = colorsScheme.getDefaultBackground();
            boolean bl = this.myUnsupportedModel = !(markupModel instanceof MarkupModelEx);
            if (this.myUnsupportedModel) {
                this.myIterator = null;
                return;
            }
            this.myIterator = ((MarkupModelEx)markupModel).overlappingIterator(startOffset, endOffset);
            try {
                this.findNextSuitableRange();
            }
            catch (Error | RuntimeException e) {
                this.myIterator.dispose();
                throw e;
            }
        }

        @Override
        public boolean atEnd() {
            return this.myUnsupportedModel || this.myNextAttributes == null;
        }

        @Override
        public void advance() {
            this.myCurrentStart = this.myNextStart;
            this.myCurrentEnd = this.myNextEnd;
            this.myCurrentAttributes = this.myNextAttributes;
            this.findNextSuitableRange();
        }

        private void findNextSuitableRange() {
            this.myNextAttributes = null;
            while (this.myIterator.hasNext()) {
                RangeHighlighterEx highlighter = (RangeHighlighterEx)this.myIterator.next();
                if (highlighter == null || !highlighter.isValid() || !MarkupModelRangeIterator.isInterestedInLayer(highlighter.getLayer())) continue;
                this.myNextStart = Math.max(highlighter.getStartOffset(), this.myStartOffset);
                this.myNextEnd = Math.min(highlighter.getEndOffset(), this.myEndOffset);
                if (this.myNextStart >= this.myEndOffset) break;
                if (this.myNextStart < this.myCurrentEnd) continue;
                TextAttributes attributes = null;
                Object tooltip = highlighter.getErrorStripeTooltip();
                if (tooltip instanceof HighlightInfo) {
                    HighlightInfo info = (HighlightInfo)tooltip;
                    TextAttributesKey key2 = info.forcedTextAttributesKey;
                    if (key2 == null) {
                        HighlightInfoType type2 = info.type;
                        key2 = type2.getAttributesKey();
                    }
                    if (key2 != null) {
                        attributes = this.myColorsScheme.getAttributes(key2);
                    }
                }
                if (attributes == null) continue;
                Color foreground = attributes.getForegroundColor();
                Color background = attributes.getBackgroundColor();
                if (!(foreground != null && !this.myDefaultForeground.equals(foreground) || background != null && !this.myDefaultBackground.equals(background) || attributes.getFontType() != 0)) continue;
                this.myNextAttributes = attributes;
                break;
            }
        }

        private static boolean isInterestedInLayer(int layer) {
            return layer != 2000 && layer != 6000 && layer != 5000 && layer != 4000 && layer != 5500;
        }

        @Override
        public int getRangeStart() {
            return this.myCurrentStart;
        }

        @Override
        public int getRangeEnd() {
            return this.myCurrentEnd;
        }

        @Override
        public TextAttributes getTextAttributes() {
            return this.myCurrentAttributes;
        }

        @Override
        public void dispose() {
            if (this.myIterator != null) {
                this.myIterator.dispose();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorsScheme", "com/intellij/openapi/editor/richcopy/TextWithMarkupProcessor$MarkupModelRangeIterator", "<init>"));
        }
    }

    private static class CompositeRangeIterator
    implements RangeIterator {
        @NotNull
        private final Color myDefaultForeground;
        @NotNull
        private final Color myDefaultBackground;
        private final IteratorWrapper[] myIterators;
        private final TextAttributes myMergedAttributes;
        private int overlappingRangesCount;
        private int myCurrentStart;
        private int myCurrentEnd;
        private final Comparator<IteratorWrapper> RANGE_SORTER;

        public CompositeRangeIterator(@NotNull EditorColorsScheme colorsScheme, RangeIterator ... iterators) {
            if (colorsScheme == null) {
                CompositeRangeIterator.$$$reportNull$$$0(0);
            }
            this.myMergedAttributes = new TextAttributes();
            this.RANGE_SORTER = new Comparator<IteratorWrapper>(){

                @Override
                public int compare(IteratorWrapper o1, IteratorWrapper o2) {
                    if (o1 == null) {
                        return 1;
                    }
                    if (o2 == null) {
                        return -1;
                    }
                    int startDiff = Math.max(o1.iterator.getRangeStart(), myCurrentEnd) - Math.max(o2.iterator.getRangeStart(), myCurrentEnd);
                    if (startDiff != 0) {
                        return startDiff;
                    }
                    return o2.order - o1.order;
                }
            };
            this.myDefaultForeground = colorsScheme.getDefaultForeground();
            this.myDefaultBackground = colorsScheme.getDefaultBackground();
            this.myIterators = new IteratorWrapper[iterators.length];
            for (int i = 0; i < iterators.length; ++i) {
                this.myIterators[i] = new IteratorWrapper(iterators[i], i);
            }
        }

        @Override
        public boolean atEnd() {
            boolean validIteratorExists = false;
            for (int i = 0; i < this.myIterators.length; ++i) {
                RangeIterator iterator;
                IteratorWrapper wrapper = this.myIterators[i];
                if (wrapper == null || (iterator = wrapper.iterator).atEnd() && (this.overlappingRangesCount <= 0 || i < this.overlappingRangesCount && iterator.getRangeEnd() <= this.myCurrentEnd)) continue;
                validIteratorExists = true;
            }
            return !validIteratorExists;
        }

        @Override
        public void advance() {
            IteratorWrapper wrapper;
            RangeIterator iterator;
            IteratorWrapper wrapper2;
            int i;
            int max = this.overlappingRangesCount == 0 ? this.myIterators.length : this.overlappingRangesCount;
            for (i = 0; i < max; ++i) {
                wrapper2 = this.myIterators[i];
                if (wrapper2 == null) continue;
                iterator = wrapper2.iterator;
                if (this.overlappingRangesCount > 0 && iterator.getRangeEnd() > this.myCurrentEnd) continue;
                if (iterator.atEnd()) {
                    iterator.dispose();
                    this.myIterators[i] = null;
                    continue;
                }
                iterator.advance();
            }
            Arrays.sort(this.myIterators, this.RANGE_SORTER);
            this.myCurrentStart = Math.max(this.myIterators[0].iterator.getRangeStart(), this.myCurrentEnd);
            this.myCurrentEnd = Integer.MAX_VALUE;
            for (i = 0; i < this.myIterators.length && (wrapper2 = this.myIterators[i]) != null; ++i) {
                iterator = wrapper2.iterator;
                int nearestBound = iterator.getRangeStart() > this.myCurrentStart ? iterator.getRangeStart() : iterator.getRangeEnd();
                this.myCurrentEnd = Math.min(this.myCurrentEnd, nearestBound);
            }
            this.overlappingRangesCount = 1;
            while (this.overlappingRangesCount < this.myIterators.length && (wrapper = this.myIterators[this.overlappingRangesCount]) != null && wrapper.iterator.getRangeStart() <= this.myCurrentStart) {
                ++this.overlappingRangesCount;
            }
        }

        @Override
        public int getRangeStart() {
            return this.myCurrentStart;
        }

        @Override
        public int getRangeEnd() {
            return this.myCurrentEnd;
        }

        @Override
        public TextAttributes getTextAttributes() {
            TextAttributes ta = this.myIterators[0].iterator.getTextAttributes();
            this.myMergedAttributes.setAttributes(ta.getForegroundColor(), ta.getBackgroundColor(), null, null, null, ta.getFontType());
            for (int i = 1; i < this.overlappingRangesCount; ++i) {
                this.merge(this.myIterators[i].iterator.getTextAttributes());
            }
            return this.myMergedAttributes;
        }

        private void merge(TextAttributes attributes) {
            Color myForeground;
            Color myBackground = this.myMergedAttributes.getBackgroundColor();
            if (myBackground == null || this.myDefaultBackground.equals(myBackground)) {
                this.myMergedAttributes.setBackgroundColor(attributes.getBackgroundColor());
            }
            if ((myForeground = this.myMergedAttributes.getForegroundColor()) == null || this.myDefaultForeground.equals(myForeground)) {
                this.myMergedAttributes.setForegroundColor(attributes.getForegroundColor());
            }
            if (this.myMergedAttributes.getFontType() == 0) {
                this.myMergedAttributes.setFontType(attributes.getFontType());
            }
        }

        @Override
        public void dispose() {
            for (IteratorWrapper wrapper : this.myIterators) {
                if (wrapper == null) continue;
                wrapper.iterator.dispose();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "colorsScheme", "com/intellij/openapi/editor/richcopy/TextWithMarkupProcessor$CompositeRangeIterator", "<init>"));
        }

        private static class IteratorWrapper {
            private final RangeIterator iterator;
            private final int order;

            private IteratorWrapper(RangeIterator iterator, int order) {
                this.iterator = iterator;
                this.order = order;
            }
        }
    }

    private static class MyMarkupIterator {
        private final SegmentIterator mySegmentIterator;
        private final RangeIterator myRangeIterator;
        private int myCurrentFontStyle;
        private Color myCurrentForegroundColor;
        private Color myCurrentBackgroundColor;

        private MyMarkupIterator(@NotNull CharSequence charSequence, @NotNull RangeIterator rangeIterator, @NotNull EditorColorsScheme colorsScheme) {
            if (charSequence == null) {
                MyMarkupIterator.$$$reportNull$$$0(0);
            }
            if (rangeIterator == null) {
                MyMarkupIterator.$$$reportNull$$$0(1);
            }
            if (colorsScheme == null) {
                MyMarkupIterator.$$$reportNull$$$0(2);
            }
            this.myRangeIterator = rangeIterator;
            this.mySegmentIterator = new SegmentIterator(charSequence, colorsScheme.getFontPreferences());
        }

        public boolean atEnd() {
            return this.myRangeIterator.atEnd() && this.mySegmentIterator.atEnd();
        }

        public void advance() {
            if (this.mySegmentIterator.atEnd()) {
                this.myRangeIterator.advance();
                TextAttributes textAttributes = this.myRangeIterator.getTextAttributes();
                this.myCurrentFontStyle = textAttributes == null ? 0 : textAttributes.getFontType();
                this.myCurrentForegroundColor = textAttributes == null ? null : textAttributes.getForegroundColor();
                this.myCurrentBackgroundColor = textAttributes == null ? null : textAttributes.getBackgroundColor();
                this.mySegmentIterator.reset(this.myRangeIterator.getRangeStart(), this.myRangeIterator.getRangeEnd(), this.myCurrentFontStyle);
            }
            this.mySegmentIterator.advance();
        }

        public int getStartOffset() {
            return this.mySegmentIterator.getCurrentStartOffset();
        }

        public int getEndOffset() {
            return this.mySegmentIterator.getCurrentEndOffset();
        }

        public int getFontStyle() {
            return this.myCurrentFontStyle;
        }

        @NotNull
        public String getFontFamilyName() {
            String string = this.mySegmentIterator.getCurrentFontFamilyName();
            if (string == null) {
                MyMarkupIterator.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nullable
        public Color getForegroundColor() {
            return this.myCurrentForegroundColor;
        }

        @Nullable
        public Color getBackgroundColor() {
            return this.myCurrentBackgroundColor;
        }

        public void dispose() {
            this.myRangeIterator.dispose();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "charSequence";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rangeIterator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "colorsScheme";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/richcopy/TextWithMarkupProcessor$MyMarkupIterator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/richcopy/TextWithMarkupProcessor$MyMarkupIterator";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFontFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class Context {
        private final SyntaxInfo.Builder builder;
        @NotNull
        private final CharSequence myText;
        @NotNull
        private final Color myDefaultForeground;
        @NotNull
        private final Color myDefaultBackground;
        @Nullable
        private Color myBackground;
        @Nullable
        private Color myForeground;
        @Nullable
        private String myFontFamilyName;
        private final int myIndentSymbolsToStrip;
        private int myFontStyle;
        private int myStartOffset;
        private int myOffsetShift;
        private int myIndentSymbolsToStripAtCurrentLine;

        Context(@NotNull CharSequence charSequence, @NotNull EditorColorsScheme scheme2, int indentSymbolsToStrip) {
            if (charSequence == null) {
                Context.$$$reportNull$$$0(0);
            }
            if (scheme2 == null) {
                Context.$$$reportNull$$$0(1);
            }
            this.myFontStyle = -1;
            this.myStartOffset = -1;
            this.myOffsetShift = 0;
            this.myText = charSequence;
            this.myDefaultForeground = scheme2.getDefaultForeground();
            this.myDefaultBackground = scheme2.getDefaultBackground();
            int javaFontSize = scheme2.getEditorFontSize();
            float fontSize = SystemInfo.isMac || ApplicationManager.getApplication().isHeadlessEnvironment() ? (float)javaFontSize : (float)javaFontSize * 72.0f / (float)Toolkit.getDefaultToolkit().getScreenResolution();
            this.builder = new SyntaxInfo.Builder(this.myDefaultForeground, this.myDefaultBackground, fontSize);
            this.myIndentSymbolsToStrip = indentSymbolsToStrip;
        }

        public void reset(int offsetShiftDelta) {
            this.myStartOffset = -1;
            this.myOffsetShift += offsetShiftDelta;
            this.myIndentSymbolsToStripAtCurrentLine = 0;
        }

        public void iterate(MyMarkupIterator iterator, int endOffset) {
            while (!iterator.atEnd()) {
                iterator.advance();
                int startOffset = iterator.getStartOffset();
                if (startOffset >= endOffset) break;
                if (this.myStartOffset < 0) {
                    this.myStartOffset = startOffset;
                }
                boolean whiteSpacesOnly = CharArrayUtil.isEmptyOrSpaces((CharSequence)this.myText, (int)startOffset, (int)iterator.getEndOffset());
                this.processBackground(startOffset, iterator.getBackgroundColor());
                if (whiteSpacesOnly) continue;
                this.processForeground(startOffset, iterator.getForegroundColor());
                this.processFontFamilyName(startOffset, iterator.getFontFamilyName());
                this.processFontStyle(startOffset, iterator.getFontStyle());
            }
            this.addTextIfPossible(endOffset);
        }

        private void processFontStyle(int startOffset, int fontStyle) {
            if (fontStyle != this.myFontStyle) {
                this.addTextIfPossible(startOffset);
                this.builder.addFontStyle(fontStyle);
                this.myFontStyle = fontStyle;
            }
        }

        private void processFontFamilyName(int startOffset, String fontName) {
            String fontFamilyName = FontMapper.getPhysicalFontName(fontName);
            if (!fontFamilyName.equals(this.myFontFamilyName)) {
                this.addTextIfPossible(startOffset);
                this.builder.addFontFamilyName(fontFamilyName);
                this.myFontFamilyName = fontFamilyName;
            }
        }

        private void processForeground(int startOffset, Color foreground) {
            if (this.myForeground == null && foreground != null) {
                this.addTextIfPossible(startOffset);
                this.myForeground = foreground;
                this.builder.addForeground(foreground);
            } else if (this.myForeground != null) {
                Color c;
                Color color = c = foreground == null ? this.myDefaultForeground : foreground;
                if (!this.myForeground.equals(c)) {
                    this.addTextIfPossible(startOffset);
                    this.builder.addForeground(c);
                    this.myForeground = c;
                }
            }
        }

        private void processBackground(int startOffset, Color background) {
            if (this.myBackground == null && background != null && !this.myDefaultBackground.equals(background)) {
                this.addTextIfPossible(startOffset);
                this.myBackground = background;
                this.builder.addBackground(background);
            } else if (this.myBackground != null) {
                Color c;
                Color color = c = background == null ? this.myDefaultBackground : background;
                if (!this.myBackground.equals(c)) {
                    this.addTextIfPossible(startOffset);
                    this.builder.addBackground(c);
                    this.myBackground = c;
                }
            }
        }

        private void addTextIfPossible(int endOffset) {
            if (endOffset <= this.myStartOffset) {
                return;
            }
            block5: for (int i = this.myStartOffset; i < endOffset; ++i) {
                char c = this.myText.charAt(i);
                switch (c) {
                    case '\r': {
                        if (i + 1 < this.myText.length() && this.myText.charAt(i + 1) == '\n') {
                            this.myIndentSymbolsToStripAtCurrentLine = this.myIndentSymbolsToStrip;
                            this.builder.addText(this.myStartOffset + this.myOffsetShift, i + this.myOffsetShift + 1);
                            this.myStartOffset = i + 2;
                            --this.myOffsetShift;
                            ++i;
                            continue block5;
                        }
                    }
                    case '\n': {
                        this.myIndentSymbolsToStripAtCurrentLine = this.myIndentSymbolsToStrip;
                        this.builder.addText(this.myStartOffset + this.myOffsetShift, i + this.myOffsetShift + 1);
                        this.myStartOffset = i + 1;
                        continue block5;
                    }
                    case '\t': 
                    case ' ': {
                        if (this.myIndentSymbolsToStripAtCurrentLine > 0) {
                            --this.myIndentSymbolsToStripAtCurrentLine;
                            ++this.myStartOffset;
                            continue block5;
                        }
                    }
                    default: {
                        this.myIndentSymbolsToStripAtCurrentLine = 0;
                    }
                }
            }
            if (this.myStartOffset < endOffset) {
                this.builder.addText(this.myStartOffset + this.myOffsetShift, endOffset + this.myOffsetShift);
                this.myStartOffset = endOffset;
            }
        }

        private void addCharacter(int position) {
            this.builder.addText(position + this.myOffsetShift, position + this.myOffsetShift + 1);
        }

        @NotNull
        public SyntaxInfo finish() {
            SyntaxInfo syntaxInfo = this.builder.build();
            if (syntaxInfo == null) {
                Context.$$$reportNull$$$0(2);
            }
            return syntaxInfo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "charSequence";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scheme";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/richcopy/TextWithMarkupProcessor$Context";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/richcopy/TextWithMarkupProcessor$Context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "finish";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

