/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.textarea;

import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.IndentsModel;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.SoftWrapModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.impl.EmptyIndentsModel;
import com.intellij.openapi.editor.impl.SettingsImpl;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.textarea.TextAreaDocument;
import com.intellij.openapi.editor.textarea.TextComponentCaretModel;
import com.intellij.openapi.editor.textarea.TextComponentDocument;
import com.intellij.openapi.editor.textarea.TextComponentEditor;
import com.intellij.openapi.editor.textarea.TextComponentFoldingModel;
import com.intellij.openapi.editor.textarea.TextComponentInlayModel;
import com.intellij.openapi.editor.textarea.TextComponentScrollingModel;
import com.intellij.openapi.editor.textarea.TextComponentSelectionModel;
import com.intellij.openapi.editor.textarea.TextComponentSoftWrapModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.ui.JBUI;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextComponentEditorImpl
extends UserDataHolderBase
implements TextComponentEditor {
    private final Project myProject;
    private final JTextComponent myTextComponent;
    private final TextComponentDocument myDocument;
    private final TextComponentCaretModel myCaretModel;
    private final TextComponentSelectionModel mySelectionModel;
    private final TextComponentScrollingModel myScrollingModel;
    private final TextComponentSoftWrapModel mySoftWrapModel;
    private final TextComponentFoldingModel myFoldingModel;
    private EditorSettings mySettings;

    public TextComponentEditorImpl(Project project2, @NotNull JTextComponent textComponent) {
        if (textComponent == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(0);
        }
        this.myProject = project2;
        this.myTextComponent = textComponent;
        this.myDocument = textComponent instanceof JTextArea ? new TextAreaDocument((JTextArea)textComponent) : new TextComponentDocument(textComponent);
        this.myCaretModel = new TextComponentCaretModel(textComponent, this);
        this.mySelectionModel = new TextComponentSelectionModel(textComponent, this);
        this.myScrollingModel = new TextComponentScrollingModel(textComponent);
        this.mySoftWrapModel = new TextComponentSoftWrapModel();
        this.myFoldingModel = new TextComponentFoldingModel();
    }

    @NotNull
    public Document getDocument() {
        TextComponentDocument textComponentDocument = this.myDocument;
        if (textComponentDocument == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(1);
        }
        return textComponentDocument;
    }

    public boolean isViewer() {
        return !this.myTextComponent.isEditable();
    }

    @NotNull
    public JComponent getComponent() {
        JTextComponent jTextComponent = this.myTextComponent;
        if (jTextComponent == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(2);
        }
        return jTextComponent;
    }

    @NotNull
    public JComponent getContentComponent() {
        JTextComponent jTextComponent = this.myTextComponent;
        if (jTextComponent == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(3);
        }
        return jTextComponent;
    }

    public void setBorder(@Nullable Border border) {
    }

    public Insets getInsets() {
        return JBUI.emptyInsets();
    }

    @NotNull
    public TextComponentSelectionModel getSelectionModel() {
        TextComponentSelectionModel textComponentSelectionModel = this.mySelectionModel;
        if (textComponentSelectionModel == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(4);
        }
        return textComponentSelectionModel;
    }

    @NotNull
    public MarkupModel getMarkupModel() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public FoldingModel getFoldingModel() {
        TextComponentFoldingModel textComponentFoldingModel = this.myFoldingModel;
        if (textComponentFoldingModel == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(5);
        }
        return textComponentFoldingModel;
    }

    @NotNull
    public ScrollingModel getScrollingModel() {
        TextComponentScrollingModel textComponentScrollingModel = this.myScrollingModel;
        if (textComponentScrollingModel == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(6);
        }
        return textComponentScrollingModel;
    }

    @NotNull
    public CaretModel getCaretModel() {
        TextComponentCaretModel textComponentCaretModel = this.myCaretModel;
        if (textComponentCaretModel == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(7);
        }
        return textComponentCaretModel;
    }

    @NotNull
    public SoftWrapModel getSoftWrapModel() {
        TextComponentSoftWrapModel textComponentSoftWrapModel = this.mySoftWrapModel;
        if (textComponentSoftWrapModel == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(8);
        }
        return textComponentSoftWrapModel;
    }

    @NotNull
    public InlayModel getInlayModel() {
        TextComponentInlayModel textComponentInlayModel = new TextComponentInlayModel();
        if (textComponentInlayModel == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(9);
        }
        return textComponentInlayModel;
    }

    @NotNull
    public EditorKind getEditorKind() {
        EditorKind editorKind = EditorKind.UNTYPED;
        if (editorKind == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(10);
        }
        return editorKind;
    }

    @NotNull
    public EditorSettings getSettings() {
        if (this.mySettings == null) {
            this.mySettings = new SettingsImpl();
        }
        EditorSettings editorSettings = this.mySettings;
        if (editorSettings == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(11);
        }
        return editorSettings;
    }

    @NotNull
    public EditorColorsScheme getColorsScheme() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int getLineHeight() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public Point logicalPositionToXY(@NotNull LogicalPosition pos) {
        if (pos == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(12);
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public int logicalPositionToOffset(@NotNull LogicalPosition pos) {
        if (pos == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(13);
        }
        if (pos.line >= this.myDocument.getLineCount()) {
            return this.myDocument.getTextLength();
        }
        return this.myDocument.getLineStartOffset(pos.line) + pos.column;
    }

    @NotNull
    public VisualPosition logicalToVisualPosition(@NotNull LogicalPosition logicalPos) {
        if (logicalPos == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(14);
        }
        VisualPosition visualPosition = new VisualPosition(logicalPos.line, logicalPos.column);
        if (visualPosition == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(15);
        }
        return visualPosition;
    }

    @NotNull
    public Point visualPositionToXY(@NotNull VisualPosition visible) {
        if (visible == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(16);
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public Point2D visualPositionToPoint2D(@NotNull VisualPosition pos) {
        if (pos == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(17);
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public LogicalPosition visualToLogicalPosition(@NotNull VisualPosition visiblePos) {
        if (visiblePos == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(18);
        }
        LogicalPosition logicalPosition = new LogicalPosition(visiblePos.line, visiblePos.column);
        if (logicalPosition == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(19);
        }
        return logicalPosition;
    }

    @NotNull
    public LogicalPosition offsetToLogicalPosition(int offset) {
        int line = this.myDocument.getLineNumber(offset);
        int lineStartOffset = this.myDocument.getLineStartOffset(line);
        LogicalPosition logicalPosition = new LogicalPosition(line, offset - lineStartOffset);
        if (logicalPosition == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(20);
        }
        return logicalPosition;
    }

    @NotNull
    public VisualPosition offsetToVisualPosition(int offset) {
        int line = this.myDocument.getLineNumber(offset);
        int lineStartOffset = this.myDocument.getLineStartOffset(line);
        VisualPosition visualPosition = new VisualPosition(line, offset - lineStartOffset);
        if (visualPosition == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(21);
        }
        return visualPosition;
    }

    @NotNull
    public VisualPosition offsetToVisualPosition(int offset, boolean leanForward, boolean beforeSoftWrap) {
        VisualPosition visualPosition = this.offsetToVisualPosition(offset);
        if (visualPosition == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(22);
        }
        return visualPosition;
    }

    @NotNull
    public LogicalPosition xyToLogicalPosition(@NotNull Point p) {
        if (p == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(23);
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public VisualPosition xyToVisualPosition(@NotNull Point p) {
        if (p == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(24);
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    @NotNull
    public VisualPosition xyToVisualPosition(@NotNull Point2D p) {
        if (p == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(25);
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public void addEditorMouseListener(@NotNull EditorMouseListener listener2) {
        if (listener2 == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(26);
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public void removeEditorMouseListener(@NotNull EditorMouseListener listener2) {
        if (listener2 == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(27);
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public void addEditorMouseMotionListener(@NotNull EditorMouseMotionListener listener2) {
        if (listener2 == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(28);
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public void removeEditorMouseMotionListener(@NotNull EditorMouseMotionListener listener2) {
        if (listener2 == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(29);
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isDisposed() {
        return false;
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    public boolean isInsertMode() {
        return true;
    }

    public boolean isColumnMode() {
        return false;
    }

    public boolean isOneLineMode() {
        return !(this.myTextComponent instanceof JTextArea);
    }

    @NotNull
    public EditorGutter getGutter() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Nullable
    public EditorMouseEventArea getMouseEventArea(@NotNull MouseEvent e) {
        if (e == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(30);
        }
        throw new UnsupportedOperationException("Not implemented");
    }

    public void setHeaderComponent(@Nullable JComponent header) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean hasHeaderComponent() {
        return false;
    }

    @Nullable
    public JComponent getHeaderComponent() {
        return null;
    }

    @NotNull
    public IndentsModel getIndentsModel() {
        EmptyIndentsModel emptyIndentsModel = new EmptyIndentsModel();
        if (emptyIndentsModel == null) {
            TextComponentEditorImpl.$$$reportNull$$$0(31);
        }
        return emptyIndentsModel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textComponent";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/textarea/TextComponentEditorImpl";
                break;
            }
            case 12: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logicalPos";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visible";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visiblePos";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/textarea/TextComponentEditorImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFoldingModel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getScrollingModel";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaretModel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSoftWrapModel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInlayModel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorKind";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "logicalToVisualPosition";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "visualToLogicalPosition";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "offsetToLogicalPosition";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "offsetToVisualPosition";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndentsModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 31: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "logicalPositionToXY";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "logicalPositionToOffset";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "logicalToVisualPosition";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "visualPositionToXY";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "visualPositionToPoint2D";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "visualToLogicalPosition";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "xyToLogicalPosition";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "xyToVisualPosition";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addEditorMouseListener";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "removeEditorMouseListener";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addEditorMouseMotionListener";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "removeEditorMouseMotionListener";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getMouseEventArea";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

