/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution.cmd;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.TailTypeDecorator;
import com.intellij.openapi.externalSystem.service.execution.cmd.ParametersListLexer;
import com.intellij.util.TextFieldCompletionProvider;
import groovyjarjarcommonscli.Option;
import groovyjarjarcommonscli.Options;
import org.jetbrains.annotations.NotNull;

public abstract class CommandLineCompletionProvider
extends TextFieldCompletionProvider {
    private final Options myOptions;

    public CommandLineCompletionProvider(Options options) {
        super(true);
        this.myOptions = options;
    }

    @Override
    @NotNull
    protected String getPrefix(@NotNull String currentTextPrefix) {
        if (currentTextPrefix == null) {
            CommandLineCompletionProvider.$$$reportNull$$$0(0);
        }
        ParametersListLexer lexer = new ParametersListLexer(currentTextPrefix);
        while (lexer.nextToken()) {
            if (lexer.getTokenEnd() != currentTextPrefix.length()) continue;
            String string = lexer.getCurrentToken();
            if (string == null) {
                CommandLineCompletionProvider.$$$reportNull$$$0(1);
            }
            return string;
        }
        if ("" == null) {
            CommandLineCompletionProvider.$$$reportNull$$$0(2);
        }
        return "";
    }

    protected LookupElement createLookupElement(@NotNull Option option, @NotNull String text2) {
        if (option == null) {
            CommandLineCompletionProvider.$$$reportNull$$$0(3);
        }
        if (text2 == null) {
            CommandLineCompletionProvider.$$$reportNull$$$0(4);
        }
        LookupElementBuilder res = LookupElementBuilder.create((String)text2);
        if (option.getDescription() != null) {
            return TailTypeDecorator.withTail(res.withTypeText(option.getDescription(), true), TailType.INSERT_SPACE);
        }
        return res;
    }

    protected abstract void addArgumentVariants(@NotNull CompletionResultSet var1);

    @Override
    protected void addCompletionVariants(@NotNull String text2, int offset, @NotNull String prefix, @NotNull CompletionResultSet result2) {
        if (text2 == null) {
            CommandLineCompletionProvider.$$$reportNull$$$0(5);
        }
        if (prefix == null) {
            CommandLineCompletionProvider.$$$reportNull$$$0(6);
        }
        if (result2 == null) {
            CommandLineCompletionProvider.$$$reportNull$$$0(7);
        }
        ParametersListLexer lexer = new ParametersListLexer(text2);
        int argCount = 0;
        while (lexer.nextToken() && offset >= lexer.getTokenStart()) {
            Option option2;
            if (offset <= lexer.getTokenEnd()) {
                if (argCount == 0) {
                    if (prefix.startsWith("--")) {
                        for (Option option2 : this.myOptions.getOptions()) {
                            if (option2.getLongOpt() == null) continue;
                            result2.addElement(this.createLookupElement(option2, "--" + option2.getLongOpt()));
                        }
                    } else if (prefix.startsWith("-")) {
                        for (Option option2 : this.myOptions.getOptions()) {
                            if (option2.getOpt() == null) continue;
                            result2.addElement(this.createLookupElement(option2, "-" + option2.getOpt()));
                        }
                    } else {
                        this.addArgumentVariants(result2);
                    }
                }
                return;
            }
            if (argCount > 0) {
                --argCount;
                continue;
            }
            String token = lexer.getCurrentToken();
            if (!token.startsWith("-") || (option2 = this.myOptions.getOption(token)) == null) continue;
            int optionArgCount = option2.getArgs();
            if (optionArgCount == -2) {
                argCount = Integer.MAX_VALUE;
                continue;
            }
            if (optionArgCount == -1) continue;
            argCount = optionArgCount;
        }
        if (argCount > 0) {
            return;
        }
        this.addArgumentVariants(result2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentTextPrefix";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/execution/cmd/CommandLineCompletionProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/cmd/CommandLineCompletionProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPrefix";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createLookupElement";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addCompletionVariants";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

