/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.notification;

import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.ide.errorTreeView.ErrorTreeElementKind;
import com.intellij.ide.errorTreeView.ErrorViewStructure;
import com.intellij.ide.errorTreeView.GroupingElement;
import com.intellij.ide.errorTreeView.NewEditableErrorTreeViewPanel;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.ExternalSystemConfigurableAware;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.LocationAwareExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.notification.EditableNotificationMessageElement;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationExtension;
import com.intellij.openapi.externalSystem.service.notification.MessageCounter;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationMessageElement;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalProjectsViewImpl;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NonNavigatable;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.MessageView;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemNotificationManager
implements Disposable {
    @NotNull
    private static final Key<Pair<NotificationSource, ProjectSystemId>> CONTENT_ID_KEY = Key.create((String)"CONTENT_ID");
    @NotNull
    private final MergingUpdateQueue myUpdateQueue;
    @Nullable
    private volatile Project myProject;
    @NotNull
    private final Set<Notification> myNotifications;
    @NotNull
    private final Map<Key, Notification> myUniqueNotifications;
    @NotNull
    private final Set<ProjectSystemId> initializedExternalSystem;
    @NotNull
    private final MessageCounter myMessageCounter;

    public ExternalSystemNotificationManager(@NotNull Project project2) {
        if (project2 == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(0);
        }
        this.myProject = project2;
        this.myNotifications = ContainerUtil.newConcurrentSet();
        this.myUniqueNotifications = ContainerUtil.newConcurrentMap();
        this.initializedExternalSystem = ContainerUtil.newConcurrentSet();
        this.myMessageCounter = new MessageCounter();
        this.myUpdateQueue = new MergingUpdateQueue(this.getClass() + " updates", 500, true, null, (Disposable)this, null, false);
    }

    @NotNull
    public static ExternalSystemNotificationManager getInstance(@NotNull Project project2) {
        if (project2 == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(1);
        }
        ExternalSystemNotificationManager externalSystemNotificationManager = (ExternalSystemNotificationManager)ServiceManager.getService((Project)project2, ExternalSystemNotificationManager.class);
        if (externalSystemNotificationManager == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(2);
        }
        return externalSystemNotificationManager;
    }

    public void processExternalProjectRefreshError(@NotNull Throwable error, @NotNull String externalProjectName, @NotNull ProjectSystemId externalSystemId) {
        if (error == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(3);
        }
        if (externalProjectName == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(4);
        }
        if (externalSystemId == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(5);
        }
        if (this.isDisposedOrNotOpen()) {
            return;
        }
        Project project2 = this.myProject;
        assert (project2 != null);
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)externalSystemId);
        if (!(manager instanceof ExternalSystemConfigurableAware)) {
            return;
        }
        NotificationData notificationData = this.createNotification(error, externalProjectName, externalSystemId, project2);
        EditorNotifications.getInstance((Project)project2).updateAllNotifications();
        this.showNotification(externalSystemId, notificationData);
    }

    @NotNull
    public NotificationData createNotification(@NotNull Throwable error, @NotNull String externalProjectName, @NotNull ProjectSystemId externalSystemId, @NotNull Project project2) {
        if (error == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(6);
        }
        if (externalProjectName == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(7);
        }
        if (externalSystemId == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(8);
        }
        if (project2 == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(9);
        }
        String title = ExternalSystemBundle.message((String)"notification.project.refresh.fail.title", (Object[])new Object[]{externalSystemId.getReadableName(), externalProjectName});
        String message2 = ExternalSystemApiUtil.buildErrorMessage((Throwable)error);
        NotificationCategory notificationCategory = NotificationCategory.ERROR;
        String filePath = null;
        Integer line = null;
        Integer column = null;
        Throwable unwrapped = RemoteUtil.unwrap((Throwable)error);
        if (unwrapped instanceof LocationAwareExternalSystemException) {
            LocationAwareExternalSystemException locationAwareExternalSystemException = (LocationAwareExternalSystemException)unwrapped;
            filePath = locationAwareExternalSystemException.getFilePath();
            line = locationAwareExternalSystemException.getLine();
            column = locationAwareExternalSystemException.getColumn();
        }
        NotificationData notificationData = new NotificationData(title, message2, notificationCategory, NotificationSource.PROJECT_SYNC, filePath, (Integer)ObjectUtils.notNull((Object)line, (Object)-1), (Integer)ObjectUtils.notNull((Object)column, (Object)-1), false);
        for (ExternalSystemNotificationExtension extension : (ExternalSystemNotificationExtension[])ExternalSystemNotificationExtension.EP_NAME.getExtensions()) {
            ProjectSystemId targetExternalSystemId = extension.getTargetExternalSystemId();
            if (!externalSystemId.equals((Object)targetExternalSystemId) && !targetExternalSystemId.equals((Object)ProjectSystemId.IDE)) continue;
            extension.customize(notificationData, project2, error);
        }
        NotificationData notificationData2 = notificationData;
        if (notificationData2 == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(10);
        }
        return notificationData2;
    }

    public boolean isNotificationActive(@NotNull Key<String> notificationKey) {
        Notification notification;
        if (notificationKey == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(11);
        }
        return (notification = this.myUniqueNotifications.get(notificationKey)) != null && !notification.isExpired();
    }

    public void showNotification(@NotNull ProjectSystemId externalSystemId, @NotNull NotificationData notificationData) {
        if (externalSystemId == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(12);
        }
        if (notificationData == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(13);
        }
        this.showNotification(externalSystemId, notificationData, null);
    }

    public void showNotification(final @NotNull ProjectSystemId externalSystemId, final @NotNull NotificationData notificationData, final @Nullable Key<String> notificationKey) {
        if (externalSystemId == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(14);
        }
        if (notificationData == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(15);
        }
        Disposer.register((Disposable)this, (Disposable)notificationData);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            PrintStream out = notificationData.getNotificationCategory() == NotificationCategory.INFO ? System.out : System.err;
            out.println(notificationData.getMessage());
            return;
        }
        if (notificationKey != null && this.isNotificationActive(notificationKey)) {
            return;
        }
        this.myUpdateQueue.queue(new Update(new Object()){

            public void run() {
                if (ExternalSystemNotificationManager.this.isDisposedOrNotOpen()) {
                    return;
                }
                assert (ExternalSystemNotificationManager.this.myProject != null);
                Project project2 = ExternalSystemNotificationManager.this.myProject;
                Application app = ApplicationManager.getApplication();
                Runnable action = () -> {
                    NotificationGroup group;
                    if (externalSystemId == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (notificationData == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (!ExternalSystemNotificationManager.this.initializedExternalSystem.contains(externalSystemId)) {
                        app.runWriteAction(() -> {
                            if (externalSystemId == null) {
                                1.$$$reportNull$$$0(2);
                            }
                            if (ExternalSystemNotificationManager.this.isDisposedOrNotOpen()) {
                                return;
                            }
                            ExternalSystemUtil.ensureToolWindowContentInitialized(project2, externalSystemId);
                            ExternalSystemNotificationManager.this.initializedExternalSystem.add(externalSystemId);
                        });
                    }
                    if (ExternalSystemNotificationManager.this.isDisposedOrNotOpen()) {
                        return;
                    }
                    if (notificationData.getBalloonGroup() == null) {
                        ExternalProjectsView externalProjectsView = ExternalProjectsManagerImpl.getInstance(project2).getExternalProjectsView(externalSystemId);
                        group = externalProjectsView instanceof ExternalProjectsViewImpl ? ((ExternalProjectsViewImpl)externalProjectsView).getNotificationGroup() : null;
                    } else {
                        NotificationGroup registeredGroup = NotificationGroup.findRegisteredGroup((String)notificationData.getBalloonGroup());
                        NotificationGroup notificationGroup = group = registeredGroup != null ? registeredGroup : NotificationGroup.balloonGroup((String)notificationData.getBalloonGroup());
                    }
                    if (group == null) {
                        return;
                    }
                    Notification notification = group.createNotification(notificationData.getTitle(), notificationData.getMessage(), notificationData.getNotificationCategory().getNotificationType(), notificationData.getListener());
                    if (notificationKey == null) {
                        ExternalSystemNotificationManager.this.myNotifications.add(notification);
                    } else {
                        Notification oldNotification = ExternalSystemNotificationManager.this.myUniqueNotifications.put(notificationKey, notification);
                        if (oldNotification != null) {
                            oldNotification.expire();
                        }
                    }
                    if (notificationData.isBalloonNotification()) {
                        ExternalSystemNotificationManager.this.applyNotification(notification);
                    } else {
                        ExternalSystemNotificationManager.this.addMessage(notification, externalSystemId, notificationData);
                    }
                };
                app.invokeLater(action, ModalityState.defaultModalityState(), project2.getDisposed());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "externalSystemId";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "notificationData";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/notification/ExternalSystemNotificationManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$run$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$null$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void openMessageView(@NotNull ProjectSystemId externalSystemId, @NotNull NotificationSource notificationSource) {
        if (externalSystemId == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(16);
        }
        if (notificationSource == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(17);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (externalSystemId == null) {
                ExternalSystemNotificationManager.$$$reportNull$$$0(41);
            }
            if (notificationSource == null) {
                ExternalSystemNotificationManager.$$$reportNull$$$0(42);
            }
            this.prepareMessagesView(externalSystemId, notificationSource, true);
        });
    }

    public void clearNotifications(@NotNull NotificationSource notificationSource, @NotNull ProjectSystemId externalSystemId) {
        if (notificationSource == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(18);
        }
        if (externalSystemId == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(19);
        }
        this.clearNotifications(null, notificationSource, externalSystemId);
    }

    public void clearNotifications(final @Nullable String groupName, @NotNull NotificationSource notificationSource, @NotNull ProjectSystemId externalSystemId) {
        if (notificationSource == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(20);
        }
        if (externalSystemId == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(21);
        }
        this.myMessageCounter.remove(groupName, notificationSource, externalSystemId);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        final Pair contentIdPair = Pair.create((Object)((Object)notificationSource), (Object)externalSystemId);
        this.myUpdateQueue.queue(new Update(new Object()){

            public void run() {
                if (ExternalSystemNotificationManager.this.isDisposedOrNotOpen()) {
                    return;
                }
                assert (ExternalSystemNotificationManager.this.myProject != null);
                Project project2 = ExternalSystemNotificationManager.this.myProject;
                Iterator iterator = ExternalSystemNotificationManager.this.myNotifications.iterator();
                while (iterator.hasNext()) {
                    Notification notification = (Notification)iterator.next();
                    if (groupName != null && !groupName.equals(notification.getGroupId())) continue;
                    notification.expire();
                    iterator.remove();
                }
                SmartList toRemove2 = new SmartList();
                ExternalSystemNotificationManager.this.myUniqueNotifications.forEach((arg_0, arg_1) -> 2.lambda$run$0(groupName, (List)toRemove2, arg_0, arg_1));
                toRemove2.forEach(ExternalSystemNotificationManager.this.myUniqueNotifications::remove);
                ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project2).getToolWindow(ToolWindowId.MESSAGES_WINDOW);
                if (toolWindow == null) {
                    return;
                }
                MessageView messageView = (MessageView)ServiceManager.getService((Project)project2, MessageView.class);
                UIUtil.invokeLaterIfNeeded(() -> {
                    if (project2.isDisposed()) {
                        return;
                    }
                    for (Content content : messageView.getContentManager().getContents()) {
                        if (content.isPinned() || !contentIdPair.equals(content.getUserData(CONTENT_ID_KEY))) continue;
                        if (groupName == null) {
                            messageView.getContentManager().removeContent(content, true);
                            continue;
                        }
                        assert (content.getComponent() instanceof NewEditableErrorTreeViewPanel);
                        NewEditableErrorTreeViewPanel errorTreeView = (NewEditableErrorTreeViewPanel)content.getComponent();
                        ErrorViewStructure errorViewStructure = errorTreeView.getErrorViewStructure();
                        errorViewStructure.removeGroup(groupName);
                    }
                });
            }

            private static /* synthetic */ void lambda$run$0(@Nullable String groupName2, List toRemove2, Key key2, Notification notification) {
                if (groupName2 == null || groupName2.equals(notification.getGroupId())) {
                    notification.expire();
                    toRemove2.add(key2);
                }
            }
        });
    }

    public int getMessageCount(@NotNull NotificationSource notificationSource, @Nullable NotificationCategory notificationCategory, @NotNull ProjectSystemId externalSystemId) {
        if (notificationSource == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(22);
        }
        if (externalSystemId == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(23);
        }
        return this.getMessageCount(null, notificationSource, notificationCategory, externalSystemId);
    }

    public int getMessageCount(@Nullable String groupName, @NotNull NotificationSource notificationSource, @Nullable NotificationCategory notificationCategory, @NotNull ProjectSystemId externalSystemId) {
        if (notificationSource == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(24);
        }
        if (externalSystemId == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(25);
        }
        return this.myMessageCounter.getCount(groupName, notificationSource, notificationCategory, externalSystemId);
    }

    private void addMessage(@NotNull Notification notification, @NotNull ProjectSystemId externalSystemId, @NotNull NotificationData notificationData) {
        int guiColumn;
        if (notification == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(26);
        }
        if (externalSystemId == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(27);
        }
        if (notificationData == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(28);
        }
        VirtualFile virtualFile = notificationData.getFilePath() != null ? ExternalSystemUtil.findLocalFileByPath(notificationData.getFilePath()) : null;
        String groupName = virtualFile != null ? virtualFile.getPresentableUrl() : notificationData.getTitle();
        this.myMessageCounter.increment(groupName, notificationData.getNotificationSource(), notificationData.getNotificationCategory(), externalSystemId);
        int line = notificationData.getLine() - 1;
        int column = notificationData.getColumn() - 1;
        if (virtualFile == null) {
            column = -1;
            line = -1;
        }
        int guiLine = line < 0 ? -1 : line + 1;
        int n = guiColumn = column < 0 ? 0 : column + 1;
        if (this.isDisposedOrNotOpen()) {
            return;
        }
        assert (this.myProject != null);
        Project project2 = this.myProject;
        Navigatable navigatable = notificationData.getNavigatable() != null ? notificationData.getNavigatable() : (virtualFile != null ? new OpenFileDescriptor(project2, virtualFile, line, column) : NonNavigatable.INSTANCE);
        ErrorTreeElementKind kind2 = ErrorTreeElementKind.convertMessageFromCompilerErrorType((int)notificationData.getNotificationCategory().getMessageCategory());
        String[] message2 = notificationData.getMessage().split("\n");
        String exportPrefix = NewErrorTreeViewPanel.createExportPrefix(guiLine);
        String rendererPrefix = NewErrorTreeViewPanel.createRendererPrefix(guiLine, guiColumn);
        UIUtil.invokeLaterIfNeeded(() -> {
            if (notificationData == null) {
                ExternalSystemNotificationManager.$$$reportNull$$$0(38);
            }
            if (externalSystemId == null) {
                ExternalSystemNotificationManager.$$$reportNull$$$0(39);
            }
            if (notification == null) {
                ExternalSystemNotificationManager.$$$reportNull$$$0(40);
            }
            boolean activate = notificationData.getNotificationCategory() == NotificationCategory.ERROR || notificationData.getNotificationCategory() == NotificationCategory.WARNING;
            NewErrorTreeViewPanel errorTreeView = this.prepareMessagesView(externalSystemId, notificationData.getNotificationSource(), activate);
            GroupingElement groupingElement = errorTreeView.getErrorViewStructure().getGroupingElement(groupName, null, virtualFile);
            NotificationMessageElement navigatableMessageElement = notificationData.hasLinks() ? new EditableNotificationMessageElement(notification, kind2, groupingElement, message2, navigatable, exportPrefix, rendererPrefix) : new NotificationMessageElement(kind2, groupingElement, message2, navigatable, exportPrefix, rendererPrefix);
            errorTreeView.getErrorViewStructure().addNavigatableMessage(groupName, navigatableMessageElement);
            errorTreeView.updateTree();
        });
    }

    private void applyNotification(@NotNull Notification notification) {
        if (notification == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(29);
        }
        if (!this.isDisposedOrNotOpen()) {
            notification.notify(this.myProject);
        }
    }

    @NotNull
    public NewErrorTreeViewPanel prepareMessagesView(@NotNull ProjectSystemId externalSystemId, @NotNull NotificationSource notificationSource, boolean activateView) {
        NewEditableErrorTreeViewPanel errorTreeView;
        if (externalSystemId == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(30);
        }
        if (notificationSource == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(31);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        String contentDisplayName = ExternalSystemNotificationManager.getContentDisplayName(notificationSource, externalSystemId);
        Pair contentIdPair = Pair.create((Object)((Object)notificationSource), (Object)externalSystemId);
        Content targetContent = this.findContent((Pair<NotificationSource, ProjectSystemId>)contentIdPair, contentDisplayName);
        assert (this.myProject != null);
        MessageView messageView = (MessageView)ServiceManager.getService((Project)this.myProject, MessageView.class);
        if (targetContent == null || !contentIdPair.equals(targetContent.getUserData(CONTENT_ID_KEY))) {
            errorTreeView = new NewEditableErrorTreeViewPanel(this.myProject, null, true, true, null);
            targetContent = ContentFactory.SERVICE.getInstance().createContent((JComponent)errorTreeView, contentDisplayName, true);
            targetContent.putUserData(CONTENT_ID_KEY, (Object)contentIdPair);
            messageView.getContentManager().addContent(targetContent);
            Disposer.register((Disposable)targetContent, (Disposable)errorTreeView);
        } else {
            assert (targetContent.getComponent() instanceof NewEditableErrorTreeViewPanel);
            errorTreeView = (NewEditableErrorTreeViewPanel)targetContent.getComponent();
        }
        messageView.getContentManager().setSelectedContent(targetContent);
        ToolWindow tw = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(ToolWindowId.MESSAGES_WINDOW);
        if (activateView && tw != null && !tw.isActive()) {
            tw.activate(null, false);
        }
        NewEditableErrorTreeViewPanel newEditableErrorTreeViewPanel = errorTreeView;
        if (newEditableErrorTreeViewPanel == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(32);
        }
        return newEditableErrorTreeViewPanel;
    }

    @Nullable
    private Content findContent(@NotNull Pair<NotificationSource, ProjectSystemId> contentIdPair, @NotNull String contentDisplayName) {
        if (contentIdPair == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(33);
        }
        if (contentDisplayName == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(34);
        }
        Content targetContent = null;
        assert (this.myProject != null);
        MessageView messageView = (MessageView)ServiceManager.getService((Project)this.myProject, MessageView.class);
        for (Content content : messageView.getContentManager().getContents()) {
            if (!contentIdPair.equals(content.getUserData(CONTENT_ID_KEY)) || !StringUtil.equals((CharSequence)content.getDisplayName(), (CharSequence)contentDisplayName) || content.isPinned()) continue;
            targetContent = content;
        }
        return targetContent;
    }

    @NotNull
    public static String getContentDisplayName(@NotNull NotificationSource notificationSource, @NotNull ProjectSystemId externalSystemId) {
        String contentDisplayName;
        if (notificationSource == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(35);
        }
        if (externalSystemId == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(36);
        }
        switch (notificationSource) {
            case PROJECT_SYNC: {
                contentDisplayName = ExternalSystemBundle.message((String)"notification.messages.project.sync.tab.name", (Object[])new Object[]{externalSystemId.getReadableName()});
                break;
            }
            case TASK_EXECUTION: {
                contentDisplayName = ExternalSystemBundle.message((String)"notification.messages.task.execution.tab.name", (Object[])new Object[]{externalSystemId.getReadableName()});
                break;
            }
            default: {
                throw new AssertionError((Object)("unsupported notification source found: " + (Object)((Object)notificationSource)));
            }
        }
        String string = contentDisplayName;
        if (string == null) {
            ExternalSystemNotificationManager.$$$reportNull$$$0(37);
        }
        return string;
    }

    public void dispose() {
        this.myProject = null;
        this.myNotifications.clear();
        this.myUniqueNotifications.clear();
        this.initializedExternalSystem.clear();
    }

    private boolean isDisposedOrNotOpen() {
        return this.myProject == null || this.myProject.isDisposed() || !this.myProject.isOpen();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 10: 
            case 32: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 10: 
            case 32: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 10: 
            case 32: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/notification/ExternalSystemNotificationManager";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectName";
                break;
            }
            case 5: 
            case 8: 
            case 12: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 30: 
            case 36: 
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationKey";
                break;
            }
            case 13: 
            case 15: 
            case 28: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationData";
                break;
            }
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 31: 
            case 35: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationSource";
                break;
            }
            case 26: 
            case 29: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentIdPair";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/notification/ExternalSystemNotificationManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createNotification";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareMessagesView";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 10: 
            case 32: 
            case 37: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processExternalProjectRefreshError";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createNotification";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isNotificationActive";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "showNotification";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "openMessageView";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "clearNotifications";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getMessageCount";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addMessage";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "applyNotification";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "prepareMessagesView";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findContent";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getContentDisplayName";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addMessage$1";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "lambda$openMessageView$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 10: 
            case 32: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

