/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.autoimport;

import com.intellij.ProjectTopics;
import com.intellij.ide.file.BatchFileChangeListener;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.externalSystem.ExternalSystemAutoImportAware;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskState;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemProcessingManager;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.autoimport.ExternalSystemProjectsWatcher;
import com.intellij.openapi.externalSystem.service.project.autoimport.FileChangeListenerBase;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.CRC32;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemProjectsWatcherImpl
extends ExternalSystemTaskNotificationListenerAdapter
implements ExternalSystemProjectsWatcher {
    private static final ExtensionPointName<Contributor> EP_NAME = ExtensionPointName.create((String)"com.intellij.externalProjectWatcherContributor");
    private static final Key<Long> CRC_WITHOUT_SPACES_CURRENT = Key.create((String)"ExternalSystemProjectsWatcher.CRC_WITHOUT_SPACES_CURRENT");
    private static final Key<Long> CRC_WITHOUT_SPACES_BEFORE_LAST_IMPORT = Key.create((String)"ExternalSystemProjectsWatcher.CRC_WITHOUT_SPACES_BEFORE_LAST_IMPORT");
    private static final int DOCUMENT_SAVE_DELAY = 1000;
    private final Project myProject;
    private final Set<Document> myChangedDocuments = new THashSet();
    private final MergingUpdateQueue myChangedDocumentsQueue;
    private final List<ExternalSystemAutoImportAware> myImportAwareManagers;
    private final MergingUpdateQueue myUpdatesQueue;
    private final Map<ProjectSystemId, MyNotification> myNotificationMap;
    private final MultiMap<String, String> myKnownAffectedFiles = MultiMap.createConcurrentSet();
    private final MultiMap<VirtualFilePointer, String> myFilesPointers = MultiMap.createConcurrentSet();
    private final List<LocalFileSystem.WatchRequest> myWatchedRoots = new ArrayList<LocalFileSystem.WatchRequest>();
    private final MergingUpdateQueue myRefreshRequestsQueue;

    public ExternalSystemProjectsWatcherImpl(Project project2) {
        this.myProject = project2;
        this.myChangedDocumentsQueue = new MergingUpdateQueue("ExternalSystemProjectsWatcher: Document changes queue", 1000, false, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this.myProject);
        this.myRefreshRequestsQueue = new MergingUpdateQueue("ExternalSystemProjectsWatcher: Refresh requests queue", 0, false, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this.myProject, null, false);
        this.myImportAwareManagers = ContainerUtil.newArrayList();
        for (ExternalSystemManager manager : ExternalSystemApiUtil.getAllManagers()) {
            if (!(manager instanceof ExternalSystemAutoImportAware)) continue;
            this.myImportAwareManagers.add((ExternalSystemAutoImportAware)manager);
            NotificationsConfiguration.getNotificationsConfiguration().register(manager.getSystemId().getReadableName() + " Import", NotificationDisplayType.STICKY_BALLOON, false);
        }
        this.myUpdatesQueue = new MergingUpdateQueue("ExternalSystemProjectsWatcher: Notifier queue", 500, false, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this.myProject);
        this.myNotificationMap = ContainerUtil.newConcurrentMap();
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.myProject).subscribe(BatchFileChangeListener.TOPIC, (Object)new BatchFileChangeListener(){

            @Override
            public void batchChangeStarted(Project project2) {
                ExternalSystemProjectsWatcherImpl.this.myRefreshRequestsQueue.suspend();
            }

            @Override
            public void batchChangeCompleted(Project project2) {
                ExternalSystemProjectsWatcherImpl.this.myRefreshRequestsQueue.resume();
            }
        });
    }

    public void markDirtyAllExternalProjects() {
        this.findLinkedProjectsSettings().forEach(this::scheduleUpdate);
        for (Contributor contributor : (Contributor[])EP_NAME.getExtensions()) {
            contributor.markDirtyAllExternalProjects(this.myProject);
        }
    }

    public void markDirty(Module module2) {
        this.scheduleUpdate(ExternalSystemApiUtil.getExternalProjectPath((Module)module2));
        for (Contributor contributor : (Contributor[])EP_NAME.getExtensions()) {
            contributor.markDirty(module2);
        }
    }

    public void markDirty(String projectPath) {
        this.scheduleUpdate(projectPath);
    }

    public synchronized void start() {
        if (ExternalSystemUtil.isNoBackgroundMode()) {
            return;
        }
        this.myUpdatesQueue.activate();
        MessageBusConnection myBusConnection = this.myProject.getMessageBus().connect((Disposable)this.myChangedDocumentsQueue);
        myBusConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new MyFileChangeListener(this));
        ExternalSystemProjectsWatcherImpl.makeUserAware(this.myChangedDocumentsQueue, this.myProject);
        this.myChangedDocumentsQueue.activate();
        this.myRefreshRequestsQueue.activate();
        DocumentListener myDocumentListener = new DocumentListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void documentChanged(DocumentEvent event) {
                Document doc = event.getDocument();
                VirtualFile file2 = FileDocumentManager.getInstance().getFile(doc);
                if (file2 == null) {
                    return;
                }
                String externalProjectPath = ExternalSystemProjectsWatcherImpl.this.getRelatedExternalProjectPath(file2);
                if (externalProjectPath == null) {
                    return;
                }
                Set set2 = ExternalSystemProjectsWatcherImpl.this.myChangedDocuments;
                synchronized (set2) {
                    ExternalSystemProjectsWatcherImpl.this.myChangedDocuments.add(doc);
                }
                ExternalSystemProjectsWatcherImpl.this.myChangedDocumentsQueue.queue(new Update((Object)ExternalSystemProjectsWatcherImpl.this){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Document[] copy;
                        Set set2 = ExternalSystemProjectsWatcherImpl.this.myChangedDocuments;
                        synchronized (set2) {
                            copy = ExternalSystemProjectsWatcherImpl.this.myChangedDocuments.toArray(new Document[ExternalSystemProjectsWatcherImpl.this.myChangedDocuments.size()]);
                            ExternalSystemProjectsWatcherImpl.this.myChangedDocuments.clear();
                        }
                        ExternalSystemUtil.invokeLater(ExternalSystemProjectsWatcherImpl.this.myProject, () -> new WriteAction(){

                            protected void run(@NotNull Result result2) {
                                if (result2 == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                for (Document each : copy) {
                                    PsiDocumentManager.getInstance((Project)ExternalSystemProjectsWatcherImpl.this.myProject).commitDocument(each);
                                    ((FileDocumentManagerImpl)FileDocumentManager.getInstance()).saveDocument(each, false);
                                }
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl$2$1$1", "run"));
                            }
                        }.execute());
                    }
                });
            }
        };
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener(myDocumentListener, (Disposable)myBusConnection);
        ((ExternalSystemProgressNotificationManager)ServiceManager.getService(ExternalSystemProgressNotificationManager.class)).addNotificationListener((ExternalSystemTaskNotificationListener)this);
        this.updateWatchedRoots(true);
        Disposer.register((Disposable)this.myChangedDocumentsQueue, () -> this.myFilesPointers.clear());
    }

    public synchronized void stop() {
        Disposer.dispose((Disposable)this.myChangedDocumentsQueue);
        Disposer.dispose((Disposable)this.myUpdatesQueue);
        Disposer.dispose((Disposable)this.myRefreshRequestsQueue);
        this.myNotificationMap.clear();
        ((ExternalSystemProgressNotificationManager)ServiceManager.getService(ExternalSystemProgressNotificationManager.class)).removeNotificationListener((ExternalSystemTaskNotificationListener)this);
    }

    public void onStart(@NotNull ExternalSystemTaskId id, final String workingDir) {
        if (id == null) {
            ExternalSystemProjectsWatcherImpl.$$$reportNull$$$0(0);
        }
        if (id.getType() == ExternalSystemTaskType.RESOLVE_PROJECT) {
            final ProjectSystemId systemId = id.getProjectSystemId();
            for (String filePath : ContainerUtil.newArrayList((Iterable)this.myKnownAffectedFiles.get((Object)workingDir))) {
                VirtualFile file2 = VfsUtil.findFileByIoFile((File)new File(filePath), (boolean)false);
                if (file2 == null || file2.isDirectory()) continue;
                file2.putUserData(CRC_WITHOUT_SPACES_BEFORE_LAST_IMPORT, file2.getUserData(CRC_WITHOUT_SPACES_CURRENT));
            }
            this.myUpdatesQueue.queue(new Update(Pair.create((Object)systemId, (Object)workingDir)){

                public void run() {
                    ExternalSystemProjectsWatcherImpl.this.doUpdateNotifications(true, systemId, workingDir);
                }
            });
        }
    }

    public void onSuccess(@NotNull ExternalSystemTaskId id) {
        if (id == null) {
            ExternalSystemProjectsWatcherImpl.$$$reportNull$$$0(1);
        }
        if (id.getType() == ExternalSystemTaskType.RESOLVE_PROJECT) {
            this.updateWatchedRoots(false);
        }
    }

    private void scheduleUpdate(String projectPath) {
        if (ExternalSystemUtil.isNoBackgroundMode()) {
            return;
        }
        Pair<ExternalSystemManager, ExternalProjectSettings> linkedProject = this.findLinkedProjectSettings(projectPath);
        if (linkedProject == null) {
            return;
        }
        this.scheduleUpdate(linkedProject);
    }

    private void scheduleUpdate(@NotNull Pair<ExternalSystemManager, ExternalProjectSettings> linkedProject) {
        if (linkedProject == null) {
            ExternalSystemProjectsWatcherImpl.$$$reportNull$$$0(2);
        }
        if (ExternalSystemUtil.isNoBackgroundMode()) {
            return;
        }
        ExternalSystemManager manager = (ExternalSystemManager)linkedProject.first;
        final String projectPath = ((ExternalProjectSettings)linkedProject.second).getExternalProjectPath();
        final ProjectSystemId systemId = manager.getSystemId();
        boolean useAutoImport = ((ExternalProjectSettings)linkedProject.second).isUseAutoImport();
        if (useAutoImport) {
            ExternalSystemTaskState taskState;
            ExternalSystemTask resolveTask = ((ExternalSystemProcessingManager)ServiceManager.getService(ExternalSystemProcessingManager.class)).findTask(ExternalSystemTaskType.RESOLVE_PROJECT, systemId, projectPath);
            ExternalSystemTaskState externalSystemTaskState = taskState = resolveTask == null ? null : resolveTask.getState();
            if (taskState == null || taskState.isStopped()) {
                this.addToRefreshQueue(projectPath, systemId);
            } else if (taskState != ExternalSystemTaskState.NOT_STARTED) {
                final ExternalSystemProgressNotificationManager progressManager = (ExternalSystemProgressNotificationManager)ServiceManager.getService(ExternalSystemProgressNotificationManager.class);
                ExternalSystemTaskNotificationListenerAdapter taskListener = new ExternalSystemTaskNotificationListenerAdapter(){

                    public void onEnd(@NotNull ExternalSystemTaskId id) {
                        if (id == null) {
                            4.$$$reportNull$$$0(0);
                        }
                        progressManager.removeNotificationListener((ExternalSystemTaskNotificationListener)this);
                        ExternalSystemProjectsWatcherImpl.this.addToRefreshQueue(projectPath, systemId);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl$4", "onEnd"));
                    }
                };
                progressManager.addNotificationListener(resolveTask.getId(), (ExternalSystemTaskNotificationListener)taskListener);
            }
        } else {
            this.myUpdatesQueue.queue(new Update(Pair.create((Object)systemId, (Object)projectPath)){

                public void run() {
                    ExternalSystemProjectsWatcherImpl.this.doUpdateNotifications(false, systemId, projectPath);
                }
            });
        }
    }

    private void addToRefreshQueue(final String projectPath, final ProjectSystemId systemId) {
        this.myRefreshRequestsQueue.queue(new Update(Pair.create((Object)systemId, (Object)projectPath)){

            public void run() {
                ExternalSystemProjectsWatcherImpl.scheduleRefresh(ExternalSystemProjectsWatcherImpl.this.myProject, projectPath, systemId, false);
            }
        });
    }

    private void updateWatchedRoots(boolean isProjectOpen) {
        SmartList pathsToWatch = new SmartList();
        this.myFilesPointers.clear();
        LocalFileSystem.getInstance().removeWatchedRoots(this.myWatchedRoots);
        HashMap pointerMap = ContainerUtil.newHashMap();
        for (ExternalSystemManager manager : ExternalSystemApiUtil.getAllManagers()) {
            if (!(manager instanceof ExternalSystemAutoImportAware)) continue;
            ExternalSystemAutoImportAware importAware = (ExternalSystemAutoImportAware)manager;
            for (ExternalProjectSettings settings : ((AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)this.myProject)).getLinkedProjectsSettings()) {
                List files = importAware.getAffectedExternalProjectFiles(settings.getExternalProjectPath(), this.myProject);
                long timeStamp = 0L;
                for (File file2 : files) {
                    timeStamp += file2.lastModified();
                }
                Map modificationStamps = ((AbstractExternalSystemLocalSettings)manager.getLocalSettingsProvider().fun((Object)this.myProject)).getExternalConfigModificationStamps();
                if (isProjectOpen && this.myProject.getUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT) != Boolean.TRUE) {
                    Long affectedFilesTimestamp = (Long)modificationStamps.get(settings.getExternalProjectPath());
                    affectedFilesTimestamp = affectedFilesTimestamp == null ? -1L : affectedFilesTimestamp;
                    if (timeStamp != affectedFilesTimestamp) {
                        this.scheduleUpdate(settings.getExternalProjectPath());
                    }
                } else {
                    modificationStamps.put(settings.getExternalProjectPath(), timeStamp);
                }
                for (File file3 : files) {
                    String path;
                    if (file3 == null || (path = ExternalSystemProjectsWatcherImpl.getNormalizedPath(file3)) == null) continue;
                    pathsToWatch.add(path);
                    String url = VfsUtilCore.pathToUrl((String)path);
                    VirtualFilePointer pointer = (VirtualFilePointer)pointerMap.get(url);
                    if (pointer == null) {
                        Long crc;
                        pointer = VirtualFilePointerManager.getInstance().create(url, (Disposable)this.myChangedDocumentsQueue, null);
                        pointerMap.put(url, pointer);
                        VirtualFile virtualFile = pointer.getFile();
                        if (virtualFile != null && (crc = (Long)virtualFile.getUserData(CRC_WITHOUT_SPACES_BEFORE_LAST_IMPORT)) != null) {
                            modificationStamps.put(path, crc);
                        }
                    }
                    this.myFilesPointers.putValue((Object)pointer, (Object)settings.getExternalProjectPath());
                }
            }
        }
        this.myWatchedRoots.addAll(LocalFileSystem.getInstance().addRootsToWatch((Collection)pathsToWatch, false));
    }

    @Nullable
    private String getRelatedExternalProjectPath(VirtualFile file2) {
        String path = file2.getPath();
        return this.getRelatedExternalProjectPath(path);
    }

    @Nullable
    private String getRelatedExternalProjectPath(String path) {
        ExternalSystemAutoImportAware importAware;
        String externalProjectPath = null;
        Iterator<ExternalSystemAutoImportAware> iterator = this.myImportAwareManagers.iterator();
        while (iterator.hasNext() && (externalProjectPath = (importAware = iterator.next()).getAffectedExternalProjectPath(path, this.myProject)) == null) {
        }
        if (externalProjectPath != null) {
            this.myKnownAffectedFiles.putValue(externalProjectPath, (Object)path);
        }
        return externalProjectPath;
    }

    private void doUpdateNotifications(boolean close, @NotNull ProjectSystemId systemId, @NotNull String projectPath) {
        if (systemId == null) {
            ExternalSystemProjectsWatcherImpl.$$$reportNull$$$0(3);
        }
        if (projectPath == null) {
            ExternalSystemProjectsWatcherImpl.$$$reportNull$$$0(4);
        }
        MyNotification notification = this.myNotificationMap.get(systemId);
        if (close) {
            if (notification == null) {
                return;
            }
            notification.projectPaths.remove(projectPath);
            if (notification.projectPaths.isEmpty()) {
                notification.expire();
            }
        } else {
            if (notification != null && !notification.isExpired()) {
                notification.projectPaths.add(projectPath);
                return;
            }
            notification = new MyNotification(this.myProject, this.myNotificationMap, systemId, projectPath);
            this.myNotificationMap.put(systemId, notification);
            Notifications.Bus.notify((Notification)notification, (Project)this.myProject);
        }
    }

    private static void scheduleRefresh(final @NotNull Project project2, String projectPath, ProjectSystemId systemId, boolean reportRefreshError) {
        if (project2 == null) {
            ExternalSystemProjectsWatcherImpl.$$$reportNull$$$0(5);
        }
        ExternalSystemUtil.refreshProject(project2, systemId, projectPath, new ExternalProjectRefreshCallback(){

            public void onSuccess(@Nullable DataNode<ProjectData> externalProject) {
                if (externalProject != null) {
                    ((ProjectDataManager)ServiceManager.getService(ProjectDataManager.class)).importData(externalProject, project2, true);
                }
            }

            public void onFailure(@NotNull String errorMessage, @Nullable String errorDetails) {
                if (errorMessage == null) {
                    7.$$$reportNull$$$0(0);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl$7", "onFailure"));
            }
        }, false, ProgressExecutionMode.IN_BACKGROUND_ASYNC, reportRefreshError);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void makeUserAware(final MergingUpdateQueue mergingUpdateQueue, Project project2) {
        AccessToken accessToken = ReadAction.start();
        try {
            EditorEventMulticaster multicaster = EditorFactory.getInstance().getEventMulticaster();
            multicaster.addCaretListener(new CaretListener(){

                public void caretPositionChanged(CaretEvent e) {
                    mergingUpdateQueue.restartTimer();
                }
            }, (Disposable)mergingUpdateQueue);
            multicaster.addDocumentListener(new DocumentListener(){

                public void documentChanged(DocumentEvent event) {
                    mergingUpdateQueue.restartTimer();
                }
            }, (Disposable)mergingUpdateQueue);
            project2.getMessageBus().connect((Disposable)mergingUpdateQueue).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){
                int beforeCalled;

                public void beforeRootsChange(ModuleRootEvent event) {
                    if (this.beforeCalled++ == 0) {
                        mergingUpdateQueue.suspend();
                    }
                }

                public void rootsChanged(ModuleRootEvent event) {
                    if (this.beforeCalled == 0) {
                        return;
                    }
                    if (--this.beforeCalled == 0) {
                        mergingUpdateQueue.resume();
                        mergingUpdateQueue.restartTimer();
                    }
                }
            });
        }
        finally {
            accessToken.finish();
        }
    }

    @Nullable
    private Pair<ExternalSystemManager, ExternalProjectSettings> findLinkedProjectSettings(String projectPath) {
        ExternalProjectSettings[] linkedProjectSettings = new ExternalProjectSettings[1];
        Optional<ExternalSystemManager> systemManager = ExternalSystemApiUtil.getAllManagers().stream().filter(m -> {
            linkedProjectSettings[0] = ((AbstractExternalSystemSettings)m.getSettingsProvider().fun((Object)this.myProject)).getLinkedProjectSettings(projectPath);
            return linkedProjectSettings[0] != null;
        }).findAny();
        if (!systemManager.isPresent()) {
            return null;
        }
        ExternalSystemManager manager = systemManager.get();
        return Pair.create((Object)manager, (Object)linkedProjectSettings[0]);
    }

    @NotNull
    private List<Pair<ExternalSystemManager, ExternalProjectSettings>> findLinkedProjectsSettings() {
        List<Pair<ExternalSystemManager, ExternalProjectSettings>> list2 = ExternalSystemApiUtil.getAllManagers().stream().flatMap(manager -> ((AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)this.myProject)).getLinkedProjectsSettings().stream().map(settings -> Pair.create((Object)manager, (Object)settings))).collect(Collectors.toList());
        if (list2 == null) {
            ExternalSystemProjectsWatcherImpl.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @Nullable
    private static String getNormalizedPath(@NotNull File file2) {
        String canonized;
        if (file2 == null) {
            ExternalSystemProjectsWatcherImpl.$$$reportNull$$$0(7);
        }
        return (canonized = PathUtil.getCanonicalPath((String)file2.getAbsolutePath())) == null ? null : FileUtil.toSystemIndependentName((String)canonized);
    }

    @NotNull
    private Long calculateCrc(VirtualFile file2) {
        Long newCrc;
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file2);
        if (psiFile != null) {
            final CRC32 crc32 = new CRC32();
            ApplicationManager.getApplication().runReadAction(() -> psiFile.acceptChildren((PsiElementVisitor)new PsiRecursiveElementVisitor(){

                public void visitElement(PsiElement element) {
                    String text2;
                    if (element instanceof LeafElement && !(element instanceof PsiWhiteSpace) && !(element instanceof PsiComment) && !(text2 = element.getText()).trim().isEmpty()) {
                        int end = text2.length();
                        for (int i = 0; i < end; ++i) {
                            crc32.update(text2.charAt(i));
                        }
                    }
                    super.visitElement(element);
                }
            }));
            newCrc = crc32.getValue();
        } else {
            newCrc = file2.getModificationStamp();
        }
        Long l = newCrc;
        if (l == null) {
            ExternalSystemProjectsWatcherImpl.$$$reportNull$$$0(8);
        }
        return l;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkedProject";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findLinkedProjectsSettings";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateCrc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "onStart";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "onSuccess";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "scheduleUpdate";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doUpdateNotifications";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "scheduleRefresh";
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @ApiStatus.Experimental
    public static interface Contributor {
        public void markDirtyAllExternalProjects(@NotNull Project var1);

        public void markDirty(@NotNull Module var1);
    }

    private class MyFileChangeListener
    extends FileChangeListenerBase {
        private final ExternalSystemProjectsWatcherImpl myWatcher;
        private MultiMap<String, String> myKnownFiles = MultiMap.createSet();
        private List<VirtualFile> filesToUpdate;
        private List<VirtualFile> filesToRemove;

        public MyFileChangeListener(ExternalSystemProjectsWatcherImpl watcher) {
            this.myWatcher = watcher;
        }

        @Override
        protected boolean isRelevant(String path) {
            if (!this.myKnownFiles.get((Object)path).isEmpty()) {
                return true;
            }
            for (VirtualFilePointer pointer : ExternalSystemProjectsWatcherImpl.this.myFilesPointers.keySet()) {
                VirtualFile f = pointer.getFile();
                if (f == null || !FileUtil.pathsEqual((String)path, (String)f.getPath())) continue;
                for (String projectPath : ExternalSystemProjectsWatcherImpl.this.myFilesPointers.get((Object)pointer)) {
                    this.myKnownFiles.putValue((Object)path, (Object)projectPath);
                    ExternalSystemProjectsWatcherImpl.this.myKnownAffectedFiles.putValue((Object)projectPath, (Object)path);
                }
                return true;
            }
            String affectedProjectPath = ExternalSystemProjectsWatcherImpl.this.getRelatedExternalProjectPath(path);
            if (affectedProjectPath != null) {
                this.myKnownFiles.putValue((Object)path, (Object)affectedProjectPath);
            }
            return affectedProjectPath != null;
        }

        @Override
        protected void updateFile(VirtualFile file2, VFileEvent event) {
            this.doUpdateFile(file2, event, false);
        }

        @Override
        protected void deleteFile(VirtualFile file2, VFileEvent event) {
            this.doUpdateFile(file2, event, true);
        }

        private void doUpdateFile(VirtualFile file2, VFileEvent event, boolean remove) {
            this.init();
            if (remove) {
                this.filesToRemove.add(file2);
            } else if (this.fileWasChanged(file2, event)) {
                this.filesToUpdate.add(file2);
            } else {
                for (String externalProjectPath : this.myKnownFiles.get((Object)file2.getPath())) {
                    this.handleRevertedChanges(externalProjectPath);
                }
            }
        }

        private void handleRevertedChanges(final String externalProjectPath) {
            for (Object filePath : ContainerUtil.newArrayList((Iterable)ExternalSystemProjectsWatcherImpl.this.myKnownAffectedFiles.get((Object)externalProjectPath))) {
                VirtualFile f = VfsUtil.findFileByIoFile((File)new File((String)filePath), (boolean)false);
                if (f != null && Objects.equals(f.getUserData(CRC_WITHOUT_SPACES_BEFORE_LAST_IMPORT), f.getUserData(CRC_WITHOUT_SPACES_CURRENT))) continue;
                return;
            }
            ProjectSystemId systemId = null;
            for (ExternalSystemManager manager : ExternalSystemApiUtil.getAllManagers()) {
                if (((AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)ExternalSystemProjectsWatcherImpl.this.myProject)).getLinkedProjectSettings(externalProjectPath) == null) continue;
                systemId = manager.getSystemId();
            }
            if (systemId != null) {
                final ProjectSystemId finalSystemId = systemId;
                ExternalSystemProjectsWatcherImpl.this.myUpdatesQueue.queue(new Update(Pair.create(finalSystemId, (Object)externalProjectPath)){

                    public void run() {
                        ExternalSystemProjectsWatcherImpl.this.doUpdateNotifications(true, finalSystemId, externalProjectPath);
                    }
                });
            }
        }

        private boolean fileWasChanged(VirtualFile file2, VFileEvent event) {
            if (!file2.isValid() || !(event instanceof VFileContentChangeEvent)) {
                return true;
            }
            Long newCrc = ExternalSystemProjectsWatcherImpl.this.calculateCrc(file2);
            file2.putUserData(CRC_WITHOUT_SPACES_CURRENT, (Object)newCrc);
            Long crc = (Long)file2.getUserData(CRC_WITHOUT_SPACES_BEFORE_LAST_IMPORT);
            if (crc == null) {
                file2.putUserData(CRC_WITHOUT_SPACES_BEFORE_LAST_IMPORT, (Object)newCrc);
                return true;
            }
            return !newCrc.equals(crc);
        }

        @Override
        protected void apply() {
            if (this.areFileSetsInitialised()) {
                this.filesToUpdate.removeAll(this.filesToRemove);
                this.scheduleUpdate(ContainerUtil.concat(this.filesToUpdate, this.filesToRemove));
            }
            this.clear();
        }

        private boolean areFileSetsInitialised() {
            return this.filesToUpdate != null;
        }

        private void scheduleUpdate(List<VirtualFile> filesToUpdate) {
            filesToUpdate.stream().flatMap(f -> this.myKnownFiles.get((Object)f.getPath()).stream()).distinct().forEach(path -> this.myWatcher.scheduleUpdate(path));
        }

        private void init() {
            if (this.areFileSetsInitialised()) {
                return;
            }
            this.filesToUpdate = new ArrayList<VirtualFile>();
            this.filesToRemove = new ArrayList<VirtualFile>();
        }

        private void clear() {
            this.filesToUpdate = null;
            this.filesToRemove = null;
            this.myKnownFiles.clear();
        }
    }

    private static class MyNotification
    extends Notification {
        private final ProjectSystemId mySystemId;
        private final Map<ProjectSystemId, MyNotification> myNotificationMap;
        private final Set<String> projectPaths;

        public MyNotification(final Project project2, Map<ProjectSystemId, MyNotification> notificationMap, final ProjectSystemId systemId, String projectPath) {
            super(systemId.getReadableName() + " Import", ExternalSystemBundle.message((String)"import.needed", (Object[])new Object[]{systemId.getReadableName()}), "<a href='reimport'>" + ExternalSystemBundle.message((String)"import.importChanged", (Object[])new Object[0]) + "</a> &nbsp;&nbsp;<a href='autoImport'>" + ExternalSystemBundle.message((String)"import.enableAutoImport", (Object[])new Object[0]) + "</a>", NotificationType.INFORMATION, null);
            this.mySystemId = systemId;
            this.myNotificationMap = notificationMap;
            this.projectPaths = ContainerUtil.newHashSet((Object[])new String[]{projectPath});
            this.setListener((NotificationListener)new NotificationListener.Adapter(){

                protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (notification == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (event == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    boolean isReimport = event.getDescription().equals("reimport");
                    boolean isAutoImport = event.getDescription().equals("autoImport");
                    projectPaths.stream().map(path -> ExternalSystemApiUtil.getSettings((Project)project2, (ProjectSystemId)systemId).getLinkedProjectSettings(path)).distinct().filter(Objects::nonNull).forEach(settings -> {
                        if (isReimport) {
                            ExternalSystemProjectsWatcherImpl.scheduleRefresh(project2, settings.getExternalProjectPath(), systemId, true);
                        }
                        if (isAutoImport) {
                            settings.setUseAutoImport(true);
                            ExternalSystemProjectsWatcherImpl.scheduleRefresh(project2, settings.getExternalProjectPath(), systemId, false);
                        }
                    });
                    notification.expire();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/openapi/externalSystem/service/project/autoimport/ExternalSystemProjectsWatcherImpl$MyNotification$1";
                    objectArray[2] = "hyperlinkActivated";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        public void expire() {
            super.expire();
            this.projectPaths.clear();
            this.myNotificationMap.remove(this.mySystemId);
        }
    }
}

