/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.SettingsSavingComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskPojo;
import com.intellij.openapi.externalSystem.model.internal.InternalExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.project.ExternalConfigPathAware;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectPojo;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManagerImpl;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Alarm;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Property;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="ExternalProjectsData", storages={@Storage(value="$WORKSPACE_FILE$")})
public class ExternalProjectsDataStorage
implements SettingsSavingComponent,
PersistentStateComponent<State> {
    private static final Logger LOG = Logger.getInstance(ExternalProjectsDataStorage.class);
    private static final String STORAGE_VERSION = ExternalProjectsDataStorage.class.getSimpleName() + ".1";
    @NotNull
    private final Project myProject;
    private final Alarm myAlarm;
    @NotNull
    private final Map<Pair<ProjectSystemId, File>, InternalExternalProjectInfo> myExternalRootProjects;
    private final AtomicBoolean changed;
    private State myState;

    public static ExternalProjectsDataStorage getInstance(@NotNull Project project2) {
        if (project2 == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(0);
        }
        return (ExternalProjectsDataStorage)ServiceManager.getService((Project)project2, ExternalProjectsDataStorage.class);
    }

    public ExternalProjectsDataStorage(@NotNull Project project2) {
        if (project2 == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(1);
        }
        this.myExternalRootProjects = ConcurrentCollectionFactory.createMap(ExternalSystemUtil.HASHING_STRATEGY);
        this.changed = new AtomicBoolean();
        this.myState = new State();
        this.myProject = project2;
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this.myProject);
    }

    public synchronized void load() {
        this.myExternalRootProjects.clear();
        try {
            Collection<InternalExternalProjectInfo> projectInfos = ExternalProjectsDataStorage.load(this.myProject);
            if (projectInfos.isEmpty()) {
                this.markDirtyAllExternalProjects();
            }
            for (InternalExternalProjectInfo projectInfo : projectInfos) {
                if (ExternalProjectsDataStorage.validate(projectInfo)) {
                    this.myExternalRootProjects.put((Pair<ProjectSystemId, File>)Pair.create((Object)projectInfo.getProjectSystemId(), (Object)new File(projectInfo.getExternalProjectPath())), projectInfo);
                    if (projectInfo.getLastImportTimestamp() == projectInfo.getLastSuccessfulImportTimestamp()) continue;
                    this.markDirty(projectInfo.getExternalProjectPath());
                    continue;
                }
                String projectPath = projectInfo.getNullSafeExternalProjectPath();
                if (projectPath == null) continue;
                this.markDirty(projectPath);
            }
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
            this.markDirtyAllExternalProjects();
        }
        this.mergeLocalSettings();
    }

    private void markDirtyAllExternalProjects() {
        ExternalProjectsManager.getInstance((Project)this.myProject).getExternalProjectsWatcher().markDirtyAllExternalProjects();
    }

    private void markDirty(String projectPath) {
        ExternalProjectsManager.getInstance((Project)this.myProject).getExternalProjectsWatcher().markDirty(projectPath);
    }

    private static boolean validate(InternalExternalProjectInfo externalProjectInfo) {
        try {
            DataNode<ProjectData> projectStructure = externalProjectInfo.getExternalProjectStructure();
            if (projectStructure == null) {
                return false;
            }
            ProjectDataManagerImpl.getInstance().ensureTheDataIsReadyToUse(projectStructure);
            return externalProjectInfo.getExternalProjectPath().equals(((ProjectData)projectStructure.getData()).getLinkedExternalProjectPath());
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return false;
        }
    }

    public synchronized void save() {
        if (!this.changed.compareAndSet(true, false)) {
            return;
        }
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest((Runnable)new MySaveTask(this.myProject, this.myExternalRootProjects.values()), 0);
    }

    synchronized void update(@NotNull ExternalProjectInfo externalProjectInfo) {
        if (externalProjectInfo == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(2);
        }
        this.restoreInclusionSettings((DataNode<ProjectData>)externalProjectInfo.getExternalProjectStructure());
        ProjectSystemId projectSystemId = externalProjectInfo.getProjectSystemId();
        String projectPath = externalProjectInfo.getExternalProjectPath();
        DataNode externalProjectStructure = externalProjectInfo.getExternalProjectStructure();
        long lastSuccessfulImportTimestamp = externalProjectInfo.getLastSuccessfulImportTimestamp();
        long lastImportTimestamp = externalProjectInfo.getLastImportTimestamp();
        Pair key2 = Pair.create((Object)projectSystemId, (Object)new File(projectPath));
        InternalExternalProjectInfo old = this.myExternalRootProjects.get(key2);
        if (old != null) {
            lastImportTimestamp = externalProjectInfo.getLastImportTimestamp();
            if (lastSuccessfulImportTimestamp == -1L) {
                lastSuccessfulImportTimestamp = old.getLastSuccessfulImportTimestamp();
            }
            externalProjectStructure = externalProjectInfo.getExternalProjectStructure() == null ? old.getExternalProjectStructure() : externalProjectInfo.getExternalProjectStructure().graphCopy();
        } else {
            externalProjectStructure = externalProjectStructure != null ? externalProjectStructure.graphCopy() : null;
        }
        InternalExternalProjectInfo merged = new InternalExternalProjectInfo(projectSystemId, projectPath, (DataNode<ProjectData>)externalProjectStructure);
        merged.setLastImportTimestamp(lastImportTimestamp);
        merged.setLastSuccessfulImportTimestamp(lastSuccessfulImportTimestamp);
        this.myExternalRootProjects.put((Pair<ProjectSystemId, File>)key2, merged);
        this.changed.set(true);
    }

    synchronized void restoreInclusionSettings(@Nullable DataNode<ProjectData> projectDataNode) {
        if (projectDataNode == null) {
            return;
        }
        String rootProjectPath = ((ProjectData)projectDataNode.getData()).getLinkedExternalProjectPath();
        ProjectState projectState = this.myState.map.get(rootProjectPath);
        if (projectState == null) {
            return;
        }
        ExternalSystemApiUtil.visit(projectDataNode, node -> {
            DataNode<ExternalConfigPathAware> projectOrModuleNode = ExternalProjectsDataStorage.resolveProjectNode(node);
            assert (projectOrModuleNode != null);
            ModuleState moduleState = projectState.map.get(((ExternalConfigPathAware)projectOrModuleNode.getData()).getLinkedExternalProjectPath());
            node.setIgnored(ExternalProjectsDataStorage.isIgnored(projectState, moduleState, node.getKey()));
        });
    }

    synchronized void saveInclusionSettings(@Nullable DataNode<ProjectData> projectDataNode) {
        MultiMap map;
        if (projectDataNode == null) {
            return;
        }
        MultiMap inclusionMap = MultiMap.create();
        MultiMap exclusionMap = MultiMap.create();
        ExternalSystemApiUtil.visit(projectDataNode, dataNode -> {
            try {
                dataNode.getDataBytes();
                DataNode<ExternalConfigPathAware> projectNode = ExternalProjectsDataStorage.resolveProjectNode(dataNode);
                if (projectNode != null) {
                    String projectPath = ((ExternalConfigPathAware)projectNode.getData()).getLinkedExternalProjectPath();
                    if (projectNode.isIgnored() || dataNode.isIgnored()) {
                        exclusionMap.putValue((Object)projectPath, (Object)dataNode.getKey().getDataType());
                    } else {
                        inclusionMap.putValue((Object)projectPath, (Object)dataNode.getKey().getDataType());
                    }
                }
            }
            catch (IOException e) {
                dataNode.clear(true);
            }
        });
        ProjectState projectState = new ProjectState();
        if (inclusionMap.size() < exclusionMap.size()) {
            projectState.isInclusion = true;
            map = inclusionMap;
        } else {
            projectState.isInclusion = false;
            map = exclusionMap;
        }
        for (String path : map.keySet()) {
            projectState.map.put(path, new ModuleState(map.get((Object)path)));
        }
        this.myState.map.put(((ProjectData)projectDataNode.getData()).getLinkedExternalProjectPath(), projectState);
        this.changed.set(true);
    }

    @Nullable
    synchronized ExternalProjectInfo get(@NotNull ProjectSystemId projectSystemId, @NotNull String externalProjectPath) {
        if (projectSystemId == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(3);
        }
        if (externalProjectPath == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(4);
        }
        return this.myExternalRootProjects.get(Pair.create((Object)projectSystemId, (Object)new File(externalProjectPath)));
    }

    synchronized void remove(@NotNull ProjectSystemId projectSystemId, @NotNull String externalProjectPath) {
        InternalExternalProjectInfo removed;
        if (projectSystemId == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(5);
        }
        if (externalProjectPath == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(6);
        }
        if ((removed = this.myExternalRootProjects.remove(Pair.create((Object)projectSystemId, (Object)new File(externalProjectPath)))) != null) {
            this.changed.set(true);
        }
    }

    @NotNull
    synchronized Collection<ExternalProjectInfo> list(@NotNull ProjectSystemId projectSystemId) {
        if (projectSystemId == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(7);
        }
        List list2 = ContainerUtil.mapNotNull(this.myExternalRootProjects.values(), info -> {
            if (projectSystemId == null) {
                ExternalProjectsDataStorage.$$$reportNull$$$0(30);
            }
            return projectSystemId.equals((Object)info.getProjectSystemId()) ? info : null;
        });
        if (list2 == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(8);
        }
        return list2;
    }

    private void mergeLocalSettings() {
        for (ExternalSystemManager manager : ExternalSystemApiUtil.getAllManagers()) {
            ProjectSystemId systemId = manager.getSystemId();
            AbstractExternalSystemLocalSettings settings = (AbstractExternalSystemLocalSettings)manager.getLocalSettingsProvider().fun((Object)this.myProject);
            Map availableProjects = settings.getAvailableProjects();
            Map availableTasks = settings.getAvailableTasks();
            for (Map.Entry entry : availableProjects.entrySet()) {
                ExternalProjectSettings linkedProjectSettings;
                ExternalProjectPojo projectPojo = (ExternalProjectPojo)entry.getKey();
                String externalProjectPath = projectPojo.getPath();
                Pair key2 = Pair.create((Object)systemId, (Object)new File(externalProjectPath));
                InternalExternalProjectInfo externalProjectInfo = this.myExternalRootProjects.get(key2);
                if (externalProjectInfo == null) {
                    DataNode<ProjectData> dataNode = ExternalProjectsDataStorage.convert(systemId, projectPojo, (Collection)entry.getValue(), availableTasks);
                    externalProjectInfo = new InternalExternalProjectInfo(systemId, externalProjectPath, dataNode);
                    this.myExternalRootProjects.put((Pair<ProjectSystemId, File>)key2, externalProjectInfo);
                    ExternalProjectsManager.getInstance((Project)this.myProject).getExternalProjectsWatcher().markDirty(externalProjectPath);
                    this.changed.set(true);
                }
                if ((linkedProjectSettings = ((AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)this.myProject)).getLinkedProjectSettings(externalProjectPath)) == null || !ContainerUtil.isEmpty((Collection)linkedProjectSettings.getModules())) continue;
                Set modulePaths = ContainerUtil.map2Set((Collection)ExternalSystemApiUtil.findAllRecursively(externalProjectInfo.getExternalProjectStructure(), (Key)ProjectKeys.MODULE), node -> ((ModuleData)node.getData()).getLinkedExternalProjectPath());
                linkedProjectSettings.setModules(modulePaths);
            }
        }
    }

    private static DataNode<ProjectData> convert(@NotNull ProjectSystemId systemId, @NotNull ExternalProjectPojo rootProject, @NotNull Collection<ExternalProjectPojo> childProjects, @NotNull Map<String, Collection<ExternalTaskPojo>> availableTasks) {
        if (systemId == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(9);
        }
        if (rootProject == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(10);
        }
        if (childProjects == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(11);
        }
        if (availableTasks == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(12);
        }
        ProjectData projectData = new ProjectData(systemId, rootProject.getName(), rootProject.getPath(), rootProject.getPath());
        DataNode projectDataNode = new DataNode(ProjectKeys.PROJECT, (Object)projectData, null);
        for (ExternalProjectPojo childProject : childProjects) {
            String moduleConfigPath = childProject.getPath();
            ModuleData moduleData = new ModuleData(childProject.getName(), systemId, "JAVA_MODULE", childProject.getName(), moduleConfigPath, moduleConfigPath);
            DataNode moduleDataNode = projectDataNode.createChild(ProjectKeys.MODULE, (Object)moduleData);
            Collection<ExternalTaskPojo> moduleTasks = availableTasks.get(moduleConfigPath);
            if (moduleTasks == null) continue;
            for (ExternalTaskPojo moduleTask : moduleTasks) {
                TaskData taskData = new TaskData(systemId, moduleTask.getName(), moduleConfigPath, moduleTask.getDescription());
                moduleDataNode.createChild(ProjectKeys.TASK, (Object)taskData);
            }
        }
        return projectDataNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doSave(@NotNull Project project2, @NotNull Collection<InternalExternalProjectInfo> externalProjects) throws IOException {
        Path projectConfigurationFile;
        if (project2 == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(13);
        }
        if (externalProjects == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(14);
        }
        if (!FileUtil.createParentDirs((File)(projectConfigurationFile = ExternalProjectsDataStorage.getProjectConfigurationFile(project2)).toFile())) {
            throw new IOException("Unable to save " + projectConfigurationFile);
        }
        Iterator<InternalExternalProjectInfo> iterator = externalProjects.iterator();
        while (iterator.hasNext()) {
            InternalExternalProjectInfo externalProject = iterator.next();
            if (!ExternalProjectsDataStorage.validate(externalProject)) {
                iterator.remove();
                continue;
            }
            ExternalSystemApiUtil.visit(externalProject.getExternalProjectStructure(), dataNode -> {
                try {
                    dataNode.getDataBytes();
                }
                catch (IOException e) {
                    dataNode.clear(true);
                }
            });
        }
        try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(Files.newOutputStream(projectConfigurationFile, new OpenOption[0])));){
            out.writeUTF(STORAGE_VERSION);
            out.writeInt(externalProjects.size());
            try (ObjectOutputStream os = new ObjectOutputStream(out);){
                for (InternalExternalProjectInfo externalProject : externalProjects) {
                    os.writeObject(externalProject);
                }
            }
        }
    }

    @Nullable
    private static DataNode<ExternalConfigPathAware> resolveProjectNode(@NotNull DataNode node) {
        if (node == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(15);
        }
        if ((ProjectKeys.MODULE.equals((Object)node.getKey()) || ProjectKeys.PROJECT.equals((Object)node.getKey())) && node.getData() instanceof ExternalConfigPathAware) {
            return node;
        }
        DataNode parent = ExternalSystemApiUtil.findParent((DataNode)node, (Key)ProjectKeys.MODULE);
        if (parent == null) {
            parent = ExternalSystemApiUtil.findParent((DataNode)node, (Key)ProjectKeys.PROJECT);
        }
        return parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static Collection<InternalExternalProjectInfo> load(@NotNull Project project2) throws IOException {
        if (project2 == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(16);
        }
        SmartList projects = new SmartList();
        Path configurationFile = ExternalProjectsDataStorage.getProjectConfigurationFile(project2);
        if (!Files.isRegularFile(configurationFile, new LinkOption[0])) {
            SmartList smartList = projects;
            if (smartList == null) {
                ExternalProjectsDataStorage.$$$reportNull$$$0(17);
            }
            return smartList;
        }
        try (DataInputStream in = new DataInputStream(new BufferedInputStream(Files.newInputStream(configurationFile, new OpenOption[0])));){
            String storage_version = in.readUTF();
            if (!STORAGE_VERSION.equals(storage_version)) {
                SmartList smartList = projects;
                SmartList smartList2 = smartList;
                if (smartList2 == null) {
                    ExternalProjectsDataStorage.$$$reportNull$$$0(18);
                }
                return smartList2;
            }
            int size = in.readInt();
            try (ObjectInputStream os = new ObjectInputStream(in);){
                for (int i = 0; i < size; ++i) {
                    InternalExternalProjectInfo projectDataDataNode = (InternalExternalProjectInfo)os.readObject();
                    projects.add((Object)projectDataDataNode);
                }
            }
        }
        SmartList smartList = projects;
        if (smartList == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(19);
        }
        return smartList;
    }

    @NotNull
    private static Path getProjectConfigurationFile(@NotNull Project project2) {
        if (project2 == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(20);
        }
        Path path = ExternalProjectsDataStorage.getProjectConfigurationDir(project2).resolve("project.dat");
        if (path == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(21);
        }
        return path;
    }

    @NotNull
    public static Path getProjectConfigurationDir(@NotNull Project project2) {
        if (project2 == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(22);
        }
        Path path = ProjectUtil.getExternalConfigurationDir((Project)project2);
        if (path == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(23);
        }
        return path;
    }

    @Nullable
    public synchronized State getState() {
        return this.myState;
    }

    public synchronized void loadState(State state) {
        this.myState = state == null ? new State() : state;
    }

    synchronized void setIgnored(@NotNull DataNode<?> dataNode, boolean isIgnored) {
        DataNode projectDataNode;
        if (dataNode == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(24);
        }
        DataNode dataNode2 = projectDataNode = ProjectKeys.PROJECT.equals((Object)dataNode.getKey()) ? dataNode : ExternalSystemApiUtil.findParent(dataNode, (Key)ProjectKeys.PROJECT);
        if (projectDataNode == null) {
            return;
        }
        ExternalSystemApiUtil.visit((DataNode)dataNode, node -> node.setIgnored(isIgnored));
        this.saveInclusionSettings((DataNode<ProjectData>)projectDataNode);
    }

    synchronized boolean isIgnored(@NotNull String rootProjectPath, @NotNull String modulePath, @NotNull Key key2) {
        ProjectState projectState;
        if (rootProjectPath == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(25);
        }
        if (modulePath == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(26);
        }
        if (key2 == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(27);
        }
        if ((projectState = this.myState.map.get(rootProjectPath)) == null) {
            return false;
        }
        ModuleState moduleState = projectState.map.get(modulePath);
        return ExternalProjectsDataStorage.isIgnored(projectState, moduleState, key2);
    }

    private static boolean isIgnored(@NotNull ProjectState projectState, @Nullable ModuleState moduleState, @NotNull Key<?> key2) {
        if (projectState == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(28);
        }
        if (key2 == null) {
            ExternalProjectsDataStorage.$$$reportNull$$$0(29);
        }
        return projectState.isInclusion ^ (moduleState != null && moduleState.set.contains(key2.getDataType()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectInfo";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSystemId";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectPath";
                break;
            }
            case 8: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsDataStorage";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemId";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootProject";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childProjects";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "availableTasks";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjects";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataNode";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootProjectPath";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulePath";
                break;
            }
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/ExternalProjectsDataStorage";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "load";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectConfigurationFile";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectConfigurationDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 8: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doSave";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "resolveProjectNode";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getProjectConfigurationFile";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getProjectConfigurationDir";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setIgnored";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isIgnored";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$list$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MySaveTask
    implements Runnable {
        private Project myProject;
        private Collection<InternalExternalProjectInfo> myExternalProjects;

        public MySaveTask(Project project2, Collection<InternalExternalProjectInfo> externalProjects) {
            this.myProject = project2;
            this.myExternalProjects = ContainerUtil.map(externalProjects, info -> (InternalExternalProjectInfo)info.copy());
        }

        @Override
        public void run() {
            try {
                ExternalProjectsDataStorage.doSave(this.myProject, this.myExternalProjects);
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
            }
        }
    }

    static class ModuleState {
        @Property(surroundWithTag=false)
        @AbstractCollection(surroundWithTag=false, elementTag="id")
        public final Set<String> set = ContainerUtil.newConcurrentSet();

        public ModuleState() {
        }

        public ModuleState(Collection<String> values) {
            this.set.addAll(values);
        }
    }

    static class ProjectState {
        @Property(surroundWithTag=false)
        @MapAnnotation(surroundWithTag=false, surroundValueWithTag=false, surroundKeyWithTag=false, keyAttributeName="path", entryTagName="dataType")
        public final Map<String, ModuleState> map = ContainerUtil.newConcurrentMap();
        public boolean isInclusion;

        ProjectState() {
        }
    }

    static class State {
        @Property(surroundWithTag=false)
        @MapAnnotation(surroundWithTag=false, surroundValueWithTag=false, surroundKeyWithTag=false, keyAttributeName="path", entryTagName="projectState")
        public final Map<String, ProjectState> map = ContainerUtil.newConcurrentMap();

        State() {
        }
    }
}

