/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.view;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.ProjectNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleNodeVisitor;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.SimpleTreeBuilder;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class ExternalProjectsStructure
extends SimpleTreeStructure
implements Disposable {
    private final Project myProject;
    private ExternalProjectsView myExternalProjectsView;
    private final SimpleTreeBuilder myTreeBuilder;
    private RootNode myRoot;
    private final Map<String, ExternalSystemNode> myNodeMapping = new THashMap();

    public ExternalProjectsStructure(Project project2, SimpleTree tree) {
        this.myProject = project2;
        ExternalProjectsStructure.configureTree(tree);
        this.myTreeBuilder = new SimpleTreeBuilder((JTree)tree, (DefaultTreeModel)tree.getModel(), (AbstractTreeStructure)this, null);
        Disposer.register((Disposable)this.myProject, (Disposable)this.myTreeBuilder);
    }

    public void init(ExternalProjectsView externalProjectsView) {
        this.myExternalProjectsView = externalProjectsView;
        this.myRoot = new RootNode();
        this.myTreeBuilder.initRoot();
        this.myTreeBuilder.expand((Object)this.myRoot, null);
    }

    public Project getProject() {
        return this.myProject;
    }

    public void updateFrom(SimpleNode node) {
        this.myTreeBuilder.addSubtreeToUpdateByElement((Object)node);
    }

    public void updateUpTo(SimpleNode node) {
        for (SimpleNode each = node; each != null; each = each.getParent()) {
            this.updateFrom(each);
        }
    }

    public Object getRootElement() {
        return this.myRoot;
    }

    private static void configureTree(SimpleTree tree) {
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
    }

    public void accept(@NotNull SimpleNodeVisitor visitor) {
        if (visitor == null) {
            ExternalProjectsStructure.$$$reportNull$$$0(0);
        }
        if (this.myTreeBuilder.getTree() instanceof SimpleTree) {
            ((SimpleTree)this.myTreeBuilder.getTree()).accept((AbstractTreeBuilder)this.myTreeBuilder, visitor);
        }
    }

    public void select(SimpleNode node) {
        this.myTreeBuilder.select((Object)node, null);
    }

    protected Class<? extends ExternalSystemNode>[] getVisibleNodesClasses() {
        return null;
    }

    public void updateProjects(Collection<DataNode<ProjectData>> toImport) {
        List orphanProjects = ContainerUtil.mapNotNull(this.myNodeMapping.entrySet(), entry -> entry.getValue() instanceof ProjectNode ? (String)entry.getKey() : null);
        for (DataNode<ProjectData> each : toImport) {
            ProjectData projectData = (ProjectData)each.getData();
            String projectPath = projectData.getLinkedExternalProjectPath();
            orphanProjects.remove(projectPath);
            ExternalSystemNode projectNode = this.findNodeFor(projectPath);
            if (projectNode instanceof ProjectNode) {
                this.doMergeChildrenChanges(projectNode, each, new ProjectNode(this.myExternalProjectsView, each));
            } else {
                SimpleNode parent;
                ExternalSystemNode node = this.myNodeMapping.remove(projectPath);
                if (node != null && (parent = node.getParent()) instanceof ExternalSystemNode) {
                    ((ExternalSystemNode)parent).remove(projectNode);
                }
                projectNode = new ProjectNode(this.myExternalProjectsView, each);
                this.myNodeMapping.put(projectPath, projectNode);
            }
            if (toImport.size() == 1) {
                this.myTreeBuilder.expand((Object)projectNode, null);
            }
            this.doUpdateProject((ProjectNode)projectNode);
        }
        for (String orphanProjectPath : orphanProjects) {
            SimpleNode parent;
            ExternalSystemNode projectNode = this.myNodeMapping.remove(orphanProjectPath);
            if (!(projectNode instanceof ProjectNode) || !((parent = projectNode.getParent()) instanceof ExternalSystemNode)) continue;
            ((ExternalSystemNode)parent).remove(projectNode);
            this.updateUpTo(projectNode);
        }
    }

    private void doMergeChildrenChanges(ExternalSystemNode currentNode, DataNode<?> newDataNode, ExternalSystemNode newNode) {
        ExternalSystemNode[] cached = currentNode.getCached();
        if (cached != null) {
            ArrayList duplicates = ContainerUtil.newArrayList();
            LinkedHashMap oldDataMap = ContainerUtil.newLinkedHashMap();
            for (ExternalSystemNode node : cached) {
                Object key3 = node.getData() != null ? node.getData() : node.getName();
                ExternalSystemNode externalSystemNode = oldDataMap.put(key3, node);
                if (externalSystemNode == null) continue;
                duplicates.add(key3);
            }
            LinkedHashMap newDataMap = ContainerUtil.newLinkedHashMap();
            LinkedHashMap unchangedNewDataMap = ContainerUtil.newLinkedHashMap();
            for (ExternalSystemNode externalSystemNode : newNode.getChildren()) {
                Object key2;
                Object object = key2 = externalSystemNode.getData() != null ? externalSystemNode.getData() : externalSystemNode.getName();
                if (oldDataMap.remove(key2) == null) {
                    newDataMap.put(key2, externalSystemNode);
                    continue;
                }
                unchangedNewDataMap.put(key2, externalSystemNode);
            }
            for (Object duplicate : duplicates) {
                newDataMap.remove(duplicate);
            }
            currentNode.removeAll(oldDataMap.values());
            for (ExternalSystemNode externalSystemNode : currentNode.getChildren()) {
                Object key2 = externalSystemNode.getData() != null ? externalSystemNode.getData() : externalSystemNode.getName();
                ExternalSystemNode unchangedNewNode = (ExternalSystemNode)unchangedNewDataMap.get(key2);
                if (unchangedNewNode == null) continue;
                this.doMergeChildrenChanges(externalSystemNode, unchangedNewNode.myDataNode, unchangedNewNode);
            }
            this.updateFrom(currentNode);
            currentNode.addAll(newDataMap.values());
        }
        currentNode.setDataNode(newDataNode);
    }

    private void doUpdateProject(ProjectNode node) {
        RootNode newParentNode = this.myRoot;
        if (!node.isVisible()) {
            newParentNode.remove(node);
        } else {
            node.updateProject();
            ExternalProjectsStructure.reconnectNode(node, newParentNode);
        }
    }

    private static void reconnectNode(ProjectNode node, ExternalSystemNode newParentNode) {
        ExternalSystemNode oldParentNode = node.getGroup();
        if (oldParentNode == null || !oldParentNode.equals(newParentNode)) {
            if (oldParentNode != null) {
                oldParentNode.remove(node);
            }
            newParentNode.add(node);
        }
    }

    private ExternalSystemNode findNodeFor(String projectPath) {
        return this.myNodeMapping.get(projectPath);
    }

    public <T extends ExternalSystemNode> void updateNodes(@NotNull Class<T> nodeClass) {
        if (nodeClass == null) {
            ExternalProjectsStructure.$$$reportNull$$$0(1);
        }
        for (ExternalSystemNode node : this.getNodes(nodeClass)) {
            this.updateFrom(node);
        }
    }

    public <T extends ExternalSystemNode> void visitNodes(@NotNull Class<T> nodeClass, @NotNull Consumer<T> consumer) {
        if (nodeClass == null) {
            ExternalProjectsStructure.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            ExternalProjectsStructure.$$$reportNull$$$0(3);
        }
        for (ExternalSystemNode node : this.getNodes(nodeClass)) {
            consumer.consume((Object)node);
        }
    }

    public void dispose() {
        this.myExternalProjectsView = null;
        this.myNodeMapping.clear();
        this.myRoot = null;
    }

    @NotNull
    public <T extends ExternalSystemNode> List<T> getNodes(@NotNull Class<T> nodeClass) {
        if (nodeClass == null) {
            ExternalProjectsStructure.$$$reportNull$$$0(4);
        }
        List<T> list2 = ExternalProjectsStructure.doGetNodes(nodeClass, this.myRoot.getChildren(), new SmartList());
        if (list2 == null) {
            ExternalProjectsStructure.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @NotNull
    private static <T extends ExternalSystemNode> List<T> doGetNodes(@NotNull Class<T> nodeClass, SimpleNode[] nodes, @NotNull List<T> result2) {
        if (nodeClass == null) {
            ExternalProjectsStructure.$$$reportNull$$$0(6);
        }
        if (result2 == null) {
            ExternalProjectsStructure.$$$reportNull$$$0(7);
        }
        if (nodes == null) {
            List<T> list2 = result2;
            if (list2 == null) {
                ExternalProjectsStructure.$$$reportNull$$$0(8);
            }
            return list2;
        }
        for (SimpleNode node : nodes) {
            if (nodeClass.isInstance(node)) {
                result2.add((ExternalSystemNode)node);
            }
            ExternalProjectsStructure.doGetNodes(nodeClass, node.getChildren(), result2);
        }
        List<T> list3 = result2;
        if (list3 == null) {
            ExternalProjectsStructure.$$$reportNull$$$0(9);
        }
        return list3;
    }

    @NotNull
    public <T extends ExternalSystemNode> List<T> getSelectedNodes(SimpleTree tree, Class<T> nodeClass) {
        ArrayList<ExternalSystemNode> filtered = new ArrayList<ExternalSystemNode>();
        for (SimpleNode node : ExternalProjectsStructure.getSelectedNodes(tree)) {
            if (nodeClass != null && !nodeClass.isInstance(node)) {
                filtered.clear();
                break;
            }
            filtered.add((ExternalSystemNode)node);
        }
        ArrayList<ExternalSystemNode> arrayList = filtered;
        if (arrayList == null) {
            ExternalProjectsStructure.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    private static List<SimpleNode> getSelectedNodes(SimpleTree tree) {
        ArrayList<SimpleNode> nodes = new ArrayList<SimpleNode>();
        TreePath[] treePaths = tree.getSelectionPaths();
        if (treePaths != null) {
            for (TreePath treePath : treePaths) {
                nodes.add(tree.getNodeFor(treePath));
            }
        }
        return nodes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/view/ExternalProjectsStructure";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/view/ExternalProjectsStructure";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetNodes";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateNodes";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitNodes";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNodes";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doGetNodes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static enum DisplayKind {
        ALWAYS,
        NEVER,
        NORMAL;

    }

    public static enum ErrorLevel {
        NONE,
        ERROR;

    }

    public class RootNode<T>
    extends ExternalSystemNode<T> {
        public RootNode() {
            super(ExternalProjectsStructure.this.myExternalProjectsView, null, null);
        }

        @Override
        public boolean isVisible() {
            return true;
        }
    }
}

