/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.view;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.TaskNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import icons.ExternalSystemIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

@Order(value=10)
public class TasksNode
extends ExternalSystemNode {
    private final MultiMap<String, TaskNode> myTasksMap = new MultiMap();

    public TasksNode(ExternalProjectsView externalProjectsView, Collection<DataNode<?>> dataNodes) {
        super(externalProjectsView, null, null);
        if (dataNodes != null && !dataNodes.isEmpty()) {
            for (DataNode<?> dataNode : dataNodes) {
                if (!(dataNode.getData() instanceof TaskData)) continue;
                String group = ((TaskData)dataNode.getData()).getGroup();
                if (group == null) {
                    group = "other";
                }
                this.myTasksMap.putValue((Object)StringUtil.toLowerCase((String)group), (Object)new TaskNode(externalProjectsView, dataNode));
            }
        }
    }

    protected void update(PresentationData presentation) {
        super.update(presentation);
        presentation.setIcon(ExternalSystemIcons.TaskGroup);
    }

    public String getName() {
        return "Tasks";
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.hasChildren();
    }

    @Override
    @NotNull
    protected List<? extends ExternalSystemNode> doBuildChildren() {
        ArrayList result2 = ContainerUtil.newArrayList();
        boolean isGroup = this.getExternalProjectsView().getGroupTasks();
        if (isGroup) {
            for (Map.Entry collectionEntry : this.myTasksMap.entrySet()) {
                final String group = (String)ObjectUtils.notNull(collectionEntry.getKey(), (Object)"other");
                ExternalSystemNode tasksGroupNode = new ExternalSystemNode(this.getExternalProjectsView(), null, null){

                    protected void update(PresentationData presentation) {
                        super.update(presentation);
                        presentation.setIcon(ExternalSystemIcons.TaskGroup);
                    }

                    public String getName() {
                        return group;
                    }

                    @Override
                    public boolean isVisible() {
                        return super.isVisible() && this.hasChildren();
                    }

                    @Override
                    public int compareTo(@NotNull ExternalSystemNode node) {
                        if (node == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return "other".equals(group) ? 1 : super.compareTo(node);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/externalSystem/view/TasksNode$1", "compareTo"));
                    }
                };
                tasksGroupNode.addAll((Collection)collectionEntry.getValue());
                result2.add(tasksGroupNode);
            }
        } else {
            result2.addAll(this.myTasksMap.values());
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            TasksNode.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/view/TasksNode", "doBuildChildren"));
    }
}

