/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ProjectTopics;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.AsyncFileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.NavigatableFileEditor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileEditor.impl.DockableEditorContainerFactory;
import com.intellij.openapi.fileEditor.impl.DockableEditorTabbedContainer;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorFileSwapper;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorWindowHolder;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.FileEditorAssociateFinder;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerChange;
import com.intellij.openapi.fileEditor.impl.FileEditorProviderManagerImpl;
import com.intellij.openapi.fileEditor.impl.FilePreviewPanelProvider;
import com.intellij.openapi.fileEditor.impl.HistoryEntry;
import com.intellij.openapi.fileEditor.impl.IdeDocumentHistoryImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.preview.PreviewManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.ActiveRunnable;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.BusyObject;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ExpirableRunnable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NullUtils;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.pom.Navigatable;
import com.intellij.reference.SoftReference;
import com.intellij.ui.FocusTrackback;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockContainerFactory;
import com.intellij.ui.docking.DockManager;
import com.intellij.ui.docking.impl.DockManagerImpl;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.impl.MessageListenerList;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import gnu.trove.THashSet;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="FileEditorManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class FileEditorManagerImpl
extends FileEditorManagerEx
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl");
    private static final Key<Boolean> DUMB_AWARE = Key.create((String)"DUMB_AWARE");
    private static final FileEditor[] EMPTY_EDITOR_ARRAY = new FileEditor[0];
    private static final FileEditorProvider[] EMPTY_PROVIDER_ARRAY = new FileEditorProvider[0];
    public static final Key<Boolean> CLOSING_TO_REOPEN = Key.create((String)"CLOSING_TO_REOPEN");
    public static final String FILE_EDITOR_MANAGER = "FileEditorManager";
    private volatile JPanel myPanels;
    private EditorsSplitters mySplitters;
    private final Project myProject;
    private final List<Pair<VirtualFile, EditorWindow>> mySelectionHistory;
    private Reference<EditorComposite> myLastSelectedComposite;
    private final MergingUpdateQueue myQueue;
    private final BusyObject.Impl.Simple myBusyObject;
    private final PropertyChangeListener myEditorPropertyChangeListener;
    private final DockManager myDockManager;
    private DockableEditorContainerFactory myContentFactory;
    private static final AtomicInteger ourOpenFilesSetModificationCount = new AtomicInteger();
    static final ModificationTracker OPEN_FILE_SET_MODIFICATION_COUNT = ourOpenFilesSetModificationCount::get;
    private final Object myInitLock;
    private final MessageListenerList<FileEditorManagerListener> myListenerList;

    public FileEditorManagerImpl(@NotNull Project project2, DockManager dockManager) {
        if (project2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(0);
        }
        this.mySelectionHistory = new ArrayList<Pair<VirtualFile, EditorWindow>>();
        this.myLastSelectedComposite = new WeakReference<Object>(null);
        this.myQueue = new MergingUpdateQueue("FileEditorManagerUpdateQueue", 50, true, MergingUpdateQueue.ANY_COMPONENT);
        this.myBusyObject = new BusyObject.Impl.Simple();
        this.myEditorPropertyChangeListener = new MyEditorPropertyChangeListener();
        this.myInitLock = new Object();
        this.myProject = project2;
        this.myDockManager = dockManager;
        this.myListenerList = new MessageListenerList(this.myProject.getMessageBus(), FileEditorManagerListener.FILE_EDITOR_MANAGER);
        if (((FileEditorAssociateFinder[])Extensions.getExtensions(FileEditorAssociateFinder.EP_NAME)).length > 0) {
            this.myListenerList.add((Object)new FileEditorManagerListener(){

                public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    EditorsSplitters splitters = FileEditorManagerImpl.this.getSplitters();
                    FileEditorManagerImpl.this.openAssociatedFile(event.getNewFile(), splitters.getCurrentWindow(), splitters);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$1", "selectionChanged"));
                }
            });
        }
        this.myQueue.setTrackUiActivity(true);
        final MessageBusConnection connection = project2.getMessageBus().connect();
        connection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
            }

            public void exitDumbMode() {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (!FileEditorManagerImpl.this.myProject.isDisposed()) {
                        FileEditorManagerImpl.this.dumbModeFinished(FileEditorManagerImpl.this.myProject);
                    }
                });
            }
        });
        connection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(Project project2) {
                if (project2 == FileEditorManagerImpl.this.myProject) {
                    FileEditorManagerImpl.this.projectOpened(connection);
                }
            }

            public void projectClosed(Project project2) {
                if (project2 == FileEditorManagerImpl.this.myProject) {
                    FileEditorManagerImpl.this.closeAllFiles();
                }
            }
        });
    }

    private void dumbModeFinished(Project project2) {
        VirtualFile[] files;
        for (VirtualFile file2 : files = this.getOpenFiles()) {
            HashSet providers2 = new HashSet();
            List<EditorWithProviderComposite> composites = this.getEditorComposites(file2);
            for (EditorWithProviderComposite composite : composites) {
                ContainerUtil.addAll(providers2, (Object[])composite.getProviders());
            }
            FileEditorProvider[] newProviders = FileEditorProviderManager.getInstance().getProviders(project2, file2);
            if (newProviders.length <= providers2.size()) continue;
            ArrayList<FileEditorProvider> toOpen = new ArrayList<FileEditorProvider>(Arrays.asList(newProviders));
            toOpen.removeAll(providers2);
            for (EditorWithProviderComposite composite : composites) {
                for (FileEditorProvider provider : toOpen) {
                    FileEditor editor = provider.createEditor(this.myProject, file2);
                    composite.addEditor(editor, provider);
                }
            }
        }
    }

    public void initDockableContentFactory() {
        if (this.myContentFactory != null) {
            return;
        }
        this.myContentFactory = new DockableEditorContainerFactory(this.myProject, this, this.myDockManager);
        this.myDockManager.register("file-editors", (DockContainerFactory)this.myContentFactory);
        Disposer.register((Disposable)this.myProject, (Disposable)this.myContentFactory);
    }

    public static boolean isDumbAware(@NotNull FileEditor editor) {
        if (editor == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(1);
        }
        return Boolean.TRUE.equals(editor.getUserData(DUMB_AWARE)) && (!(editor instanceof PossiblyDumbAware) || ((PossiblyDumbAware)editor).isDumbAware());
    }

    @Override
    public JComponent getComponent() {
        this.initUI();
        return this.myPanels;
    }

    @NotNull
    public EditorsSplitters getMainSplitters() {
        this.initUI();
        EditorsSplitters editorsSplitters = this.mySplitters;
        if (editorsSplitters == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(2);
        }
        return editorsSplitters;
    }

    @NotNull
    public Set<EditorsSplitters> getAllSplitters() {
        LinkedHashSet<EditorsSplitters> all = new LinkedHashSet<EditorsSplitters>();
        all.add(this.getMainSplitters());
        Set dockContainers = this.myDockManager.getContainers();
        for (DockContainer each : dockContainers) {
            if (!(each instanceof DockableEditorTabbedContainer)) continue;
            all.add(((DockableEditorTabbedContainer)each).getSplitters());
        }
        Set<EditorsSplitters> set2 = Collections.unmodifiableSet(all);
        if (set2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(3);
        }
        return set2;
    }

    @NotNull
    private AsyncResult<EditorsSplitters> getActiveSplittersAsync() {
        AsyncResult result2 = new AsyncResult();
        IdeFocusManager fm = IdeFocusManager.getInstance((Project)this.myProject);
        TransactionGuard.getInstance().assertWriteSafeContext(ModalityState.defaultModalityState());
        fm.doWhenFocusSettlesDown(() -> {
            if (this.myProject.isDisposed()) {
                result2.setRejected();
                return;
            }
            Component focusOwner = fm.getFocusOwner();
            DockContainer container = this.myDockManager.getContainerFor(focusOwner);
            if (container instanceof DockableEditorTabbedContainer) {
                result2.setDone((Object)((DockableEditorTabbedContainer)container).getSplitters());
            } else {
                result2.setDone((Object)this.getMainSplitters());
            }
        }, ModalityState.defaultModalityState());
        AsyncResult asyncResult = result2;
        if (asyncResult == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(4);
        }
        return asyncResult;
    }

    private EditorsSplitters getActiveSplittersSync() {
        DockContainer container;
        FileEditorManagerImpl.assertDispatchThread();
        IdeFocusManager fm = IdeFocusManager.getInstance((Project)this.myProject);
        Component focusOwner = fm.getFocusOwner();
        if (focusOwner == null) {
            focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        }
        if (focusOwner == null) {
            focusOwner = fm.getLastFocusedFor(fm.getLastFocusedFrame());
        }
        if ((container = this.myDockManager.getContainerFor(focusOwner)) == null) {
            focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            container = this.myDockManager.getContainerFor(focusOwner);
        }
        if (container instanceof DockableEditorTabbedContainer) {
            return ((DockableEditorTabbedContainer)container).getSplitters();
        }
        return this.getMainSplitters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initUI() {
        if (this.myPanels == null) {
            Object object = this.myInitLock;
            synchronized (object) {
                if (this.myPanels == null) {
                    JPanel panel2 = new JPanel(new BorderLayout());
                    panel2.setOpaque(false);
                    panel2.setBorder(new MyBorder());
                    this.mySplitters = new EditorsSplitters(this, this.myDockManager, true);
                    Disposer.register((Disposable)this.myProject, (Disposable)this.mySplitters);
                    panel2.add((Component)((Object)this.mySplitters), "Center");
                    this.myPanels = panel2;
                }
            }
        }
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        EditorWithProviderComposite editor;
        FileEditorManagerImpl.assertReadAccess();
        EditorWindow window = this.getSplitters().getCurrentWindow();
        if (window != null && (editor = window.getSelectedEditor()) != null) {
            return editor.getPreferredFocusedComponent();
        }
        return null;
    }

    public Color getFileColor(@NotNull VirtualFile file2) {
        FileStatusManager fileStatusManager;
        Color statusColor;
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(5);
        }
        Color color = statusColor = (fileStatusManager = FileStatusManager.getInstance((Project)this.myProject)) != null ? fileStatusManager.getStatus(file2).getColor() : UIUtil.getLabelForeground();
        if (statusColor == null) {
            statusColor = UIUtil.getLabelForeground();
        }
        return statusColor;
    }

    public boolean isProblem(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(6);
        }
        return false;
    }

    @NotNull
    public String getFileTooltipText(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(7);
        }
        String string = FileUtil.getLocationRelativeToUserHome((String)file2.getPresentableUrl());
        if (string == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    public void updateFilePresentation(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(9);
        }
        if (!this.isFileOpen(file2)) {
            return;
        }
        this.updateFileColor(file2);
        this.updateFileIcon(file2);
        this.updateFileName(file2);
        this.updateFileBackgroundColor(file2);
    }

    private void updateFileColor(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(10);
        }
        Set<EditorsSplitters> all = this.getAllSplitters();
        for (EditorsSplitters each : all) {
            each.updateFileColor(file2);
        }
    }

    private void updateFileBackgroundColor(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(11);
        }
        Set<EditorsSplitters> all = this.getAllSplitters();
        for (EditorsSplitters each : all) {
            each.updateFileBackgroundColor(file2);
        }
    }

    protected void updateFileIcon(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(12);
        }
        Set<EditorsSplitters> all = this.getAllSplitters();
        for (EditorsSplitters each : all) {
            each.updateFileIcon(file2);
        }
    }

    void updateFileName(final @Nullable VirtualFile file2) {
        this.myQueue.queue(new Update("UpdateFileName " + (file2 == null ? "" : file2.getPath())){

            public boolean isExpired() {
                return FileEditorManagerImpl.this.myProject.isDisposed() || !FileEditorManagerImpl.this.myProject.isOpen() || (file2 == null ? super.isExpired() : !file2.isValid());
            }

            public void run() {
                Set<EditorsSplitters> all = FileEditorManagerImpl.this.getAllSplitters();
                for (EditorsSplitters each : all) {
                    each.updateFileName(file2);
                }
            }
        });
    }

    @Override
    public VirtualFile getFile(@NotNull FileEditor editor) {
        EditorWithProviderComposite editorComposite;
        if (editor == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(13);
        }
        if ((editorComposite = this.getEditorComposite(editor)) != null) {
            return editorComposite.getFile();
        }
        return null;
    }

    @Override
    public void unsplitWindow() {
        EditorWindow currentWindow = this.getActiveSplittersSync().getCurrentWindow();
        if (currentWindow != null) {
            currentWindow.unsplit(true);
        }
    }

    @Override
    public void unsplitAllWindow() {
        EditorWindow currentWindow = this.getActiveSplittersSync().getCurrentWindow();
        if (currentWindow != null) {
            currentWindow.unsplitAll();
        }
    }

    @Override
    public int getWindowSplitCount() {
        return this.getActiveSplittersSync().getSplitCount();
    }

    @Override
    public boolean hasSplitOrUndockedWindows() {
        Set<EditorsSplitters> splitters = this.getAllSplitters();
        if (splitters.size() > 1) {
            return true;
        }
        return this.getWindowSplitCount() > 1;
    }

    @Override
    @NotNull
    public EditorWindow[] getWindows() {
        ArrayList windows = new ArrayList();
        Set<EditorsSplitters> all = this.getAllSplitters();
        for (EditorsSplitters each : all) {
            Object[] eachList = each.getWindows();
            ContainerUtil.addAll(windows, (Object[])eachList);
        }
        EditorWindow[] editorWindowArray = windows.toArray(new EditorWindow[windows.size()]);
        if (editorWindowArray == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(14);
        }
        return editorWindowArray;
    }

    @Override
    public EditorWindow getNextWindow(@NotNull EditorWindow window) {
        if (window == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(15);
        }
        EditorWindow[] windows = this.getSplitters().getOrderedWindows();
        for (int i = 0; i != windows.length; ++i) {
            if (!windows[i].equals(window)) continue;
            return windows[(i + 1) % windows.length];
        }
        LOG.error("Not window found");
        return null;
    }

    @Override
    public EditorWindow getPrevWindow(@NotNull EditorWindow window) {
        if (window == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(16);
        }
        EditorWindow[] windows = this.getSplitters().getOrderedWindows();
        for (int i = 0; i != windows.length; ++i) {
            if (!windows[i].equals(window)) continue;
            return windows[(i + windows.length - 1) % windows.length];
        }
        LOG.error("Not window found");
        return null;
    }

    @Override
    public void createSplitter(int orientation, @Nullable EditorWindow window) {
        if (window != null) {
            window.split(orientation, true, null, false);
        } else {
            EditorWindow currentWindow = this.getSplitters().getCurrentWindow();
            if (currentWindow != null) {
                currentWindow.split(orientation, true, null, false);
            }
        }
    }

    @Override
    public void changeSplitterOrientation() {
        EditorWindow currentWindow = this.getSplitters().getCurrentWindow();
        if (currentWindow != null) {
            currentWindow.changeOrientation();
        }
    }

    @Override
    public void flipTabs() {
        this.myPanels.revalidate();
    }

    @Override
    public boolean tabsMode() {
        return false;
    }

    private void setTabsMode(boolean mode) {
        if (this.tabsMode() != mode) {
            this.flipTabs();
        }
    }

    @Override
    public boolean isInSplitter() {
        EditorWindow currentWindow = this.getSplitters().getCurrentWindow();
        return currentWindow != null && currentWindow.inSplitter();
    }

    @Override
    public boolean hasOpenedFile() {
        EditorWindow currentWindow = this.getSplitters().getCurrentWindow();
        return currentWindow != null && currentWindow.getSelectedEditor() != null;
    }

    @Override
    public VirtualFile getCurrentFile() {
        return this.getActiveSplittersSync().getCurrentFile();
    }

    @Override
    @NotNull
    public AsyncResult<EditorWindow> getActiveWindow() {
        AsyncResult asyncResult = this.getActiveSplittersAsync().subResult(EditorsSplitters::getCurrentWindow);
        if (asyncResult == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(17);
        }
        return asyncResult;
    }

    @Override
    public EditorWindow getCurrentWindow() {
        if (!ApplicationManager.getApplication().isDispatchThread()) {
            return null;
        }
        EditorsSplitters splitters = this.getActiveSplittersSync();
        return splitters == null ? null : splitters.getCurrentWindow();
    }

    @Override
    public void setCurrentWindow(EditorWindow window) {
        this.getActiveSplittersSync().setCurrentWindow(window, true);
    }

    public void closeFile(@NotNull VirtualFile file2, @NotNull EditorWindow window, boolean transferFocus) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(18);
        }
        if (window == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(19);
        }
        FileEditorManagerImpl.assertDispatchThread();
        ourOpenFilesSetModificationCount.incrementAndGet();
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            if (window == null) {
                FileEditorManagerImpl.$$$reportNull$$$0(132);
            }
            if (file2 == null) {
                FileEditorManagerImpl.$$$reportNull$$$0(133);
            }
            if (window.isFileOpen(file2)) {
                window.closeFile(file2, true, transferFocus);
            }
        }, IdeBundle.message((String)"command.close.active.editor", (Object[])new Object[0]), null);
        this.removeSelectionRecord(file2, window);
    }

    @Override
    public void closeFile(@NotNull VirtualFile file2, @NotNull EditorWindow window) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(20);
        }
        if (window == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(21);
        }
        this.closeFile(file2, window, true);
    }

    public void closeFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(22);
        }
        this.closeFile(file2, true, false);
    }

    public void closeFile(@NotNull VirtualFile file2, boolean moveFocus, boolean closeAllCopies) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(23);
        }
        FileEditorManagerImpl.assertDispatchThread();
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            if (file2 == null) {
                FileEditorManagerImpl.$$$reportNull$$$0(131);
            }
            this.closeFileImpl(file2, moveFocus, closeAllCopies);
        }, "", null);
    }

    private void closeFileImpl(@NotNull VirtualFile file2, boolean moveFocus, boolean closeAllCopies) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(24);
        }
        FileEditorManagerImpl.assertDispatchThread();
        ourOpenFilesSetModificationCount.incrementAndGet();
        this.runChange(splitters -> {
            if (file2 == null) {
                FileEditorManagerImpl.$$$reportNull$$$0(130);
            }
            splitters.closeFile(file2, moveFocus);
        }, closeAllCopies ? null : this.getActiveSplittersSync());
    }

    @Override
    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> openFileWithProviders(@NotNull VirtualFile file2, boolean focusEditor, boolean searchForSplitter) {
        Pair<FileEditor[], FileEditorProvider[]> previewResult;
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(25);
        }
        if (!file2.isValid()) {
            throw new IllegalArgumentException("file is not valid: " + file2);
        }
        FileEditorManagerImpl.assertDispatchThread();
        if (FileEditorManagerImpl.isOpenInNewWindow()) {
            Pair<FileEditor[], FileEditorProvider[]> pair2 = this.openFileInNewWindow(file2);
            if (pair2 == null) {
                FileEditorManagerImpl.$$$reportNull$$$0(26);
            }
            return pair2;
        }
        EditorWindow wndToOpenIn = null;
        if (searchForSplitter) {
            Set<EditorsSplitters> all = this.getAllSplitters();
            EditorsSplitters active = this.getActiveSplittersSync();
            if (active.getCurrentWindow() != null && active.getCurrentWindow().isFileOpen(file2)) {
                wndToOpenIn = active.getCurrentWindow();
            } else {
                for (EditorsSplitters splitters : all) {
                    EditorWindow window = splitters.getCurrentWindow();
                    if (window == null || !window.isFileOpen(file2)) continue;
                    wndToOpenIn = window;
                    break;
                }
            }
        } else {
            wndToOpenIn = this.getSplitters().getCurrentWindow();
        }
        if (!(wndToOpenIn != null && wndToOpenIn.isFileOpen(file2) || (previewResult = PreviewManager.SERVICE.preview(this.myProject, FilePreviewPanelProvider.ID, file2, focusEditor)) == null)) {
            Pair<FileEditor[], FileEditorProvider[]> pair3 = previewResult;
            if (pair3 == null) {
                FileEditorManagerImpl.$$$reportNull$$$0(27);
            }
            return pair3;
        }
        EditorsSplitters splitters = this.getSplitters();
        if (wndToOpenIn == null) {
            wndToOpenIn = splitters.getOrCreateCurrentWindow(file2);
        }
        this.openAssociatedFile(file2, wndToOpenIn, splitters);
        Pair<FileEditor[], FileEditorProvider[]> pair4 = this.openFileImpl2(wndToOpenIn, file2, focusEditor);
        if (pair4 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(28);
        }
        return pair4;
    }

    public Pair<FileEditor[], FileEditorProvider[]> openFileInNewWindow(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(29);
        }
        return ((DockManagerImpl)DockManager.getInstance((Project)this.getProject())).createNewDockContainerFor(file2, this);
    }

    private static boolean isOpenInNewWindow() {
        AWTEvent event = IdeEventQueue.getInstance().getTrueCurrentEvent();
        if (event instanceof MouseEvent && ((MouseEvent)event).isShiftDown() && (event.getID() == 500 || event.getID() == 501 || event.getID() == 502)) {
            return true;
        }
        if (event instanceof KeyEvent) {
            KeyEvent ke = (KeyEvent)event;
            Keymap keymap = KeymapManager.getInstance().getActiveKeymap();
            String[] ids = keymap.getActionIds(KeyStroke.getKeyStroke(ke.getKeyCode(), ke.getModifiers()));
            return Arrays.asList(ids).contains("OpenElementInNewWindow");
        }
        return false;
    }

    private void openAssociatedFile(VirtualFile file2, EditorWindow wndToOpenIn, @NotNull EditorsSplitters splitters) {
        if (splitters == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(30);
        }
        EditorWindow[] windows = splitters.getWindows();
        if (file2 != null && windows.length == 2) {
            for (FileEditorAssociateFinder finder : (FileEditorAssociateFinder[])Extensions.getExtensions(FileEditorAssociateFinder.EP_NAME)) {
                VirtualFile associatedFile = finder.getAssociatedFileToOpen(this.myProject, file2);
                if (associatedFile == null) continue;
                EditorWindow currentWindow = splitters.getCurrentWindow();
                int idx = windows[0] == wndToOpenIn ? 1 : 0;
                this.openFileImpl2(windows[idx], associatedFile, false);
                if (currentWindow == null) break;
                splitters.setCurrentWindow(currentWindow, false);
                break;
            }
        }
    }

    @Override
    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> openFileWithProviders(@NotNull VirtualFile file2, boolean focusEditor, @NotNull EditorWindow window) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(31);
        }
        if (window == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(32);
        }
        if (!file2.isValid()) {
            throw new IllegalArgumentException("file is not valid: " + file2);
        }
        FileEditorManagerImpl.assertDispatchThread();
        Pair<FileEditor[], FileEditorProvider[]> pair2 = this.openFileImpl2(window, file2, focusEditor);
        if (pair2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(33);
        }
        return pair2;
    }

    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> openFileImpl2(@NotNull EditorWindow window, @NotNull VirtualFile file2, boolean focusEditor) {
        if (window == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(34);
        }
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(35);
        }
        Ref result2 = new Ref();
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            if (window == null) {
                FileEditorManagerImpl.$$$reportNull$$$0(128);
            }
            if (file2 == null) {
                FileEditorManagerImpl.$$$reportNull$$$0(129);
            }
            result2.set(this.openFileImpl3(window, file2, focusEditor, null, true));
        }, "", null);
        Pair pair2 = (Pair)result2.get();
        if (pair2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(36);
        }
        return pair2;
    }

    @NotNull
    Pair<FileEditor[], FileEditorProvider[]> openFileImpl3(@NotNull EditorWindow window, @NotNull VirtualFile file2, boolean focusEditor, @Nullable HistoryEntry entry, boolean current) {
        if (window == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(37);
        }
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(38);
        }
        Pair<FileEditor[], FileEditorProvider[]> pair2 = this.openFileImpl4(window, file2, entry, current, focusEditor, null, -1);
        if (pair2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(39);
        }
        return pair2;
    }

    @NotNull
    Pair<FileEditor[], FileEditorProvider[]> openFileImpl4(@NotNull EditorWindow window, @NotNull VirtualFile file2, @Nullable HistoryEntry entry, boolean current, boolean focusEditor, Boolean pin, int index) {
        AsyncFileEditorProvider.Builder[] builders;
        FileEditorProvider[] newProviders;
        if (window == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(40);
        }
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(41);
        }
        assert (ApplicationManager.getApplication().isDispatchThread() || !ApplicationManager.getApplication().isReadAccessAllowed()) : "must not open files under read action since we are doing a lot of invokeAndWaits here";
        Ref compositeRef = new Ref();
        UIUtil.invokeAndWaitIfNeeded(() -> {
            if (window == null) {
                FileEditorManagerImpl.$$$reportNull$$$0(126);
            }
            if (file2 == null) {
                FileEditorManagerImpl.$$$reportNull$$$0(127);
            }
            compositeRef.set((Object)window.findFileComposite(file2));
        });
        if (compositeRef.isNull()) {
            newProviders = FileEditorProviderManager.getInstance().getProviders(this.myProject, file2);
            if (newProviders.length == 0) {
                Pair pair2 = Pair.create((Object)EMPTY_EDITOR_ARRAY, (Object)EMPTY_PROVIDER_ARRAY);
                if (pair2 == null) {
                    FileEditorManagerImpl.$$$reportNull$$$0(42);
                }
                return pair2;
            }
            builders = new AsyncFileEditorProvider.Builder[newProviders.length];
            for (int i = 0; i < newProviders.length; ++i) {
                try {
                    FileEditorProvider provider = newProviders[i];
                    LOG.assertTrue(provider != null, (Object)("Provider for file " + file2 + " is null. All providers: " + Arrays.asList(newProviders)));
                    builders[i] = (AsyncFileEditorProvider.Builder)ReadAction.compute(() -> {
                        if (file2 == null) {
                            FileEditorManagerImpl.$$$reportNull$$$0(125);
                        }
                        if (this.myProject.isDisposed() || !file2.isValid()) {
                            return null;
                        }
                        LOG.assertTrue(provider.accept(this.myProject, file2), (Object)("Provider " + provider + " doesn't accept file " + file2));
                        return provider instanceof AsyncFileEditorProvider ? ((AsyncFileEditorProvider)provider).createEditorAsync(this.myProject, file2) : null;
                    });
                    continue;
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (AssertionError | Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        } else {
            newProviders = null;
            builders = null;
        }
        Runnable runnable2 = () -> {
            if (file2 == null) {
                FileEditorManagerImpl.$$$reportNull$$$0(122);
            }
            if (window == null) {
                FileEditorManagerImpl.$$$reportNull$$$0(123);
            }
            if (this.myProject.isDisposed() || !file2.isValid()) {
                return;
            }
            HeavyProcessLatch.INSTANCE.prioritizeUiActivity();
            ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
            compositeRef.set((Object)window.findFileComposite(file2));
            boolean newEditor = compositeRef.isNull();
            if (newEditor) {
                FileEditorManagerImpl.clearWindowIfNeeded(window);
                ((FileEditorManagerListener.Before)this.getProject().getMessageBus().syncPublisher(FileEditorManagerListener.Before.FILE_EDITOR_MANAGER)).beforeFileOpened((FileEditorManager)this, file2);
                FileEditor[] newEditors = new FileEditor[newProviders.length];
                for (int i = 0; i < newProviders.length; ++i) {
                    try {
                        FileEditorProvider provider = newProviders[i];
                        FileEditor editor = builders[i] == null ? provider.createEditor(this.myProject, file2) : builders[i].build();
                        LOG.assertTrue(editor.isValid(), (Object)("Invalid editor created by provider " + (provider == null ? null : provider.getClass().getName())));
                        newEditors[i] = editor;
                        editor.addPropertyChangeListener(this.myEditorPropertyChangeListener);
                        editor.putUserData(DUMB_AWARE, (Object)DumbService.isDumbAware((Object)provider));
                        continue;
                    }
                    catch (ProcessCanceledException e) {
                        throw e;
                    }
                    catch (AssertionError | Exception e) {
                        LOG.error((Throwable)e);
                    }
                }
                EditorWithProviderComposite composite = this.createComposite(file2, newEditors, newProviders);
                if (composite == null) {
                    return;
                }
                if (index >= 0) {
                    composite.getFile().putUserData(EditorWindow.INITIAL_INDEX_KEY, (Object)index);
                }
                compositeRef.set((Object)composite);
            }
            EditorWithProviderComposite composite = (EditorWithProviderComposite)compositeRef.get();
            FileEditor[] editors = composite.getEditors();
            FileEditorProvider[] providers2 = composite.getProviders();
            window.setEditor(composite, current, focusEditor);
            for (int i = 0; i < editors.length; ++i) {
                this.restoreEditorState(file2, providers2[i], editors[i], entry, newEditor);
            }
            FileEditorProvider selectedProvider = entry == null ? ((FileEditorProviderManagerImpl)FileEditorProviderManager.getInstance()).getSelectedFileEditorProvider(EditorHistoryManager.getInstance(this.myProject), file2, providers2) : entry.getSelectedProvider();
            if (selectedProvider != null) {
                for (int i = editors.length - 1; i >= 0; --i) {
                    FileEditorProvider provider = providers2[i];
                    if (!provider.equals(selectedProvider)) continue;
                    composite.setSelectedEditor(i);
                    break;
                }
            }
            window.getOwner().setCurrentWindow(window, focusEditor);
            window.getOwner().afterFileOpen(file2);
            this.addSelectionRecord(file2, window);
            composite.getSelectedEditor().selectNotify();
            if (!ApplicationManagerEx.getApplicationEx().isUnitTestMode() && focusEditor) {
                window.setAsCurrentWindow(true);
                ToolWindowManager.getInstance((Project)this.myProject).activateEditorComponent();
                IdeFocusManager.getInstance((Project)this.myProject).toFront((JComponent)((Object)window.getOwner()));
            }
            if (newEditor) {
                this.notifyPublisher(() -> {
                    if (file2 == null) {
                        FileEditorManagerImpl.$$$reportNull$$$0(124);
                    }
                    if (this.isFileOpen(file2)) {
                        ((FileEditorManagerListener)this.getProject().getMessageBus().syncPublisher(FileEditorManagerListener.FILE_EDITOR_MANAGER)).fileOpened((FileEditorManager)this, file2);
                    }
                });
                ourOpenFilesSetModificationCount.incrementAndGet();
            }
            ((IdeDocumentHistoryImpl)IdeDocumentHistory.getInstance(this.myProject)).onSelectionChanged();
            this.updateFileName(file2);
            IdeDocumentHistory.getInstance(this.myProject).includeCurrentCommandAsNavigation();
            if (pin != null) {
                window.setFilePinned(file2, pin);
            }
        };
        ApplicationManager.getApplication().invokeAndWait(runnable2);
        EditorWithProviderComposite composite = (EditorWithProviderComposite)compositeRef.get();
        Pair pair3 = Pair.create((Object)(composite == null ? EMPTY_EDITOR_ARRAY : composite.getEditors()), (Object)(composite == null ? EMPTY_PROVIDER_ARRAY : composite.getProviders()));
        if (pair3 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(43);
        }
        return pair3;
    }

    @Nullable
    private EditorWithProviderComposite createComposite(@NotNull VirtualFile file2, @NotNull FileEditor[] editors, @NotNull FileEditorProvider[] providers2) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(44);
        }
        if (editors == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(45);
        }
        if (providers2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(46);
        }
        if (NullUtils.hasNull((Object[])editors) || NullUtils.hasNull((Object[])providers2)) {
            ArrayList<FileEditor> editorList = new ArrayList<FileEditor>(editors.length);
            ArrayList<FileEditorProvider> providerList = new ArrayList<FileEditorProvider>(providers2.length);
            for (int i = 0; i < editors.length; ++i) {
                FileEditor editor = editors[i];
                FileEditorProvider provider = providers2[i];
                if (editor == null || provider == null) continue;
                editorList.add(editor);
                providerList.add(provider);
            }
            if (editorList.isEmpty()) {
                return null;
            }
            editors = editorList.toArray(new FileEditor[editorList.size()]);
            providers2 = providerList.toArray(new FileEditorProvider[providerList.size()]);
        }
        return new EditorWithProviderComposite(file2, editors, providers2, this);
    }

    private static void clearWindowIfNeeded(@NotNull EditorWindow window) {
        if (window == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(47);
        }
        if (UISettings.getInstance().getEditorTabPlacement() == 0 || UISettings.getInstance().getPresentationMode()) {
            window.clear();
        }
    }

    private void restoreEditorState(@NotNull VirtualFile file2, @NotNull FileEditorProvider provider, @NotNull FileEditor editor, HistoryEntry entry, boolean newEditor) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(48);
        }
        if (provider == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(49);
        }
        if (editor == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(50);
        }
        FileEditorState state = null;
        if (entry != null) {
            state = entry.getState(provider);
        }
        if (state == null && newEditor) {
            state = EditorHistoryManager.getInstance(this.myProject).getState(file2, provider);
        }
        if (state != null) {
            if (!FileEditorManagerImpl.isDumbAware(editor)) {
                FileEditorState finalState = state;
                DumbService.getInstance((Project)this.getProject()).runWhenSmart(() -> {
                    if (editor == null) {
                        FileEditorManagerImpl.$$$reportNull$$$0(121);
                    }
                    editor.setState(finalState);
                });
            } else {
                editor.setState(state);
            }
        }
    }

    @Override
    @NotNull
    public ActionCallback notifyPublisher(final @NotNull Runnable runnable2) {
        if (runnable2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(51);
        }
        final IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)this.myProject);
        final ActionCallback done2 = new ActionCallback();
        ActionCallback actionCallback = this.myBusyObject.execute(new ActiveRunnable(){

            @NotNull
            public ActionCallback run() {
                focusManager.doWhenFocusSettlesDown((Runnable)new ExpirableRunnable.ForProject(FileEditorManagerImpl.this.myProject){

                    public void run() {
                        runnable2.run();
                        done2.setDone();
                    }
                }, ModalityState.current());
                ActionCallback actionCallback = done2;
                if (actionCallback == null) {
                    5.$$$reportNull$$$0(0);
                }
                return actionCallback;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$5", "run"));
            }
        });
        if (actionCallback == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(52);
        }
        return actionCallback;
    }

    public void setSelectedEditor(@NotNull VirtualFile file2, @NotNull String fileEditorProviderId) {
        EditorWithProviderComposite composite;
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(53);
        }
        if (fileEditorProviderId == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(54);
        }
        if ((composite = this.getCurrentEditorWithProviderComposite(file2)) == null) {
            List<EditorWithProviderComposite> composites = this.getEditorComposites(file2);
            if (composites.isEmpty()) {
                return;
            }
            composite = composites.get(0);
        }
        FileEditorProvider[] editorProviders = composite.getProviders();
        FileEditorProvider selectedProvider = (FileEditorProvider)composite.getSelectedEditorWithProvider().getSecond();
        for (int i = 0; i < editorProviders.length; ++i) {
            if (!editorProviders[i].getEditorTypeId().equals(fileEditorProviderId) || selectedProvider.equals(editorProviders[i])) continue;
            composite.setSelectedEditor(i);
            composite.getSelectedEditor().selectNotify();
        }
    }

    @Nullable
    EditorWithProviderComposite newEditorComposite(VirtualFile file2) {
        if (file2 == null) {
            return null;
        }
        FileEditorProviderManager editorProviderManager = FileEditorProviderManager.getInstance();
        FileEditorProvider[] providers2 = editorProviderManager.getProviders(this.myProject, file2);
        if (providers2.length == 0) {
            return null;
        }
        FileEditor[] editors = new FileEditor[providers2.length];
        for (int i = 0; i < providers2.length; ++i) {
            FileEditor editor;
            FileEditorProvider provider = providers2[i];
            LOG.assertTrue(provider != null);
            LOG.assertTrue(provider.accept(this.myProject, file2));
            editors[i] = editor = provider.createEditor(this.myProject, file2);
            LOG.assertTrue(editor.isValid());
            editor.addPropertyChangeListener(this.myEditorPropertyChangeListener);
        }
        EditorWithProviderComposite newComposite = new EditorWithProviderComposite(file2, editors, providers2, this);
        EditorHistoryManager editorHistoryManager = EditorHistoryManager.getInstance(this.myProject);
        for (int i = 0; i < editors.length; ++i) {
            FileEditor editor = editors[i];
            FileEditorProvider provider = providers2[i];
            FileEditorState state = editorHistoryManager.getState(file2, provider);
            if (state == null) continue;
            editor.setState(state);
        }
        return newComposite;
    }

    @NotNull
    public List<FileEditor> openEditor(@NotNull OpenFileDescriptor descriptor2, boolean focusEditor) {
        if (descriptor2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(55);
        }
        FileEditorManagerImpl.assertDispatchThread();
        if (descriptor2.getFile() instanceof VirtualFileWindow) {
            VirtualFileWindow delegate = (VirtualFileWindow)descriptor2.getFile();
            int hostOffset = delegate.getDocumentWindow().injectedToHost(descriptor2.getOffset());
            OpenFileDescriptor realDescriptor = new OpenFileDescriptor(descriptor2.getProject(), delegate.getDelegate(), hostOffset);
            realDescriptor.setUseCurrentWindow(descriptor2.isUseCurrentWindow());
            List<FileEditor> list2 = this.openEditor(realDescriptor, focusEditor);
            if (list2 == null) {
                FileEditorManagerImpl.$$$reportNull$$$0(56);
            }
            return list2;
        }
        SmartList result2 = new SmartList();
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> this.lambda$openEditor$10(descriptor2, focusEditor, (List)result2), "", null);
        SmartList smartList = result2;
        if (smartList == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(57);
        }
        return smartList;
    }

    private boolean navigateAndSelectEditor(@NotNull NavigatableFileEditor editor, @NotNull OpenFileDescriptor descriptor2) {
        if (editor == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(58);
        }
        if (descriptor2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(59);
        }
        if (editor.canNavigateTo((Navigatable)descriptor2)) {
            this.setSelectedEditor((FileEditor)editor);
            editor.navigateTo((Navigatable)descriptor2);
            return true;
        }
        return false;
    }

    private void setSelectedEditor(@NotNull FileEditor editor) {
        EditorWithProviderComposite composite;
        if (editor == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(60);
        }
        if ((composite = this.getEditorComposite(editor)) == null) {
            return;
        }
        FileEditor[] editors = composite.getEditors();
        for (int i = 0; i < editors.length; ++i) {
            FileEditor each = editors[i];
            if (editor != each) continue;
            composite.setSelectedEditor(i);
            composite.getSelectedEditor().selectNotify();
            break;
        }
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(61);
        }
        return project2;
    }

    @Nullable
    public Editor openTextEditor(@NotNull OpenFileDescriptor descriptor2, boolean focusEditor) {
        if (descriptor2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(62);
        }
        List<FileEditor> fileEditors = this.openEditor(descriptor2, focusEditor);
        for (FileEditor fileEditor : fileEditors) {
            if (!(fileEditor instanceof TextEditor)) continue;
            this.setSelectedEditor(descriptor2.getFile(), TextEditorProvider.getInstance().getEditorTypeId());
            Editor editor = ((TextEditor)fileEditor).getEditor();
            return this.getOpenedEditor(editor, focusEditor);
        }
        return null;
    }

    protected Editor getOpenedEditor(@NotNull Editor editor, boolean focusEditor) {
        if (editor == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(63);
        }
        return editor;
    }

    public Editor getSelectedTextEditor() {
        return this.getSelectedTextEditor(false);
    }

    public Editor getSelectedTextEditor(boolean lockfree) {
        EditorWithProviderComposite selectedEditor;
        EditorWindow currentWindow;
        if (!lockfree) {
            FileEditorManagerImpl.assertDispatchThread();
        }
        EditorWindow editorWindow = currentWindow = lockfree ? this.getMainSplitters().getCurrentWindow() : this.getSplitters().getCurrentWindow();
        if (currentWindow != null && (selectedEditor = currentWindow.getSelectedEditor()) != null && selectedEditor.getSelectedEditor() instanceof TextEditor) {
            return ((TextEditor)selectedEditor.getSelectedEditor()).getEditor();
        }
        return null;
    }

    public boolean isFileOpen(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(64);
        }
        return !this.getEditorComposites(file2).isEmpty();
    }

    @NotNull
    public VirtualFile[] getOpenFiles() {
        THashSet openFiles = new THashSet();
        for (EditorsSplitters each : this.getAllSplitters()) {
            ContainerUtil.addAll((Collection)openFiles, (Object[])each.getOpenFiles());
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray((Collection)openFiles);
        if (virtualFileArray == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(65);
        }
        return virtualFileArray;
    }

    @NotNull
    public VirtualFile[] getSelectedFiles() {
        LinkedHashSet selectedFiles = new LinkedHashSet();
        EditorsSplitters activeSplitters = this.getSplitters();
        ContainerUtil.addAll(selectedFiles, (Object[])activeSplitters.getSelectedFiles());
        for (EditorsSplitters each : this.getAllSplitters()) {
            if (each == activeSplitters) continue;
            ContainerUtil.addAll(selectedFiles, (Object[])each.getSelectedFiles());
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(selectedFiles);
        if (virtualFileArray == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(66);
        }
        return virtualFileArray;
    }

    @NotNull
    public FileEditor[] getSelectedEditors() {
        HashSet selectedEditors = new HashSet();
        for (EditorsSplitters each : this.getAllSplitters()) {
            ContainerUtil.addAll(selectedEditors, (Object[])each.getSelectedEditors());
        }
        FileEditor[] fileEditorArray = selectedEditors.toArray(new FileEditor[selectedEditors.size()]);
        if (fileEditorArray == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(67);
        }
        return fileEditorArray;
    }

    @Override
    @NotNull
    public EditorsSplitters getSplitters() {
        EditorsSplitters active = null;
        if (ApplicationManager.getApplication().isDispatchThread()) {
            active = this.getActiveSplittersSync();
        }
        EditorsSplitters editorsSplitters = active == null ? this.getMainSplitters() : active;
        if (editorsSplitters == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(68);
        }
        return editorsSplitters;
    }

    @Nullable
    public FileEditor getSelectedEditor(@NotNull VirtualFile file2) {
        Pair<FileEditor, FileEditorProvider> selectedEditorWithProvider;
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(69);
        }
        return (selectedEditorWithProvider = this.getSelectedEditorWithProvider(file2)) == null ? null : (FileEditor)selectedEditorWithProvider.getFirst();
    }

    @Override
    @Nullable
    public Pair<FileEditor, FileEditorProvider> getSelectedEditorWithProvider(@NotNull VirtualFile file2) {
        EditorWithProviderComposite composite;
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(70);
        }
        if (file2 instanceof VirtualFileWindow) {
            file2 = ((VirtualFileWindow)file2).getDelegate();
        }
        if ((composite = this.getCurrentEditorWithProviderComposite(file2)) != null) {
            return composite.getSelectedEditorWithProvider();
        }
        List<EditorWithProviderComposite> composites = this.getEditorComposites(file2);
        return composites.isEmpty() ? null : composites.get(0).getSelectedEditorWithProvider();
    }

    @Override
    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> getEditorsWithProviders(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(71);
        }
        FileEditorManagerImpl.assertReadAccess();
        EditorWithProviderComposite composite = this.getCurrentEditorWithProviderComposite(file2);
        if (composite != null) {
            Pair pair2 = Pair.create((Object)composite.getEditors(), (Object)composite.getProviders());
            if (pair2 == null) {
                FileEditorManagerImpl.$$$reportNull$$$0(72);
            }
            return pair2;
        }
        List<EditorWithProviderComposite> composites = this.getEditorComposites(file2);
        if (!composites.isEmpty()) {
            Pair pair3 = Pair.create((Object)composites.get(0).getEditors(), (Object)composites.get(0).getProviders());
            if (pair3 == null) {
                FileEditorManagerImpl.$$$reportNull$$$0(73);
            }
            return pair3;
        }
        Pair pair4 = Pair.create((Object)EMPTY_EDITOR_ARRAY, (Object)EMPTY_PROVIDER_ARRAY);
        if (pair4 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(74);
        }
        return pair4;
    }

    @NotNull
    public FileEditor[] getEditors(@NotNull VirtualFile file2) {
        EditorWithProviderComposite composite;
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(75);
        }
        FileEditorManagerImpl.assertReadAccess();
        if (file2 instanceof VirtualFileWindow) {
            file2 = ((VirtualFileWindow)file2).getDelegate();
        }
        if ((composite = this.getCurrentEditorWithProviderComposite(file2)) != null) {
            FileEditor[] fileEditorArray = composite.getEditors();
            if (fileEditorArray == null) {
                FileEditorManagerImpl.$$$reportNull$$$0(76);
            }
            return fileEditorArray;
        }
        List<EditorWithProviderComposite> composites = this.getEditorComposites(file2);
        if (!composites.isEmpty()) {
            FileEditor[] fileEditorArray = composites.get(0).getEditors();
            if (fileEditorArray == null) {
                FileEditorManagerImpl.$$$reportNull$$$0(77);
            }
            return fileEditorArray;
        }
        if (EMPTY_EDITOR_ARRAY == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(78);
        }
        return EMPTY_EDITOR_ARRAY;
    }

    @NotNull
    public FileEditor[] getAllEditors(@NotNull VirtualFile file2) {
        List<EditorWithProviderComposite> editorComposites;
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(79);
        }
        if ((editorComposites = this.getEditorComposites(file2)).isEmpty()) {
            if (EMPTY_EDITOR_ARRAY == null) {
                FileEditorManagerImpl.$$$reportNull$$$0(80);
            }
            return EMPTY_EDITOR_ARRAY;
        }
        ArrayList editors = new ArrayList();
        for (EditorWithProviderComposite composite : editorComposites) {
            ContainerUtil.addAll(editors, (Object[])composite.getEditors());
        }
        FileEditor[] fileEditorArray = editors.toArray(new FileEditor[editors.size()]);
        if (fileEditorArray == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(81);
        }
        return fileEditorArray;
    }

    @Nullable
    private EditorWithProviderComposite getCurrentEditorWithProviderComposite(@NotNull VirtualFile virtualFile) {
        EditorWindow editorWindow;
        if (virtualFile == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(82);
        }
        if ((editorWindow = this.getSplitters().getCurrentWindow()) != null) {
            return editorWindow.findFileComposite(virtualFile);
        }
        return null;
    }

    @NotNull
    private List<EditorWithProviderComposite> getEditorComposites(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(83);
        }
        ArrayList<EditorWithProviderComposite> result2 = new ArrayList<EditorWithProviderComposite>();
        Set<EditorsSplitters> all = this.getAllSplitters();
        for (EditorsSplitters each : all) {
            result2.addAll(each.findEditorComposites(file2));
        }
        ArrayList<EditorWithProviderComposite> arrayList = result2;
        if (arrayList == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(84);
        }
        return arrayList;
    }

    @NotNull
    public FileEditor[] getAllEditors() {
        FileEditorManagerImpl.assertReadAccess();
        ArrayList result2 = new ArrayList();
        Set<EditorsSplitters> allSplitters = this.getAllSplitters();
        for (EditorsSplitters splitter : allSplitters) {
            EditorWithProviderComposite[] editorsComposites;
            for (EditorWithProviderComposite editorsComposite : editorsComposites = splitter.getEditorsComposites()) {
                Object[] editors = editorsComposite.getEditors();
                ContainerUtil.addAll(result2, (Object[])editors);
            }
        }
        FileEditor[] fileEditorArray = result2.toArray(new FileEditor[result2.size()]);
        if (fileEditorArray == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(85);
        }
        return fileEditorArray;
    }

    public void showEditorAnnotation(@NotNull FileEditor editor, @NotNull JComponent annotationComponent) {
        if (editor == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(86);
        }
        if (annotationComponent == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(87);
        }
        this.addTopComponent(editor, annotationComponent);
    }

    public void removeEditorAnnotation(@NotNull FileEditor editor, @NotNull JComponent annotationComponent) {
        if (editor == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(88);
        }
        if (annotationComponent == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(89);
        }
        this.removeTopComponent(editor, annotationComponent);
    }

    @NotNull
    public List<JComponent> getTopComponents(@NotNull FileEditor editor) {
        EditorWithProviderComposite composite;
        if (editor == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(90);
        }
        List<JComponent> list2 = (composite = this.getEditorComposite(editor)) != null ? composite.getTopComponents(editor) : Collections.emptyList();
        if (list2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(91);
        }
        return list2;
    }

    public void addTopComponent(@NotNull FileEditor editor, @NotNull JComponent component) {
        EditorWithProviderComposite composite;
        if (editor == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(92);
        }
        if (component == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(93);
        }
        if ((composite = this.getEditorComposite(editor)) != null) {
            composite.addTopComponent(editor, component);
        }
    }

    public void removeTopComponent(@NotNull FileEditor editor, @NotNull JComponent component) {
        EditorWithProviderComposite composite;
        if (editor == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(94);
        }
        if (component == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(95);
        }
        if ((composite = this.getEditorComposite(editor)) != null) {
            composite.removeTopComponent(editor, component);
        }
    }

    public void addBottomComponent(@NotNull FileEditor editor, @NotNull JComponent component) {
        EditorWithProviderComposite composite;
        if (editor == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(96);
        }
        if (component == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(97);
        }
        if ((composite = this.getEditorComposite(editor)) != null) {
            composite.addBottomComponent(editor, component);
        }
    }

    public void removeBottomComponent(@NotNull FileEditor editor, @NotNull JComponent component) {
        EditorWithProviderComposite composite;
        if (editor == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(98);
        }
        if (component == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(99);
        }
        if ((composite = this.getEditorComposite(editor)) != null) {
            composite.removeBottomComponent(editor, component);
        }
    }

    public void addFileEditorManagerListener(@NotNull FileEditorManagerListener listener2) {
        if (listener2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(100);
        }
        this.myListenerList.add((Object)listener2);
    }

    public void addFileEditorManagerListener(@NotNull FileEditorManagerListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(101);
        }
        if (parentDisposable == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(102);
        }
        this.myListenerList.add((Object)listener2, parentDisposable);
    }

    public void removeFileEditorManagerListener(@NotNull FileEditorManagerListener listener2) {
        if (listener2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(103);
        }
        this.myListenerList.remove((Object)listener2);
    }

    protected void projectOpened(@NotNull MessageBusConnection connection) {
        if (connection == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(104);
        }
        this.getMainSplitters().startListeningFocus();
        FileStatusManager fileStatusManager = FileStatusManager.getInstance((Project)this.myProject);
        if (fileStatusManager != null) {
            MyFileStatusListener myFileStatusListener = new MyFileStatusListener();
            fileStatusManager.addFileStatusListener((FileStatusListener)myFileStatusListener, (Disposable)this.myProject);
        }
        connection.subscribe(FileTypeManager.TOPIC, (Object)new MyFileTypeListener());
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new MyRootsListener());
        MyVirtualFileListener myVirtualFileListener = new MyVirtualFileListener();
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)myVirtualFileListener, (Disposable)this.myProject);
        connection.subscribe(UISettingsListener.TOPIC, (Object)new MyUISettingsListener());
        StartupManager.getInstance((Project)this.myProject).registerPostStartupActivity((Runnable)((DumbAwareRunnable)() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            this.setTabsMode(UISettings.getInstance().getEditorTabPlacement() != 0);
            ToolWindowManager.getInstance((Project)this.myProject).invokeLater(() -> {
                if (!this.myProject.isDisposed()) {
                    CommandProcessor.getInstance().executeCommand(this.myProject, () -> ApplicationManager.getApplication().invokeLater(() -> {
                        long currentTime = System.nanoTime();
                        Long startTime = (Long)this.myProject.getUserData(ProjectImpl.CREATION_TIME);
                        if (startTime != null) {
                            LOG.info("Project opening took " + (currentTime - startTime) / 1000000L + " ms");
                            PluginManagerCore.dumpPluginClassStatistics();
                        }
                    }, this.myProject.getDisposed()), "", null);
                }
            });
        }));
    }

    @Nullable
    public Element getState() {
        if (this.mySplitters == null) {
            return null;
        }
        Element state = new Element("state");
        this.getMainSplitters().writeExternal(state);
        return state;
    }

    public void loadState(Element state) {
        this.getMainSplitters().readExternal(state);
    }

    @Nullable
    private EditorWithProviderComposite getEditorComposite(@NotNull FileEditor editor) {
        if (editor == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(105);
        }
        for (EditorsSplitters splitters : this.getAllSplitters()) {
            EditorWithProviderComposite[] editorsComposites = splitters.getEditorsComposites();
            for (int i = editorsComposites.length - 1; i >= 0; --i) {
                EditorWithProviderComposite composite = editorsComposites[i];
                FileEditor[] editors = composite.getEditors();
                for (int j = editors.length - 1; j >= 0; --j) {
                    FileEditor _editor = editors[j];
                    LOG.assertTrue(_editor != null);
                    if (!editor.equals(_editor)) continue;
                    return composite;
                }
            }
        }
        return null;
    }

    private static void assertDispatchThread() {
        ApplicationManager.getApplication().assertIsDispatchThread();
    }

    private static void assertReadAccess() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
    }

    public void fireSelectionChanged(EditorComposite newSelectedComposite) {
        boolean editorsEqual;
        boolean filesEqual;
        Trinity<VirtualFile, FileEditor, FileEditorProvider> oldData = FileEditorManagerImpl.extract((EditorComposite)SoftReference.dereference(this.myLastSelectedComposite));
        Trinity<VirtualFile, FileEditor, FileEditorProvider> newData = FileEditorManagerImpl.extract(newSelectedComposite);
        WeakReference<EditorComposite> weakReference = this.myLastSelectedComposite = newSelectedComposite == null ? null : new WeakReference<EditorComposite>(newSelectedComposite);
        boolean bl = oldData.first == null ? newData.first == null : (filesEqual = ((VirtualFile)oldData.first).equals(newData.first));
        boolean bl2 = oldData.second == null ? newData.second == null : (editorsEqual = ((FileEditor)oldData.second).equals(newData.second));
        if (!filesEqual || !editorsEqual) {
            JComponent component;
            EditorWindowHolder holder;
            if (oldData.first != null && newData.first != null) {
                for (FileEditorAssociateFinder finder : (FileEditorAssociateFinder[])Extensions.getExtensions(FileEditorAssociateFinder.EP_NAME)) {
                    VirtualFile associatedFile = finder.getAssociatedFileToOpen(this.myProject, (VirtualFile)oldData.first);
                    if (!Comparing.equal((Object)associatedFile, (Object)newData.first)) continue;
                    return;
                }
            }
            FileEditorManagerEvent event = new FileEditorManagerEvent((FileEditorManager)this, (VirtualFile)oldData.first, (FileEditor)oldData.second, (FileEditorProvider)oldData.third, (VirtualFile)newData.first, (FileEditor)newData.second, (FileEditorProvider)newData.third);
            FileEditorManagerListener publisher = (FileEditorManagerListener)this.getProject().getMessageBus().syncPublisher(FileEditorManagerListener.FILE_EDITOR_MANAGER);
            if (newData.first != null && (holder = (EditorWindowHolder)UIUtil.getParentOfType(EditorWindowHolder.class, (Component)(component = ((FileEditor)newData.second).getComponent()))) != null) {
                this.addSelectionRecord((VirtualFile)newData.first, holder.getEditorWindow());
            }
            this.notifyPublisher(() -> publisher.selectionChanged(event));
        }
    }

    @NotNull
    private static Trinity<VirtualFile, FileEditor, FileEditorProvider> extract(@Nullable EditorComposite composite) {
        FileEditorProvider provider;
        FileEditor editor;
        VirtualFile file2;
        if (composite == null || composite.isDisposed()) {
            file2 = null;
            editor = null;
            provider = null;
        } else {
            file2 = composite.getFile();
            Pair<FileEditor, FileEditorProvider> pair2 = composite.getSelectedEditorWithProvider();
            editor = (FileEditor)pair2.first;
            provider = (FileEditorProvider)pair2.second;
        }
        Trinity trinity = new Trinity((Object)file2, (Object)editor, provider);
        if (trinity == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(106);
        }
        return trinity;
    }

    @Override
    public boolean isChanged(@NotNull EditorComposite editor) {
        FileStatusManager fileStatusManager;
        if (editor == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(107);
        }
        if ((fileStatusManager = FileStatusManager.getInstance((Project)this.myProject)) == null) {
            return false;
        }
        FileStatus status = fileStatusManager.getStatus(editor.getFile());
        return status != FileStatus.UNKNOWN && status != FileStatus.NOT_CHANGED;
    }

    void disposeComposite(@NotNull EditorWithProviderComposite editor) {
        if (editor == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(108);
        }
        if (this.getAllEditors().length == 0) {
            this.setCurrentWindow(null);
        }
        if (editor.equals(this.getLastSelected())) {
            editor.getSelectedEditor().deselectNotify();
            this.getSplitters().setCurrentWindow(null, false);
        }
        FileEditor[] editors = editor.getEditors();
        FileEditorProvider[] providers2 = editor.getProviders();
        FileEditor selectedEditor = editor.getSelectedEditor();
        for (int i = editors.length - 1; i >= 0; --i) {
            FileEditor editor1 = editors[i];
            FileEditorProvider provider = providers2[i];
            if (!editor.equals(selectedEditor) && selectedEditor.equals(editor1)) {
                editor1.deselectNotify();
            }
            editor1.removePropertyChangeListener(this.myEditorPropertyChangeListener);
            provider.disposeEditor(editor1);
        }
        Disposer.dispose((Disposable)editor);
    }

    @Nullable
    private EditorComposite getLastSelected() {
        EditorWindow currentWindow = this.getActiveSplittersSync().getCurrentWindow();
        if (currentWindow != null) {
            return currentWindow.getSelectedEditor();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runChange(@NotNull FileEditorManagerChange change, @Nullable EditorsSplitters splitters) {
        if (change == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(109);
        }
        HashSet<EditorsSplitters> target2 = new HashSet<EditorsSplitters>();
        if (splitters == null) {
            target2.addAll(this.getAllSplitters());
        } else {
            target2.add(splitters);
        }
        for (EditorsSplitters each : target2) {
            ++each.myInsideChange;
            try {
                change.run(each);
            }
            finally {
                --each.myInsideChange;
            }
        }
    }

    private static boolean moveFocusOnDelete() {
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        if (window != null) {
            Component component = FocusTrackback.getFocusFor(window);
            if (component != null) {
                return component instanceof EditorComponentImpl;
            }
            return window instanceof IdeFrameImpl;
        }
        return true;
    }

    @Override
    public boolean isInsideChange() {
        return this.getSplitters().isInsideChange();
    }

    @Override
    public void closeAllFiles() {
        VirtualFile[] openFiles;
        for (VirtualFile openFile2 : openFiles = this.getSplitters().getOpenFiles()) {
            this.closeFile(openFile2);
        }
    }

    @Override
    @NotNull
    public VirtualFile[] getSiblings(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(110);
        }
        VirtualFile[] virtualFileArray = this.getOpenFiles();
        if (virtualFileArray == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(111);
        }
        return virtualFileArray;
    }

    void queueUpdateFile(final @NotNull VirtualFile file2) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(112);
        }
        this.myQueue.queue(new Update(file2){

            public void run() {
                if (FileEditorManagerImpl.this.isFileOpen(file2)) {
                    FileEditorManagerImpl.this.updateFileIcon(file2);
                    FileEditorManagerImpl.this.updateFileColor(file2);
                    FileEditorManagerImpl.this.updateFileBackgroundColor(file2);
                }
            }
        });
    }

    @Override
    public EditorsSplitters getSplittersFor(Component c) {
        EditorsSplitters splitters = null;
        DockContainer dockContainer = this.myDockManager.getContainerFor(c);
        if (dockContainer instanceof DockableEditorTabbedContainer) {
            splitters = ((DockableEditorTabbedContainer)dockContainer).getSplitters();
        }
        if (splitters == null) {
            splitters = this.getMainSplitters();
        }
        return splitters;
    }

    @NotNull
    public List<Pair<VirtualFile, EditorWindow>> getSelectionHistory() {
        ArrayList<Object> copy = new ArrayList<Object>();
        for (Pair<VirtualFile, EditorWindow> pair2 : this.mySelectionHistory) {
            if (((EditorWindow)pair2.second).getFiles().length == 0) {
                Pair p;
                EditorWindow[] windows = ((EditorWindow)pair2.second).getOwner().getWindows();
                if (windows.length <= 0 || windows[0] == null || windows[0].getFiles().length <= 0 || copy.contains(p = Pair.create((Object)pair2.first, (Object)windows[0]))) continue;
                copy.add(p);
                continue;
            }
            if (copy.contains(pair2)) continue;
            copy.add(pair2);
        }
        this.mySelectionHistory.clear();
        this.mySelectionHistory.addAll(copy);
        List<Pair<VirtualFile, EditorWindow>> list2 = this.mySelectionHistory;
        if (list2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(113);
        }
        return list2;
    }

    public void addSelectionRecord(@NotNull VirtualFile file2, @NotNull EditorWindow window) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(114);
        }
        if (window == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(115);
        }
        Pair record = Pair.create((Object)file2, (Object)window);
        this.mySelectionHistory.remove(record);
        this.mySelectionHistory.add(0, (Pair<VirtualFile, EditorWindow>)record);
    }

    void removeSelectionRecord(@NotNull VirtualFile file2, @NotNull EditorWindow window) {
        if (file2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(116);
        }
        if (window == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(117);
        }
        this.mySelectionHistory.remove(Pair.create((Object)file2, (Object)window));
        this.updateFileName(file2);
    }

    @NotNull
    public ActionCallback getReady(@NotNull Object requestor) {
        if (requestor == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(118);
        }
        ActionCallback actionCallback = this.myBusyObject.getReady(requestor);
        if (actionCallback == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(119);
        }
        return actionCallback;
    }

    private /* synthetic */ void lambda$openEditor$10(@NotNull OpenFileDescriptor descriptor2, boolean focusEditor, List result2) {
        Object editor;
        int n;
        if (descriptor2 == null) {
            FileEditorManagerImpl.$$$reportNull$$$0(120);
        }
        VirtualFile file2 = descriptor2.getFile();
        Object[] editors = this.openFile(file2, focusEditor, !descriptor2.isUseCurrentWindow());
        ContainerUtil.addAll((Collection)result2, (Object[])editors);
        boolean navigated = false;
        Object[] objectArray = editors;
        int n2 = objectArray.length;
        for (n = 0; !(n >= n2 || (editor = objectArray[n]) instanceof NavigatableFileEditor && this.getSelectedEditor(descriptor2.getFile()) == editor && (navigated = this.navigateAndSelectEditor((NavigatableFileEditor)editor, descriptor2))); ++n) {
        }
        if (!navigated) {
            objectArray = editors;
            n2 = objectArray.length;
            for (n = 0; !(n >= n2 || (editor = objectArray[n]) instanceof NavigatableFileEditor && this.getSelectedEditor(descriptor2.getFile()) != editor && this.navigateAndSelectEditor((NavigatableFileEditor)editor, descriptor2)); ++n) {
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 14: 
            case 17: 
            case 26: 
            case 27: 
            case 28: 
            case 33: 
            case 36: 
            case 39: 
            case 42: 
            case 43: 
            case 52: 
            case 56: 
            case 57: 
            case 61: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 78: 
            case 80: 
            case 81: 
            case 84: 
            case 85: 
            case 91: 
            case 106: 
            case 111: 
            case 113: 
            case 119: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 14: 
            case 17: 
            case 26: 
            case 27: 
            case 28: 
            case 33: 
            case 36: 
            case 39: 
            case 42: 
            case 43: 
            case 52: 
            case 56: 
            case 57: 
            case 61: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 78: 
            case 80: 
            case 81: 
            case 84: 
            case 85: 
            case 91: 
            case 106: 
            case 111: 
            case 113: 
            case 119: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 13: 
            case 50: 
            case 58: 
            case 60: 
            case 63: 
            case 86: 
            case 88: 
            case 90: 
            case 92: 
            case 94: 
            case 96: 
            case 98: 
            case 105: 
            case 107: 
            case 108: 
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 14: 
            case 17: 
            case 26: 
            case 27: 
            case 28: 
            case 33: 
            case 36: 
            case 39: 
            case 42: 
            case 43: 
            case 52: 
            case 56: 
            case 57: 
            case 61: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 78: 
            case 80: 
            case 81: 
            case 84: 
            case 85: 
            case 91: 
            case 106: 
            case 111: 
            case 113: 
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 29: 
            case 31: 
            case 35: 
            case 38: 
            case 41: 
            case 44: 
            case 48: 
            case 53: 
            case 64: 
            case 69: 
            case 70: 
            case 71: 
            case 75: 
            case 79: 
            case 83: 
            case 110: 
            case 112: 
            case 114: 
            case 116: 
            case 122: 
            case 124: 
            case 125: 
            case 127: 
            case 129: 
            case 130: 
            case 131: 
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: 
            case 16: 
            case 19: 
            case 21: 
            case 32: 
            case 34: 
            case 37: 
            case 40: 
            case 47: 
            case 115: 
            case 117: 
            case 123: 
            case 126: 
            case 128: 
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "splitters";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editors";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditorProviderId";
                break;
            }
            case 55: 
            case 59: 
            case 62: 
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 87: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationComponent";
                break;
            }
            case 93: 
            case 95: 
            case 97: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 100: 
            case 101: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainSplitters";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSplitters";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveSplittersAsync";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTooltipText";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getWindows";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveWindow";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "openFileWithProviders";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "openFileImpl2";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "openFileImpl3";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "openFileImpl4";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "notifyPublisher";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "openEditor";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpenFiles";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedFiles";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedEditors";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getSplitters";
                break;
            }
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorsWithProviders";
                break;
            }
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditors";
                break;
            }
            case 80: 
            case 81: 
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllEditors";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorComposites";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopComponents";
                break;
            }
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "extract";
                break;
            }
            case 111: {
                objectArray = objectArray2;
                objectArray2[1] = "getSiblings";
                break;
            }
            case 113: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionHistory";
                break;
            }
            case 119: {
                objectArray = objectArray2;
                objectArray2[1] = "getReady";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isDumbAware";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 14: 
            case 17: 
            case 26: 
            case 27: 
            case 28: 
            case 33: 
            case 36: 
            case 39: 
            case 42: 
            case 43: 
            case 52: 
            case 56: 
            case 57: 
            case 61: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 78: 
            case 80: 
            case 81: 
            case 84: 
            case 85: 
            case 91: 
            case 106: 
            case 111: 
            case 113: 
            case 119: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFileColor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isProblem";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFileTooltipText";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateFilePresentation";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateFileColor";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateFileBackgroundColor";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "updateFileIcon";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getNextWindow";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPrevWindow";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "closeFile";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "closeFileImpl";
                break;
            }
            case 25: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "openFileWithProviders";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "openFileInNewWindow";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "openAssociatedFile";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "openFileImpl2";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "openFileImpl3";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "openFileImpl4";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "createComposite";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "clearWindowIfNeeded";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "restoreEditorState";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "notifyPublisher";
                break;
            }
            case 53: 
            case 54: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedEditor";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "openEditor";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "navigateAndSelectEditor";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "openTextEditor";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getOpenedEditor";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "isFileOpen";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedEditor";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedEditorWithProvider";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getEditorsWithProviders";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "getEditors";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getAllEditors";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentEditorWithProviderComposite";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "getEditorComposites";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "showEditorAnnotation";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "removeEditorAnnotation";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "getTopComponents";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "addTopComponent";
                break;
            }
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "removeTopComponent";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "addBottomComponent";
                break;
            }
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "removeBottomComponent";
                break;
            }
            case 100: 
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "addFileEditorManagerListener";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "removeFileEditorManagerListener";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "projectOpened";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "getEditorComposite";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "isChanged";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "disposeComposite";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "runChange";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "getSiblings";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "queueUpdateFile";
                break;
            }
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "addSelectionRecord";
                break;
            }
            case 116: 
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "removeSelectionRecord";
                break;
            }
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "getReady";
                break;
            }
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "lambda$openEditor$10";
                break;
            }
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "lambda$restoreEditorState$9";
                break;
            }
            case 122: 
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "lambda$openFileImpl4$8";
                break;
            }
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$7";
                break;
            }
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "lambda$openFileImpl4$6";
                break;
            }
            case 126: 
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "lambda$openFileImpl4$5";
                break;
            }
            case 128: 
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "lambda$openFileImpl2$4";
                break;
            }
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "lambda$closeFileImpl$3";
                break;
            }
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "lambda$closeFile$2";
                break;
            }
            case 132: 
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "lambda$closeFile$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 14: 
            case 17: 
            case 26: 
            case 27: 
            case 28: 
            case 33: 
            case 36: 
            case 39: 
            case 42: 
            case 43: 
            case 52: 
            case 56: 
            case 57: 
            case 61: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 78: 
            case 80: 
            case 81: 
            case 84: 
            case 85: 
            case 91: 
            case 106: 
            case 111: 
            case 113: 
            case 119: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class MyUISettingsListener
    implements UISettingsListener {
        private MyUISettingsListener() {
        }

        public void uiSettingsChanged(UISettings uiSettings) {
            FileEditorManagerImpl.assertDispatchThread();
            TransactionGuard.submitTransaction((Disposable)FileEditorManagerImpl.this.myProject, () -> this.handleUiSettingChange(uiSettings));
        }

        private void handleUiSettingChange(UISettings uiSettings) {
            FileEditorManagerImpl.this.setTabsMode(uiSettings.getEditorTabPlacement() != 0 && !uiSettings.getPresentationMode());
            for (EditorsSplitters each : FileEditorManagerImpl.this.getAllSplitters()) {
                each.setTabsPlacement(uiSettings.getEditorTabPlacement());
                each.trimToSize(uiSettings.getEditorTabLimit());
                if (uiSettings.getScrollTabLayoutInEditor()) {
                    each.setTabLayoutPolicy(1);
                    continue;
                }
                each.setTabLayoutPolicy(0);
            }
            VirtualFile[] openFiles = FileEditorManagerImpl.this.getOpenFiles();
            for (int i = openFiles.length - 1; i >= 0; --i) {
                VirtualFile file2 = openFiles[i];
                FileEditorManagerImpl.this.updateFileIcon(file2);
                FileEditorManagerImpl.this.updateFileName(file2);
                FileEditorManagerImpl.this.updateFileBackgroundColor(file2);
            }
        }
    }

    private class MyRootsListener
    implements ModuleRootListener {
        private boolean myScheduled;

        private MyRootsListener() {
        }

        public void rootsChanged(ModuleRootEvent event) {
            if (this.myScheduled) {
                return;
            }
            this.myScheduled = true;
            DumbService.getInstance((Project)FileEditorManagerImpl.this.myProject).runWhenSmart(() -> {
                this.myScheduled = false;
                this.handleRootChange();
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleRootChange() {
            EditorFileSwapper[] swappers = (EditorFileSwapper[])Extensions.getExtensions(EditorFileSwapper.EP_NAME);
            for (EditorWindow eachWindow : FileEditorManagerImpl.this.getWindows()) {
                EditorWithProviderComposite selected = eachWindow.getSelectedEditor();
                EditorWithProviderComposite[] editors = eachWindow.getEditors();
                for (int i = 0; i < editors.length; ++i) {
                    VirtualFile newFile;
                    EditorFileSwapper each;
                    EditorWithProviderComposite editor = editors[i];
                    VirtualFile file2 = editor.getFile();
                    if (!file2.isValid()) continue;
                    Pair<VirtualFile, Integer> newFilePair = null;
                    EditorFileSwapper[] editorFileSwapperArray = swappers;
                    int n = editorFileSwapperArray.length;
                    for (int j = 0; j < n && (newFilePair = (each = editorFileSwapperArray[j]).getFileToSwapTo(FileEditorManagerImpl.this.myProject, editor)) == null; ++j) {
                    }
                    if (newFilePair == null || (newFile = (VirtualFile)newFilePair.first) == null || eachWindow.findFileIndex(newFile) != -1) continue;
                    try {
                        TextEditorImpl openedEditor;
                        newFile.putUserData(EditorWindow.INITIAL_INDEX_KEY, (Object)i);
                        Pair<FileEditor[], FileEditorProvider[]> pair2 = FileEditorManagerImpl.this.openFileImpl2(eachWindow, newFile, editor == selected);
                        if (newFilePair.second != null && (openedEditor = EditorFileSwapper.findSinglePsiAwareEditor((FileEditor[])pair2.first)) != null) {
                            openedEditor.getEditor().getCaretModel().moveToOffset(((Integer)newFilePair.second).intValue());
                            openedEditor.getEditor().getScrollingModel().scrollToCaret(ScrollType.CENTER);
                        }
                    }
                    finally {
                        newFile.putUserData(EditorWindow.INITIAL_INDEX_KEY, null);
                    }
                    FileEditorManagerImpl.this.closeFile(file2, eachWindow);
                }
            }
        }
    }

    private final class MyFileTypeListener
    implements FileTypeListener {
        private MyFileTypeListener() {
        }

        public void fileTypesChanged(@NotNull FileTypeEvent event) {
            if (event == null) {
                MyFileTypeListener.$$$reportNull$$$0(0);
            }
            FileEditorManagerImpl.assertDispatchThread();
            VirtualFile[] openFiles = FileEditorManagerImpl.this.getOpenFiles();
            for (int i = openFiles.length - 1; i >= 0; --i) {
                VirtualFile file2 = openFiles[i];
                LOG.assertTrue(file2 != null);
                FileEditorManagerImpl.this.updateFileIcon(file2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$MyFileTypeListener", "fileTypesChanged"));
        }
    }

    private final class MyFileStatusListener
    implements FileStatusListener {
        private MyFileStatusListener() {
        }

        public void fileStatusesChanged() {
            FileEditorManagerImpl.assertDispatchThread();
            LOG.debug("FileEditorManagerImpl.MyFileStatusListener.fileStatusesChanged()");
            VirtualFile[] openFiles = FileEditorManagerImpl.this.getOpenFiles();
            for (int i = openFiles.length - 1; i >= 0; --i) {
                VirtualFile file2 = openFiles[i];
                LOG.assertTrue(file2 != null);
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("updating file status in tab for " + file2.getPath());
                    }
                    this.updateFileStatus(file2);
                }, ModalityState.NON_MODAL, FileEditorManagerImpl.this.myProject.getDisposed());
            }
        }

        public void fileStatusChanged(@NotNull VirtualFile file2) {
            if (file2 == null) {
                MyFileStatusListener.$$$reportNull$$$0(0);
            }
            FileEditorManagerImpl.assertDispatchThread();
            if (FileEditorManagerImpl.this.isFileOpen(file2)) {
                this.updateFileStatus(file2);
            }
        }

        private void updateFileStatus(VirtualFile file2) {
            FileEditorManagerImpl.this.updateFileColor(file2);
            FileEditorManagerImpl.this.updateFileIcon(file2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$MyFileStatusListener", "fileStatusChanged"));
        }
    }

    private final class MyEditorPropertyChangeListener
    implements PropertyChangeListener {
        private MyEditorPropertyChangeListener() {
        }

        @Override
        public void propertyChange(@NotNull PropertyChangeEvent e) {
            boolean valid;
            if (e == null) {
                MyEditorPropertyChangeListener.$$$reportNull$$$0(0);
            }
            FileEditorManagerImpl.assertDispatchThread();
            String propertyName = e.getPropertyName();
            if ("modified".equals(propertyName)) {
                FileEditor editor = (FileEditor)e.getSource();
                EditorWithProviderComposite composite = FileEditorManagerImpl.this.getEditorComposite(editor);
                if (composite != null) {
                    FileEditorManagerImpl.this.updateFileIcon(composite.getFile());
                }
            } else if ("valid".equals(propertyName) && !(valid = ((Boolean)e.getNewValue()).booleanValue())) {
                FileEditor editor = (FileEditor)e.getSource();
                LOG.assertTrue(editor != null);
                EditorWithProviderComposite composite = FileEditorManagerImpl.this.getEditorComposite(editor);
                if (composite != null) {
                    FileEditorManagerImpl.this.closeFile(composite.getFile());
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$MyEditorPropertyChangeListener", "propertyChange"));
        }
    }

    private final class MyVirtualFileListener
    implements VirtualFileListener {
        private MyVirtualFileListener() {
        }

        public void beforeFileDeletion(@NotNull VirtualFileEvent e) {
            if (e == null) {
                MyVirtualFileListener.$$$reportNull$$$0(0);
            }
            FileEditorManagerImpl.assertDispatchThread();
            boolean moveFocus = FileEditorManagerImpl.moveFocusOnDelete();
            VirtualFile file2 = e.getFile();
            VirtualFile[] openFiles = FileEditorManagerImpl.this.getOpenFiles();
            for (int i = openFiles.length - 1; i >= 0; --i) {
                if (!VfsUtilCore.isAncestor((VirtualFile)file2, (VirtualFile)openFiles[i], (boolean)false)) continue;
                FileEditorManagerImpl.this.closeFile(openFiles[i], moveFocus, true);
            }
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent e) {
            if (e == null) {
                MyVirtualFileListener.$$$reportNull$$$0(1);
            }
            if ("name".equals(e.getPropertyName())) {
                FileEditorManagerImpl.assertDispatchThread();
                VirtualFile file2 = e.getFile();
                if (FileEditorManagerImpl.this.isFileOpen(file2)) {
                    FileEditorManagerImpl.this.updateFileName(file2);
                    FileEditorManagerImpl.this.updateFileIcon(file2);
                    FileEditorManagerImpl.this.updateFileBackgroundColor(file2);
                }
            } else if ("writable".equals(e.getPropertyName()) || "encoding".equals(e.getPropertyName())) {
                this.updateIconAndStatusBar(e);
            }
        }

        private void updateIconAndStatusBar(VirtualFilePropertyEvent e) {
            FileEditorManagerImpl.assertDispatchThread();
            VirtualFile file2 = e.getFile();
            if (FileEditorManagerImpl.this.isFileOpen(file2)) {
                FileEditorManagerImpl.this.updateFileIcon(file2);
                if (file2.equals(FileEditorManagerImpl.this.getSelectedFiles()[0])) {
                    StatusBarEx statusBar = (StatusBarEx)WindowManager.getInstance().getStatusBar(FileEditorManagerImpl.this.myProject);
                    assert (statusBar != null);
                    statusBar.updateWidgets();
                }
            }
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent e) {
            VirtualFile[] openFiles;
            if (e == null) {
                MyVirtualFileListener.$$$reportNull$$$0(2);
            }
            VirtualFile file2 = e.getFile();
            for (VirtualFile openFile2 : openFiles = FileEditorManagerImpl.this.getOpenFiles()) {
                if (!VfsUtilCore.isAncestor((VirtualFile)file2, (VirtualFile)openFile2, (boolean)false)) continue;
                FileEditorManagerImpl.this.updateFileName(openFile2);
                FileEditorManagerImpl.this.updateFileBackgroundColor(openFile2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$MyVirtualFileListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeFileDeletion";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "propertyChanged";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileMoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyBorder
    implements Border {
        private MyBorder() {
        }

        @Override
        public void paintBorder(@NotNull Component c, @NotNull Graphics g, int x, int y, int width, int height) {
            if (c == null) {
                MyBorder.$$$reportNull$$$0(0);
            }
            if (g == null) {
                MyBorder.$$$reportNull$$$0(1);
            }
            if (UIUtil.isUnderAquaLookAndFeel()) {
                g.setColor(JBTabsImpl.MAC_AQUA_BG_COLOR);
                Insets insets = this.getBorderInsets(c);
                if (insets.top > 0) {
                    g.fillRect(x, y, width, height + insets.top);
                }
            }
        }

        @Override
        @NotNull
        public Insets getBorderInsets(Component c) {
            JBInsets jBInsets = JBUI.emptyInsets();
            if (jBInsets == null) {
                MyBorder.$$$reportNull$$$0(2);
            }
            return jBInsets;
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "c";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$MyBorder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/fileEditor/impl/FileEditorManagerImpl$MyBorder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBorderInsets";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "paintBorder";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

