/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.util.PingProgress;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.progress.util.SmoothProgressAdapter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.SystemNotifications;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.storage.HeavyProcessLatch;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProgressManagerImpl
extends CoreProgressManager
implements Disposable {
    private final Set<CoreProgressManager.CheckCanceledHook> myHooks = ContainerUtil.newConcurrentSet();

    public ProgressManagerImpl() {
        HeavyProcessLatch.INSTANCE.addUIActivityListener(new HeavyProcessLatch.HeavyProcessListener(){
            private final CoreProgressManager.CheckCanceledHook sleepHook = indicator -> ProgressManagerImpl.access$000();
            private final AtomicBoolean scheduled = new AtomicBoolean();
            private final Runnable addHookLater = () -> {
                this.scheduled.set(false);
                if (HeavyProcessLatch.INSTANCE.hasPrioritizedThread()) {
                    ProgressManagerImpl.this.addCheckCanceledHook(this.sleepHook);
                }
            };

            public void processStarted() {
                if (this.scheduled.compareAndSet(false, true)) {
                    AppExecutorUtil.getAppScheduledExecutorService().schedule(this.addHookLater, 5L, TimeUnit.MILLISECONDS);
                }
            }

            public void processFinished() {
                ProgressManagerImpl.this.removeCheckCanceledHook(this.sleepHook);
            }
        }, (Disposable)this);
    }

    @Override
    public void setCancelButtonText(String cancelButtonText) {
        ProgressIndicator original;
        ProgressIndicator progressIndicator = this.getProgressIndicator();
        if (progressIndicator != null && progressIndicator instanceof SmoothProgressAdapter && cancelButtonText != null && (original = ((SmoothProgressAdapter)progressIndicator).getOriginalProgressIndicator()) instanceof ProgressWindow) {
            ((ProgressWindow)original).setCancelButtonText(cancelButtonText);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeProcessUnderProgress(@NotNull Runnable process2, ProgressIndicator progress) throws ProcessCanceledException {
        CoreProgressManager.CheckCanceledHook hook;
        if (process2 == null) {
            ProgressManagerImpl.$$$reportNull$$$0(0);
        }
        if (progress instanceof ProgressWindow) {
            this.myCurrentUnsafeProgressCount.incrementAndGet();
        }
        CoreProgressManager.CheckCanceledHook checkCanceledHook = hook = progress instanceof PingProgress && ApplicationManager.getApplication().isDispatchThread() ? p -> {
            ((PingProgress)progress).interact();
            return true;
        } : null;
        if (hook != null) {
            this.addCheckCanceledHook(hook);
        }
        try {
            super.executeProcessUnderProgress(process2, progress);
        }
        finally {
            if (progress instanceof ProgressWindow) {
                this.myCurrentUnsafeProgressCount.decrementAndGet();
            }
            if (hook != null) {
                this.removeCheckCanceledHook(hook);
            }
        }
    }

    public static void __testWhileAlwaysCheckingCanceled(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            ProgressManagerImpl.$$$reportNull$$$0(1);
        }
        Thread fake = new Thread("fake");
        try {
            threadsUnderCanceledIndicator.add(fake);
            runnable2.run();
        }
        finally {
            threadsUnderCanceledIndicator.remove(fake);
        }
    }

    @Override
    public boolean runProcessWithProgressSynchronously(@NotNull Task task, @Nullable JComponent parentComponent) {
        if (task == null) {
            ProgressManagerImpl.$$$reportNull$$$0(2);
        }
        long start = System.currentTimeMillis();
        boolean result2 = super.runProcessWithProgressSynchronously(task, parentComponent);
        if (result2) {
            JFrame frame;
            long end = System.currentTimeMillis();
            Task.NotificationInfo notificationInfo = task.notifyFinished();
            long time = end - start;
            if (notificationInfo != null && time > 5000L && (frame = WindowManager.getInstance().getFrame(task.getProject())) != null && !frame.hasFocus()) {
                ProgressManagerImpl.systemNotify(notificationInfo);
            }
        }
        return result2;
    }

    private static void systemNotify(@NotNull Task.NotificationInfo info) {
        if (info == null) {
            ProgressManagerImpl.$$$reportNull$$$0(3);
        }
        SystemNotifications.getInstance().notify(info.getNotificationName(), info.getNotificationTitle(), info.getNotificationText());
    }

    @Override
    @NotNull
    public Future<?> runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task) {
        if (task == null) {
            ProgressManagerImpl.$$$reportNull$$$0(4);
        }
        Object progressIndicator = ApplicationManager.getApplication().isHeadlessEnvironment() ? new EmptyProgressIndicator() : new BackgroundableProcessIndicator(task);
        Future<?> future2 = this.runProcessWithProgressAsynchronously(task, (ProgressIndicator)progressIndicator, null);
        if (future2 == null) {
            ProgressManagerImpl.$$$reportNull$$$0(5);
        }
        return future2;
    }

    @Override
    @NotNull
    public Future<?> runProcessWithProgressAsynchronously(final @NotNull Task.Backgroundable task, final @NotNull ProgressIndicator progressIndicator, @Nullable Runnable continuation, final @NotNull ModalityState modalityState) {
        if (task == null) {
            ProgressManagerImpl.$$$reportNull$$$0(6);
        }
        if (progressIndicator == null) {
            ProgressManagerImpl.$$$reportNull$$$0(7);
        }
        if (modalityState == null) {
            ProgressManagerImpl.$$$reportNull$$$0(8);
        }
        if (progressIndicator instanceof Disposable) {
            Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)((Disposable)progressIndicator));
        }
        final CoreProgressManager.TaskRunnable process2 = new CoreProgressManager.TaskRunnable((Task)task, progressIndicator, continuation);
        CoreProgressManager.TaskContainer action = new CoreProgressManager.TaskContainer((Task)task){

            @Override
            public void run() {
                boolean processCanceled = false;
                Throwable exception = null;
                long start = System.currentTimeMillis();
                try {
                    ProgressManager.getInstance().runProcess(process2, progressIndicator);
                }
                catch (ProcessCanceledException e) {
                    processCanceled = true;
                }
                catch (Throwable e) {
                    exception = e;
                }
                long end = System.currentTimeMillis();
                boolean finalCanceled = processCanceled || progressIndicator.isCanceled();
                Throwable finalException = exception;
                if (!finalCanceled) {
                    Window window;
                    Task.NotificationInfo notificationInfo = task.notifyFinished();
                    long time = end - start;
                    if (notificationInfo != null && time > 5000L && ((window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow()) == null || notificationInfo.isShowWhenFocused())) {
                        ProgressManagerImpl.systemNotify(notificationInfo);
                    }
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (task == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    CoreProgressManager.finishTask((Task)task, finalCanceled, finalException);
                }, modalityState);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/impl/ProgressManagerImpl$2", "lambda$run$0"));
            }
        };
        Future future2 = ApplicationManager.getApplication().executeOnPooledThread((Runnable)action);
        if (future2 == null) {
            ProgressManagerImpl.$$$reportNull$$$0(9);
        }
        return future2;
    }

    @Override
    public boolean runInReadActionWithWriteActionPriority(@NotNull Runnable action, @Nullable ProgressIndicator indicator) {
        if (action == null) {
            ProgressManagerImpl.$$$reportNull$$$0(10);
        }
        return ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(action, indicator);
    }

    void addCheckCanceledHook(@NotNull CoreProgressManager.CheckCanceledHook hook) {
        if (hook == null) {
            ProgressManagerImpl.$$$reportNull$$$0(11);
        }
        if (this.myHooks.add(hook)) {
            this.updateShouldCheckCanceled();
        }
    }

    void removeCheckCanceledHook(@NotNull CoreProgressManager.CheckCanceledHook hook) {
        if (hook == null) {
            ProgressManagerImpl.$$$reportNull$$$0(12);
        }
        if (this.myHooks.remove(hook)) {
            this.updateShouldCheckCanceled();
        }
    }

    @Override
    @Nullable
    protected CoreProgressManager.CheckCanceledHook createCheckCanceledHook() {
        if (this.myHooks.isEmpty()) {
            return null;
        }
        CoreProgressManager.CheckCanceledHook[] activeHooks = (CoreProgressManager.CheckCanceledHook[])ArrayUtil.stripTrailingNulls((Object[])this.myHooks.toArray(new CoreProgressManager.CheckCanceledHook[0]));
        return activeHooks.length == 1 ? activeHooks[0] : indicator -> {
            boolean result2 = false;
            for (CoreProgressManager.CheckCanceledHook hook : activeHooks) {
                if (!hook.runHook(indicator)) continue;
                result2 = true;
            }
            return result2;
        };
    }

    private static boolean sleepIfNeededToGivePriorityToAnotherThread() {
        if (HeavyProcessLatch.INSTANCE.isInsideLowPriorityThread()) {
            LockSupport.parkNanos(1000000L);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/progress/impl/ProgressManagerImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hook";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/progress/impl/ProgressManagerImpl";
                break;
            }
            case 5: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "runProcessWithProgressAsynchronously";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "executeProcessUnderProgress";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "__testWhileAlwaysCheckingCanceled";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithProgressSynchronously";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "systemNotify";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "runProcessWithProgressAsynchronously";
                break;
            }
            case 5: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "runInReadActionWithWriteActionPriority";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addCheckCanceledHook";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeCheckCanceledHook";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

