/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.StandardProgressIndicator;
import com.intellij.openapi.progress.WrappedProgressIndicator;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.progress.util.BlockingProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.Semaphore;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class SmoothProgressAdapter
extends AbstractProgressIndicatorExBase
implements BlockingProgressIndicator,
WrappedProgressIndicator,
StandardProgressIndicator {
    private static final int SHOW_DELAY = 500;
    private Future<?> myStartupAlarm;
    private final ProgressIndicator myOriginal;
    private final Project myProject;
    private volatile boolean myOriginalStarted;
    private DialogWrapper myDialog;
    private final Runnable myShowRequest;

    public SmoothProgressAdapter(@NotNull ProgressIndicator original, @NotNull Project project2) {
        if (original == null) {
            SmoothProgressAdapter.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            SmoothProgressAdapter.$$$reportNull$$$0(1);
        }
        this.myStartupAlarm = CompletableFuture.completedFuture(null);
        this.myShowRequest = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SmoothProgressAdapter smoothProgressAdapter = SmoothProgressAdapter.this;
                synchronized (smoothProgressAdapter) {
                    if (!SmoothProgressAdapter.this.isRunning()) {
                        return;
                    }
                    SmoothProgressAdapter.this.myOriginal.start();
                    SmoothProgressAdapter.this.myOriginalStarted = true;
                    SmoothProgressAdapter.this.myOriginal.setText(SmoothProgressAdapter.this.getText());
                    SmoothProgressAdapter.this.myOriginal.setFraction(SmoothProgressAdapter.this.getFraction());
                    SmoothProgressAdapter.this.myOriginal.setText2(SmoothProgressAdapter.this.getText2());
                }
            }
        };
        this.myOriginal = original;
        this.myProject = project2;
        if (this.myOriginal.isModal()) {
            this.myOriginal.setModalityProgress((ProgressIndicator)this);
            this.setModalityProgress(this);
        }
        ProgressManager.assertNotCircular((ProgressIndicator)original);
    }

    @NotNull
    public ProgressIndicator getOriginalProgressIndicator() {
        ProgressIndicator progressIndicator = this.myOriginal;
        if (progressIndicator == null) {
            SmoothProgressAdapter.$$$reportNull$$$0(2);
        }
        return progressIndicator;
    }

    @Override
    public void setIndeterminate(boolean indeterminate) {
        super.setIndeterminate(indeterminate);
        this.myOriginal.setIndeterminate(indeterminate);
    }

    @Override
    public boolean isIndeterminate() {
        return this.myOriginal.isIndeterminate();
    }

    @Override
    public synchronized void start() {
        if (this.isRunning()) {
            return;
        }
        super.start();
        this.myOriginalStarted = false;
        this.myStartupAlarm = AppExecutorUtil.getAppScheduledExecutorService().schedule(this.myShowRequest, 500L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void startBlocking() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.start();
        if (this.isModal()) {
            this.showDialog();
        }
    }

    private void showDialog() {
        if (this.myDialog == null) {
            this.myDialog = new DialogWrapper(this.myProject, false){
                {
                    this.getWindow().setBounds(0, 0, 1, 1);
                    this.setResizable(false);
                }

                protected boolean isProgressDialog() {
                    return true;
                }

                protected JComponent createCenterPanel() {
                    return null;
                }
            };
            this.myDialog.setModal(true);
            this.myDialog.setUndecorated(true);
            this.myDialog.show();
        }
    }

    @Override
    public synchronized void stop() {
        if (this.myOriginal.isRunning()) {
            this.myOriginal.stop();
        } else {
            this.myStartupAlarm.cancel(false);
            if (!this.myOriginalStarted && this.myOriginal instanceof Disposable) {
                Disposer.dispose((Disposable)((Disposable)this.myOriginal));
            }
        }
        Semaphore semaphore = new Semaphore();
        semaphore.down();
        SwingUtilities.invokeLater(() -> {
            semaphore.waitFor();
            if (this.myDialog != null) {
                this.myDialog.close(0);
                this.myDialog = null;
            }
        });
        try {
            super.stop();
        }
        finally {
            semaphore.up();
        }
    }

    @Override
    public synchronized void setText(String text2) {
        super.setText(text2);
        if (this.myOriginal.isRunning()) {
            this.myOriginal.setText(text2);
        }
    }

    @Override
    public synchronized void setFraction(double fraction) {
        super.setFraction(fraction);
        if (this.myOriginal.isRunning()) {
            this.myOriginal.setFraction(fraction);
        }
    }

    @Override
    public synchronized void setText2(String text2) {
        super.setText2(text2);
        if (this.myOriginal.isRunning()) {
            this.myOriginal.setText2(text2);
        }
    }

    @Override
    public final void cancel() {
        super.cancel();
        this.myOriginal.cancel();
    }

    @Override
    public final boolean isCanceled() {
        return super.isCanceled() || this.myOriginalStarted && this.myOriginal.isCanceled();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/progress/util/SmoothProgressAdapter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/progress/util/SmoothProgressAdapter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalProgressIndicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

