/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.ProjectRootListener;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.RootsAsVirtualFilePointers;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootProviderBaseImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectJdkImpl
extends UserDataHolderBase
implements Sdk,
SdkModificator,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.projectRoots.impl.ProjectJdkImpl");
    private String myName;
    private String myVersionString;
    private boolean myVersionDefined;
    private String myHomePath = "";
    private final RootsAsVirtualFilePointers myRoots;
    private ProjectJdkImpl myOrigin;
    private SdkAdditionalData myAdditionalData;
    private SdkTypeId mySdkType;
    @NonNls
    public static final String ELEMENT_NAME = "name";
    @NonNls
    public static final String ATTRIBUTE_VALUE = "value";
    @NonNls
    public static final String ELEMENT_TYPE = "type";
    @NonNls
    private static final String ELEMENT_VERSION = "version";
    @NonNls
    private static final String ELEMENT_ROOTS = "roots";
    @NonNls
    private static final String ELEMENT_HOMEPATH = "homePath";
    @NonNls
    private static final String ELEMENT_ADDITIONAL = "additional";
    private final MyRootProvider myRootProvider = new MyRootProvider();
    private static final VirtualFilePointerListener tellAllProjectsTheirRootsAreGoingToChange = new VirtualFilePointerListener(){

        public void beforeValidityChanged(@NotNull VirtualFilePointer[] pointers) {
            if (pointers == null) {
                1.$$$reportNull$$$0(0);
            }
            for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
                VirtualFilePointerListener listener2 = ((ProjectRootManagerImpl)ProjectRootManager.getInstance((Project)project2)).getRootsValidityChangedListener();
                listener2.beforeValidityChanged(pointers);
            }
        }

        public void validityChanged(@NotNull VirtualFilePointer[] pointers) {
            if (pointers == null) {
                1.$$$reportNull$$$0(1);
            }
            for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
                VirtualFilePointerListener listener2 = ((ProjectRootManagerImpl)ProjectRootManager.getInstance((Project)project2)).getRootsValidityChangedListener();
                listener2.validityChanged(pointers);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "pointers";
            objectArray2[1] = "com/intellij/openapi/projectRoots/impl/ProjectJdkImpl$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeValidityChanged";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "validityChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    public ProjectJdkImpl(String name2, SdkTypeId sdkType) {
        this.mySdkType = sdkType;
        this.myName = name2;
        this.myRoots = new RootsAsVirtualFilePointers(true, tellAllProjectsTheirRootsAreGoingToChange, this);
        Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)this);
    }

    public ProjectJdkImpl(String name2, SdkTypeId sdkType, String homePath, String version) {
        this(name2, sdkType);
        this.myHomePath = homePath;
        this.myVersionString = version;
    }

    @NotNull
    public static VirtualFilePointerListener getGlobalVirtualFilePointerListener() {
        VirtualFilePointerListener virtualFilePointerListener = tellAllProjectsTheirRootsAreGoingToChange;
        if (virtualFilePointerListener == null) {
            ProjectJdkImpl.$$$reportNull$$$0(0);
        }
        return virtualFilePointerListener;
    }

    public void dispose() {
    }

    @NotNull
    public SdkTypeId getSdkType() {
        if (this.mySdkType == null) {
            this.mySdkType = ProjectJdkTable.getInstance().getDefaultSdkType();
        }
        SdkTypeId sdkTypeId = this.mySdkType;
        if (sdkTypeId == null) {
            ProjectJdkImpl.$$$reportNull$$$0(1);
        }
        return sdkTypeId;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            ProjectJdkImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void setName(@NotNull String name2) {
        if (name2 == null) {
            ProjectJdkImpl.$$$reportNull$$$0(3);
        }
        this.myName = name2;
    }

    public final void setVersionString(@Nullable String versionString) {
        this.myVersionString = versionString == null || versionString.isEmpty() ? null : versionString;
        this.myVersionDefined = true;
    }

    public String getVersionString() {
        String homePath;
        if (this.myVersionString == null && !this.myVersionDefined && (homePath = this.getHomePath()) != null && !homePath.isEmpty()) {
            this.setVersionString(this.getSdkType().getVersionString((Sdk)this));
        }
        return this.myVersionString;
    }

    public final void resetVersionString() {
        this.myVersionDefined = false;
        this.myVersionString = null;
    }

    public String getHomePath() {
        return this.myHomePath;
    }

    public VirtualFile getHomeDirectory() {
        if (this.myHomePath == null) {
            return null;
        }
        return StandardFileSystems.local().findFileByPath(this.myHomePath);
    }

    public void readExternal(@NotNull Element element) {
        if (element == null) {
            ProjectJdkImpl.$$$reportNull$$$0(4);
        }
        this.readExternal(element, null);
    }

    public void readExternal(@NotNull Element element, @Nullable ProjectJdkTable projectJdkTable) throws InvalidDataException {
        Element version;
        String sdkTypeName;
        if (element == null) {
            ProjectJdkImpl.$$$reportNull$$$0(5);
        }
        Element elementName = ProjectJdkImpl.assertNotMissing(element, ELEMENT_NAME);
        this.myName = elementName.getAttributeValue(ATTRIBUTE_VALUE);
        Element typeChild = element.getChild(ELEMENT_TYPE);
        String string = sdkTypeName = typeChild != null ? typeChild.getAttributeValue(ATTRIBUTE_VALUE) : null;
        if (sdkTypeName != null) {
            if (projectJdkTable == null) {
                projectJdkTable = ProjectJdkTable.getInstance();
            }
            this.mySdkType = projectJdkTable.getSdkTypeByName(sdkTypeName);
        }
        if ((version = element.getChild(ELEMENT_VERSION)) != null) {
            this.setVersionString(version.getAttributeValue(ATTRIBUTE_VALUE));
        } else {
            this.myVersionDefined = false;
        }
        String versionValue = element.getAttributeValue(ELEMENT_VERSION, "");
        if (versionValue.isEmpty() || !"2".equals(versionValue)) {
            throw new InvalidDataException("Too old version is not supported: " + versionValue);
        }
        Element homePath = ProjectJdkImpl.assertNotMissing(element, ELEMENT_HOMEPATH);
        this.myHomePath = homePath.getAttributeValue(ATTRIBUTE_VALUE);
        Element elementRoots = ProjectJdkImpl.assertNotMissing(element, ELEMENT_ROOTS);
        this.myRoots.readExternal(elementRoots);
        Element additional = element.getChild(ELEMENT_ADDITIONAL);
        if (additional != null) {
            LOG.assertTrue(this.mySdkType != null);
            this.myAdditionalData = this.mySdkType.loadAdditionalData((Sdk)this, additional);
        } else {
            this.myAdditionalData = null;
        }
    }

    @NotNull
    private static Element assertNotMissing(@NotNull Element parent, @NotNull String childName) {
        Element child;
        if (parent == null) {
            ProjectJdkImpl.$$$reportNull$$$0(6);
        }
        if (childName == null) {
            ProjectJdkImpl.$$$reportNull$$$0(7);
        }
        if ((child = parent.getChild(childName)) == null) {
            throw new InvalidDataException("mandatory element '" + childName + "' is missing: " + parent);
        }
        Element element = child;
        if (element == null) {
            ProjectJdkImpl.$$$reportNull$$$0(8);
        }
        return element;
    }

    public void writeExternal(@NotNull Element element) {
        if (element == null) {
            ProjectJdkImpl.$$$reportNull$$$0(9);
        }
        element.setAttribute(ELEMENT_VERSION, "2");
        Element name2 = new Element(ELEMENT_NAME);
        name2.setAttribute(ATTRIBUTE_VALUE, this.myName);
        element.addContent(name2);
        if (this.mySdkType != null) {
            Element sdkType = new Element(ELEMENT_TYPE);
            sdkType.setAttribute(ATTRIBUTE_VALUE, this.mySdkType.getName());
            element.addContent(sdkType);
        }
        if (this.myVersionString != null) {
            Element version = new Element(ELEMENT_VERSION);
            version.setAttribute(ATTRIBUTE_VALUE, this.myVersionString);
            element.addContent(version);
        }
        Element home = new Element(ELEMENT_HOMEPATH);
        home.setAttribute(ATTRIBUTE_VALUE, this.myHomePath);
        element.addContent(home);
        Element roots = new Element(ELEMENT_ROOTS);
        this.myRoots.writeExternal(roots);
        element.addContent(roots);
        Element additional = new Element(ELEMENT_ADDITIONAL);
        if (this.myAdditionalData != null) {
            LOG.assertTrue(this.mySdkType != null);
            this.mySdkType.saveAdditionalData(this.myAdditionalData, additional);
        }
        element.addContent(additional);
    }

    public void setHomePath(String path) {
        boolean changes = this.myHomePath == null ? path != null : !this.myHomePath.equals(path);
        this.myHomePath = path;
        if (changes) {
            this.resetVersionString();
        }
    }

    @NotNull
    public ProjectJdkImpl clone() {
        ProjectJdkImpl newJdk = new ProjectJdkImpl("", this.mySdkType);
        this.copyTo(newJdk);
        ProjectJdkImpl projectJdkImpl = newJdk;
        if (projectJdkImpl == null) {
            ProjectJdkImpl.$$$reportNull$$$0(10);
        }
        return projectJdkImpl;
    }

    @NotNull
    public RootProvider getRootProvider() {
        MyRootProvider myRootProvider = this.myRootProvider;
        if (myRootProvider == null) {
            ProjectJdkImpl.$$$reportNull$$$0(11);
        }
        return myRootProvider;
    }

    void copyTo(@NotNull ProjectJdkImpl dest) {
        if (dest == null) {
            ProjectJdkImpl.$$$reportNull$$$0(12);
        }
        String name2 = this.getName();
        dest.setName(name2);
        dest.setHomePath(this.getHomePath());
        dest.myVersionDefined = this.myVersionDefined;
        dest.myVersionString = this.myVersionString;
        dest.setSdkAdditionalData(this.getSdkAdditionalData());
        dest.myRoots.copyRootsFrom(this.myRoots);
        dest.myRootProvider.rootsChanged();
    }

    @NotNull
    public SdkModificator getSdkModificator() {
        ProjectJdkImpl sdk = this.clone();
        sdk.myOrigin = this;
        ProjectJdkImpl projectJdkImpl = sdk;
        if (projectJdkImpl == null) {
            ProjectJdkImpl.$$$reportNull$$$0(13);
        }
        return projectJdkImpl;
    }

    public void commitChanges() {
        LOG.assertTrue(this.isWritable());
        this.copyTo(this.myOrigin);
        this.myOrigin = null;
        Disposer.dispose((Disposable)this);
    }

    public SdkAdditionalData getSdkAdditionalData() {
        return this.myAdditionalData;
    }

    public void setSdkAdditionalData(SdkAdditionalData data) {
        this.myAdditionalData = data;
    }

    @NotNull
    public VirtualFile[] getRoots(@NotNull OrderRootType rootType) {
        if (rootType == null) {
            ProjectJdkImpl.$$$reportNull$$$0(14);
        }
        VirtualFile[] virtualFileArray = this.myRoots.getFiles(rootType);
        if (virtualFileArray == null) {
            ProjectJdkImpl.$$$reportNull$$$0(15);
        }
        return virtualFileArray;
    }

    public void addRoot(@NotNull VirtualFile root, @NotNull OrderRootType rootType) {
        if (root == null) {
            ProjectJdkImpl.$$$reportNull$$$0(16);
        }
        if (rootType == null) {
            ProjectJdkImpl.$$$reportNull$$$0(17);
        }
        this.myRoots.addRoot(root, rootType);
    }

    public void removeRoot(@NotNull VirtualFile root, @NotNull OrderRootType rootType) {
        if (root == null) {
            ProjectJdkImpl.$$$reportNull$$$0(18);
        }
        if (rootType == null) {
            ProjectJdkImpl.$$$reportNull$$$0(19);
        }
        this.myRoots.removeRoot(root, rootType);
    }

    public void removeRoots(@NotNull OrderRootType rootType) {
        if (rootType == null) {
            ProjectJdkImpl.$$$reportNull$$$0(20);
        }
        this.myRoots.removeAllRoots(rootType);
    }

    public void removeAllRoots() {
        this.myRoots.removeAllRoots();
    }

    public boolean isWritable() {
        return this.myOrigin != null;
    }

    public String toString() {
        return this.myName + (this.myVersionDefined ? ": " + this.myVersionString : "") + " (" + this.myHomePath + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/impl/ProjectJdkImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = ELEMENT_NAME;
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childName";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dest";
                break;
            }
            case 14: 
            case 17: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalVirtualFilePointerListener";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/impl/ProjectJdkImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "assertNotMissing";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootProvider";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkModificator";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "assertNotMissing";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "copyTo";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getRoots";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addRoot";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "removeRoot";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "removeRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyRootProvider
    extends RootProviderBaseImpl
    implements ProjectRootListener {
        private final List<RootProvider.RootSetChangedListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

        private MyRootProvider() {
        }

        @NotNull
        public String[] getUrls(@NotNull OrderRootType rootType) {
            if (rootType == null) {
                MyRootProvider.$$$reportNull$$$0(0);
            }
            String[] stringArray = ProjectJdkImpl.this.myRoots.getUrls(rootType);
            if (stringArray == null) {
                MyRootProvider.$$$reportNull$$$0(1);
            }
            return stringArray;
        }

        @NotNull
        public VirtualFile[] getFiles(@NotNull OrderRootType rootType) {
            if (rootType == null) {
                MyRootProvider.$$$reportNull$$$0(2);
            }
            VirtualFile[] virtualFileArray = ProjectJdkImpl.this.myRoots.getFiles(rootType);
            if (virtualFileArray == null) {
                MyRootProvider.$$$reportNull$$$0(3);
            }
            return virtualFileArray;
        }

        @Override
        public void addRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener2) {
            if (listener2 == null) {
                MyRootProvider.$$$reportNull$$$0(4);
            }
            if (!this.myListeners.contains(listener2)) {
                this.myListeners.add(listener2);
                super.addRootSetChangedListener(listener2);
            }
        }

        @Override
        public void addRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener2, @NotNull Disposable parentDisposable) {
            if (listener2 == null) {
                MyRootProvider.$$$reportNull$$$0(5);
            }
            if (parentDisposable == null) {
                MyRootProvider.$$$reportNull$$$0(6);
            }
            super.addRootSetChangedListener(listener2, parentDisposable);
            Disposer.register((Disposable)parentDisposable, () -> {
                if (listener2 == null) {
                    MyRootProvider.$$$reportNull$$$0(8);
                }
                this.removeRootSetChangedListener(listener2);
            });
        }

        @Override
        public void removeRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener2) {
            if (listener2 == null) {
                MyRootProvider.$$$reportNull$$$0(7);
            }
            super.removeRootSetChangedListener(listener2);
            this.myListeners.remove(listener2);
        }

        public void rootsChanged() {
            if (this.myListeners.isEmpty()) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction(this::fireRootSetChanged);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootType";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/projectRoots/impl/ProjectJdkImpl$MyRootProvider";
                    break;
                }
                case 4: 
                case 5: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parentDisposable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/projectRoots/impl/ProjectJdkImpl$MyRootProvider";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUrls";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getUrls";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getFiles";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "addRootSetChangedListener";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "removeRootSetChangedListener";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$addRootSetChangedListener$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

