/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.ui;

import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.SdkEditorAdditionalOptionsProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.projectRoots.ui.PathEditor;
import com.intellij.openapi.projectRoots.ui.SdkPathEditor;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ui.OrderRootTypeUIFactory;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkEditor
implements Configurable,
Place.Navigator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.projectRoots.ui.SdkEditor");
    private static final String SDK_TAB = "sdkTab";
    private Sdk mySdk;
    private final Map<OrderRootType, SdkPathEditor> myPathEditors = new HashMap<OrderRootType, SdkPathEditor>();
    private TextFieldWithBrowseButton myHomeComponent;
    private final Map<SdkType, List<AdditionalDataConfigurable>> myAdditionalDataConfigurables = new HashMap<SdkType, List<AdditionalDataConfigurable>>();
    private final Map<AdditionalDataConfigurable, JComponent> myAdditionalDataComponents = new HashMap<AdditionalDataConfigurable, JComponent>();
    private JPanel myAdditionalDataPanel;
    private final SdkModificator myEditedSdkModificator = new EditedSdkModificator();
    private JPanel myMainPanel;
    private TabbedPaneWrapper myTabbedPane;
    private final Project myProject;
    private final SdkModel mySdkModel;
    private JLabel myHomeFieldLabel;
    private String myVersionString;
    private String myInitialName;
    private String myInitialPath;
    private final History myHistory;
    private final Disposable myDisposable = Disposer.newDisposable();

    public SdkEditor(Project project2, SdkModel sdkModel, History history, ProjectJdkImpl sdk) {
        this.myProject = project2;
        this.mySdkModel = sdkModel;
        this.myHistory = history;
        this.mySdk = sdk;
        this.createMainPanel();
        this.initSdk(sdk);
    }

    private void initSdk(Sdk sdk) {
        this.mySdk = sdk;
        if (this.mySdk != null) {
            this.myInitialName = this.mySdk.getName();
            this.myInitialPath = this.mySdk.getHomePath();
        } else {
            this.myInitialName = "";
            this.myInitialPath = "";
        }
        for (AdditionalDataConfigurable additionalDataConfigurable : this.getAdditionalDataConfigurable()) {
            additionalDataConfigurable.setSdk(sdk);
        }
        if (this.myMainPanel != null) {
            this.reset();
        }
    }

    public String getDisplayName() {
        return ProjectBundle.message((String)"sdk.configure.editor.title", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return null;
    }

    public JComponent createComponent() {
        return this.myMainPanel;
    }

    private void createMainPanel() {
        this.myMainPanel = new JPanel(new GridBagLayout());
        this.myTabbedPane = new TabbedPaneWrapper(this.myDisposable);
        for (OrderRootType type2 : OrderRootType.getAllTypes()) {
            SdkPathEditor pathEditor;
            if (this.mySdk != null && !this.showTabForType(type2) || (pathEditor = ((OrderRootTypeUIFactory)OrderRootTypeUIFactory.FACTORY.getByKey((Object)type2)).createPathEditor(this.mySdk)) == null) continue;
            pathEditor.setAddBaseDir(this.mySdk.getHomeDirectory());
            this.myTabbedPane.addTab(pathEditor.getDisplayName(), pathEditor.createComponent());
            this.myPathEditors.put(type2, pathEditor);
        }
        this.myTabbedPane.addChangeListener(e -> this.myHistory.pushQueryPlace());
        this.myHomeComponent = this.createHomeComponent();
        this.myHomeComponent.getTextField().setEditable(false);
        this.myHomeFieldLabel = new JLabel(this.getHomeFieldLabelValue());
        this.myMainPanel.add((Component)this.myHomeFieldLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, (Insets)JBUI.insets((int)2, (int)10, (int)2, (int)2), 0, 0));
        this.myMainPanel.add((Component)this.myHomeComponent, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 10, 2, (Insets)JBUI.insets((int)2, (int)2, (int)2, (int)10), 0, 0));
        this.myAdditionalDataPanel = new JPanel(new BorderLayout());
        this.myMainPanel.add((Component)this.myAdditionalDataPanel, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 10, 1, (Insets)JBUI.insets((int)2, (int)10, (int)0, (int)10), 0, 0));
        this.myMainPanel.add((Component)this.myTabbedPane.getComponent(), new GridBagConstraints(0, -1, 2, 1, 1.0, 1.0, 10, 1, (Insets)JBUI.insetsTop((int)2), 0, 0));
    }

    protected TextFieldWithBrowseButton createHomeComponent() {
        return new TextFieldWithBrowseButton(e -> this.doSelectHomePath());
    }

    protected boolean showTabForType(@NotNull OrderRootType type2) {
        if (type2 == null) {
            SdkEditor.$$$reportNull$$$0(0);
        }
        return ((SdkType)this.mySdk.getSdkType()).isRootTypeApplicable(type2);
    }

    private String getHomeFieldLabelValue() {
        return this.mySdk != null ? ((SdkType)this.mySdk.getSdkType()).getHomeFieldLabel() : ProjectBundle.message((String)"sdk.configure.general.home.path", (Object[])new Object[0]);
    }

    public boolean isModified() {
        boolean isModified = !Comparing.equal((String)(this.mySdk == null ? null : this.mySdk.getName()), (String)this.myInitialName);
        isModified = isModified || !Comparing.equal((String)FileUtil.toSystemIndependentName((String)this.getHomeValue()), (String)FileUtil.toSystemIndependentName((String)this.myInitialPath));
        for (PathEditor pathEditor : this.myPathEditors.values()) {
            isModified = isModified || pathEditor.isModified();
        }
        for (AdditionalDataConfigurable additionalDataConfigurable : this.getAdditionalDataConfigurable()) {
            isModified = isModified || additionalDataConfigurable.isModified();
        }
        return isModified;
    }

    public void apply() throws ConfigurationException {
        if (!Comparing.equal((String)this.myInitialName, (String)(this.mySdk == null ? "" : this.mySdk.getName())) && (this.mySdk == null || this.mySdk.getName().isEmpty())) {
            throw new ConfigurationException(ProjectBundle.message((String)"sdk.list.name.required.error", (Object[])new Object[0]));
        }
        if (this.mySdk != null) {
            this.myInitialName = this.mySdk.getName();
            this.myInitialPath = this.mySdk.getHomePath();
            SdkModificator sdkModificator = this.mySdk.getSdkModificator();
            sdkModificator.setHomePath(FileUtil.toSystemDependentName((String)this.getHomeValue()));
            for (SdkPathEditor pathEditor : this.myPathEditors.values()) {
                pathEditor.apply(sdkModificator);
            }
            ApplicationManager.getApplication().runWriteAction(() -> ((SdkModificator)sdkModificator).commitChanges());
            for (AdditionalDataConfigurable configurable : this.getAdditionalDataConfigurable()) {
                if (configurable == null) continue;
                configurable.apply();
            }
        }
    }

    public void reset() {
        if (this.mySdk == null) {
            this.setHomePathValue("");
            for (SdkPathEditor pathEditor : this.myPathEditors.values()) {
                pathEditor.reset(null);
            }
        } else {
            SdkModificator sdkModificator = this.mySdk.getSdkModificator();
            for (OrderRootType type2 : this.myPathEditors.keySet()) {
                this.myPathEditors.get(type2).reset(sdkModificator);
            }
            sdkModificator.commitChanges();
            this.setHomePathValue(FileUtil.toSystemDependentName((String)((String)ObjectUtils.notNull((Object)this.mySdk.getHomePath(), (Object)""))));
        }
        this.myVersionString = null;
        this.myHomeFieldLabel.setText(this.getHomeFieldLabelValue());
        this.updateAdditionalDataComponent();
        for (AdditionalDataConfigurable configurable : this.getAdditionalDataConfigurable()) {
            configurable.reset();
        }
        this.myHomeComponent.setEnabled(this.mySdk != null);
        for (int i = 0; i < this.myTabbedPane.getTabCount(); ++i) {
            this.myTabbedPane.setEnabledAt(i, this.mySdk != null);
        }
    }

    public void disposeUIResources() {
        for (SdkType sdkType : this.myAdditionalDataConfigurables.keySet()) {
            for (AdditionalDataConfigurable configurable : this.myAdditionalDataConfigurables.get(sdkType)) {
                configurable.disposeUIResources();
            }
        }
        this.myAdditionalDataConfigurables.clear();
        this.myAdditionalDataComponents.clear();
        Disposer.dispose((Disposable)this.myDisposable);
    }

    private String getHomeValue() {
        return this.myHomeComponent.getText().trim();
    }

    private void clearAllPaths() {
        for (PathEditor pathEditor : this.myPathEditors.values()) {
            pathEditor.clearList();
        }
    }

    private void setHomePathValue(String absolutePath) {
        Color fg;
        this.myHomeComponent.setText(absolutePath);
        if (absolutePath != null && !absolutePath.isEmpty() && this.mySdk != null && this.mySdk.getSdkType().isLocalSdk(this.mySdk)) {
            File homeDir = new File(absolutePath);
            boolean homeMustBeDirectory = ((SdkType)this.mySdk.getSdkType()).getHomeChooserDescriptor().isChooseFolders();
            fg = homeDir.exists() && homeDir.isDirectory() == homeMustBeDirectory ? UIUtil.getFieldForegroundColor() : PathEditor.INVALID_COLOR;
        } else {
            fg = UIUtil.getFieldForegroundColor();
        }
        this.myHomeComponent.getTextField().setForeground(fg);
    }

    private void doSelectHomePath() {
        SdkType sdkType = (SdkType)this.mySdk.getSdkType();
        SdkConfigurationUtil.selectSdkHome(sdkType, (Consumer<String>)((Consumer)path -> this.doSetHomePath((String)path, sdkType)));
    }

    private void doSetHomePath(String homePath, SdkType sdkType) {
        if (homePath == null) {
            return;
        }
        this.setHomePathValue(homePath.replace('/', File.separatorChar));
        String newSdkName = this.suggestSdkName(homePath);
        ((ProjectJdkImpl)this.mySdk).setName(newSdkName);
        try {
            Sdk dummySdk = (Sdk)this.mySdk.clone();
            SdkModificator sdkModificator = dummySdk.getSdkModificator();
            sdkModificator.setHomePath(homePath);
            sdkModificator.removeAllRoots();
            sdkModificator.commitChanges();
            sdkType.setupSdkPaths(dummySdk, this.mySdkModel);
            this.clearAllPaths();
            this.myVersionString = dummySdk.getVersionString();
            if (this.myVersionString == null) {
                Messages.showMessageDialog((String)ProjectBundle.message((String)"sdk.java.corrupt.error", (Object[])new Object[]{homePath}), (String)ProjectBundle.message((String)"sdk.java.corrupt.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            }
            sdkModificator = dummySdk.getSdkModificator();
            for (OrderRootType type2 : this.myPathEditors.keySet()) {
                SdkPathEditor pathEditor = this.myPathEditors.get(type2);
                pathEditor.setAddBaseDir(dummySdk.getHomeDirectory());
                pathEditor.addPaths(sdkModificator.getRoots(type2));
            }
            this.mySdkModel.getMulticaster().sdkHomeSelected(dummySdk, homePath);
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Throwable)e);
        }
    }

    private String suggestSdkName(String homePath) {
        Sdk[] sdks;
        String suggestedName;
        String currentName = this.mySdk.getName();
        if (Comparing.equal((String)currentName, (String)(suggestedName = ((SdkType)this.mySdk.getSdkType()).suggestSdkName(currentName, homePath)))) {
            return currentName;
        }
        String newSdkName = suggestedName;
        HashSet<String> allNames = new HashSet<String>();
        for (Sdk sdk : sdks = this.mySdkModel.getSdks()) {
            allNames.add(sdk.getName());
        }
        int i = 0;
        while (allNames.contains(newSdkName)) {
            newSdkName = suggestedName + " (" + ++i + ")";
        }
        return newSdkName;
    }

    private void updateAdditionalDataComponent() {
        this.myAdditionalDataPanel.removeAll();
        for (AdditionalDataConfigurable configurable : this.getAdditionalDataConfigurable()) {
            JComponent component = this.myAdditionalDataComponents.get(configurable);
            if (component == null) {
                component = configurable.createComponent();
                this.myAdditionalDataComponents.put(configurable, component);
            }
            if (component == null) continue;
            if (configurable.getTabName() != null) {
                for (int i = 0; i < this.myTabbedPane.getTabCount(); ++i) {
                    if (!configurable.getTabName().equals(this.myTabbedPane.getTitleAt(i))) continue;
                    this.myTabbedPane.removeTabAt(i);
                }
                this.myTabbedPane.addTab(configurable.getTabName(), component);
                continue;
            }
            this.myAdditionalDataPanel.add((Component)component, "Center");
        }
    }

    @NotNull
    private List<AdditionalDataConfigurable> getAdditionalDataConfigurable() {
        if (this.mySdk == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                SdkEditor.$$$reportNull$$$0(1);
            }
            return list2;
        }
        List<AdditionalDataConfigurable> list3 = this.initAdditionalDataConfigurable(this.mySdk);
        if (list3 == null) {
            SdkEditor.$$$reportNull$$$0(2);
        }
        return list3;
    }

    @NotNull
    private List<AdditionalDataConfigurable> initAdditionalDataConfigurable(Sdk sdk) {
        SdkType sdkType = (SdkType)sdk.getSdkType();
        ArrayList configurables = this.myAdditionalDataConfigurables.get(sdkType);
        if (configurables == null) {
            configurables = Lists.newArrayList();
            this.myAdditionalDataConfigurables.put(sdkType, configurables);
            AdditionalDataConfigurable sdkConfigurable = sdkType.createAdditionalDataConfigurable(this.mySdkModel, this.myEditedSdkModificator);
            if (sdkConfigurable != null) {
                configurables.add(sdkConfigurable);
            }
            for (SdkEditorAdditionalOptionsProvider factory : SdkEditorAdditionalOptionsProvider.getSdkOptionsFactory(this.mySdk.getSdkType())) {
                AdditionalDataConfigurable options = factory.createOptions(this.myProject, this.mySdk);
                if (options == null) continue;
                configurables.add(options);
            }
        }
        ArrayList arrayList = configurables;
        if (arrayList == null) {
            SdkEditor.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        if (place == null) {
            return ActionCallback.DONE;
        }
        this.myTabbedPane.setSelectedTitle((String)place.getPath(SDK_TAB));
        return ActionCallback.DONE;
    }

    public void queryPlace(@NotNull Place place) {
        if (place == null) {
            SdkEditor.$$$reportNull$$$0(4);
        }
        place.putPath(SDK_TAB, (Object)this.myTabbedPane.getSelectedTitle());
    }

    public void setHistory(History history) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/ui/SdkEditor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/ui/SdkEditor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalDataConfigurable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "initAdditionalDataConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showTabForType";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "queryPlace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class EditedSdkModificator
    implements SdkModificator {
        private EditedSdkModificator() {
        }

        public String getName() {
            return SdkEditor.this.mySdk.getName();
        }

        public void setName(String name2) {
            ((ProjectJdkImpl)SdkEditor.this.mySdk).setName(name2);
        }

        public String getHomePath() {
            return SdkEditor.this.getHomeValue();
        }

        public void setHomePath(String path) {
            SdkEditor.this.doSetHomePath(path, (SdkType)SdkEditor.this.mySdk.getSdkType());
        }

        public String getVersionString() {
            return SdkEditor.this.myVersionString != null ? SdkEditor.this.myVersionString : SdkEditor.this.mySdk.getVersionString();
        }

        public void setVersionString(String versionString) {
            throw new UnsupportedOperationException();
        }

        public SdkAdditionalData getSdkAdditionalData() {
            return SdkEditor.this.mySdk.getSdkAdditionalData();
        }

        public void setSdkAdditionalData(SdkAdditionalData data) {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public VirtualFile[] getRoots(OrderRootType rootType) {
            PathEditor editor = (PathEditor)SdkEditor.this.myPathEditors.get(rootType);
            if (editor == null) {
                throw new IllegalStateException("no editor for root type " + rootType);
            }
            VirtualFile[] virtualFileArray = editor.getRoots();
            if (virtualFileArray == null) {
                EditedSdkModificator.$$$reportNull$$$0(0);
            }
            return virtualFileArray;
        }

        public void addRoot(@NotNull VirtualFile root, @NotNull OrderRootType rootType) {
            if (root == null) {
                EditedSdkModificator.$$$reportNull$$$0(1);
            }
            if (rootType == null) {
                EditedSdkModificator.$$$reportNull$$$0(2);
            }
            ((SdkPathEditor)SdkEditor.this.myPathEditors.get(rootType)).addPaths(new VirtualFile[]{root});
        }

        public void removeRoot(@NotNull VirtualFile root, @NotNull OrderRootType rootType) {
            if (root == null) {
                EditedSdkModificator.$$$reportNull$$$0(3);
            }
            if (rootType == null) {
                EditedSdkModificator.$$$reportNull$$$0(4);
            }
            ((SdkPathEditor)SdkEditor.this.myPathEditors.get(rootType)).removePaths(new VirtualFile[]{root});
        }

        public void removeRoots(@NotNull OrderRootType rootType) {
            if (rootType == null) {
                EditedSdkModificator.$$$reportNull$$$0(5);
            }
            ((SdkPathEditor)SdkEditor.this.myPathEditors.get(rootType)).clearList();
        }

        public void removeAllRoots() {
            for (PathEditor editor : SdkEditor.this.myPathEditors.values()) {
                editor.clearList();
            }
        }

        public void commitChanges() {
        }

        public boolean isWritable() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/projectRoots/ui/SdkEditor$EditedSdkModificator";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 2: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRoots";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/projectRoots/ui/SdkEditor$EditedSdkModificator";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "addRoot";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "removeRoot";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "removeRoots";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

