/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ModifiableModelCommitter {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.module.impl.ModifiableModelCommitter");

    public static void multiCommit(@NotNull ModifiableRootModel[] rootModels, @NotNull ModifiableModuleModel moduleModel) {
        if (rootModels == null) {
            ModifiableModelCommitter.$$$reportNull$$$0(0);
        }
        if (moduleModel == null) {
            ModifiableModelCommitter.$$$reportNull$$$0(1);
        }
        ModifiableModelCommitter.multiCommit(Arrays.asList(rootModels), moduleModel);
    }

    public static void multiCommit(@NotNull Collection<ModifiableRootModel> rootModels, @NotNull ModifiableModuleModel moduleModel) {
        if (rootModels == null) {
            ModifiableModelCommitter.$$$reportNull$$$0(2);
        }
        if (moduleModel == null) {
            ModifiableModelCommitter.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        List<RootModelImpl> modelsToCommit = ModifiableModelCommitter.getSortedChangedModels(rootModels, moduleModel);
        SmartList modelsToDispose = new SmartList(rootModels);
        modelsToDispose.removeAll(modelsToCommit);
        ModuleManagerImpl.commitModelWithRunnable(moduleModel, () -> ModifiableModelCommitter.lambda$multiCommit$0(modelsToCommit, (List)modelsToDispose));
    }

    @NotNull
    private static List<RootModelImpl> getSortedChangedModels(Collection<ModifiableRootModel> rootModels, ModifiableModuleModel moduleModel) {
        List result2 = null;
        for (ModifiableRootModel model : rootModels) {
            RootModelImpl rootModel = (RootModelImpl)model;
            if (!rootModel.isChanged()) continue;
            if (result2 == null) {
                result2 = new SmartList();
            }
            result2.add(rootModel);
        }
        if (result2 == null) {
            List<RootModelImpl> list2 = Collections.emptyList();
            if (list2 == null) {
                ModifiableModelCommitter.$$$reportNull$$$0(4);
            }
            return list2;
        }
        if (result2.size() > 1) {
            result2.sort(ModifiableModelCommitter.createDFSTBuilder(result2, moduleModel).comparator());
        }
        List list3 = result2;
        if (list3 == null) {
            ModifiableModelCommitter.$$$reportNull$$$0(5);
        }
        return list3;
    }

    private static DFSTBuilder<RootModelImpl> createDFSTBuilder(List<RootModelImpl> rootModels, final ModifiableModuleModel moduleModel) {
        Module[] modules;
        final HashMap nameToModel = ContainerUtil.newHashMap();
        for (RootModelImpl rootModelImpl : rootModels) {
            String name2 = rootModelImpl.getModule().getName();
            LOG.assertTrue(!nameToModel.containsKey(name2), (Object)name2);
            nameToModel.put(name2, rootModelImpl);
        }
        for (Module module2 : modules = moduleModel.getModules()) {
            String name3 = module2.getName();
            if (nameToModel.containsKey(name3)) continue;
            RootModelImpl rootModel = ((ModuleRootManagerImpl)ModuleRootManager.getInstance((Module)module2)).getRootModel();
            nameToModel.put(name3, rootModel);
        }
        final Collection collection = nameToModel.values();
        InboundSemiGraph<RootModelImpl> graph = new InboundSemiGraph<RootModelImpl>(){

            public Collection<RootModelImpl> getNodes() {
                return collection;
            }

            public Iterator<RootModelImpl> getIn(RootModelImpl rootModel) {
                OrderEnumerator entries = rootModel.orderEntries().withoutSdk().withoutLibraries().withoutModuleSourceEntries();
                List namesList = (List)entries.process((RootPolicy)new RootPolicy<List<String>>(){

                    public List<String> visitModuleOrderEntry(@NotNull ModuleOrderEntry moduleOrderEntry, List<String> strings) {
                        Module module2;
                        if (moduleOrderEntry == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if ((module2 = moduleOrderEntry.getModule()) != null && !module2.isDisposed()) {
                            strings.add(module2.getName());
                        } else {
                            Module moduleToBeRenamed = moduleModel.getModuleToBeRenamed(moduleOrderEntry.getModuleName());
                            if (moduleToBeRenamed != null && !moduleToBeRenamed.isDisposed()) {
                                strings.add(moduleToBeRenamed.getName());
                            }
                        }
                        return strings;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleOrderEntry", "com/intellij/openapi/roots/impl/ModifiableModelCommitter$1$1", "visitModuleOrderEntry"));
                    }
                }, new ArrayList());
                String[] names = ArrayUtil.toStringArray((Collection)namesList);
                ArrayList<RootModelImpl> result2 = new ArrayList<RootModelImpl>();
                for (String name2 : names) {
                    RootModelImpl depRootModel = (RootModelImpl)nameToModel.get(name2);
                    if (depRootModel == null) continue;
                    result2.add(depRootModel);
                }
                return result2.iterator();
            }
        };
        return new DFSTBuilder(GraphGenerator.generate((InboundSemiGraph)CachingSemiGraph.cache((InboundSemiGraph)graph)));
    }

    private static /* synthetic */ void lambda$multiCommit$0(List modelsToCommit, List modelsToDispose) {
        for (RootModelImpl model : modelsToCommit) {
            ModuleRootManagerImpl.doCommit(model);
        }
        for (RootModelImpl model : modelsToDispose) {
            if (model instanceof RootModelImpl) {
                model.checkModuleExtensionModification();
            }
            model.dispose();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModels";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleModel";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/ModifiableModelCommitter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/ModifiableModelCommitter";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedChangedModels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "multiCommit";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

