/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectExtension;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.roots.impl.ModulesOrderEnumerator;
import com.intellij.openapi.roots.impl.OrderRootsCache;
import com.intellij.openapi.roots.impl.ProjectOrderEnumerator;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.psi.PsiManager;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@State(name="ProjectRootManager")
public class ProjectRootManagerImpl
extends ProjectRootManagerEx
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.projectRoots.impl.ProjectRootManagerImpl");
    @NonNls
    private static final String PROJECT_JDK_NAME_ATTR = "project-jdk-name";
    @NonNls
    private static final String PROJECT_JDK_TYPE_ATTR = "project-jdk-type";
    protected final Project myProject;
    private final EventDispatcher<ProjectRootManagerEx.ProjectJdkListener> myProjectJdkEventDispatcher = EventDispatcher.create(ProjectRootManagerEx.ProjectJdkListener.class);
    private String myProjectSdkName;
    private String myProjectSdkType;
    @NonNls
    private static final String ATTRIBUTE_VERSION = "version";
    private final OrderRootsCache myRootsCache;
    protected boolean myStartupActivityPerformed;
    private final RootProviderChangeListener myRootProviderChangeListener = new RootProviderChangeListener();
    protected final BatchSession myRootsChanged = new BatchSession(false);
    protected final BatchSession myFileTypesChanged = new BatchSession(true);
    private final VirtualFilePointerListener myRootsValidityChangedListener = new VirtualFilePointerListener(){};
    private boolean myMergedCallStarted;
    private boolean myMergedCallHasRootChange;
    private int myRootsChangesDepth;
    protected boolean isFiringEvent;
    private final Object myLibraryTableListenersLock = new Object();
    private final Map<LibraryTable, LibraryTableMultiListener> myLibraryTableMultiListeners = new HashMap();
    private final JdkTableMultiListener myJdkTableMultiListener;
    private final Map<RootProvider, Set<OrderEntry>> myRegisteredRootProviders = ContainerUtil.newIdentityTroveMap();

    public static ProjectRootManagerImpl getInstanceImpl(Project project2) {
        return (ProjectRootManagerImpl)ProjectRootManagerImpl.getInstance((Project)project2);
    }

    public ProjectRootManagerImpl(Project project2) {
        this.myProject = project2;
        this.myRootsCache = new OrderRootsCache((Disposable)project2);
        this.myJdkTableMultiListener = new JdkTableMultiListener(project2);
    }

    @NotNull
    public ProjectFileIndex getFileIndex() {
        ProjectFileIndex projectFileIndex = ProjectFileIndex.SERVICE.getInstance((Project)this.myProject);
        if (projectFileIndex == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(0);
        }
        return projectFileIndex;
    }

    @NotNull
    public List<String> getContentRootUrls() {
        ArrayList<String> result2 = new ArrayList<String>();
        for (Module module2 : this.getModuleManager().getModules()) {
            Object[] urls = ModuleRootManager.getInstance((Module)module2).getContentRootUrls();
            ContainerUtil.addAll(result2, (Object[])urls);
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public VirtualFile[] getContentRoots() {
        Module[] modules;
        ArrayList result2 = new ArrayList();
        for (Module module2 : modules = this.getModuleManager().getModules()) {
            Object[] contentRoots = ModuleRootManager.getInstance((Module)module2).getContentRoots();
            if (modules.length == 1) {
                if (contentRoots == null) {
                    ProjectRootManagerImpl.$$$reportNull$$$0(2);
                }
                return contentRoots;
            }
            ContainerUtil.addAll(result2, (Object[])contentRoots);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(result2);
        if (virtualFileArray == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(3);
        }
        return virtualFileArray;
    }

    @NotNull
    public VirtualFile[] getContentSourceRoots() {
        ArrayList result2 = new ArrayList();
        for (Module module2 : this.getModuleManager().getModules()) {
            Object[] sourceRoots = ModuleRootManager.getInstance((Module)module2).getSourceRoots();
            ContainerUtil.addAll(result2, (Object[])sourceRoots);
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(result2);
        if (virtualFileArray == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(4);
        }
        return virtualFileArray;
    }

    @NotNull
    public List<VirtualFile> getModuleSourceRoots(@NotNull Set<? extends JpsModuleSourceRootType<?>> rootTypes) {
        if (rootTypes == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(5);
        }
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>();
        for (Module module2 : this.getModuleManager().getModules()) {
            roots.addAll(ModuleRootManager.getInstance((Module)module2).getSourceRoots(rootTypes));
        }
        ArrayList<VirtualFile> arrayList = roots;
        if (arrayList == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    public OrderEnumerator orderEntries() {
        ProjectOrderEnumerator projectOrderEnumerator = new ProjectOrderEnumerator(this.myProject, this.myRootsCache);
        if (projectOrderEnumerator == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(7);
        }
        return projectOrderEnumerator;
    }

    @NotNull
    public OrderEnumerator orderEntries(@NotNull Collection<? extends Module> modules) {
        if (modules == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(8);
        }
        ModulesOrderEnumerator modulesOrderEnumerator = new ModulesOrderEnumerator(modules);
        if (modulesOrderEnumerator == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(9);
        }
        return modulesOrderEnumerator;
    }

    public VirtualFile[] getContentRootsFromAllModules() {
        Module[] modules;
        ArrayList result2 = new ArrayList();
        for (Module module2 : modules = this.getModuleManager().getSortedModules()) {
            Object[] files = ModuleRootManager.getInstance((Module)module2).getContentRoots();
            ContainerUtil.addAll(result2, (Object[])files);
        }
        ContainerUtil.addIfNotNull(result2, (Object)this.myProject.getBaseDir());
        return VfsUtilCore.toVirtualFileArray(result2);
    }

    public Sdk getProjectSdk() {
        return this.myProjectSdkName == null ? null : ProjectJdkTable.getInstance().findJdk(this.myProjectSdkName, this.myProjectSdkType);
    }

    public String getProjectSdkName() {
        return this.myProjectSdkName;
    }

    public void setProjectSdk(Sdk sdk) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (sdk == null) {
            this.myProjectSdkName = null;
            this.myProjectSdkType = null;
        } else {
            this.myProjectSdkName = sdk.getName();
            this.myProjectSdkType = sdk.getSdkType().getName();
        }
        this.projectJdkChanged();
    }

    private void projectJdkChanged() {
        this.mergeRootsChangesDuring(() -> ((ProjectRootManagerEx.ProjectJdkListener)this.myProjectJdkEventDispatcher.getMulticaster()).projectJdkChanged());
        Sdk sdk = this.getProjectSdk();
        for (ProjectExtension extension : (ProjectExtension[])Extensions.getExtensions(ProjectExtension.EP_NAME, (AreaInstance)this.myProject)) {
            extension.projectSdkChanged(sdk);
        }
    }

    public void setProjectSdkName(String name2) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.myProjectSdkName = name2;
        this.projectJdkChanged();
    }

    public void addProjectJdkListener(@NotNull ProjectRootManagerEx.ProjectJdkListener listener2) {
        if (listener2 == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(10);
        }
        this.myProjectJdkEventDispatcher.addListener((EventListener)listener2);
    }

    public void removeProjectJdkListener(@NotNull ProjectRootManagerEx.ProjectJdkListener listener2) {
        if (listener2 == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(11);
        }
        this.myProjectJdkEventDispatcher.removeListener((EventListener)listener2);
    }

    public void loadState(Element element) {
        for (ProjectExtension extension : (ProjectExtension[])Extensions.getExtensions(ProjectExtension.EP_NAME, (AreaInstance)this.myProject)) {
            extension.readExternal(element);
        }
        this.myProjectSdkName = element.getAttributeValue(PROJECT_JDK_NAME_ATTR);
        this.myProjectSdkType = element.getAttributeValue(PROJECT_JDK_TYPE_ATTR);
    }

    @Nullable
    public Element getState() {
        Element element = new Element("state");
        element.setAttribute(ATTRIBUTE_VERSION, "2");
        for (ProjectExtension extension : (ProjectExtension[])Extensions.getExtensions(ProjectExtension.EP_NAME, (AreaInstance)this.myProject)) {
            extension.writeExternal(element);
        }
        if (this.myProjectSdkName != null) {
            element.setAttribute(PROJECT_JDK_NAME_ATTR, this.myProjectSdkName);
        }
        if (this.myProjectSdkType != null) {
            element.setAttribute(PROJECT_JDK_TYPE_ATTR, this.myProjectSdkType);
        }
        if (element.getAttributes().size() == 1) {
            element.removeAttribute(ATTRIBUTE_VERSION);
        }
        return element;
    }

    public void mergeRootsChangesDuring(@NotNull Runnable runnable2) {
        block7: {
            block6: {
                block5: {
                    if (runnable2 == null) {
                        ProjectRootManagerImpl.$$$reportNull$$$0(12);
                    }
                    if (this.getBatchSession(false).myBatchLevel != 0 || this.myMergedCallStarted) break block6;
                    if (this.myRootsChangesDepth != 0) {
                        int depth = this.myRootsChangesDepth;
                        this.myRootsChangesDepth = 0;
                        LOG.error("Merged rootsChanged not allowed inside rootsChanged, rootsChanged level == " + depth);
                    }
                    this.myMergedCallStarted = true;
                    this.myMergedCallHasRootChange = false;
                    try {
                        runnable2.run();
                        if (!this.myMergedCallHasRootChange) break block5;
                        LOG.assertTrue(this.myRootsChangesDepth == 1, (Object)("myMergedCallDepth = " + this.myRootsChangesDepth));
                    }
                    catch (Throwable throwable) {
                        if (this.myMergedCallHasRootChange) {
                            LOG.assertTrue(this.myRootsChangesDepth == 1, (Object)("myMergedCallDepth = " + this.myRootsChangesDepth));
                            this.getBatchSession(false).rootsChanged();
                        }
                        this.myMergedCallStarted = false;
                        this.myMergedCallHasRootChange = false;
                        throw throwable;
                    }
                    this.getBatchSession(false).rootsChanged();
                }
                this.myMergedCallStarted = false;
                this.myMergedCallHasRootChange = false;
                break block7;
            }
            runnable2.run();
        }
    }

    protected void clearScopesCaches() {
        this.clearScopesCachesForModules();
    }

    public void clearScopesCachesForModules() {
        Module[] modules;
        this.myRootsCache.clearCache();
        for (Module module2 : modules = ModuleManager.getInstance((Project)this.myProject).getModules()) {
            ((ModuleRootManagerImpl)ModuleRootManager.getInstance((Module)module2)).dropCaches();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeRootsChange(@NotNull Runnable runnable2, boolean fileTypes, boolean fireEvents) {
        if (runnable2 == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(13);
        }
        if (this.myProject.isDisposed() || Disposer.isDisposing((Disposable)this.myProject)) {
            return;
        }
        BatchSession session2 = this.getBatchSession(fileTypes);
        try {
            if (fireEvents) {
                session2.beforeRootsChanged();
            }
            runnable2.run();
        }
        finally {
            if (fireEvents) {
                session2.rootsChanged();
            }
        }
    }

    protected BatchSession getBatchSession(boolean fileTypes) {
        return fileTypes ? this.myFileTypesChanged : this.myRootsChanged;
    }

    private boolean fireBeforeRootsChanged(boolean fileTypes) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        LOG.assertTrue(!this.isFiringEvent, (Object)"Do not use API that changes roots from roots events. Try using invoke later or something else.");
        if (this.myMergedCallStarted) {
            LOG.assertTrue(!fileTypes, (Object)"File types change is not supported inside merged call");
        }
        if (this.myRootsChangesDepth++ == 0) {
            if (this.myMergedCallStarted) {
                this.myMergedCallHasRootChange = true;
                ++this.myRootsChangesDepth;
            }
            this.fireBeforeRootsChangeEvent(fileTypes);
            return true;
        }
        return false;
    }

    protected void fireBeforeRootsChangeEvent(boolean fileTypes) {
    }

    private boolean fireRootsChanged(boolean fileTypes) {
        if (this.myProject.isDisposed() || Disposer.isDisposing((Disposable)this.myProject)) {
            return false;
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        LOG.assertTrue(!this.isFiringEvent, (Object)"Do not use API that changes roots from roots events. Try using invoke later or something else.");
        if (this.myMergedCallStarted) {
            LOG.assertTrue(!fileTypes, (Object)"File types change is not supported inside merged call");
        }
        --this.myRootsChangesDepth;
        if (this.myRootsChangesDepth > 0) {
            return false;
        }
        if (this.myRootsChangesDepth < 0) {
            LOG.info("Restoring from roots change start/finish mismatch: ", new Throwable());
            this.myRootsChangesDepth = 0;
        }
        this.clearScopesCaches();
        this.incModificationCount();
        PsiManager.getInstance((Project)this.myProject).dropPsiCaches();
        this.fireRootsChangedEvent(fileTypes);
        this.doSynchronizeRoots();
        this.addRootsToWatch();
        return true;
    }

    protected void fireRootsChangedEvent(boolean fileTypes) {
    }

    protected void addRootsToWatch() {
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(14);
        }
        return project2;
    }

    protected void doSynchronizeRoots() {
    }

    public static String extractLocalPath(String url) {
        String path = VfsUtilCore.urlToPath((String)url);
        int jarSeparatorIndex = path.indexOf("!/");
        if (jarSeparatorIndex > 0) {
            return path.substring(0, jarSeparatorIndex);
        }
        return path;
    }

    private ModuleManager getModuleManager() {
        return ModuleManager.getInstance((Project)this.myProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void subscribeToRootProvider(@NotNull OrderEntry owner2, @NotNull RootProvider provider) {
        if (owner2 == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(15);
        }
        if (provider == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(16);
        }
        Map<RootProvider, Set<OrderEntry>> map = this.myRegisteredRootProviders;
        synchronized (map) {
            HashSet owners = this.myRegisteredRootProviders.get(provider);
            if (owners == null) {
                owners = new HashSet();
                this.myRegisteredRootProviders.put(provider, (Set<OrderEntry>)owners);
                provider.addRootSetChangedListener((RootProvider.RootSetChangedListener)this.myRootProviderChangeListener);
            }
            owners.add((OrderEntry)owner2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unsubscribeFromRootProvider(@NotNull OrderEntry owner2, @NotNull RootProvider provider) {
        if (owner2 == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(17);
        }
        if (provider == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(18);
        }
        Map<RootProvider, Set<OrderEntry>> map = this.myRegisteredRootProviders;
        synchronized (map) {
            Set<OrderEntry> owners = this.myRegisteredRootProviders.get(provider);
            if (owners != null) {
                owners.remove(owner2);
                if (owners.isEmpty()) {
                    provider.removeRootSetChangedListener((RootProvider.RootSetChangedListener)this.myRootProviderChangeListener);
                    this.myRegisteredRootProviders.remove(provider);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addListenerForTable(@NotNull LibraryTable.Listener libraryListener, @NotNull LibraryTable libraryTable) {
        if (libraryListener == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(19);
        }
        if (libraryTable == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(20);
        }
        Object object = this.myLibraryTableListenersLock;
        synchronized (object) {
            LibraryTableMultiListener multiListener = this.myLibraryTableMultiListeners.get(libraryTable);
            if (multiListener == null) {
                multiListener = new LibraryTableMultiListener();
                libraryTable.addListener((LibraryTable.Listener)multiListener);
                this.myLibraryTableMultiListeners.put(libraryTable, multiListener);
            }
            multiListener.addListener(libraryListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeListenerForTable(@NotNull LibraryTable.Listener libraryListener, @NotNull LibraryTable libraryTable) {
        if (libraryListener == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(21);
        }
        if (libraryTable == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(22);
        }
        Object object = this.myLibraryTableListenersLock;
        synchronized (object) {
            boolean last;
            LibraryTableMultiListener multiListener = this.myLibraryTableMultiListeners.get(libraryTable);
            if (multiListener != null && (last = multiListener.removeListener(libraryListener))) {
                libraryTable.removeListener((LibraryTable.Listener)multiListener);
                this.myLibraryTableMultiListeners.remove(libraryTable);
            }
        }
    }

    void addJdkTableListener(@NotNull ProjectJdkTable.Listener jdkTableListener, @NotNull Disposable parent) {
        if (jdkTableListener == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(23);
        }
        if (parent == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(24);
        }
        this.myJdkTableMultiListener.addListener(jdkTableListener);
        Disposer.register((Disposable)parent, () -> {
            if (jdkTableListener == null) {
                ProjectRootManagerImpl.$$$reportNull$$$0(26);
            }
            this.myJdkTableMultiListener.removeListener(jdkTableListener);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void assertListenersAreDisposed() {
        Map<RootProvider, Set<OrderEntry>> map = this.myRegisteredRootProviders;
        synchronized (map) {
            if (!this.myRegisteredRootProviders.isEmpty()) {
                StringBuilder details = new StringBuilder();
                for (Map.Entry<RootProvider, Set<OrderEntry>> entry : this.myRegisteredRootProviders.entrySet()) {
                    details.append(" ").append(entry.getKey()).append(" referenced by ").append(entry.getValue().size()).append(" order entries:\n");
                    for (OrderEntry orderEntry : entry.getValue()) {
                        details.append("   ").append(orderEntry).append("\n");
                    }
                }
                LOG.error("Listeners for " + this.myRegisteredRootProviders.size() + " root providers aren't disposed:" + details);
                for (RootProvider provider : this.myRegisteredRootProviders.keySet()) {
                    provider.removeRootSetChangedListener((RootProvider.RootSetChangedListener)this.myRootProviderChangeListener);
                }
            }
        }
    }

    public void markRootsForRefresh() {
    }

    @NotNull
    public VirtualFilePointerListener getRootsValidityChangedListener() {
        VirtualFilePointerListener virtualFilePointerListener = this.myRootsValidityChangedListener;
        if (virtualFilePointerListener == null) {
            ProjectRootManagerImpl.$$$reportNull$$$0(25);
        }
        return virtualFilePointerListener;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/ProjectRootManagerImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTypes";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryListener";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryTable";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdkTableListener";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileIndex";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRootUrls";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRoots";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentSourceRoots";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/ProjectRootManagerImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleSourceRoots";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "orderEntries";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootsValidityChangedListener";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getModuleSourceRoots";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "orderEntries";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addProjectJdkListener";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeProjectJdkListener";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "mergeRootsChangesDuring";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "makeRootsChange";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "subscribeToRootProvider";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "unsubscribeFromRootProvider";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addListenerForTable";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "removeListenerForTable";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addJdkTableListener";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addJdkTableListener$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class RootProviderChangeListener
    implements RootProvider.RootSetChangedListener {
        private boolean myInsideRootsChange;

        private RootProviderChangeListener() {
        }

        public void rootSetChanged(@NotNull RootProvider wrapper) {
            if (wrapper == null) {
                RootProviderChangeListener.$$$reportNull$$$0(0);
            }
            if (this.myInsideRootsChange) {
                return;
            }
            this.myInsideRootsChange = true;
            try {
                ProjectRootManagerImpl.this.makeRootsChange(EmptyRunnable.INSTANCE, false, true);
            }
            finally {
                this.myInsideRootsChange = false;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "wrapper", "com/intellij/openapi/roots/impl/ProjectRootManagerImpl$RootProviderChangeListener", "rootSetChanged"));
        }
    }

    private class JdkTableMultiListener
    implements ProjectJdkTable.Listener {
        private final Set<ProjectJdkTable.Listener> myListeners = new LinkedHashSet<ProjectJdkTable.Listener>();
        private final MessageBusConnection listenerConnection;
        private ProjectJdkTable.Listener[] myListenersArray;

        private JdkTableMultiListener(Project project2) {
            this.listenerConnection = project2.getMessageBus().connect();
            this.listenerConnection.subscribe(ProjectJdkTable.JDK_TABLE_TOPIC, (Object)this);
        }

        private synchronized void addListener(ProjectJdkTable.Listener listener2) {
            this.myListeners.add(listener2);
            this.myListenersArray = null;
        }

        private synchronized void removeListener(ProjectJdkTable.Listener listener2) {
            this.myListeners.remove(listener2);
            this.myListenersArray = null;
        }

        private synchronized ProjectJdkTable.Listener[] getListeners() {
            if (this.myListenersArray == null) {
                this.myListenersArray = this.myListeners.toArray(new ProjectJdkTable.Listener[this.myListeners.size()]);
            }
            return this.myListenersArray;
        }

        public void jdkAdded(@NotNull Sdk jdk) {
            if (jdk == null) {
                JdkTableMultiListener.$$$reportNull$$$0(0);
            }
            ProjectRootManagerImpl.this.mergeRootsChangesDuring(() -> {
                if (jdk == null) {
                    JdkTableMultiListener.$$$reportNull$$$0(7);
                }
                for (ProjectJdkTable.Listener listener2 : this.getListeners()) {
                    listener2.jdkAdded(jdk);
                }
            });
        }

        public void jdkRemoved(@NotNull Sdk jdk) {
            if (jdk == null) {
                JdkTableMultiListener.$$$reportNull$$$0(1);
            }
            ProjectRootManagerImpl.this.mergeRootsChangesDuring(() -> {
                if (jdk == null) {
                    JdkTableMultiListener.$$$reportNull$$$0(6);
                }
                for (ProjectJdkTable.Listener listener2 : this.getListeners()) {
                    listener2.jdkRemoved(jdk);
                }
            });
        }

        public void jdkNameChanged(@NotNull Sdk jdk, @NotNull String previousName) {
            if (jdk == null) {
                JdkTableMultiListener.$$$reportNull$$$0(2);
            }
            if (previousName == null) {
                JdkTableMultiListener.$$$reportNull$$$0(3);
            }
            ProjectRootManagerImpl.this.mergeRootsChangesDuring(() -> {
                if (jdk == null) {
                    JdkTableMultiListener.$$$reportNull$$$0(4);
                }
                if (previousName == null) {
                    JdkTableMultiListener.$$$reportNull$$$0(5);
                }
                for (ProjectJdkTable.Listener listener2 : this.getListeners()) {
                    listener2.jdkNameChanged(jdk, previousName);
                }
            });
            String currentName = ProjectRootManagerImpl.this.getProjectSdkName();
            if (previousName.equals(currentName)) {
                ProjectRootManagerImpl.this.myProjectSdkName = jdk.getName();
                ProjectRootManagerImpl.this.myProjectSdkType = jdk.getSdkType().getName();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jdk";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previousName";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/roots/impl/ProjectRootManagerImpl$JdkTableMultiListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "jdkAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "jdkRemoved";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "jdkNameChanged";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$jdkNameChanged$2";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$jdkRemoved$1";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$jdkAdded$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class LibraryTableMultiListener
    implements LibraryTable.Listener {
        private final Set<LibraryTable.Listener> myListeners = new LinkedHashSet<LibraryTable.Listener>();
        private LibraryTable.Listener[] myListenersArray;

        private LibraryTableMultiListener() {
        }

        private synchronized void addListener(@NotNull LibraryTable.Listener listener2) {
            if (listener2 == null) {
                LibraryTableMultiListener.$$$reportNull$$$0(0);
            }
            this.myListeners.add(listener2);
            this.myListenersArray = null;
        }

        private synchronized boolean removeListener(@NotNull LibraryTable.Listener listener2) {
            if (listener2 == null) {
                LibraryTableMultiListener.$$$reportNull$$$0(1);
            }
            this.myListeners.remove(listener2);
            this.myListenersArray = null;
            return this.myListeners.isEmpty();
        }

        public void afterLibraryAdded(@NotNull Library newLibrary) {
            if (newLibrary == null) {
                LibraryTableMultiListener.$$$reportNull$$$0(2);
            }
            ProjectRootManagerImpl.this.incModificationCount();
            ProjectRootManagerImpl.this.mergeRootsChangesDuring(() -> {
                if (newLibrary == null) {
                    LibraryTableMultiListener.$$$reportNull$$$0(9);
                }
                for (LibraryTable.Listener listener2 : this.getListeners()) {
                    listener2.afterLibraryAdded(newLibrary);
                }
            });
        }

        private synchronized LibraryTable.Listener[] getListeners() {
            if (this.myListenersArray == null) {
                this.myListenersArray = this.myListeners.toArray(new LibraryTable.Listener[this.myListeners.size()]);
            }
            return this.myListenersArray;
        }

        public void afterLibraryRenamed(@NotNull Library library) {
            if (library == null) {
                LibraryTableMultiListener.$$$reportNull$$$0(3);
            }
            ProjectRootManagerImpl.this.incModificationCount();
            ProjectRootManagerImpl.this.mergeRootsChangesDuring(() -> {
                if (library == null) {
                    LibraryTableMultiListener.$$$reportNull$$$0(8);
                }
                for (LibraryTable.Listener listener2 : this.getListeners()) {
                    listener2.afterLibraryRenamed(library);
                }
            });
        }

        public void beforeLibraryRemoved(@NotNull Library library) {
            if (library == null) {
                LibraryTableMultiListener.$$$reportNull$$$0(4);
            }
            ProjectRootManagerImpl.this.incModificationCount();
            ProjectRootManagerImpl.this.mergeRootsChangesDuring(() -> {
                if (library == null) {
                    LibraryTableMultiListener.$$$reportNull$$$0(7);
                }
                for (LibraryTable.Listener listener2 : this.getListeners()) {
                    listener2.beforeLibraryRemoved(library);
                }
            });
        }

        public void afterLibraryRemoved(@NotNull Library library) {
            if (library == null) {
                LibraryTableMultiListener.$$$reportNull$$$0(5);
            }
            ProjectRootManagerImpl.this.incModificationCount();
            ProjectRootManagerImpl.this.mergeRootsChangesDuring(() -> {
                if (library == null) {
                    LibraryTableMultiListener.$$$reportNull$$$0(6);
                }
                for (LibraryTable.Listener listener2 : this.getListeners()) {
                    listener2.afterLibraryRemoved(library);
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 2: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newLibrary";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "library";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/roots/impl/ProjectRootManagerImpl$LibraryTableMultiListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addListener";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "removeListener";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterLibraryAdded";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterLibraryRenamed";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeLibraryRemoved";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterLibraryRemoved";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$afterLibraryRemoved$3";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$beforeLibraryRemoved$2";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$afterLibraryRenamed$1";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$afterLibraryAdded$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected class BatchSession {
        private int myBatchLevel;
        private boolean myChanged;
        private final boolean myFileTypes;

        private BatchSession(boolean fileTypes) {
            this.myFileTypes = fileTypes;
        }

        protected void levelUp() {
            if (this.myBatchLevel == 0) {
                this.myChanged = false;
            }
            ++this.myBatchLevel;
        }

        protected void levelDown() {
            --this.myBatchLevel;
            if (this.myChanged && this.myBatchLevel == 0) {
                try {
                    WriteAction.run(() -> ProjectRootManagerImpl.this.fireRootsChanged(this.myFileTypes));
                }
                finally {
                    this.myChanged = false;
                }
            }
        }

        protected void beforeRootsChanged() {
            if ((this.myBatchLevel == 0 || !this.myChanged) && ProjectRootManagerImpl.this.fireBeforeRootsChanged(this.myFileTypes)) {
                this.myChanged = true;
            }
        }

        protected void rootsChanged() {
            if (this.myBatchLevel == 0 && ProjectRootManagerImpl.this.fireRootsChanged(this.myFileTypes)) {
                this.myChanged = false;
            }
        }
    }
}

