/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.LibraryTypeService;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.libraries.ui.impl.RootDetectionUtil;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryTypeServiceImpl
extends LibraryTypeService {
    private static final String DEFAULT_LIBRARY_NAME = "Unnamed";

    @Override
    public NewLibraryConfiguration createLibraryFromFiles(@NotNull LibraryRootsComponentDescriptor descriptor2, @NotNull JComponent parentComponent, @Nullable VirtualFile contextDirectory, LibraryType<?> type2, Project project2) {
        if (descriptor2 == null) {
            LibraryTypeServiceImpl.$$$reportNull$$$0(0);
        }
        if (parentComponent == null) {
            LibraryTypeServiceImpl.$$$reportNull$$$0(1);
        }
        FileChooserDescriptor chooserDescriptor = descriptor2.createAttachFilesChooserDescriptor(null);
        chooserDescriptor.setTitle("Select Library Files");
        VirtualFile[] rootCandidates = FileChooser.chooseFiles((FileChooserDescriptor)chooserDescriptor, (Component)parentComponent, (Project)project2, (VirtualFile)contextDirectory);
        if (rootCandidates.length == 0) {
            return null;
        }
        List<OrderRoot> roots = RootDetectionUtil.detectRoots(Arrays.asList(rootCandidates), parentComponent, project2, descriptor2);
        if (roots.isEmpty()) {
            return null;
        }
        String name2 = LibraryTypeServiceImpl.suggestLibraryName(roots);
        return LibraryTypeServiceImpl.doCreate(type2, name2, roots);
    }

    private static <P extends LibraryProperties<?>> NewLibraryConfiguration doCreate(LibraryType<P> type2, String name2, final List<OrderRoot> roots) {
        return new NewLibraryConfiguration(name2, type2, type2 != null ? type2.getKind().createDefaultProperties() : null){

            @Override
            public void addRoots(@NotNull LibraryEditor editor) {
                if (editor == null) {
                    1.$$$reportNull$$$0(0);
                }
                editor.addRoots(roots);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/roots/impl/libraries/LibraryTypeServiceImpl$1", "addRoots"));
            }
        };
    }

    public static String suggestLibraryName(@NotNull VirtualFile[] classesRoots) {
        if (classesRoots == null) {
            LibraryTypeServiceImpl.$$$reportNull$$$0(2);
        }
        if (classesRoots.length >= 1) {
            return FileUtil.getNameWithoutExtension((String)PathUtil.getFileName((String)classesRoots[0].getPath()));
        }
        return DEFAULT_LIBRARY_NAME;
    }

    public static String suggestLibraryName(@NotNull List<OrderRoot> roots) {
        if (roots == null) {
            LibraryTypeServiceImpl.$$$reportNull$$$0(3);
        }
        if (roots.size() >= 1) {
            return FileUtil.getNameWithoutExtension((String)PathUtil.getFileName((String)roots.get(0).getFile().getPath()));
        }
        return DEFAULT_LIBRARY_NAME;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesRoots";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/impl/libraries/LibraryTypeServiceImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createLibraryFromFiles";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "suggestLibraryName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

