/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.ide.util.projectWizard.importSources.JavaModuleSourceRoot;
import com.intellij.ide.util.projectWizard.importSources.JavaSourceRootDetectionUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.progress.util.SmoothProgressAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.CommonContentEntriesEditor;
import com.intellij.openapi.roots.ui.configuration.ContentEntryEditor;
import com.intellij.openapi.roots.ui.configuration.JavaContentEntryEditor;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.SwingWorker;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class JavaContentEntriesEditor
extends CommonContentEntriesEditor {
    public JavaContentEntriesEditor(String moduleName, ModuleConfigurationState state) {
        super(moduleName, state, new JpsModuleSourceRootType[]{JavaSourceRootType.SOURCE, JavaSourceRootType.TEST_SOURCE, JavaResourceRootType.RESOURCE, JavaResourceRootType.TEST_RESOURCE});
    }

    @Override
    protected ContentEntryEditor createContentEntryEditor(String contentEntryUrl) {
        return new JavaContentEntryEditor(contentEntryUrl, this.getEditHandlers()){

            @Override
            protected ModifiableRootModel getModel() {
                return JavaContentEntriesEditor.this.getModel();
            }
        };
    }

    @Override
    protected List<ContentEntry> addContentEntries(VirtualFile[] files) {
        List<ContentEntry> contentEntries = super.addContentEntries(files);
        if (!contentEntries.isEmpty()) {
            ContentEntry[] contentEntriesArray = contentEntries.toArray(new ContentEntry[contentEntries.size()]);
            JavaContentEntriesEditor.addSourceRoots(this.myProject, contentEntriesArray, () -> this.addContentEntryPanels(contentEntriesArray));
        }
        return contentEntries;
    }

    private static void addSourceRoots(@NotNull Project project2, ContentEntry[] contentEntries, Runnable finishRunnable) {
        if (project2 == null) {
            JavaContentEntriesEditor.$$$reportNull$$$0(0);
        }
        HashMap<ContentEntry, Object> entryToRootMap = new HashMap<ContentEntry, Object>();
        HashMap<File, ContentEntry> fileToEntryMap = new HashMap<File, ContentEntry>();
        for (ContentEntry contentEntry : contentEntries) {
            VirtualFile file2 = contentEntry.getFile();
            if (file2 == null) continue;
            entryToRootMap.put(contentEntry, null);
            fileToEntryMap.put(VfsUtilCore.virtualToIoFile((VirtualFile)file2), contentEntry);
        }
        ProgressWindow progressWindow = new ProgressWindow(true, project2);
        SmoothProgressAdapter progressIndicator = new SmoothProgressAdapter(progressWindow, project2);
        final Runnable searchRunnable = () -> {
            Runnable process2 = () -> {
                for (File file2 : fileToEntryMap.keySet()) {
                    progressIndicator.setText(ProjectBundle.message((String)"module.paths.searching.source.roots.progress", (Object[])new Object[]{file2.getPath()}));
                    Collection<JavaModuleSourceRoot> roots = JavaSourceRootDetectionUtil.suggestRoots(file2);
                    entryToRootMap.put((ContentEntry)fileToEntryMap.get(file2), roots);
                }
            };
            progressWindow.setTitle(ProjectBundle.message((String)"module.paths.searching.source.roots.title", (Object[])new Object[0]));
            ProgressManager.getInstance().runProcess(process2, progressIndicator);
        };
        final Runnable addSourcesRunnable = () -> {
            for (ContentEntry contentEntry : contentEntries) {
                Collection suggestedRoots = (Collection)entryToRootMap.get(contentEntry);
                if (suggestedRoots == null) continue;
                for (JavaModuleSourceRoot suggestedRoot : suggestedRoots) {
                    VirtualFile sourceRoot = LocalFileSystem.getInstance().findFileByIoFile(suggestedRoot.getDirectory());
                    VirtualFile fileContent = contentEntry.getFile();
                    if (sourceRoot == null || fileContent == null || !VfsUtilCore.isAncestor((VirtualFile)fileContent, (VirtualFile)sourceRoot, (boolean)false)) continue;
                    contentEntry.addSourceFolder(sourceRoot, false, suggestedRoot.getPackagePrefix());
                }
            }
            if (finishRunnable != null) {
                finishRunnable.run();
            }
        };
        new SwingWorker(){

            public Object construct() {
                searchRunnable.run();
                return null;
            }

            public void finished() {
                addSourcesRunnable.run();
            }
        }.start();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/ui/configuration/JavaContentEntriesEditor", "addSourceRoots"));
    }
}

