/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.actions;

import com.intellij.ide.DeleteProvider;
import com.intellij.ide.TitledHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.project.ProjectKt;
import com.intellij.projectImport.ProjectAttachProcessor;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PathUtilRt;
import com.intellij.util.PlatformUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleDeleteProvider
implements DeleteProvider,
TitledHandler {
    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        Module[] modules;
        if (dataContext == null) {
            ModuleDeleteProvider.$$$reportNull$$$0(0);
        }
        return (modules = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext)) != null && !ModuleDeleteProvider.isPrimaryModule(modules);
    }

    private static boolean isPrimaryModule(Module[] modules) {
        if (!ProjectAttachProcessor.canAttachToProject()) {
            return !PlatformUtils.isIntelliJ();
        }
        for (Module module2 : modules) {
            String moduleFile = module2.getModuleFilePath();
            Project project2 = module2.getProject();
            if (!ProjectKt.isDirectoryBased(project2)) continue;
            String ideaDir = ProjectKt.getStateStore(project2).getDirectoryStorePath();
            if (!PathUtilRt.getParentPath((String)moduleFile).equals(ideaDir)) continue;
            return true;
        }
        return false;
    }

    public void deleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            ModuleDeleteProvider.$$$reportNull$$$0(1);
        }
        Module[] modules = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext);
        assert (modules != null);
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        assert (project2 != null);
        String names = StringUtil.join(Arrays.asList(modules), module2 -> "'" + module2.getName() + "'", (String)", ");
        int ret = Messages.showOkCancelDialog((String)ModuleDeleteProvider.getConfirmationText(modules, names), (String)this.getActionTitle(), (Icon)Messages.getQuestionIcon());
        if (ret != 0) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(project2, () -> {
            Runnable action = () -> {
                ModuleManager moduleManager = ModuleManager.getInstance((Project)project2);
                Module[] currentModules = moduleManager.getModules();
                ModifiableModuleModel modifiableModuleModel = moduleManager.getModifiableModel();
                HashMap<Module, ModifiableRootModel> otherModuleRootModels = new HashMap<Module, ModifiableRootModel>();
                for (Module module2 : modules) {
                    ModifiableRootModel modifiableModel = ModuleRootManager.getInstance((Module)module2).getModifiableModel();
                    for (Module otherModule : currentModules) {
                        if (otherModule == module2 || ArrayUtilRt.find((Object[])modules, (Object)otherModule) != -1 || otherModuleRootModels.containsKey(otherModule)) continue;
                        otherModuleRootModels.put(otherModule, ModuleRootManager.getInstance((Module)otherModule).getModifiableModel());
                    }
                    ModuleDeleteProvider.removeModule(module2, modifiableModel, otherModuleRootModels.values(), modifiableModuleModel);
                }
                ModifiableRootModel[] modifiableRootModels = otherModuleRootModels.values().toArray(new ModifiableRootModel[otherModuleRootModels.size()]);
                ModifiableModelCommitter.multiCommit(modifiableRootModels, modifiableModuleModel);
            };
            ApplicationManager.getApplication().runWriteAction(action);
        }, ProjectBundle.message((String)"module.remove.command", (Object[])new Object[0]), null);
    }

    private static String getConfirmationText(Module[] modules, String names) {
        if (ProjectAttachProcessor.canAttachToProject()) {
            return ProjectBundle.message((String)"project.remove.confirmation.prompt", (Object[])new Object[]{names, modules.length});
        }
        return ProjectBundle.message((String)"module.remove.confirmation.prompt", (Object[])new Object[]{names, modules.length});
    }

    public String getActionTitle() {
        return ProjectAttachProcessor.canAttachToProject() ? "Remove from Project View" : "Remove Module";
    }

    public static void removeModule(@NotNull Module moduleToRemove, @Nullable ModifiableRootModel modifiableRootModelToRemove, @NotNull Collection<ModifiableRootModel> otherModuleRootModels, @NotNull ModifiableModuleModel moduleModel) {
        if (moduleToRemove == null) {
            ModuleDeleteProvider.$$$reportNull$$$0(2);
        }
        if (otherModuleRootModels == null) {
            ModuleDeleteProvider.$$$reportNull$$$0(3);
        }
        if (moduleModel == null) {
            ModuleDeleteProvider.$$$reportNull$$$0(4);
        }
        for (ModifiableRootModel modifiableRootModel : otherModuleRootModels) {
            OrderEntry[] orderEntries;
            for (OrderEntry orderEntry : orderEntries = modifiableRootModel.getOrderEntries()) {
                Module orderEntryModule;
                if (!(orderEntry instanceof ModuleOrderEntry) || !orderEntry.isValid() || (orderEntryModule = ((ModuleOrderEntry)orderEntry).getModule()) == null || !orderEntryModule.equals(moduleToRemove)) continue;
                modifiableRootModel.removeOrderEntry(orderEntry);
            }
        }
        if (modifiableRootModelToRemove != null) {
            modifiableRootModelToRemove.dispose();
        }
        moduleModel.disposeModule(moduleToRemove);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleToRemove";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherModuleRootModels";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleModel";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/actions/ModuleDeleteProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canDeleteElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "deleteElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "removeModule";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

