/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.ui.Util;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.NativeLibraryOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.ui.AttachRootButtonDescriptor;
import com.intellij.openapi.roots.libraries.ui.DescendentBasedRootFilter;
import com.intellij.openapi.roots.libraries.ui.LibraryRootsComponentDescriptor;
import com.intellij.openapi.roots.libraries.ui.OrderRootTypePresentation;
import com.intellij.openapi.roots.libraries.ui.RootDetector;
import com.intellij.openapi.roots.ui.OrderRootTypeUIFactory;
import com.intellij.openapi.roots.ui.configuration.LibrarySourceRootDetectorUtil;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.JavadocQuarantineStatusCleaner;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultLibraryRootsComponentDescriptor
extends LibraryRootsComponentDescriptor {
    private static final Set<String> NATIVE_LIBRARY_EXTENSIONS = ContainerUtil.newTroveSet((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY, (Object[])new String[]{"dll", "so", "dylib"});
    public static final Condition<VirtualFile> LIBRARY_ROOT_CONDITION = file2 -> FileElement.isArchive((VirtualFile)file2) || DefaultLibraryRootsComponentDescriptor.isNativeLibrary(file2);

    @Override
    public OrderRootTypePresentation getRootTypePresentation(@NotNull OrderRootType type2) {
        if (type2 == null) {
            DefaultLibraryRootsComponentDescriptor.$$$reportNull$$$0(0);
        }
        return DefaultLibraryRootsComponentDescriptor.getDefaultPresentation(type2);
    }

    @Override
    @NotNull
    public List<? extends AttachRootButtonDescriptor> createAttachButtons() {
        List<AttachUrlJavadocDescriptor> list2 = Collections.singletonList(new AttachUrlJavadocDescriptor());
        if (list2 == null) {
            DefaultLibraryRootsComponentDescriptor.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<? extends RootDetector> getRootDetectors() {
        ArrayList<RootDetector> results = new ArrayList<RootDetector>();
        results.add(new DescendentBasedRootFilter(OrderRootType.CLASSES, false, "classes", file2 -> StdFileTypes.CLASS.equals(file2.getFileType()) || file2.getFileSystem() instanceof JarFileSystem && DefaultLibraryRootsComponentDescriptor.isNativeLibrary(file2)));
        results.add(DescendentBasedRootFilter.createFileTypeBasedFilter(OrderRootType.CLASSES, true, StdFileTypes.CLASS, "jar directory"));
        ContainerUtil.addAll(results, (Object[])Extensions.getExtensions(LibrarySourceRootDetectorUtil.JAVA_SOURCE_ROOT_DETECTOR));
        results.add(DescendentBasedRootFilter.createFileTypeBasedFilter(OrderRootType.SOURCES, true, (FileType)StdFileTypes.JAVA, "source archive directory"));
        results.add(new JavadocRootDetector());
        results.add(new DescendentBasedRootFilter(AnnotationOrderRootType.getInstance(), false, "external annotations", file2 -> "annotations.xml".equals(file2.getName())));
        results.add(new NativeLibraryRootFilter());
        ArrayList<RootDetector> arrayList = results;
        if (arrayList == null) {
            DefaultLibraryRootsComponentDescriptor.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static boolean isNativeLibrary(VirtualFile file2) {
        String extension = file2.getExtension();
        return extension != null && NATIVE_LIBRARY_EXTENSIONS.contains(extension);
    }

    @Override
    @NotNull
    public FileChooserDescriptor createAttachFilesChooserDescriptor(@Nullable String libraryName) {
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(true, true, true, false, true, true).withFileFilter(LIBRARY_ROOT_CONDITION);
        descriptor2.setTitle(StringUtil.isEmpty((String)libraryName) ? ProjectBundle.message((String)"library.attach.files.action", (Object[])new Object[0]) : ProjectBundle.message((String)"library.attach.files.to.library.action", (Object[])new Object[]{libraryName}));
        descriptor2.setDescription(ProjectBundle.message((String)"library.java.attach.files.description", (Object[])new Object[0]));
        FileChooserDescriptor fileChooserDescriptor2 = descriptor2;
        if (fileChooserDescriptor2 == null) {
            DefaultLibraryRootsComponentDescriptor.$$$reportNull$$$0(3);
        }
        return fileChooserDescriptor2;
    }

    public static OrderRootTypePresentation getDefaultPresentation(OrderRootType type2) {
        OrderRootTypeUIFactory factory = (OrderRootTypeUIFactory)OrderRootTypeUIFactory.FACTORY.getByKey((Object)type2);
        return new OrderRootTypePresentation(factory.getNodeText(), factory.getIcon());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/DefaultLibraryRootsComponentDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/DefaultLibraryRootsComponentDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createAttachButtons";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootDetectors";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createAttachFilesChooserDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRootTypePresentation";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AttachUrlJavadocDescriptor
    extends AttachRootButtonDescriptor {
        private AttachUrlJavadocDescriptor() {
            super(JavadocOrderRootType.getInstance(), IconUtil.getAddLinkIcon(), ProjectBundle.message((String)"module.libraries.javadoc.url.button", (Object[])new Object[0]));
        }

        @Override
        public VirtualFile[] selectFiles(@NotNull JComponent parent, @Nullable VirtualFile initialSelection, @Nullable Module contextModule, @NotNull LibraryEditor libraryEditor) {
            VirtualFile[] virtualFileArray;
            VirtualFile vFile;
            if (parent == null) {
                AttachUrlJavadocDescriptor.$$$reportNull$$$0(0);
            }
            if (libraryEditor == null) {
                AttachUrlJavadocDescriptor.$$$reportNull$$$0(1);
            }
            if ((vFile = Util.showSpecifyJavadocUrlDialog(parent)) != null) {
                VirtualFile[] virtualFileArray2 = new VirtualFile[1];
                virtualFileArray = virtualFileArray2;
                virtualFileArray2[0] = vFile;
            } else {
                virtualFileArray = VirtualFile.EMPTY_ARRAY;
            }
            return virtualFileArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "libraryEditor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/DefaultLibraryRootsComponentDescriptor$AttachUrlJavadocDescriptor";
            objectArray[2] = "selectFiles";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class NativeLibraryRootFilter
    extends RootDetector {
        private NativeLibraryRootFilter() {
            super(NativeLibraryOrderRootType.getInstance(), false, "native library location");
        }

        @Override
        @NotNull
        public Collection<VirtualFile> detectRoots(@NotNull VirtualFile rootCandidate, @NotNull ProgressIndicator progressIndicator) {
            if (rootCandidate == null) {
                NativeLibraryRootFilter.$$$reportNull$$$0(0);
            }
            if (progressIndicator == null) {
                NativeLibraryRootFilter.$$$reportNull$$$0(1);
            }
            if (rootCandidate.isInLocalFileSystem()) {
                if (rootCandidate.isDirectory()) {
                    for (VirtualFile file2 : rootCandidate.getChildren()) {
                        if (!DefaultLibraryRootsComponentDescriptor.isNativeLibrary(file2)) continue;
                        Set<VirtualFile> set2 = Collections.singleton(rootCandidate);
                        if (set2 == null) {
                            NativeLibraryRootFilter.$$$reportNull$$$0(2);
                        }
                        return set2;
                    }
                } else if (DefaultLibraryRootsComponentDescriptor.isNativeLibrary(rootCandidate)) {
                    Set<VirtualFile> set3 = Collections.singleton(rootCandidate.getParent());
                    if (set3 == null) {
                        NativeLibraryRootFilter.$$$reportNull$$$0(3);
                    }
                    return set3;
                }
            }
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                NativeLibraryRootFilter.$$$reportNull$$$0(4);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootCandidate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progressIndicator";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/DefaultLibraryRootsComponentDescriptor$NativeLibraryRootFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/DefaultLibraryRootsComponentDescriptor$NativeLibraryRootFilter";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "detectRoots";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "detectRoots";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class JavadocRootDetector
    extends RootDetector {
        private JavadocRootDetector() {
            super(JavadocOrderRootType.getInstance(), false, "JavaDocs");
        }

        @Override
        @NotNull
        public Collection<VirtualFile> detectRoots(@NotNull VirtualFile rootCandidate, @NotNull ProgressIndicator progressIndicator) {
            if (rootCandidate == null) {
                JavadocRootDetector.$$$reportNull$$$0(0);
            }
            if (progressIndicator == null) {
                JavadocRootDetector.$$$reportNull$$$0(1);
            }
            ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
            JavadocRootDetector.collectJavadocRoots(rootCandidate, result2, progressIndicator);
            JavadocQuarantineStatusCleaner.cleanIfNeeded(VfsUtilCore.toVirtualFileArray(result2));
            ArrayList<VirtualFile> arrayList = result2;
            if (arrayList == null) {
                JavadocRootDetector.$$$reportNull$$$0(2);
            }
            return arrayList;
        }

        private static void collectJavadocRoots(VirtualFile file2, final List<VirtualFile> result2, final ProgressIndicator progressIndicator) {
            VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                public boolean visitFile(@NotNull VirtualFile file2) {
                    if (file2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    progressIndicator.checkCanceled();
                    if (file2.isDirectory() && file2.findChild("allclasses-frame.html") != null && file2.findChild("allclasses-noframe.html") != null) {
                        result2.add(file2);
                        return false;
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/ui/configuration/libraryEditor/DefaultLibraryRootsComponentDescriptor$JavadocRootDetector$1", "visitFile"));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootCandidate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "progressIndicator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/DefaultLibraryRootsComponentDescriptor$JavadocRootDetector";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/DefaultLibraryRootsComponentDescriptor$JavadocRootDetector";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "detectRoots";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "detectRoots";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

