/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryDetectionManager;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditorBase;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditorListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExistingLibraryEditor
extends LibraryEditorBase
implements Disposable {
    private final LibraryEx myLibrary;
    private final LibraryEditorListener myListener;
    private String myLibraryName;
    private LibraryProperties myLibraryProperties;
    private LibraryProperties myDetectedLibraryProperties;
    private LibraryEx.ModifiableModelEx myModel;
    private LibraryType<?> myDetectedType;
    private boolean myDetectedTypeComputed;

    public ExistingLibraryEditor(@NotNull Library library, @Nullable LibraryEditorListener listener2) {
        if (library == null) {
            ExistingLibraryEditor.$$$reportNull$$$0(0);
        }
        this.myLibrary = (LibraryEx)library;
        this.myListener = listener2;
    }

    public Library getLibrary() {
        return this.myLibrary;
    }

    @Override
    public String getName() {
        if (this.myLibraryName != null) {
            return this.myLibraryName;
        }
        return this.myLibrary.getName();
    }

    @Override
    public LibraryType<?> getType() {
        PersistentLibraryKind kind2 = this.myLibrary.getKind();
        if (kind2 != null) {
            return LibraryType.findByKind((LibraryKind)kind2);
        }
        return this.detectType();
    }

    @Override
    @Nullable
    public ProjectModelExternalSource getExternalSource() {
        return this.myLibrary.getExternalSource();
    }

    @Override
    public void setType(@NotNull LibraryType<?> type2) {
        if (type2 == null) {
            ExistingLibraryEditor.$$$reportNull$$$0(1);
        }
        this.getModel().setKind(type2.getKind());
    }

    private LibraryType detectType() {
        if (!this.myDetectedTypeComputed) {
            Pair<LibraryType<?>, LibraryProperties<?>> pair2;
            LibraryTable libraryTable = this.myLibrary.getTable();
            if ((libraryTable == null || libraryTable.isEditable()) && (pair2 = LibraryDetectionManager.getInstance().detectType(Arrays.asList(this.getFiles(OrderRootType.CLASSES)))) != null) {
                this.myDetectedType = (LibraryType)pair2.getFirst();
                this.myDetectedLibraryProperties = (LibraryProperties)pair2.getSecond();
            }
            this.myDetectedTypeComputed = true;
        }
        return this.myDetectedType;
    }

    @Override
    public LibraryProperties getProperties() {
        LibraryType<?> type2 = this.getType();
        if (type2 == null) {
            return null;
        }
        if (this.myDetectedType != null) {
            return this.myDetectedLibraryProperties;
        }
        if (this.myLibraryProperties == null) {
            this.myLibraryProperties = type2.getKind().createDefaultProperties();
            this.myLibraryProperties.loadState(this.getOriginalProperties().getState());
        }
        return this.myLibraryProperties;
    }

    @Override
    public void setProperties(LibraryProperties properties) {
        this.myLibraryProperties = properties;
    }

    private LibraryProperties getOriginalProperties() {
        return this.myLibrary.getProperties();
    }

    public void dispose() {
        if (this.myModel != null) {
            Disposer.dispose((Disposable)this.myModel);
        }
    }

    @Override
    @NotNull
    public String[] getUrls(@NotNull OrderRootType rootType) {
        if (rootType == null) {
            ExistingLibraryEditor.$$$reportNull$$$0(2);
        }
        if (this.myModel != null) {
            String[] stringArray = this.myModel.getUrls(rootType);
            if (stringArray == null) {
                ExistingLibraryEditor.$$$reportNull$$$0(3);
            }
            return stringArray;
        }
        String[] stringArray = this.myLibrary.getUrls(rootType);
        if (stringArray == null) {
            ExistingLibraryEditor.$$$reportNull$$$0(4);
        }
        return stringArray;
    }

    @Override
    @NotNull
    public VirtualFile[] getFiles(@NotNull OrderRootType rootType) {
        if (rootType == null) {
            ExistingLibraryEditor.$$$reportNull$$$0(5);
        }
        if (this.myModel != null) {
            VirtualFile[] virtualFileArray = this.myModel.getFiles(rootType);
            if (virtualFileArray == null) {
                ExistingLibraryEditor.$$$reportNull$$$0(6);
            }
            return virtualFileArray;
        }
        VirtualFile[] virtualFileArray = this.myLibrary.getFiles(rootType);
        if (virtualFileArray == null) {
            ExistingLibraryEditor.$$$reportNull$$$0(7);
        }
        return virtualFileArray;
    }

    @Override
    @NotNull
    public String[] getExcludedRootUrls() {
        if (this.myModel != null) {
            String[] stringArray = this.myModel.getExcludedRootUrls();
            if (stringArray == null) {
                ExistingLibraryEditor.$$$reportNull$$$0(8);
            }
            return stringArray;
        }
        String[] stringArray = this.myLibrary.getExcludedRootUrls();
        if (stringArray == null) {
            ExistingLibraryEditor.$$$reportNull$$$0(9);
        }
        return stringArray;
    }

    @Override
    public void setName(String name2) {
        String oldName = this.getModel().getName();
        this.myLibraryName = name2;
        this.getModel().setName(name2);
        if (this.myListener != null) {
            this.myListener.libraryRenamed((Library)this.myLibrary, oldName, name2);
        }
    }

    @Override
    public void addRoot(@NotNull VirtualFile file2, @NotNull OrderRootType rootType) {
        if (file2 == null) {
            ExistingLibraryEditor.$$$reportNull$$$0(10);
        }
        if (rootType == null) {
            ExistingLibraryEditor.$$$reportNull$$$0(11);
        }
        this.getModel().addRoot(file2, rootType);
    }

    @Override
    public void addRoot(@NotNull String url, @NotNull OrderRootType rootType) {
        if (url == null) {
            ExistingLibraryEditor.$$$reportNull$$$0(12);
        }
        if (rootType == null) {
            ExistingLibraryEditor.$$$reportNull$$$0(13);
        }
        this.getModel().addRoot(url, rootType);
    }

    @Override
    public void addExcludedRoot(@NotNull String url) {
        if (url == null) {
            ExistingLibraryEditor.$$$reportNull$$$0(14);
        }
        this.getModel().addExcludedRoot(url);
    }

    @Override
    public void addJarDirectory(@NotNull VirtualFile file2, boolean recursive, @NotNull OrderRootType rootType) {
        if (file2 == null) {
            ExistingLibraryEditor.$$$reportNull$$$0(15);
        }
        if (rootType == null) {
            ExistingLibraryEditor.$$$reportNull$$$0(16);
        }
        this.getModel().addJarDirectory(file2, recursive, rootType);
    }

    @Override
    public void addJarDirectory(@NotNull String url, boolean recursive, @NotNull OrderRootType rootType) {
        if (url == null) {
            ExistingLibraryEditor.$$$reportNull$$$0(17);
        }
        if (rootType == null) {
            ExistingLibraryEditor.$$$reportNull$$$0(18);
        }
        this.getModel().addJarDirectory(url, recursive, rootType);
    }

    @Override
    public void removeRoot(@NotNull String url, @NotNull OrderRootType rootType) {
        boolean removed;
        if (url == null) {
            ExistingLibraryEditor.$$$reportNull$$$0(19);
        }
        if (rootType == null) {
            ExistingLibraryEditor.$$$reportNull$$$0(20);
        }
        while (removed = this.getModel().removeRoot(url, rootType)) {
        }
    }

    @Override
    public void removeExcludedRoot(@NotNull String url) {
        if (url == null) {
            ExistingLibraryEditor.$$$reportNull$$$0(21);
        }
        this.getModel().removeExcludedRoot(url);
    }

    public void commit() {
        if (this.myModel != null) {
            if (this.myLibraryProperties != null) {
                this.myModel.setProperties(this.myLibraryProperties);
            }
            this.myModel.commit();
            this.myModel = null;
            this.myLibraryName = null;
            this.myLibraryProperties = null;
        }
    }

    public LibraryEx.ModifiableModelEx getModel() {
        if (this.myModel == null) {
            this.myModel = this.myLibrary.getModifiableModel();
        }
        return this.myModel;
    }

    @Override
    public boolean hasChanges() {
        if (this.myModel != null && this.myModel.isChanged()) {
            return true;
        }
        return this.myLibraryProperties != null && !this.myLibraryProperties.equals((Object)this.getOriginalProperties());
    }

    @Override
    public boolean isJarDirectory(@NotNull String url, @NotNull OrderRootType rootType) {
        if (url == null) {
            ExistingLibraryEditor.$$$reportNull$$$0(22);
        }
        if (rootType == null) {
            ExistingLibraryEditor.$$$reportNull$$$0(23);
        }
        if (this.myModel != null) {
            return this.myModel.isJarDirectory(url, rootType);
        }
        return this.myLibrary.isJarDirectory(url, rootType);
    }

    @Override
    public boolean isValid(@NotNull String url, @NotNull OrderRootType orderRootType) {
        if (url == null) {
            ExistingLibraryEditor.$$$reportNull$$$0(24);
        }
        if (orderRootType == null) {
            ExistingLibraryEditor.$$$reportNull$$$0(25);
        }
        if (this.myModel != null) {
            return this.myModel.isValid(url, orderRootType);
        }
        return this.myLibrary.isValid(url, orderRootType);
    }

    @Override
    public Collection<OrderRootType> getOrderRootTypes() {
        return Arrays.asList(OrderRootType.getAllTypes());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 5: 
            case 11: 
            case 13: 
            case 16: 
            case 18: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/ExistingLibraryEditor";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderRootType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/libraryEditor/ExistingLibraryEditor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedRootUrls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setType";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getUrls";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFiles";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addRoot";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addExcludedRoot";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addJarDirectory";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "removeRoot";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "removeExcludedRoot";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isJarDirectory";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isValid";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

