/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.playback.commands;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.TypeCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TimedOutCallback;
import com.intellij.openapi.util.registry.Registry;
import java.awt.AWTKeyStroke;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class ActionCommand
extends TypeCommand {
    public static final String PREFIX = "%action";

    public ActionCommand(String text2, int line) {
        super(text2, line, true);
    }

    @Override
    protected ActionCallback _execute(final PlaybackContext context) {
        String actionName = this.getText().substring(PREFIX.length()).trim();
        ActionManager am = ActionManager.getInstance();
        AnAction targetAction = am.getAction(actionName);
        if (targetAction == null) {
            this.dumpError(context, "Unknown action: " + actionName);
            return ActionCallback.REJECTED;
        }
        if (!context.isUseDirectActionCall()) {
            Shortcut[] sc = KeymapUtil.getActiveKeymapShortcuts((String)actionName).getShortcuts();
            KeyStroke stroke = null;
            for (Shortcut each : sc) {
                if (!(each instanceof KeyboardShortcut)) continue;
                KeyboardShortcut ks = (KeyboardShortcut)each;
                KeyStroke first = ks.getFirstKeyStroke();
                KeyStroke second = ks.getSecondKeyStroke();
                if (second != null) continue;
                stroke = KeyStroke.getKeyStroke(first.getKeyCode(), first.getModifiers(), false);
                break;
            }
            if (stroke != null) {
                TimedOutCallback result2 = new TimedOutCallback(Registry.intValue((String)"actionSystem.commandProcessingTimeout"), "Timed out calling action id=" + actionName, new Throwable(), true){

                    protected void dumpError() {
                        context.error(this.getMessage(), ActionCommand.this.getLine());
                    }
                };
                context.message("Invoking action via shortcut: " + stroke.toString(), this.getLine());
                KeyStroke finalStroke = stroke;
                ActionCommand.inWriteSafeContext(() -> this.lambda$_execute$1(context, am, targetAction, actionName, (ActionCallback)result2, finalStroke));
                return result2;
            }
        }
        InputEvent input = ActionCommand.getInputEvent(actionName);
        ActionCallback result3 = new ActionCallback();
        context.getRobot().delay(Registry.intValue((String)"actionSystem.playback.delay"));
        ApplicationManager.getApplication().invokeLater(() -> am.tryToExecute(targetAction, input, null, null, false).doWhenProcessed(result3.createSetDoneRunnable()), ModalityState.any());
        return result3;
    }

    public static InputEvent getInputEvent(String actionName) {
        Shortcut[] shortcuts = KeymapUtil.getActiveKeymapShortcuts((String)actionName).getShortcuts();
        AWTKeyStroke keyStroke = null;
        for (Shortcut each : shortcuts) {
            if (!(each instanceof KeyboardShortcut)) continue;
            keyStroke = ((KeyboardShortcut)each).getFirstKeyStroke();
            break;
        }
        if (keyStroke != null) {
            return new KeyEvent(JOptionPane.getRootFrame(), 401, System.currentTimeMillis(), keyStroke.getModifiers(), keyStroke.getKeyCode(), keyStroke.getKeyChar(), 1);
        }
        return new MouseEvent(JOptionPane.getRootFrame(), 501, 0L, 0, 0, 0, 1, false, 1);
    }

    private /* synthetic */ void lambda$_execute$1(final PlaybackContext context, final ActionManager am, final AnAction targetAction, final String actionName, final ActionCallback result2, KeyStroke finalStroke) {
        final Ref listener2 = new Ref();
        listener2.set((Object)new AnActionListener.Adapter(){

            public void beforeActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (context.isDisposed()) {
                        am.removeAnActionListener((AnActionListener)listener2.get());
                        return;
                    }
                    if (targetAction.equals(action)) {
                        context.message("Performed action: " + actionName, context.getCurrentLine());
                        am.removeAnActionListener((AnActionListener)listener2.get());
                        result2.setDone();
                    }
                }, ModalityState.any());
            }
        });
        am.addAnActionListener((AnActionListener)listener2.get());
        context.runPooledThread(() -> this.type(context.getRobot(), finalStroke));
    }
}

