/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.playback.commands;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ReflectionUtil;
import java.awt.AWTKeyStroke;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.KeyStroke;

public class KeyStrokeMap {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.debugger.extensions.playback.KeyStokeMap");
    private Map<Character, KeyStroke> myMap;

    public KeyStroke get(char c) {
        Character mappedChar = new Character(c);
        if (this.getMap().containsKey(mappedChar)) {
            return this.getMap().get(mappedChar);
        }
        return KeyStroke.getKeyStroke(c);
    }

    public boolean containsChar(char c) {
        return this.getMap().containsKey(Character.valueOf(c));
    }

    public KeyStroke get(String strokeText) {
        boolean haveSymbol;
        String s = strokeText.trim();
        assert (s.length() > 0);
        String lowerCaseS = s.toLowerCase();
        boolean hasModifiers = lowerCaseS.contains("shift") || lowerCaseS.contains("control") || lowerCaseS.contains("alt") || lowerCaseS.contains("meta");
        String symbol = null;
        int beforeSymbol = -1;
        AWTKeyStroke symbolStroke = null;
        if (hasModifiers) {
            beforeSymbol = s.lastIndexOf(" ");
            haveSymbol = beforeSymbol > 0;
        } else {
            symbol = s;
            haveSymbol = true;
        }
        int modifiers = 0;
        if (haveSymbol) {
            if (symbol == null) {
                symbol = s.substring(beforeSymbol + 1);
            }
            if (symbol.length() > 1) {
                Integer code2 = (Integer)ReflectionUtil.getStaticFieldValue(KeyEvent.class, Integer.TYPE, (String)("VK_" + StringUtil.toUpperCase((String)symbol)));
                if (code2 == null) {
                    return KeyStrokeMap.throwUnrecognized(symbol);
                }
                symbolStroke = KeyStroke.getKeyStroke(code2, 0);
            }
            String modifierPlusA = s.substring(0, s.length() - (s.length() - beforeSymbol - 1)) + "A";
            KeyStroke modifierPlusAStroke = KeyStroke.getKeyStroke(modifierPlusA);
            if (symbolStroke == null) {
                symbol = String.valueOf(symbol.charAt(0));
                symbolStroke = this.get(symbol.charAt(0));
            }
            modifiers = modifierPlusAStroke.getModifiers();
            if ((symbolStroke.getModifiers() & 1) > 0) {
                modifiers |= 1;
            }
        }
        if (symbolStroke == null || symbolStroke.getKeyCode() == 0) {
            return KeyStrokeMap.throwUnrecognized(symbol);
        }
        return KeyStroke.getKeyStroke(symbolStroke.getKeyCode(), modifiers, false);
    }

    private static KeyStroke throwUnrecognized(String symbol) {
        throw new IllegalArgumentException("Unrecoginzed symbol: " + symbol);
    }

    private static Map<Character, KeyStroke> generateKeyStrokeMappings() {
        int i;
        KeyStroke stroke;
        LOG.debug("Generating default keystroke mappings");
        int shift = 1;
        int ctrl = 2;
        int[][] universalMappings = new int[][]{{27, 27, 0}, {8, 8, 0}, {127, 127, 0}, {10, 10, 0}, {13, 10, 0}};
        int[][] mappings = new int[][]{{32, 32, 0}, {9, 9, 0}, {126, 192, shift}, {96, 192, 0}, {33, 49, shift}, {64, 50, shift}, {35, 51, shift}, {36, 52, shift}, {37, 53, shift}, {94, 54, shift}, {38, 55, shift}, {42, 56, shift}, {40, 57, shift}, {41, 48, shift}, {45, 45, 0}, {95, 45, shift}, {61, 61, 0}, {43, 61, shift}, {91, 91, 0}, {123, 91, shift}, {93, 93, 0}, {125, 93, shift}, {124, 92, shift}, {59, 59, 0}, {58, 59, shift}, {44, 44, 0}, {60, 44, shift}, {46, 46, 0}, {62, 46, shift}, {47, 47, 0}, {63, 47, shift}, {92, 92, 0}, {124, 92, shift}, {39, 222, 0}, {34, 222, shift}};
        HashMap<Character, KeyStroke> map = new HashMap<Character, KeyStroke>();
        for (int[] entry : universalMappings) {
            stroke = KeyStroke.getKeyStroke(entry[1], entry[2]);
            map.put(new Character((char)entry[0]), stroke);
        }
        for (int[] entry : mappings) {
            stroke = KeyStroke.getKeyStroke(entry[1], entry[2]);
            map.put(new Character((char)entry[0]), stroke);
        }
        for (i = 97; i <= 122; ++i) {
            KeyStroke stroke2 = KeyStroke.getKeyStroke(65 + i - 97, 0);
            map.put(new Character((char)i), stroke2);
            stroke2 = KeyStroke.getKeyStroke(65 + i - 97, ctrl);
            Character key2 = new Character((char)(i - 97 + 1));
            map.putIfAbsent(key2, stroke2);
        }
        for (i = 65; i <= 90; ++i) {
            KeyStroke stroke3 = KeyStroke.getKeyStroke(65 + i - 65, shift);
            map.put(new Character((char)i), stroke3);
        }
        for (i = 48; i <= 57; ++i) {
            KeyStroke stroke4 = KeyStroke.getKeyStroke(48 + i - 48, 0);
            map.put(new Character((char)i), stroke4);
        }
        return map;
    }

    private Map<Character, KeyStroke> getMap() {
        if (this.myMap == null) {
            this.myMap = KeyStrokeMap.generateKeyStrokeMappings();
        }
        return this.myMap;
    }
}

