/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.util.PathUtil;
import java.io.File;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class FilePathImpl
implements FilePath {
    @NotNull
    private final String myPath;
    private final boolean myIsDirectory;

    public FilePathImpl(@NotNull String path, boolean isDirectory) {
        if (path == null) {
            FilePathImpl.$$$reportNull$$$0(0);
        }
        this.myPath = FileUtil.toCanonicalPath((String)path);
        this.myIsDirectory = isDirectory;
    }

    @Deprecated
    public FilePathImpl(@NotNull VirtualFile file2) {
        if (file2 == null) {
            FilePathImpl.$$$reportNull$$$0(1);
        }
        this(file2.getPath(), file2.isDirectory());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilePathImpl path = (FilePathImpl)o;
        if (this.myIsDirectory != path.myIsDirectory) {
            return false;
        }
        return FileUtil.PATH_HASHING_STRATEGY.equals((Object)this.myPath, (Object)path.myPath);
    }

    public int hashCode() {
        int result2 = FileUtil.PATH_HASHING_STRATEGY.computeHashCode((Object)this.myPath);
        result2 = 31 * result2 + (this.myIsDirectory ? 1 : 0);
        return result2;
    }

    public void refresh() {
    }

    public void hardRefresh() {
        LocalFileSystem.getInstance().refreshAndFindFileByPath(this.myPath);
    }

    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            FilePathImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isDirectory() {
        return this.myIsDirectory;
    }

    public boolean isUnder(@NotNull FilePath parent, boolean strict) {
        if (parent == null) {
            FilePathImpl.$$$reportNull$$$0(3);
        }
        return FileUtil.isAncestor((String)parent.getPath(), (String)this.getPath(), (boolean)strict);
    }

    @Nullable
    public FilePath getParentPath() {
        String parent = PathUtil.getParentPath((String)this.myPath);
        return parent.isEmpty() ? null : new FilePathImpl(parent, true);
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return LocalFileSystem.getInstance().findFileByPath(this.myPath);
    }

    @Nullable
    public VirtualFile getVirtualFileParent() {
        FilePath parent = this.getParentPath();
        return parent != null ? parent.getVirtualFile() : null;
    }

    @NotNull
    public File getIOFile() {
        File file2 = new File(this.myPath);
        if (file2 == null) {
            FilePathImpl.$$$reportNull$$$0(4);
        }
        return file2;
    }

    @NotNull
    public String getName() {
        String string = PathUtil.getFileName((String)this.myPath);
        if (string == null) {
            FilePathImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getPresentableUrl() {
        String string = FileUtil.toSystemDependentName((String)this.myPath);
        if (string == null) {
            FilePathImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public Document getDocument() {
        VirtualFile file2 = this.getVirtualFile();
        if (file2 == null || file2.getFileType().isBinary()) {
            return null;
        }
        return FileDocumentManager.getInstance().getDocument(file2);
    }

    @NotNull
    public Charset getCharset() {
        Charset charset = this.getCharset(null);
        if (charset == null) {
            FilePathImpl.$$$reportNull$$$0(7);
        }
        return charset;
    }

    @NotNull
    public Charset getCharset(@Nullable Project project2) {
        VirtualFile file2 = this.getVirtualFile();
        String path = this.myPath;
        while (!(file2 != null && file2.isValid() || path.isEmpty())) {
            path = PathUtil.getParentPath((String)path);
            file2 = LocalFileSystem.getInstance().findFileByPath(path);
        }
        if (file2 != null) {
            Charset charset = file2.getCharset();
            if (charset == null) {
                FilePathImpl.$$$reportNull$$$0(8);
            }
            return charset;
        }
        EncodingManager e = project2 == null ? EncodingManager.getInstance() : EncodingProjectManager.getInstance((Project)project2);
        Charset charset = e.getDefaultCharset();
        if (charset == null) {
            FilePathImpl.$$$reportNull$$$0(9);
        }
        return charset;
    }

    @NotNull
    public FileType getFileType() {
        VirtualFile file2 = this.getVirtualFile();
        FileTypeManager manager = FileTypeManager.getInstance();
        FileType fileType = file2 != null ? manager.getFileTypeByFile(file2) : manager.getFileTypeByFileName(this.getName());
        if (fileType == null) {
            FilePathImpl.$$$reportNull$$$0(10);
        }
        return fileType;
    }

    @NonNls
    public String toString() {
        return this.myPath + (this.myIsDirectory ? "/" : "");
    }

    public boolean isNonLocal() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/FilePathImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/FilePathImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIOFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableUrl";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCharset";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isUnder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

