/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RepositoryLocationCache {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<Couple<String>, RepositoryLocation> myMap;

    public RepositoryLocationCache(@NotNull Project project2) {
        if (project2 == null) {
            RepositoryLocationCache.$$$reportNull$$$0(0);
        }
        this.myMap = Collections.synchronizedMap(ContainerUtil.newHashMap());
        this.myProject = project2;
        MessageBusConnection connection = this.myProject.getMessageBus().connect();
        VcsListener listener2 = () -> this.reset();
        connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)listener2);
        connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED_IN_PLUGIN, (Object)listener2);
    }

    @Nullable
    public RepositoryLocation getLocation(@NotNull AbstractVcs vcs, @NotNull FilePath filePath, boolean silent) {
        Couple key2;
        RepositoryLocation location;
        if (vcs == null) {
            RepositoryLocationCache.$$$reportNull$$$0(1);
        }
        if (filePath == null) {
            RepositoryLocationCache.$$$reportNull$$$0(2);
        }
        if ((location = this.myMap.get(key2 = Couple.of((Object)vcs.getName(), (Object)filePath.getPath()))) == null) {
            location = this.getLocationUnderProgress(vcs, filePath, silent);
            this.myMap.put((Couple<String>)key2, location);
        }
        return location;
    }

    @Nullable
    private RepositoryLocation getLocationUnderProgress(@NotNull AbstractVcs vcs, @NotNull FilePath filePath, boolean silent) {
        if (vcs == null) {
            RepositoryLocationCache.$$$reportNull$$$0(3);
        }
        if (filePath == null) {
            RepositoryLocationCache.$$$reportNull$$$0(4);
        }
        ThrowableComputable result2 = () -> {
            CommittedChangesProvider committedChangesProvider;
            if (vcs == null) {
                RepositoryLocationCache.$$$reportNull$$$0(5);
            }
            if (filePath == null) {
                RepositoryLocationCache.$$$reportNull$$$0(6);
            }
            return (committedChangesProvider = vcs.getCommittedChangesProvider()) != null ? committedChangesProvider.getLocationFor(filePath) : null;
        };
        return !silent && ApplicationManager.getApplication().isDispatchThread() ? (RepositoryLocation)ProgressManager.getInstance().runProcessWithProgressSynchronously(result2, "Discovering location of " + filePath.getPresentableUrl(), true, this.myProject) : (RepositoryLocation)result2.compute();
    }

    public void reset() {
        this.myMap.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/committed/RepositoryLocationCache";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getLocation";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getLocationUnderProgress";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getLocationUnderProgress$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

