/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.patch.PatchNameChecker;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.charset.Charset;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreatePatchConfigurationPanel {
    private static final int TEXT_FIELD_WIDTH = 70;
    private JPanel myMainPanel;
    private TextFieldWithBrowseButton myFileNameField;
    private TextFieldWithBrowseButton myBasePathField;
    private JCheckBox myReversePatchCheckbox;
    private ComboBox<Charset> myEncoding;
    private JLabel myWarningLabel;
    private final Project myProject;
    @Nullable
    private File myCommonParentDir;
    private JBRadioButton myToClipboardButton;
    private JBRadioButton myToFileButton;

    public CreatePatchConfigurationPanel(final @NotNull Project project2) {
        if (project2 == null) {
            CreatePatchConfigurationPanel.$$$reportNull$$$0(0);
        }
        this.myProject = project2;
        this.initMainPanel();
        this.myFileNameField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String name2;
                FileSaverDialog dialog2 = FileChooserFactory.getInstance().createSaveFileDialog(new FileSaverDescriptor("Save Patch to", "", new String[0]), (Component)CreatePatchConfigurationPanel.this.myMainPanel);
                String path = FileUtil.toSystemIndependentName((String)CreatePatchConfigurationPanel.this.getFileName());
                int idx = path.lastIndexOf("/");
                VirtualFile baseDir = idx == -1 ? project2.getBaseDir() : LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(path.substring(0, idx)));
                VirtualFileWrapper fileWrapper = dialog2.save(baseDir = baseDir == null ? project2.getBaseDir() : baseDir, name2 = idx == -1 ? path : path.substring(idx + 1));
                if (fileWrapper != null) {
                    CreatePatchConfigurationPanel.this.myFileNameField.setText(fileWrapper.getFile().getPath());
                }
            }
        });
        this.myToFileButton.addChangeListener(e -> this.myFileNameField.setEnabled(this.myToFileButton.isSelected()));
        this.myFileNameField.setTextFieldPreferredWidth(70);
        this.myBasePathField.setTextFieldPreferredWidth(70);
        this.myBasePathField.addBrowseFolderListener(new TextBrowseFolderListener(FileChooserDescriptorFactory.createSingleFolderDescriptor()));
        this.myWarningLabel.setForeground((Color)JBColor.RED);
        this.selectBasePath((VirtualFile)ObjectUtils.assertNotNull((Object)this.myProject.getBaseDir()));
        this.initEncodingCombo();
    }

    public void selectBasePath(@NotNull VirtualFile baseDir) {
        if (baseDir == null) {
            CreatePatchConfigurationPanel.$$$reportNull$$$0(1);
        }
        this.myBasePathField.setText(baseDir.getPresentableUrl());
    }

    private void initEncodingCombo() {
        DefaultComboBoxModel<Charset> encodingsModel = new DefaultComboBoxModel<Charset>(CharsetToolkit.getAvailableCharsets());
        this.myEncoding.setModel(encodingsModel);
        Charset projectCharset = EncodingProjectManager.getInstance((Project)this.myProject).getDefaultCharset();
        this.myEncoding.setSelectedItem((Object)projectCharset);
    }

    @NotNull
    public Charset getEncoding() {
        Charset charset = (Charset)this.myEncoding.getSelectedItem();
        if (charset == null) {
            CreatePatchConfigurationPanel.$$$reportNull$$$0(2);
        }
        return charset;
    }

    private void initMainPanel() {
        this.myFileNameField = new TextFieldWithBrowseButton();
        this.myBasePathField = new TextFieldWithBrowseButton();
        this.myReversePatchCheckbox = new JCheckBox(VcsBundle.message((String)"create.patch.reverse.checkbox", (Object[])new Object[0]));
        this.myEncoding = new ComboBox();
        this.myWarningLabel = new JLabel();
        this.myToFileButton = new JBRadioButton(VcsBundle.message((String)"create.patch.file.path", (Object[])new Object[0]), true);
        if (UIUtil.isUnderWin10LookAndFeel()) {
            this.myToFileButton.setBorder((Border)JBUI.Borders.emptyRight((int)10));
        }
        this.myToClipboardButton = new JBRadioButton(VcsBundle.message((String)"create.patch.to.clipboard", (Object[])new Object[0]));
        ButtonGroup group = new ButtonGroup();
        group.add((AbstractButton)this.myToFileButton);
        group.add((AbstractButton)this.myToClipboardButton);
        BorderLayoutPanel toFilePanel = JBUI.Panels.simplePanel().addToLeft((Component)this.myToFileButton).addToCenter((Component)this.myFileNameField);
        this.myMainPanel = FormBuilder.createFormBuilder().addComponent((JComponent)toFilePanel).addComponent((JComponent)this.myToClipboardButton).addVerticalGap(5).addLabeledComponent("&Base path:", (JComponent)this.myBasePathField).addComponent((JComponent)this.myReversePatchCheckbox).addLabeledComponent(VcsBundle.message((String)"create.patch.encoding", (Object[])new Object[0]), this.myEncoding).addComponent((JComponent)this.myWarningLabel).getPanel();
    }

    public void setCommonParentPath(@Nullable File commonParentPath) {
        this.myCommonParentDir = commonParentPath == null || commonParentPath.isDirectory() ? commonParentPath : commonParentPath.getParentFile();
    }

    private void checkExist() {
        this.myWarningLabel.setText(new File(this.getFileName()).exists() ? "File with the same name already exists" : "");
    }

    public JComponent getPanel() {
        return this.myMainPanel;
    }

    public String getFileName() {
        return FileUtil.expandUserHome((String)this.myFileNameField.getText().trim());
    }

    @NotNull
    public String getBaseDirName() {
        String string = FileUtil.expandUserHome((String)this.myBasePathField.getText().trim());
        if (string == null) {
            CreatePatchConfigurationPanel.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void setFileName(File file2) {
        this.myFileNameField.setText(file2.getPath());
    }

    public boolean isReversePatch() {
        return this.myReversePatchCheckbox.isSelected();
    }

    public void setReversePatch(boolean reverse) {
        this.myReversePatchCheckbox.setSelected(reverse);
    }

    public boolean isToClipboard() {
        return this.myToClipboardButton.isSelected();
    }

    public void setToClipboard(boolean toClipboard) {
        this.myToClipboardButton.setSelected(toClipboard);
    }

    public boolean isOkToExecute() {
        return this.validateFields() == null;
    }

    @Nullable
    private ValidationInfo verifyBaseDirPath() {
        String baseDirName = this.getBaseDirName();
        if (StringUtil.isEmptyOrSpaces((String)baseDirName)) {
            return new ValidationInfo("Base path can't be empty!", (JComponent)this.myBasePathField);
        }
        File baseFile = new File(baseDirName);
        if (!baseFile.exists()) {
            return new ValidationInfo("Base dir doesn't exist", (JComponent)this.myBasePathField);
        }
        if (this.myCommonParentDir != null && !FileUtil.isAncestor((File)baseFile, (File)this.myCommonParentDir, (boolean)false)) {
            return new ValidationInfo(String.format("Base path doesn't contain all selected changes (use %s)", this.myCommonParentDir.getPath()), (JComponent)this.myBasePathField);
        }
        return null;
    }

    @Nullable
    public ValidationInfo validateFields() {
        this.checkExist();
        String validateNameError = PatchNameChecker.validateName(this.getFileName());
        if (validateNameError != null) {
            return new ValidationInfo(validateNameError, (JComponent)this.myFileNameField);
        }
        return this.verifyBaseDirPath();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/CreatePatchConfigurationPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/CreatePatchConfigurationPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEncoding";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseDirName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "selectBasePath";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

