/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vcs.VcsBundle;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RelativePathCalculator {
    private final int ourNumOfAllowedStepsAbove = 1;
    private static final int ourAllowedStepsDown = 2;
    private final String myShifted;
    private final String myBase;
    private String myResult;
    private boolean myRename;

    public RelativePathCalculator(String base, String shifted) {
        this.myShifted = shifted;
        this.myBase = base;
    }

    private static boolean stringEqual(@NotNull String s1, @NotNull String s2) {
        if (s1 == null) {
            RelativePathCalculator.$$$reportNull$$$0(0);
        }
        if (s2 == null) {
            RelativePathCalculator.$$$reportNull$$$0(1);
        }
        if (!SystemInfo.isFileSystemCaseSensitive) {
            return s1.equalsIgnoreCase(s2);
        }
        return s1.equals(s2);
    }

    public void execute() {
        int i;
        if (this.myShifted == null || this.myBase == null) {
            this.myResult = null;
            return;
        }
        if (RelativePathCalculator.stringEqual(this.myShifted, this.myBase)) {
            this.myResult = ".";
            this.myRename = false;
            return;
        }
        String[] baseParts = RelativePathCalculator.split(this.myBase);
        String[] shiftedParts = RelativePathCalculator.split(this.myShifted);
        this.myRename = this.checkRename(baseParts, shiftedParts);
        int cnt = 0;
        while (true) {
            if (baseParts.length <= cnt || shiftedParts.length <= cnt) {
                return;
            }
            if (!RelativePathCalculator.stringEqual(baseParts[cnt], shiftedParts[cnt])) break;
            ++cnt;
        }
        int stepsUp = baseParts.length - cnt - 1;
        if (!this.myRename && stepsUp > 1 && shiftedParts.length - cnt <= 2) {
            this.myResult = this.myShifted;
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < stepsUp; ++i) {
            sb.append("../");
        }
        for (i = cnt; i < shiftedParts.length - 1; ++i) {
            String shiftedPart = shiftedParts[i];
            sb.append(shiftedPart);
            sb.append('/');
        }
        String oldName = baseParts[baseParts.length - 1];
        String newName = shiftedParts[shiftedParts.length - 1];
        boolean skipFileName = oldName.equals(newName);
        if (!skipFileName) {
            sb.append(newName);
        }
        this.myResult = sb.toString();
    }

    public boolean isRename() {
        return this.myRename;
    }

    private boolean checkRename(String[] baseParts, String[] shiftedParts) {
        if (baseParts.length == shiftedParts.length) {
            for (int i = 0; i < baseParts.length; ++i) {
                if (RelativePathCalculator.stringEqual(baseParts[i], shiftedParts[i])) continue;
                return i == baseParts.length - 1;
            }
        }
        return false;
    }

    public String getResult() {
        return this.myResult;
    }

    @Nullable
    public static String getMovedString(String beforeName, String afterName) {
        if (beforeName != null && afterName != null && !RelativePathCalculator.stringEqual(beforeName, afterName)) {
            RelativePathCalculator calculator = new RelativePathCalculator(beforeName, afterName);
            calculator.execute();
            String key2 = calculator.isRename() ? "change.file.renamed.to.text" : "change.file.moved.to.text";
            return VcsBundle.message((String)key2, (Object[])new Object[]{calculator.getResult()});
        }
        return null;
    }

    public static String[] split(String s) {
        return s.replace(File.separatorChar, '/').split("/");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "s1";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "s2";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/vcs/changes/patch/RelativePathCalculator";
        objectArray[2] = "stringEqual";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

