/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.SpellCheckingEditorCustomizationProvider;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.EditChangelistSupport;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EditorTextFieldProvider;
import com.intellij.ui.HorizontalScrollBarEditorCustomization;
import com.intellij.ui.OneLineEditorCustomization;
import com.intellij.ui.SoftWrapsEditorCustomization;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jetbrains.annotations.NotNull;

public abstract class NewEditChangelistPanel
extends JPanel {
    protected final EditorTextField myNameTextField;
    protected final EditorTextField myDescriptionTextArea;
    private final JPanel myAdditionalControlsPanel;
    private final JCheckBox myMakeActiveCheckBox;
    private Consumer<LocalChangeList> myConsumer;
    protected final Project myProject;

    public NewEditChangelistPanel(Project project2) {
        super(new GridBagLayout());
        this.myProject = project2;
        GridBagConstraints gb = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, (Insets)JBUI.insets((int)1), 0, 0);
        JLabel nameLabel = new JLabel(VcsBundle.message((String)"edit.changelist.name", (Object[])new Object[0]));
        this.add((Component)nameLabel, gb);
        ++gb.gridx;
        gb.fill = 2;
        gb.weightx = 1.0;
        ComponentWithTextFieldWrapper componentWithTextField = this.createComponentWithTextField(project2);
        this.myNameTextField = componentWithTextField.getEditorTextField();
        this.myNameTextField.setOneLineMode(true);
        String generateUniqueName = UniqueNameGenerator.generateUniqueName((String)"New changelist", (String)"", (String)"", (String)" (", (String)")", s -> ChangeListManager.getInstance((Project)this.myProject).findChangeList(s) == null);
        this.myNameTextField.setText(generateUniqueName);
        this.myNameTextField.selectAll();
        this.add(componentWithTextField.myComponent, gb);
        nameLabel.setLabelFor((Component)((Object)this.myNameTextField));
        ++gb.gridy;
        gb.gridx = 0;
        gb.weightx = 0.0;
        gb.fill = 0;
        gb.anchor = 18;
        JLabel commentLabel = new JLabel(VcsBundle.message((String)"edit.changelist.description", (Object[])new Object[0]));
        UIUtil.addInsets((JComponent)commentLabel, (Insets)JBUI.insetsRight((int)4));
        this.add((Component)commentLabel, gb);
        ++gb.gridx;
        gb.weightx = 1.0;
        gb.weighty = 1.0;
        gb.fill = 1;
        gb.insets = JBUI.insetsTop((int)2);
        this.myDescriptionTextArea = NewEditChangelistPanel.createEditorField(project2, 4);
        this.myDescriptionTextArea.setOneLineMode(false);
        this.add((Component)((Object)this.myDescriptionTextArea), gb);
        commentLabel.setLabelFor((Component)((Object)this.myDescriptionTextArea));
        gb.insets = JBUI.insetsTop((int)0);
        ++gb.gridy;
        gb.gridx = 0;
        gb.gridwidth = 2;
        gb.weighty = 0.0;
        this.myAdditionalControlsPanel = new JPanel();
        BoxLayout layout = new BoxLayout(this.myAdditionalControlsPanel, 0);
        this.myAdditionalControlsPanel.setLayout(layout);
        this.myMakeActiveCheckBox = new JCheckBox(VcsBundle.message((String)"new.changelist.make.active.checkbox", (Object[])new Object[0]));
        this.myMakeActiveCheckBox.setBorder((Border)JBUI.Borders.emptyRight((int)4));
        this.myAdditionalControlsPanel.add(this.myMakeActiveCheckBox);
        this.add((Component)this.myAdditionalControlsPanel, gb);
    }

    public JCheckBox getMakeActiveCheckBox() {
        return this.myMakeActiveCheckBox;
    }

    public void init(final LocalChangeList initial) {
        this.myMakeActiveCheckBox.setSelected(VcsConfiguration.getInstance((Project)this.myProject).MAKE_NEW_CHANGELIST_ACTIVE);
        for (EditChangelistSupport support : (EditChangelistSupport[])Extensions.getExtensions(EditChangelistSupport.EP_NAME, (AreaInstance)this.myProject)) {
            support.installSearch(this.myNameTextField, this.myDescriptionTextArea);
            this.myConsumer = support.addControls(this.myAdditionalControlsPanel, initial);
        }
        this.myNameTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent event) {
                NewEditChangelistPanel.this.nameChangedImpl(NewEditChangelistPanel.this.myProject, initial);
            }
        });
        this.nameChangedImpl(this.myProject, initial);
    }

    protected void nameChangedImpl(Project project2, LocalChangeList initial) {
        String name2 = this.getChangeListName();
        if (name2 == null || name2.trim().length() == 0) {
            this.nameChanged("Cannot create new changelist with empty name.");
        } else if (!(initial != null && name2.equals(initial.getName()) || ChangeListManager.getInstance((Project)project2).findChangeList(name2) == null)) {
            this.nameChanged(VcsBundle.message((String)"new.changelist.duplicate.name.error", (Object[])new Object[0]));
        } else {
            this.nameChanged(null);
        }
    }

    public void changelistCreatedOrChanged(LocalChangeList list2) {
        if (this.myConsumer != null) {
            this.myConsumer.consume((Object)list2);
        }
    }

    public void setChangeListName(String s) {
        this.myNameTextField.setText(s);
    }

    public String getChangeListName() {
        return this.myNameTextField.getText();
    }

    public void setDescription(String s) {
        this.myDescriptionTextArea.setText(s);
    }

    public String getDescription() {
        return this.myDescriptionTextArea.getText();
    }

    public JComponent getContent() {
        return this;
    }

    @Override
    public void requestFocus() {
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)((Object)this.myNameTextField), true));
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameTextField;
    }

    protected abstract void nameChanged(String var1);

    protected ComponentWithTextFieldWrapper createComponentWithTextField(Project project2) {
        final EditorTextField editorTextField = NewEditChangelistPanel.createEditorField(project2, 1);
        return new ComponentWithTextFieldWrapper((Component)((Object)editorTextField)){

            @Override
            @NotNull
            public EditorTextField getEditorTextField() {
                EditorTextField editorTextField2 = editorTextField;
                if (editorTextField2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return editorTextField2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/ui/NewEditChangelistPanel$2", "getEditorTextField"));
            }
        };
    }

    private static EditorTextField createEditorField(Project project2, int defaultLines) {
        EditorTextFieldProvider service = (EditorTextFieldProvider)ServiceManager.getService((Project)project2, EditorTextFieldProvider.class);
        HashSet editorFeatures = ContainerUtil.newHashSet();
        ContainerUtil.addIfNotNull((Collection)editorFeatures, (Object)SpellCheckingEditorCustomizationProvider.getInstance().getEnabledCustomization());
        double scaleFactor = 1.3;
        if (defaultLines == 1) {
            editorFeatures.add(HorizontalScrollBarEditorCustomization.DISABLED);
            editorFeatures.add(OneLineEditorCustomization.ENABLED);
        } else {
            editorFeatures.add(SoftWrapsEditorCustomization.ENABLED);
            scaleFactor = 2.1;
        }
        EditorTextField editorField = service.getEditorField(FileTypes.PLAIN_TEXT.getLanguage(), project2, editorFeatures);
        int height = editorField.getFontMetrics(editorField.getFont()).getHeight();
        editorField.getComponent().setMinimumSize(new Dimension(100, (int)((double)height * scaleFactor)));
        editorField.addSettingsProvider(editor -> editor.getContentComponent().setBorder(new CompoundBorder(editor.getContentComponent().getBorder(), (Border)JBUI.Borders.emptyLeft((int)2))));
        return editorField;
    }

    protected static abstract class ComponentWithTextFieldWrapper {
        @NotNull
        private final Component myComponent;

        public ComponentWithTextFieldWrapper(@NotNull Component component) {
            if (component == null) {
                ComponentWithTextFieldWrapper.$$$reportNull$$$0(0);
            }
            this.myComponent = component;
        }

        @NotNull
        abstract EditorTextField getEditorTextField();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/vcs/changes/ui/NewEditChangelistPanel$ComponentWithTextFieldWrapper", "<init>"));
        }
    }
}

