/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.checkin;

import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.OutOfSourcesChecker;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import org.jetbrains.annotations.NotNull;

public class CheckinHandlerUtil {
    public static List<VirtualFile> filterOutGeneratedAndExcludedFiles(@NotNull Collection<VirtualFile> files, @NotNull Project project2) {
        if (files == null) {
            CheckinHandlerUtil.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            CheckinHandlerUtil.$$$reportNull$$$0(1);
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project2);
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>(files.size());
        for (VirtualFile file2 : files) {
            if (fileIndex.isExcluded(file2) || GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)file2, (Project)project2)) continue;
            result2.add(file2);
        }
        return result2;
    }

    public static PsiFile[] getPsiFiles(Project project2, Collection<VirtualFile> selectedFiles) {
        ArrayList<PsiFile> result2 = new ArrayList<PsiFile>();
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        IProjectStore projectStore = ProjectKt.getStateStore(project2);
        for (VirtualFile file2 : selectedFiles) {
            PsiFile psiFile;
            if (!file2.isValid() || projectStore.isProjectFile(file2) || !CheckinHandlerUtil.isFileUnderSourceRoot(project2, file2) || CheckinHandlerUtil.isOutOfSources(project2, file2) || (psiFile = psiManager.findFile(file2)) == null) continue;
            result2.add(psiFile);
        }
        return PsiUtilCore.toPsiFileArray(result2);
    }

    private static boolean isFileUnderSourceRoot(@NotNull Project project2, @NotNull VirtualFile file2) {
        ProjectFileIndex index;
        if (project2 == null) {
            CheckinHandlerUtil.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            CheckinHandlerUtil.$$$reportNull$$$0(3);
        }
        return (index = ProjectRootManager.getInstance((Project)project2).getFileIndex()).isInContent(file2) && !index.isInLibrarySource(file2);
    }

    private static boolean isOutOfSources(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            CheckinHandlerUtil.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            CheckinHandlerUtil.$$$reportNull$$$0(5);
        }
        for (OutOfSourcesChecker checker : (OutOfSourcesChecker[])OutOfSourcesChecker.EP_NAME.getExtensions()) {
            if (checker.getFileType() != file2.getFileType() || !checker.isOutOfSources(project2, file2)) continue;
            return true;
        }
        return false;
    }

    static void disableWhenDumb(@NotNull Project project2, @NotNull JCheckBox checkBox, @NotNull String tooltip) {
        boolean dumb;
        if (project2 == null) {
            CheckinHandlerUtil.$$$reportNull$$$0(6);
        }
        if (checkBox == null) {
            CheckinHandlerUtil.$$$reportNull$$$0(7);
        }
        if (tooltip == null) {
            CheckinHandlerUtil.$$$reportNull$$$0(8);
        }
        checkBox.setEnabled(!(dumb = DumbService.isDumb((Project)project2)));
        checkBox.setToolTipText(dumb ? tooltip : "");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkBox";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltip";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/checkin/CheckinHandlerUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "filterOutGeneratedAndExcludedFiles";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isFileUnderSourceRoot";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isOutOfSources";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "disableWhenDumb";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

