/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.IssueNavigationConfiguration;
import com.intellij.openapi.vcs.IssueNavigationLink;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.configurable.IssueLinkConfigurationDialog;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class IssueNavigationConfigurationPanel
extends JPanel
implements SearchableConfigurable,
Configurable.NoScroll {
    private final JBTable myLinkTable;
    private final Project myProject;
    private List<IssueNavigationLink> myLinks;
    private ListTableModel<IssueNavigationLink> myModel;
    private final ColumnInfo<IssueNavigationLink, String> ISSUE_COLUMN = new ColumnInfo<IssueNavigationLink, String>(VcsBundle.message((String)"issue.link.issue.column", (Object[])new Object[0])){

        public String valueOf(IssueNavigationLink issueNavigationLink) {
            return issueNavigationLink.getIssueRegexp();
        }
    };
    private final ColumnInfo<IssueNavigationLink, String> LINK_COLUMN = new ColumnInfo<IssueNavigationLink, String>(VcsBundle.message((String)"issue.link.link.column", (Object[])new Object[0])){

        public String valueOf(IssueNavigationLink issueNavigationLink) {
            return issueNavigationLink.getLinkRegexp();
        }
    };

    public IssueNavigationConfigurationPanel(Project project2) {
        super(new BorderLayout());
        this.myProject = project2;
        this.myLinkTable = new JBTable();
        this.myLinkTable.getEmptyText().setText(VcsBundle.message((String)"issue.link.no.patterns", (Object[])new Object[0]));
        this.reset();
        this.add((Component)new JLabel(XmlStringUtil.wrapInHtml((CharSequence)(ApplicationNamesInfo.getInstance().getFullProductName() + " will search for the specified patterns in checkin comments and link them to issues in your issue tracker:"))), "North");
        this.add((Component)ToolbarDecorator.createDecorator((JTable)this.myLinkTable).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                IssueLinkConfigurationDialog dlg = new IssueLinkConfigurationDialog(IssueNavigationConfigurationPanel.this.myProject);
                dlg.setTitle(VcsBundle.message((String)"issue.link.add.title", (Object[])new Object[0]));
                if (dlg.showAndGet()) {
                    IssueNavigationConfigurationPanel.this.myLinks.add(dlg.getLink());
                    IssueNavigationConfigurationPanel.this.myModel.fireTableDataChanged();
                }
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                if (Messages.showOkCancelDialog((Project)IssueNavigationConfigurationPanel.this.myProject, (String)VcsBundle.message((String)"issue.link.delete.prompt", (Object[])new Object[0]), (String)VcsBundle.message((String)"issue.link.delete.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) == 0) {
                    int selRow = IssueNavigationConfigurationPanel.this.myLinkTable.getSelectedRow();
                    IssueNavigationConfigurationPanel.this.myLinks.remove(selRow);
                    IssueNavigationConfigurationPanel.this.myModel.fireTableDataChanged();
                    if (IssueNavigationConfigurationPanel.this.myLinkTable.getRowCount() > 0) {
                        if (selRow >= IssueNavigationConfigurationPanel.this.myLinkTable.getRowCount()) {
                            --selRow;
                        }
                        IssueNavigationConfigurationPanel.this.myLinkTable.getSelectionModel().setSelectionInterval(selRow, selRow);
                    }
                }
            }
        }).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                IssueNavigationLink link = (IssueNavigationLink)IssueNavigationConfigurationPanel.this.myModel.getItem(IssueNavigationConfigurationPanel.this.myLinkTable.getSelectedRow());
                IssueLinkConfigurationDialog dlg = new IssueLinkConfigurationDialog(IssueNavigationConfigurationPanel.this.myProject);
                dlg.setTitle(VcsBundle.message((String)"issue.link.edit.title", (Object[])new Object[0]));
                dlg.setLink(link);
                if (dlg.showAndGet()) {
                    IssueNavigationLink editedLink = dlg.getLink();
                    link.setIssueRegexp(editedLink.getIssueRegexp());
                    link.setLinkRegexp(editedLink.getLinkRegexp());
                    IssueNavigationConfigurationPanel.this.myModel.fireTableDataChanged();
                }
            }
        }).addExtraAction(new AnActionButton("Add JIRA Pattern", IconUtil.getAddJiraPatternIcon()){

            public void actionPerformed(AnActionEvent e) {
                String s = Messages.showInputDialog((Component)IssueNavigationConfigurationPanel.this, (String)"Enter JIRA installation URL:", (String)"Add JIRA Issue Navigation Pattern", (Icon)Messages.getQuestionIcon());
                if (s == null) {
                    return;
                }
                if (!s.endsWith("/")) {
                    s = s + "/";
                }
                IssueNavigationConfigurationPanel.this.myLinks.add(new IssueNavigationLink("[A-Z]+\\-\\d+", s + "browse/$0"));
                IssueNavigationConfigurationPanel.this.myModel.fireTableDataChanged();
            }
        }).addExtraAction(new AnActionButton("Add YouTrack Pattern", IconUtil.getAddYouTrackPatternIcon()){

            public void actionPerformed(AnActionEvent e) {
                String s = Messages.showInputDialog((Component)IssueNavigationConfigurationPanel.this, (String)"Enter YouTrack installation URL:", (String)"Add YouTrack Issue Navigation Pattern", (Icon)Messages.getQuestionIcon());
                if (s == null) {
                    return;
                }
                if (!s.endsWith("/")) {
                    s = s + "/";
                }
                IssueNavigationConfigurationPanel.this.myLinks.add(new IssueNavigationLink("[A-Z]+\\-\\d+", s + "issue/$0"));
                IssueNavigationConfigurationPanel.this.myModel.fireTableDataChanged();
            }
        }).setButtonComparator(new String[]{"Add", "Add JIRA Pattern", "Add YouTrack Pattern", "Edit", "Remove"}).disableUpDownActions().createPanel(), "Center");
    }

    public void apply() {
        IssueNavigationConfiguration configuration = IssueNavigationConfiguration.getInstance((Project)this.myProject);
        configuration.setLinks(this.myLinks);
    }

    public boolean isModified() {
        IssueNavigationConfiguration configuration = IssueNavigationConfiguration.getInstance((Project)this.myProject);
        return !this.myLinks.equals(configuration.getLinks());
    }

    public void reset() {
        IssueNavigationConfiguration configuration = IssueNavigationConfiguration.getInstance((Project)this.myProject);
        this.myLinks = new ArrayList<IssueNavigationLink>();
        for (IssueNavigationLink link : configuration.getLinks()) {
            this.myLinks.add(new IssueNavigationLink(link.getIssueRegexp(), link.getLinkRegexp()));
        }
        this.myModel = new ListTableModel(new ColumnInfo[]{this.ISSUE_COLUMN, this.LINK_COLUMN}, this.myLinks, 0);
        this.myLinkTable.setModel(this.myModel);
    }

    @Nls
    public String getDisplayName() {
        return "Issue Navigation";
    }

    public String getHelpTopic() {
        return "project.propVCSSupport.Issue.Navigation";
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            IssueNavigationConfigurationPanel.$$$reportNull$$$0(0);
        }
        return string;
    }

    public JComponent createComponent() {
        return this;
    }

    public void disposeUIResources() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/configurable/IssueNavigationConfigurationPanel", "getId"));
    }
}

