/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.comparison.ByLine;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.comparison.TrimUtil;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RangesBuilder {
    private static final Logger LOG = Logger.getInstance(RangesBuilder.class);

    @NotNull
    public static List<Range> createRanges(@NotNull Document current, @NotNull Document vcs) throws FilesTooBigForDiffException {
        if (current == null) {
            RangesBuilder.$$$reportNull$$$0(0);
        }
        if (vcs == null) {
            RangesBuilder.$$$reportNull$$$0(1);
        }
        List<Range> list2 = RangesBuilder.createRanges(current, vcs, false);
        if (list2 == null) {
            RangesBuilder.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @NotNull
    public static List<Range> createRanges(@NotNull Document current, @NotNull Document vcs, boolean innerWhitespaceChanges) throws FilesTooBigForDiffException {
        if (current == null) {
            RangesBuilder.$$$reportNull$$$0(3);
        }
        if (vcs == null) {
            RangesBuilder.$$$reportNull$$$0(4);
        }
        List<Range> list2 = RangesBuilder.createRanges(DiffUtil.getLines(current), DiffUtil.getLines(vcs), 0, 0, innerWhitespaceChanges);
        if (list2 == null) {
            RangesBuilder.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @NotNull
    public static List<Range> createRanges(@NotNull List<String> current, @NotNull List<String> vcs, int currentShift, int vcsShift, boolean innerWhitespaceChanges) throws FilesTooBigForDiffException {
        block7: {
            List<Range> list2;
            if (current == null) {
                RangesBuilder.$$$reportNull$$$0(6);
            }
            if (vcs == null) {
                RangesBuilder.$$$reportNull$$$0(7);
            }
            try {
                if (!innerWhitespaceChanges) break block7;
                list2 = RangesBuilder.createRangesSmart(current, vcs, currentShift, vcsShift);
            }
            catch (DiffTooBigException e) {
                throw new FilesTooBigForDiffException();
            }
            if (list2 == null) {
                RangesBuilder.$$$reportNull$$$0(8);
            }
            return list2;
        }
        List<Range> list3 = RangesBuilder.createRangesSimple(current, vcs, currentShift, vcsShift);
        if (list3 == null) {
            RangesBuilder.$$$reportNull$$$0(9);
        }
        return list3;
    }

    @NotNull
    private static List<Range> createRangesSimple(@NotNull List<String> current, @NotNull List<String> vcs, int currentShift, int vcsShift) throws DiffTooBigException {
        if (current == null) {
            RangesBuilder.$$$reportNull$$$0(10);
        }
        if (vcs == null) {
            RangesBuilder.$$$reportNull$$$0(11);
        }
        FairDiffIterable iterable = ByLine.compare(vcs, current, ComparisonPolicy.DEFAULT, (ProgressIndicator)DumbProgressIndicator.INSTANCE);
        ArrayList<Range> result2 = new ArrayList<Range>();
        for (com.intellij.diff.util.Range range : iterable.iterateChanges()) {
            int vcsLine1 = vcsShift + range.start1;
            int vcsLine2 = vcsShift + range.end1;
            int currentLine1 = currentShift + range.start2;
            int currentLine2 = currentShift + range.end2;
            result2.add(new Range(currentLine1, currentLine2, vcsLine1, vcsLine2));
        }
        ArrayList<Range> arrayList = result2;
        if (arrayList == null) {
            RangesBuilder.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    @NotNull
    private static List<Range> createRangesSmart(@NotNull List<String> current, @NotNull List<String> vcs, int currentShift, int vcsShift) throws DiffTooBigException {
        if (current == null) {
            RangesBuilder.$$$reportNull$$$0(13);
        }
        if (vcs == null) {
            RangesBuilder.$$$reportNull$$$0(14);
        }
        FairDiffIterable iwIterable = ByLine.compare(vcs, current, ComparisonPolicy.IGNORE_WHITESPACES, (ProgressIndicator)DumbProgressIndicator.INSTANCE);
        RangeBuilder rangeBuilder = new RangeBuilder(current, vcs, currentShift, vcsShift);
        for (com.intellij.diff.util.Range range : iwIterable.iterateUnchanged()) {
            int count = range.end1 - range.start1;
            for (int i = 0; i < count; ++i) {
                int vcsIndex = range.start1 + i;
                int currentIndex = range.start2 + i;
                if (!vcs.get(vcsIndex).equals(current.get(currentIndex))) continue;
                rangeBuilder.markEqual(vcsIndex, currentIndex);
            }
        }
        List<Range> list2 = rangeBuilder.finish();
        if (list2 == null) {
            RangesBuilder.$$$reportNull$$$0(15);
        }
        return list2;
    }

    private static byte getChangeType(int vcsStart, int vcsEnd, int currentStart, int currentEnd) {
        int deleted = vcsEnd - vcsStart;
        int inserted = currentEnd - currentStart;
        if (deleted > 0 && inserted > 0) {
            return 1;
        }
        if (deleted > 0) {
            return 3;
        }
        if (inserted > 0) {
            return 2;
        }
        LOG.error("Unknown change type");
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 12: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 12: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/ex/RangesBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/ex/RangesBuilder";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createRanges";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createRangesSimple";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createRangesSmart";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createRanges";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 12: 
            case 15: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createRangesSimple";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createRangesSmart";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 12: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RangeBuilder
    extends DiffIterableUtil.ChangeBuilderBase {
        @NotNull
        private final List<String> myCurrent;
        @NotNull
        private final List<String> myVcs;
        private final int myCurrentShift;
        private final int myVcsShift;
        @NotNull
        private final List<Range> myResult;

        public RangeBuilder(@NotNull List<String> current, @NotNull List<String> vcs, int currentShift, int vcsShift) {
            if (current == null) {
                RangeBuilder.$$$reportNull$$$0(0);
            }
            if (vcs == null) {
                RangeBuilder.$$$reportNull$$$0(1);
            }
            super(vcs.size(), current.size());
            this.myResult = new ArrayList<Range>();
            this.myCurrent = current;
            this.myVcs = vcs;
            this.myCurrentShift = currentShift;
            this.myVcsShift = vcsShift;
        }

        @NotNull
        public List<Range> finish() {
            this.doFinish();
            List<Range> list2 = this.myResult;
            if (list2 == null) {
                RangeBuilder.$$$reportNull$$$0(2);
            }
            return list2;
        }

        @Override
        protected void addChange(int vcsStart, int currentStart, int vcsEnd, int currentEnd) {
            com.intellij.diff.util.Range range = TrimUtil.expand(this.myVcs, this.myCurrent, vcsStart, currentStart, vcsEnd, currentEnd);
            if (range.isEmpty()) {
                return;
            }
            List<Range.InnerRange> innerRanges = this.calcInnerRanges(range);
            Range newRange = new Range(range.start2, range.end2, range.start1, range.end1, innerRanges);
            newRange.shift(this.myCurrentShift);
            newRange.vcsShift(this.myVcsShift);
            this.myResult.add(newRange);
        }

        @Nullable
        private List<Range.InnerRange> calcInnerRanges(@NotNull com.intellij.diff.util.Range blockRange) {
            if (blockRange == null) {
                RangeBuilder.$$$reportNull$$$0(3);
            }
            try {
                List<String> vcs = this.myVcs.subList(blockRange.start1, blockRange.end1);
                List<String> current = this.myCurrent.subList(blockRange.start2, blockRange.end2);
                ArrayList<Range.InnerRange> result2 = new ArrayList<Range.InnerRange>();
                FairDiffIterable iwIterable = ByLine.compare(vcs, current, ComparisonPolicy.IGNORE_WHITESPACES, (ProgressIndicator)DumbProgressIndicator.INSTANCE);
                for (Pair<com.intellij.diff.util.Range, Boolean> pair2 : DiffIterableUtil.iterateAll(iwIterable)) {
                    com.intellij.diff.util.Range range = (com.intellij.diff.util.Range)pair2.first;
                    Boolean equals = (Boolean)pair2.second;
                    byte type2 = equals != false ? (byte)0 : RangesBuilder.getChangeType(range.start1, range.end1, range.start2, range.end2);
                    result2.add(new Range.InnerRange(range.start2 + blockRange.start2, range.end2 + blockRange.start2, type2));
                }
                result2.trimToSize();
                return result2;
            }
            catch (DiffTooBigException e) {
                return null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "current";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "vcs";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/ex/RangesBuilder$RangeBuilder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "blockRange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/ex/RangesBuilder$RangeBuilder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "finish";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "calcInnerRanges";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

