/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.patch.RelativePathCalculator;
import com.intellij.openapi.vcs.impl.VcsPathPresenter;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleVcsPathPresenter
extends VcsPathPresenter {
    private final Project myProject;

    public ModuleVcsPathPresenter(Project project2) {
        this.myProject = project2;
    }

    public String getPresentableRelativePathFor(VirtualFile file2) {
        if (file2 == null) {
            return "";
        }
        return (String)ReadAction.compute(() -> {
            boolean hideExcludedFiles = Registry.is((String)"ide.hide.excluded.files");
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
            Module module2 = fileIndex.getModuleForFile(file2, hideExcludedFiles);
            VirtualFile contentRoot = fileIndex.getContentRootForFile(file2, hideExcludedFiles);
            if (module2 == null || contentRoot == null) {
                return file2.getPresentableUrl();
            }
            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file2, (VirtualFile)contentRoot, (char)File.separatorChar);
            assert (relativePath != null);
            return ModuleVcsPathPresenter.getPresentableRelativePathFor(module2, contentRoot, relativePath);
        });
    }

    public String getPresentableRelativePath(@NotNull ContentRevision fromRevision, @NotNull ContentRevision toRevision) {
        String moduleResult;
        if (fromRevision == null) {
            ModuleVcsPathPresenter.$$$reportNull$$$0(0);
        }
        if (toRevision == null) {
            ModuleVcsPathPresenter.$$$reportNull$$$0(1);
        }
        FilePath fromPath = fromRevision.getFile();
        FilePath toPath = toRevision.getFile();
        VirtualFile fromParent = ModuleVcsPathPresenter.getParentFile(fromPath);
        VirtualFile toParent = ModuleVcsPathPresenter.getParentFile(toPath);
        if (fromParent != null && toParent != null && (moduleResult = (String)ReadAction.compute(() -> {
            boolean hideExcludedFiles = Registry.is((String)"ide.hide.excluded.files");
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
            Module fromModule = fileIndex.getModuleForFile(fromParent, hideExcludedFiles);
            Module toModule = fileIndex.getModuleForFile(toParent, hideExcludedFiles);
            if (fromModule == null || toModule == null || fromModule.equals(toModule)) {
                return null;
            }
            VirtualFile fromContentRoot = fileIndex.getContentRootForFile(fromParent, hideExcludedFiles);
            if (fromContentRoot == null) {
                return null;
            }
            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)fromParent, (VirtualFile)fromContentRoot, (char)File.separatorChar);
            assert (relativePath != null);
            relativePath = relativePath + File.separatorChar;
            if (!fromPath.getName().equals(toPath.getName())) {
                relativePath = relativePath + fromPath.getName();
            }
            return ModuleVcsPathPresenter.getPresentableRelativePathFor(fromModule, fromContentRoot, relativePath);
        })) != null) {
            return moduleResult;
        }
        RelativePathCalculator calculator = new RelativePathCalculator(toPath.getPath(), fromPath.getPath());
        calculator.execute();
        String result2 = calculator.getResult();
        return result2 != null ? result2.replace("/", File.separator) : null;
    }

    @Nullable
    private static VirtualFile getParentFile(@NotNull FilePath path) {
        FilePath parentPath;
        if (path == null) {
            ModuleVcsPathPresenter.$$$reportNull$$$0(2);
        }
        return (parentPath = path.getParentPath()) != null ? parentPath.getVirtualFile() : null;
    }

    @NotNull
    private static String getPresentableRelativePathFor(@NotNull Module module2, @NotNull VirtualFile contentRoot, @NotNull String relativePath) {
        if (module2 == null) {
            ModuleVcsPathPresenter.$$$reportNull$$$0(3);
        }
        if (contentRoot == null) {
            ModuleVcsPathPresenter.$$$reportNull$$$0(4);
        }
        if (relativePath == null) {
            ModuleVcsPathPresenter.$$$reportNull$$$0(5);
        }
        StringBuilder result2 = new StringBuilder();
        result2.append("[");
        result2.append(module2.getName());
        result2.append("] ");
        result2.append(contentRoot.getName());
        if (!relativePath.isEmpty()) {
            result2.append(File.separatorChar);
            result2.append(relativePath);
        }
        String string = result2.toString();
        if (string == null) {
            ModuleVcsPathPresenter.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromRevision";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toRevision";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRoot";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/impl/ModuleVcsPathPresenter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/impl/ModuleVcsPathPresenter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableRelativePathFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableRelativePath";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getParentFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableRelativePathFor";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

