/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.roots;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vcs.VcsRootError;
import com.intellij.openapi.vcs.VcsRootErrorImpl;
import com.intellij.openapi.vcs.roots.VcsRootDetector;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class VcsRootErrorsFinder {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectLevelVcsManager myVcsManager;
    @NotNull
    private final VcsRootDetector myRootDetector;

    public VcsRootErrorsFinder(@NotNull Project project2) {
        if (project2 == null) {
            VcsRootErrorsFinder.$$$reportNull$$$0(0);
        }
        this.myProject = project2;
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project2);
        this.myRootDetector = (VcsRootDetector)ServiceManager.getService((Project)this.myProject, VcsRootDetector.class);
    }

    @NotNull
    public Collection<VcsRootError> find() {
        List mappings = this.myVcsManager.getDirectoryMappings();
        Collection vcsRoots = this.myRootDetector.detect();
        ArrayList<VcsRootError> errors = new ArrayList<VcsRootError>();
        errors.addAll(this.findExtraMappings(mappings));
        errors.addAll(this.findUnregisteredRoots(mappings, vcsRoots));
        ArrayList<VcsRootError> arrayList = errors;
        if (arrayList == null) {
            VcsRootErrorsFinder.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    private Collection<VcsRootError> findUnregisteredRoots(@NotNull List<VcsDirectoryMapping> mappings, @NotNull Collection<VcsRoot> vcsRoots) {
        if (mappings == null) {
            VcsRootErrorsFinder.$$$reportNull$$$0(2);
        }
        if (vcsRoots == null) {
            VcsRootErrorsFinder.$$$reportNull$$$0(3);
        }
        ArrayList<VcsRootError> errors = new ArrayList<VcsRootError>();
        List<String> mappedPaths = this.mappingsToPathsWithSelectedVcs(mappings);
        for (VcsRoot root : vcsRoots) {
            String vcsPath;
            VirtualFile virtualFileFromRoot = root.getPath();
            if (virtualFileFromRoot == null || mappedPaths.contains(vcsPath = virtualFileFromRoot.getPath()) || root.getVcs() == null) continue;
            errors.add(new VcsRootErrorImpl(VcsRootError.Type.UNREGISTERED_ROOT, vcsPath, root.getVcs().getName()));
        }
        ArrayList<VcsRootError> arrayList = errors;
        if (arrayList == null) {
            VcsRootErrorsFinder.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    private Collection<VcsRootError> findExtraMappings(@NotNull List<VcsDirectoryMapping> mappings) {
        if (mappings == null) {
            VcsRootErrorsFinder.$$$reportNull$$$0(5);
        }
        ArrayList<VcsRootError> errors = new ArrayList<VcsRootError>();
        for (VcsDirectoryMapping mapping : mappings) {
            if (!VcsRootErrorsFinder.hasVcsChecker(mapping.getVcs())) continue;
            if (mapping.isDefaultMapping()) {
                if (this.isRoot(mapping)) continue;
                errors.add(new VcsRootErrorImpl(VcsRootError.Type.EXTRA_MAPPING, "<Project>", mapping.getVcs()));
                continue;
            }
            String mappedPath = mapping.systemIndependentPath();
            if (this.isRoot(mapping)) continue;
            errors.add(new VcsRootErrorImpl(VcsRootError.Type.EXTRA_MAPPING, mappedPath, mapping.getVcs()));
        }
        ArrayList<VcsRootError> arrayList = errors;
        if (arrayList == null) {
            VcsRootErrorsFinder.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static boolean hasVcsChecker(String vcs) {
        VcsRootChecker[] checkers;
        if (StringUtil.isEmptyOrSpaces((String)vcs)) {
            return false;
        }
        for (VcsRootChecker checker : checkers = (VcsRootChecker[])Extensions.getExtensions((ExtensionPointName)VcsRootChecker.EXTENSION_POINT_NAME)) {
            if (!vcs.equalsIgnoreCase(checker.getSupportedVcs().getName())) continue;
            return true;
        }
        return false;
    }

    private List<String> mappingsToPathsWithSelectedVcs(@NotNull List<VcsDirectoryMapping> mappings) {
        if (mappings == null) {
            VcsRootErrorsFinder.$$$reportNull$$$0(7);
        }
        ArrayList<String> paths = new ArrayList<String>();
        for (VcsDirectoryMapping mapping : mappings) {
            if (StringUtil.isEmptyOrSpaces((String)mapping.getVcs())) continue;
            if (!mapping.isDefaultMapping()) {
                paths.add(mapping.systemIndependentPath());
                continue;
            }
            String basePath = this.myProject.getBasePath();
            if (basePath == null) continue;
            paths.add(FileUtil.toSystemIndependentName((String)basePath));
        }
        return paths;
    }

    public static VcsRootErrorsFinder getInstance(Project project2) {
        return new VcsRootErrorsFinder(project2);
    }

    private boolean isRoot(@NotNull VcsDirectoryMapping mapping) {
        if (mapping == null) {
            VcsRootErrorsFinder.$$$reportNull$$$0(8);
        }
        Object[] checkers = (VcsRootChecker[])Extensions.getExtensions((ExtensionPointName)VcsRootChecker.EXTENSION_POINT_NAME);
        String pathToCheck = mapping.isDefaultMapping() ? this.myProject.getBasePath() : mapping.getDirectory();
        return ContainerUtil.find((Object[])checkers, checker -> {
            if (mapping == null) {
                VcsRootErrorsFinder.$$$reportNull$$$0(9);
            }
            return checker.getSupportedVcs().getName().equalsIgnoreCase(mapping.getVcs()) && checker.isRoot(pathToCheck);
        }) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/roots/VcsRootErrorsFinder";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsRoots";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/roots/VcsRootErrorsFinder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "find";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findUnregisteredRoots";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findExtraMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findUnregisteredRoots";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findExtraMappings";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "mappingsToPathsWithSelectedVcs";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isRoot";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isRoot$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

