/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.impl.ZipEntryMap;
import com.intellij.util.io.ResourceHandle;
import com.intellij.util.text.ByteArrayCharSequence;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ZipHandlerBase
extends ArchiveHandler {
    public ZipHandlerBase(@NotNull String path) {
        if (path == null) {
            ZipHandlerBase.$$$reportNull$$$0(0);
        }
        super(path);
    }

    @NotNull
    protected Map<String, ArchiveHandler.EntryInfo> createEntriesMap() throws IOException {
        Map<String, ArchiveHandler.EntryInfo> map;
        try (ResourceHandle<ZipFile> existingZipRef = this.acquireZipHandle();){
            Map<String, ArchiveHandler.EntryInfo> map2 = this.buildEntryMapForZipFile((ZipFile)existingZipRef.get());
            map = map2;
        }
        if (map == null) {
            ZipHandlerBase.$$$reportNull$$$0(1);
        }
        return map;
    }

    @NotNull
    protected Map<String, ArchiveHandler.EntryInfo> buildEntryMapForZipFile(ZipFile zip) {
        ZipEntryMap map = new ZipEntryMap(zip.size());
        map.put("", this.createRootEntry());
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            this.getOrCreate(entries.nextElement(), (Map<String, ArchiveHandler.EntryInfo>)map, zip);
        }
        ZipEntryMap zipEntryMap = map;
        if (zipEntryMap == null) {
            ZipHandlerBase.$$$reportNull$$$0(2);
        }
        return zipEntryMap;
    }

    public void dispose() {
        super.dispose();
        this.clearCaches();
    }

    @NotNull
    private ArchiveHandler.EntryInfo getOrCreate(@NotNull ZipEntry entry, @NotNull Map<String, ArchiveHandler.EntryInfo> map, @NotNull ZipFile zip) {
        ArchiveHandler.EntryInfo info;
        if (entry == null) {
            ZipHandlerBase.$$$reportNull$$$0(3);
        }
        if (map == null) {
            ZipHandlerBase.$$$reportNull$$$0(4);
        }
        if (zip == null) {
            ZipHandlerBase.$$$reportNull$$$0(5);
        }
        boolean isDirectory = entry.isDirectory();
        String entryName = entry.getName();
        if (StringUtil.endsWithChar((CharSequence)entryName, (char)'/')) {
            entryName = entryName.substring(0, entryName.length() - 1);
            isDirectory = true;
        }
        if ((info = map.get(entryName)) != null) {
            ArchiveHandler.EntryInfo entryInfo = info;
            if (entryInfo == null) {
                ZipHandlerBase.$$$reportNull$$$0(6);
            }
            return entryInfo;
        }
        Pair path = this.splitPath(entryName);
        ArchiveHandler.EntryInfo parentInfo = this.getOrCreate((String)path.first, map, zip);
        if (".".equals(path.second)) {
            ArchiveHandler.EntryInfo entryInfo = parentInfo;
            if (entryInfo == null) {
                ZipHandlerBase.$$$reportNull$$$0(7);
            }
            return entryInfo;
        }
        ArchiveHandler.EntryInfo entryInfo = info = ZipHandlerBase.store(map, parentInfo, (CharSequence)path.second, isDirectory, entry.getSize(), this.getEntryFileStamp(), entryName);
        if (entryInfo == null) {
            ZipHandlerBase.$$$reportNull$$$0(8);
        }
        return entryInfo;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static ArchiveHandler.EntryInfo store(@NotNull Map<String, ArchiveHandler.EntryInfo> map, @Nullable ArchiveHandler.EntryInfo parentInfo, @NotNull CharSequence shortName, boolean isDirectory, long size, long time, @NotNull String string) {
        void entryName;
        if (map == null) {
            ZipHandlerBase.$$$reportNull$$$0(9);
        }
        if (shortName == null) {
            ZipHandlerBase.$$$reportNull$$$0(10);
        }
        if (string == null) {
            ZipHandlerBase.$$$reportNull$$$0(11);
        }
        CharSequence sequence = shortName instanceof ByteArrayCharSequence ? shortName : ByteArrayCharSequence.convertToBytesIfAsciiString((CharSequence)shortName);
        ArchiveHandler.EntryInfo info = new ArchiveHandler.EntryInfo(sequence, isDirectory, size, time, parentInfo);
        map.put((String)entryName, info);
        ArchiveHandler.EntryInfo entryInfo = info;
        if (entryInfo == null) {
            ZipHandlerBase.$$$reportNull$$$0(12);
        }
        return entryInfo;
    }

    @NotNull
    private ArchiveHandler.EntryInfo getOrCreate(@NotNull String entryName, Map<String, ArchiveHandler.EntryInfo> map, @NotNull ZipFile zip) {
        ArchiveHandler.EntryInfo info;
        if (entryName == null) {
            ZipHandlerBase.$$$reportNull$$$0(13);
        }
        if (zip == null) {
            ZipHandlerBase.$$$reportNull$$$0(14);
        }
        if ((info = map.get(entryName)) == null) {
            ZipEntry entry = zip.getEntry(entryName + "/");
            if (entry != null) {
                ArchiveHandler.EntryInfo entryInfo = this.getOrCreate(entry, map, zip);
                if (entryInfo == null) {
                    ZipHandlerBase.$$$reportNull$$$0(15);
                }
                return entryInfo;
            }
            Pair path = this.splitPath(entryName);
            ArchiveHandler.EntryInfo parentInfo = this.getOrCreate((String)path.first, map, zip);
            info = ZipHandlerBase.store(map, parentInfo, (CharSequence)path.second, true, 0L, -1L, entryName);
        }
        if (!info.isDirectory) {
            Logger.getInstance(((Object)((Object)this)).getClass()).info(zip.getName() + ": " + entryName + " should be a directory");
            info = ZipHandlerBase.store(map, info.parent, info.shortName, true, info.length, info.timestamp, entryName);
        }
        ArchiveHandler.EntryInfo entryInfo = info;
        if (entryInfo == null) {
            ZipHandlerBase.$$$reportNull$$$0(16);
        }
        return entryInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public byte[] contentsToByteArray(@NotNull String relativePath) throws IOException {
        block31: {
            byte[] byArray;
            Throwable throwable;
            ResourceHandle<ZipFile> zipRef;
            block32: {
                if (relativePath == null) {
                    ZipHandlerBase.$$$reportNull$$$0(17);
                }
                zipRef = this.acquireZipHandle();
                throwable = null;
                try {
                    ZipFile zip = (ZipFile)zipRef.get();
                    ZipEntry entry = zip.getEntry(relativePath);
                    if (entry == null) break block31;
                    long length = entry.getSize();
                    if (FileUtilRt.isTooLarge((long)length)) {
                        throw new FileTooBigException(this.getFile() + "!/" + relativePath);
                    }
                    try (InputStream stream = zip.getInputStream(entry);){
                        if (stream == null) break block31;
                        byArray = FileUtil.loadBytes((InputStream)stream, (int)((int)length));
                        if (byArray != null) break block32;
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                ZipHandlerBase.$$$reportNull$$$0(18);
            }
            return byArray;
            finally {
                if (zipRef != null) {
                    if (throwable != null) {
                        try {
                            zipRef.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        zipRef.close();
                    }
                }
            }
        }
        throw new FileNotFoundException(this.getFile() + "!/" + relativePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public InputStream getInputStream(@NotNull String relativePath) throws IOException {
        block12: {
            InputStream stream;
            if (relativePath == null) {
                ZipHandlerBase.$$$reportNull$$$0(19);
            }
            boolean release = true;
            ResourceHandle<ZipFile> zipRef = this.acquireZipHandle();
            ZipFile zip = (ZipFile)zipRef.get();
            ZipEntry entry = zip.getEntry(relativePath);
            if (entry == null || (stream = zip.getInputStream(entry)) == null) break block12;
            long length = entry.getSize();
            if (!FileUtilRt.isTooLarge((long)length)) {
                BufferExposingByteArrayInputStream bufferExposingByteArrayInputStream = new BufferExposingByteArrayInputStream(FileUtil.loadBytes((InputStream)stream, (int)((int)length)));
                BufferExposingByteArrayInputStream bufferExposingByteArrayInputStream2 = bufferExposingByteArrayInputStream;
                if (bufferExposingByteArrayInputStream2 == null) {
                    ZipHandlerBase.$$$reportNull$$$0(20);
                }
                return bufferExposingByteArrayInputStream2;
                finally {
                    stream.close();
                }
            }
            release = false;
            InputStreamWrapper inputStreamWrapper = new InputStreamWrapper(stream, zipRef);
            InputStreamWrapper inputStreamWrapper2 = inputStreamWrapper;
            if (inputStreamWrapper2 == null) {
                ZipHandlerBase.$$$reportNull$$$0(21);
            }
            return inputStreamWrapper2;
            finally {
                if (release) {
                    zipRef.close();
                }
            }
        }
        throw new FileNotFoundException(this.getFile() + "!/" + relativePath);
    }

    protected abstract long getEntryFileStamp();

    @NotNull
    protected abstract ResourceHandle<ZipFile> acquireZipHandle() throws IOException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/ZipHandlerBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zip";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryName";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/ZipHandlerBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createEntriesMap";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildEntryMapForZipFile";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreate";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "store";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 21: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreate";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "store";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "contentsToByteArray";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getInputStream";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class InputStreamWrapper
    extends InputStream {
        private final InputStream myStream;
        private final ResourceHandle<ZipFile> myZipRef;
        private final AtomicBoolean closed = new AtomicBoolean(false);

        public InputStreamWrapper(InputStream stream, ResourceHandle<ZipFile> zipRef) {
            this.myStream = stream;
            this.myZipRef = zipRef;
        }

        @Override
        public int read() throws IOException {
            return this.myStream.read();
        }

        @Override
        public int read(@NotNull byte[] b, int off, int len) throws IOException {
            if (b == null) {
                InputStreamWrapper.$$$reportNull$$$0(0);
            }
            return this.myStream.read(b, off, len);
        }

        @Override
        public int available() throws IOException {
            return this.myStream.available();
        }

        @Override
        public void close() throws IOException {
            if (!this.closed.getAndSet(true)) {
                try {
                    this.myStream.close();
                }
                finally {
                    this.myZipRef.close();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "b", "com/intellij/openapi/vfs/impl/ZipHandlerBase$InputStreamWrapper", "read"));
        }
    }
}

