/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.http;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.http.HttpVirtualFileListener;
import com.intellij.openapi.vfs.impl.http.DefaultRemoteContentProvider;
import com.intellij.openapi.vfs.impl.http.FileDownloadingAdapter;
import com.intellij.openapi.vfs.impl.http.HttpFileSystemBase;
import com.intellij.openapi.vfs.impl.http.HttpFileSystemImpl;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFileImpl;
import com.intellij.openapi.vfs.impl.http.HttpsFileSystem;
import com.intellij.openapi.vfs.impl.http.LocalFileStorage;
import com.intellij.openapi.vfs.impl.http.RemoteContentProvider;
import com.intellij.openapi.vfs.impl.http.RemoteFileInfoImpl;
import com.intellij.openapi.vfs.impl.http.RemoteFileManager;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Url;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteFileManagerImpl
extends RemoteFileManager
implements Disposable {
    private final LocalFileStorage myStorage;
    private final Map<Url, HttpVirtualFileImpl> remoteFiles = new THashMap();
    private final Map<Url, HttpVirtualFileImpl> remoteDirectories = new THashMap();
    private final EventDispatcher<HttpVirtualFileListener> myDispatcher = EventDispatcher.create(HttpVirtualFileListener.class);
    private final List<RemoteContentProvider> myProviders = new ArrayList<RemoteContentProvider>();
    private final DefaultRemoteContentProvider myDefaultRemoteContentProvider;

    public RemoteFileManagerImpl() {
        this.myStorage = new LocalFileStorage();
        this.myDefaultRemoteContentProvider = new DefaultRemoteContentProvider();
    }

    @NotNull
    public RemoteContentProvider findContentProvider(@NotNull Url url) {
        if (url == null) {
            RemoteFileManagerImpl.$$$reportNull$$$0(0);
        }
        for (RemoteContentProvider provider : this.myProviders) {
            if (!provider.canProvideContent(url)) continue;
            RemoteContentProvider remoteContentProvider = provider;
            if (remoteContentProvider == null) {
                RemoteFileManagerImpl.$$$reportNull$$$0(1);
            }
            return remoteContentProvider;
        }
        DefaultRemoteContentProvider defaultRemoteContentProvider = this.myDefaultRemoteContentProvider;
        if (defaultRemoteContentProvider == null) {
            RemoteFileManagerImpl.$$$reportNull$$$0(2);
        }
        return defaultRemoteContentProvider;
    }

    public synchronized HttpVirtualFileImpl getOrCreateFile(@Nullable HttpVirtualFileImpl parent, @NotNull Url url, @NotNull String path, boolean directory) {
        Map<Url, HttpVirtualFileImpl> cache;
        HttpVirtualFileImpl file2;
        if (url == null) {
            RemoteFileManagerImpl.$$$reportNull$$$0(3);
        }
        if (path == null) {
            RemoteFileManagerImpl.$$$reportNull$$$0(4);
        }
        if ((file2 = (cache = directory ? this.remoteDirectories : this.remoteFiles).get(url)) == null) {
            if (directory) {
                file2 = new HttpVirtualFileImpl(RemoteFileManagerImpl.getHttpFileSystem(url), parent, path, null);
            } else {
                RemoteFileInfoImpl fileInfo = new RemoteFileInfoImpl(url, this);
                file2 = new HttpVirtualFileImpl(RemoteFileManagerImpl.getHttpFileSystem(url), parent, path, fileInfo);
                fileInfo.addDownloadingListener(new MyDownloadingListener(file2));
            }
            cache.put(url, file2);
        }
        return file2;
    }

    private static HttpFileSystemBase getHttpFileSystem(@NotNull Url url) {
        if (url == null) {
            RemoteFileManagerImpl.$$$reportNull$$$0(5);
        }
        return "https".equals(url.getScheme()) ? HttpsFileSystem.getHttpsInstance() : HttpFileSystemImpl.getInstanceImpl();
    }

    @Override
    public void addRemoteContentProvider(final @NotNull RemoteContentProvider provider, @NotNull Disposable parentDisposable) {
        if (provider == null) {
            RemoteFileManagerImpl.$$$reportNull$$$0(6);
        }
        if (parentDisposable == null) {
            RemoteFileManagerImpl.$$$reportNull$$$0(7);
        }
        this.addRemoteContentProvider(provider);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                RemoteFileManagerImpl.this.removeRemoteContentProvider(provider);
            }
        });
    }

    @Override
    public void addRemoteContentProvider(@NotNull RemoteContentProvider provider) {
        if (provider == null) {
            RemoteFileManagerImpl.$$$reportNull$$$0(8);
        }
        this.myProviders.add(provider);
    }

    @Override
    public void removeRemoteContentProvider(@NotNull RemoteContentProvider provider) {
        if (provider == null) {
            RemoteFileManagerImpl.$$$reportNull$$$0(9);
        }
        this.myProviders.remove(provider);
    }

    @Override
    public void addFileListener(@NotNull HttpVirtualFileListener listener2) {
        if (listener2 == null) {
            RemoteFileManagerImpl.$$$reportNull$$$0(10);
        }
        this.myDispatcher.addListener((EventListener)listener2);
    }

    @Override
    public void addFileListener(@NotNull HttpVirtualFileListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            RemoteFileManagerImpl.$$$reportNull$$$0(11);
        }
        if (parentDisposable == null) {
            RemoteFileManagerImpl.$$$reportNull$$$0(12);
        }
        this.myDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    @Override
    public void removeFileListener(@NotNull HttpVirtualFileListener listener2) {
        if (listener2 == null) {
            RemoteFileManagerImpl.$$$reportNull$$$0(13);
        }
        this.myDispatcher.removeListener((EventListener)listener2);
    }

    public void fireFileDownloaded(@NotNull VirtualFile file2) {
        if (file2 == null) {
            RemoteFileManagerImpl.$$$reportNull$$$0(14);
        }
        ((HttpVirtualFileListener)this.myDispatcher.getMulticaster()).fileDownloaded(file2);
    }

    public LocalFileStorage getStorage() {
        return this.myStorage;
    }

    public void dispose() {
        this.myStorage.deleteDownloadedFiles();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/http/RemoteFileManagerImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/http/RemoteFileManagerImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findContentProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findContentProvider";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getHttpFileSystem";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addRemoteContentProvider";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeRemoteContentProvider";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addFileListener";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "removeFileListener";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "fireFileDownloaded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyDownloadingListener
    extends FileDownloadingAdapter {
        private final HttpVirtualFileImpl myFile;

        public MyDownloadingListener(HttpVirtualFileImpl file2) {
            this.myFile = file2;
        }

        @Override
        public void fileDownloaded(VirtualFile localFile) {
            RemoteFileManagerImpl.this.fireFileDownloaded(this.myFile);
        }
    }
}

