/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.jar;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.impl.jar.BasicJarHandler;
import com.intellij.openapi.vfs.impl.jar.JarHandler;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JarFileSystemImpl
extends JarFileSystem {
    private final Set<String> myNoCopyJarPaths;
    private final File myNoCopyJarDir;

    public JarFileSystemImpl() {
        boolean noCopy = SystemProperties.getBooleanProperty((String)"idea.jars.nocopy", (!SystemInfo.isWindows ? 1 : 0) != 0);
        this.myNoCopyJarPaths = noCopy ? null : ConcurrentCollectionFactory.createConcurrentSet(FileUtil.PATH_HASHING_STRATEGY);
        boolean runningFromDist = new File(PathManager.getLibPath(), "openapi.jar").exists();
        this.myNoCopyJarDir = !runningFromDist ? null : new File(PathManager.getHomePath());
    }

    public void setNoCopyJarForPath(@NotNull String pathInJar) {
        if (pathInJar == null) {
            JarFileSystemImpl.$$$reportNull$$$0(0);
        }
        if (this.myNoCopyJarPaths == null) {
            return;
        }
        int index = pathInJar.indexOf("!/");
        if (index < 0) {
            return;
        }
        String path = FileUtil.toSystemIndependentName((String)pathInJar.substring(0, index));
        this.myNoCopyJarPaths.add(path);
    }

    @Nullable
    public File getMirroredFile(@NotNull VirtualFile vFile) {
        VirtualFile root;
        if (vFile == null) {
            JarFileSystemImpl.$$$reportNull$$$0(1);
        }
        if ((root = this.getRootByLocal(vFile)) != null) {
            ArchiveHandler handler2 = this.getHandler(root);
            if (handler2 instanceof JarHandler) {
                return ((JarHandler)handler2).getFileToUse();
            }
            return handler2.getFile();
        }
        return null;
    }

    public boolean isMakeCopyOfJar(@NotNull File originalJar) {
        if (originalJar == null) {
            JarFileSystemImpl.$$$reportNull$$$0(2);
        }
        if (this.myNoCopyJarPaths == null || this.myNoCopyJarPaths.contains(FileUtil.toSystemIndependentName((String)originalJar.getPath()))) {
            return false;
        }
        return this.myNoCopyJarDir == null || !FileUtil.isAncestor((File)this.myNoCopyJarDir, (File)originalJar, (boolean)false);
    }

    @NotNull
    public String getProtocol() {
        if ("jar" == null) {
            JarFileSystemImpl.$$$reportNull$$$0(3);
        }
        return "jar";
    }

    @NotNull
    public String extractPresentableUrl(@NotNull String path) {
        if (path == null) {
            JarFileSystemImpl.$$$reportNull$$$0(4);
        }
        String string = super.extractPresentableUrl(StringUtil.trimEnd((String)path, (String)"!/"));
        if (string == null) {
            JarFileSystemImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    protected String normalize(@NotNull String path) {
        int jarSeparatorIndex;
        if (path == null) {
            JarFileSystemImpl.$$$reportNull$$$0(6);
        }
        if ((jarSeparatorIndex = path.indexOf("!/")) > 0) {
            String root = path.substring(0, jarSeparatorIndex);
            String string = FileUtil.normalize((String)root) + path.substring(jarSeparatorIndex);
            if (string == null) {
                JarFileSystemImpl.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = super.normalize(path);
        if (string == null) {
            JarFileSystemImpl.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    protected String extractRootPath(@NotNull String path) {
        if (path == null) {
            JarFileSystemImpl.$$$reportNull$$$0(9);
        }
        int jarSeparatorIndex = path.indexOf("!/");
        assert (jarSeparatorIndex >= 0) : "Path passed to JarFileSystem must have jar separator '!/': " + path;
        String string = path.substring(0, jarSeparatorIndex + "!/".length());
        if (string == null) {
            JarFileSystemImpl.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    protected String extractLocalPath(@NotNull String rootPath) {
        if (rootPath == null) {
            JarFileSystemImpl.$$$reportNull$$$0(11);
        }
        String string = StringUtil.trimEnd((String)rootPath, (String)"!/");
        if (string == null) {
            JarFileSystemImpl.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    protected String composeRootPath(@NotNull String localPath) {
        if (localPath == null) {
            JarFileSystemImpl.$$$reportNull$$$0(13);
        }
        String string = localPath + "!/";
        if (string == null) {
            JarFileSystemImpl.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    protected ArchiveHandler getHandler(@NotNull VirtualFile entryFile) {
        boolean useNewJarHandler;
        if (entryFile == null) {
            JarFileSystemImpl.$$$reportNull$$$0(15);
        }
        Object t = VfsImplUtil.getHandler((ArchiveFileSystem)this, entryFile, (useNewJarHandler = Registry.is((String)"vfs.use.new.jar.handler")) ? BasicJarHandler::new : JarHandler::new);
        if (t == null) {
            JarFileSystemImpl.$$$reportNull$$$0(16);
        }
        return t;
    }

    public VirtualFile findFileByPath(@NotNull String path) {
        if (path == null) {
            JarFileSystemImpl.$$$reportNull$$$0(17);
        }
        return JarFileSystemImpl.isValid(path) ? VfsImplUtil.findFileByPath((NewVirtualFileSystem)this, path) : null;
    }

    public VirtualFile findFileByPathIfCached(@NotNull String path) {
        if (path == null) {
            JarFileSystemImpl.$$$reportNull$$$0(18);
        }
        return JarFileSystemImpl.isValid(path) ? VfsImplUtil.findFileByPathIfCached((NewVirtualFileSystem)this, path) : null;
    }

    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            JarFileSystemImpl.$$$reportNull$$$0(19);
        }
        return JarFileSystemImpl.isValid(path) ? VfsImplUtil.refreshAndFindFileByPath((NewVirtualFileSystem)this, path) : null;
    }

    private static boolean isValid(String path) {
        return path.contains("!/");
    }

    public void refresh(boolean asynchronous) {
        VfsImplUtil.refresh((NewVirtualFileSystem)this, asynchronous);
    }

    public void cleanupForNextTest() {
        BasicJarHandler.closeOpenedZipReferences();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathInJar";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalJar";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/jar/JarFileSystemImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProtocol";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "extractPresentableUrl";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "normalize";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "extractRootPath";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "extractLocalPath";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "composeRootPath";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setNoCopyJarForPath";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getMirroredFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isMakeCopyOfJar";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "extractPresentableUrl";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "normalize";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "extractRootPath";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "extractLocalPath";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "composeRootPath";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getHandler";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPath";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPathIfCached";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

