/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.jrt;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.openapi.vfs.impl.jrt.JrtHandler;
import com.intellij.openapi.vfs.jrt.JrtFileSystem;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectHashingStrategy;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class JrtFileSystemImpl
extends JrtFileSystem {
    private final Map<String, ArchiveHandler> myHandlers = ContainerUtil.newTroveMap((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY);
    private final AtomicBoolean mySubscribed = new AtomicBoolean(false);

    @NotNull
    public String getProtocol() {
        if ("jrt" == null) {
            JrtFileSystemImpl.$$$reportNull$$$0(0);
        }
        return "jrt";
    }

    @NotNull
    protected String normalize(@NotNull String path) {
        int p;
        if (path == null) {
            JrtFileSystemImpl.$$$reportNull$$$0(1);
        }
        String string = (p = path.indexOf("!/")) > 0 ? FileUtil.normalize((String)path.substring(0, p)) + path.substring(p) : super.normalize(path);
        if (string == null) {
            JrtFileSystemImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    protected String extractLocalPath(@NotNull String rootPath) {
        if (rootPath == null) {
            JrtFileSystemImpl.$$$reportNull$$$0(3);
        }
        String string = StringUtil.trimEnd((String)rootPath, (String)"!/");
        if (string == null) {
            JrtFileSystemImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    protected String composeRootPath(@NotNull String localPath) {
        if (localPath == null) {
            JrtFileSystemImpl.$$$reportNull$$$0(5);
        }
        String string = localPath + "!/";
        if (string == null) {
            JrtFileSystemImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    protected String extractRootPath(@NotNull String entryPath) {
        if (entryPath == null) {
            JrtFileSystemImpl.$$$reportNull$$$0(7);
        }
        int separatorIndex = entryPath.indexOf("!/");
        assert (separatorIndex >= 0) : "Path passed to JrtFileSystem must have a separator '!/': " + entryPath;
        String string = entryPath.substring(0, separatorIndex + "!/".length());
        if (string == null) {
            JrtFileSystemImpl.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    protected ArchiveHandler getHandler(@NotNull VirtualFile entryFile) {
        if (entryFile == null) {
            JrtFileSystemImpl.$$$reportNull$$$0(9);
        }
        this.checkSubscription();
        String homePath = this.extractLocalPath(this.extractRootPath(entryFile.getPath()));
        ArchiveHandler handler2 = this.myHandlers.get(homePath);
        if (handler2 == null) {
            handler2 = new JrtHandler(homePath);
            this.myHandlers.put(homePath, handler2);
            ApplicationManager.getApplication().invokeLater(() -> LocalFileSystem.getInstance().refreshAndFindFileByPath(homePath + "/release"), ModalityState.defaultModalityState());
        }
        ArchiveHandler archiveHandler = handler2;
        if (archiveHandler == null) {
            JrtFileSystemImpl.$$$reportNull$$$0(10);
        }
        return archiveHandler;
    }

    private void checkSubscription() {
        if (this.mySubscribed.getAndSet(true)) {
            return;
        }
        Application app = ApplicationManager.getApplication();
        app.getMessageBus().connect((Disposable)app).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                HashSet toRefresh = null;
                for (VFileEvent vFileEvent : events) {
                    VirtualFile file2;
                    if (!(vFileEvent.getFileSystem() instanceof LocalFileSystem) || !(vFileEvent instanceof VFileContentChangeEvent) || (file2 = vFileEvent.getFile()) == null || !"release".equals(file2.getName())) continue;
                    String homePath = file2.getParent().getPath();
                    ArchiveHandler handler2 = (ArchiveHandler)JrtFileSystemImpl.this.myHandlers.remove(homePath);
                    if (handler2 == null) continue;
                    handler2.dispose();
                    VirtualFile root = JrtFileSystemImpl.this.findFileByPath(JrtFileSystemImpl.this.composeRootPath(homePath));
                    if (root == null) continue;
                    ((NewVirtualFile)root).markDirtyRecursively();
                    if (toRefresh == null) {
                        toRefresh = ContainerUtil.newHashSet();
                    }
                    toRefresh.add(root);
                }
                if (toRefresh != null) {
                    boolean async = !ApplicationManager.getApplication().isUnitTestMode();
                    RefreshQueue.getInstance().refresh(async, true, null, toRefresh);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/vfs/impl/jrt/JrtFileSystemImpl$1", "after"));
            }
        });
    }

    public VirtualFile findFileByPath(@NotNull String path) {
        if (path == null) {
            JrtFileSystemImpl.$$$reportNull$$$0(11);
        }
        return VfsImplUtil.findFileByPath((NewVirtualFileSystem)this, path);
    }

    public VirtualFile findFileByPathIfCached(@NotNull String path) {
        if (path == null) {
            JrtFileSystemImpl.$$$reportNull$$$0(12);
        }
        return VfsImplUtil.findFileByPathIfCached((NewVirtualFileSystem)this, path);
    }

    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            JrtFileSystemImpl.$$$reportNull$$$0(13);
        }
        return VfsImplUtil.refreshAndFindFileByPath((NewVirtualFileSystem)this, path);
    }

    public void refresh(boolean asynchronous) {
        VfsImplUtil.refresh((NewVirtualFileSystem)this, asynchronous);
    }

    protected boolean isCorrectFileType(@NotNull VirtualFile local) {
        String path;
        if (local == null) {
            JrtFileSystemImpl.$$$reportNull$$$0(14);
        }
        return JdkUtil.isModularRuntime((String)(path = local.getPath())) && !JdkUtil.isExplodedModularRuntime((String)path);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/jrt/JrtFileSystemImpl";
                break;
            }
            case 1: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryPath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryFile";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "local";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProtocol";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/jrt/JrtFileSystemImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "normalize";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "extractLocalPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "composeRootPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "extractRootPath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandler";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "normalize";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "extractLocalPath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "composeRootPath";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "extractRootPath";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getHandler";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPath";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPathIfCached";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByPath";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isCorrectFileType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

