/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.local;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.impl.local.FileWatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

class CanonicalPathMap {
    private static final Logger LOG = Logger.getInstance(FileWatcher.class);
    private final List<String> myRecursiveWatchRoots;
    private final List<String> myFlatWatchRoots;
    private final List<String> myCanonicalRecursiveWatchRoots;
    private final List<String> myCanonicalFlatWatchRoots;
    private final MultiMap<String, String> myPathMapping;

    public CanonicalPathMap() {
        this.myCanonicalFlatWatchRoots = Collections.emptyList();
        this.myFlatWatchRoots = this.myCanonicalFlatWatchRoots;
        this.myCanonicalRecursiveWatchRoots = this.myCanonicalFlatWatchRoots;
        this.myRecursiveWatchRoots = this.myCanonicalFlatWatchRoots;
        this.myPathMapping = MultiMap.empty();
    }

    public CanonicalPathMap(@NotNull List<String> recursive, @NotNull List<String> flat) {
        if (recursive == null) {
            CanonicalPathMap.$$$reportNull$$$0(0);
        }
        if (flat == null) {
            CanonicalPathMap.$$$reportNull$$$0(1);
        }
        this.myRecursiveWatchRoots = ContainerUtil.newArrayList(recursive);
        this.myFlatWatchRoots = ContainerUtil.newArrayList(flat);
        List mapping = ContainerUtil.newSmartList();
        Map<String, String> resolvedPaths = CanonicalPathMap.resolvePaths(recursive, flat);
        this.myCanonicalRecursiveWatchRoots = CanonicalPathMap.mapPaths(resolvedPaths, recursive, mapping);
        this.myCanonicalFlatWatchRoots = CanonicalPathMap.mapPaths(resolvedPaths, flat, mapping);
        this.myPathMapping = MultiMap.createConcurrentSet();
        this.addMapping(mapping);
    }

    private static Map<String, String> resolvePaths(Collection<String> recursiveRoots, Collection<String> flatRoots) {
        ConcurrentMap result2 = ContainerUtil.newConcurrentMap();
        ((Stream)Stream.concat(recursiveRoots.stream(), flatRoots.stream()).parallel()).forEach(root -> ContainerUtil.putIfNotNull((Object)root, (Object)FileSystemUtil.resolveSymLink((String)root), (Map)result2));
        return result2;
    }

    private static List<String> mapPaths(Map<String, String> resolvedPaths, List<String> paths, Collection<Pair<String, String>> mapping) {
        ArrayList canonicalPaths = ContainerUtil.newArrayList(paths);
        for (int i = 0; i < paths.size(); ++i) {
            String path = paths.get(i);
            String canonicalPath = resolvedPaths.get(path);
            if (canonicalPath == null || path.equals(canonicalPath)) continue;
            canonicalPaths.set(i, canonicalPath);
            mapping.add((Pair<String, String>)Pair.pair((Object)canonicalPath, (Object)path));
        }
        return canonicalPaths;
    }

    public List<String> getCanonicalRecursiveWatchRoots() {
        return this.myCanonicalRecursiveWatchRoots;
    }

    public List<String> getCanonicalFlatWatchRoots() {
        return this.myCanonicalFlatWatchRoots;
    }

    public void addMapping(@NotNull Collection<Pair<String, String>> mapping) {
        if (mapping == null) {
            CanonicalPathMap.$$$reportNull$$$0(2);
        }
        for (Pair<String, String> pair2 : mapping) {
            Collection preRemapPathToWatchedPaths = this.myPathMapping.get(pair2.second);
            for (String realWatchedPath : preRemapPathToWatchedPaths) {
                Collection remappedPathMappings = this.myPathMapping.getModifiable(pair2.first);
                remappedPathMappings.add(realWatchedPath);
            }
            Collection symLinksToCanonicalPath = this.myPathMapping.getModifiable(pair2.first);
            symLinksToCanonicalPath.add(pair2.second);
        }
    }

    @NotNull
    public Collection<String> getWatchedPaths(@NotNull String reportedPath, boolean isExact) {
        if (reportedPath == null) {
            CanonicalPathMap.$$$reportNull$$$0(3);
        }
        if (this.myFlatWatchRoots.isEmpty() && this.myRecursiveWatchRoots.isEmpty()) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                CanonicalPathMap.$$$reportNull$$$0(4);
            }
            return list2;
        }
        Collection<String> affectedPaths = this.applyMapping(reportedPath);
        List changedPaths = ContainerUtil.newSmartList();
        block0: for (String path : affectedPaths) {
            String rootParent;
            for (String root : this.myFlatWatchRoots) {
                if (FileUtil.namesEqual((String)path, (String)root)) {
                    changedPaths.add(path);
                    continue block0;
                }
                if (isExact) {
                    String parentPath = new File(path).getParent();
                    if (parentPath == null || !FileUtil.namesEqual((String)parentPath, (String)root)) continue;
                    changedPaths.add(path);
                    continue block0;
                }
                rootParent = new File(root).getParent();
                if (rootParent == null || !FileUtil.namesEqual((String)path, (String)rootParent)) continue;
                changedPaths.add(root);
            }
            for (String root : this.myRecursiveWatchRoots) {
                if (FileUtil.startsWith((String)path, (String)root)) {
                    changedPaths.add(path);
                    continue block0;
                }
                if (isExact || (rootParent = new File(root).getParent()) == null || !FileUtil.namesEqual((String)path, (String)rootParent)) continue;
                changedPaths.add(root);
            }
        }
        if (changedPaths.isEmpty() && LOG.isDebugEnabled()) {
            LOG.debug("Not watchable, filtered: " + reportedPath);
        }
        List list3 = changedPaths;
        if (list3 == null) {
            CanonicalPathMap.$$$reportNull$$$0(5);
        }
        return list3;
    }

    private Collection<String> applyMapping(String reportedPath) {
        List results = ContainerUtil.newSmartList((Object)reportedPath);
        List pathComponents = FileUtil.splitPath((String)reportedPath);
        File runningPath = null;
        for (int i = 0; i < pathComponents.size(); ++i) {
            String currentPathComponent = (String)pathComponents.get(i);
            runningPath = runningPath == null ? new File(currentPathComponent.isEmpty() ? "/" : currentPathComponent) : new File(runningPath, currentPathComponent);
            Collection mappedPaths = this.myPathMapping.get((Object)runningPath.getPath());
            for (String mappedPath : mappedPaths) {
                String fileSuffix = StringUtil.join(pathComponents.subList(i + 1, pathComponents.size()), (String)File.separator);
                results.add(new File(mappedPath, fileSuffix).getPath());
            }
        }
        return results;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recursive";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flat";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reportedPath";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/local/CanonicalPathMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/local/CanonicalPathMap";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getWatchedPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addMapping";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getWatchedPaths";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

