/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.impl.commands.FinalizableCommand;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CommandProcessor
implements Runnable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.wm.impl.CommandProcessor");
    private final Object myLock = new Object();
    private final List<CommandGroup> myCommandGroupList = new ArrayList<CommandGroup>();
    private int myCommandCount;
    private boolean myFlushed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getCommandCount() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myCommandCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Object object = this.myLock;
        synchronized (object) {
            this.myFlushed = true;
            while (this.run(true)) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(@NotNull List<FinalizableCommand> commandList, @NotNull Condition expired) {
        if (commandList == null) {
            CommandProcessor.$$$reportNull$$$0(0);
        }
        if (expired == null) {
            CommandProcessor.$$$reportNull$$$0(1);
        }
        Object object = this.myLock;
        synchronized (object) {
            boolean isBusy = this.myCommandCount > 0 || !this.myFlushed;
            CommandGroup commandGroup = new CommandGroup(commandList, expired);
            this.myCommandGroupList.add(commandGroup);
            this.myCommandCount += commandList.size();
            if (!isBusy) {
                this.run(false);
            }
        }
    }

    @Override
    public final void run() {
        while (this.run(true)) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean run(boolean synchronously) {
        Object object = this.myLock;
        synchronized (object) {
            Condition expire;
            CommandGroup commandGroup = this.getNextCommandGroup();
            if (commandGroup == null || commandGroup.isEmpty()) {
                return false;
            }
            Condition conditionForGroup = commandGroup.getExpireCondition();
            FinalizableCommand command = commandGroup.takeNextCommand();
            --this.myCommandCount;
            Condition condition2 = expire = command.getExpireCondition() != null ? command.getExpireCondition() : conditionForGroup;
            if (expire == null) {
                expire = ApplicationManager.getApplication().getDisposed();
            }
            if (expire.value(null)) {
                return true;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("CommandProcessor.run " + command);
            }
            if (synchronously) {
                command.run();
                return true;
            }
            boolean queueNext = this.myCommandCount > 0;
            Application application = ApplicationManager.getApplication();
            ModalityState modalityState = Registry.is((String)"ide.perProjectModality") ? ModalityState.current() : ModalityState.NON_MODAL;
            application.getInvokator().invokeLater((Runnable)command, modalityState, expire).doWhenDone(() -> {
                if (queueNext) {
                    this.run(false);
                }
            });
            return true;
        }
    }

    @Nullable
    private CommandGroup getNextCommandGroup() {
        while (!this.myCommandGroupList.isEmpty()) {
            CommandGroup candidate = this.myCommandGroupList.get(0);
            if (!candidate.isEmpty()) {
                return candidate;
            }
            this.myCommandGroupList.remove(candidate);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "commandList";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "expired";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/wm/impl/CommandProcessor";
        objectArray[2] = "execute";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CommandGroup {
        private final List<FinalizableCommand> myList;
        private Condition myExpireCondition;

        private CommandGroup(@NotNull List<FinalizableCommand> list2, @NotNull Condition expireCondition) {
            if (list2 == null) {
                CommandGroup.$$$reportNull$$$0(0);
            }
            if (expireCondition == null) {
                CommandGroup.$$$reportNull$$$0(1);
            }
            this.myList = list2;
            this.myExpireCondition = expireCondition;
        }

        public Condition getExpireCondition() {
            return this.myExpireCondition;
        }

        public boolean isEmpty() {
            return this.myList.isEmpty();
        }

        public FinalizableCommand takeNextCommand() {
            FinalizableCommand command = this.myList.remove(0);
            if (this.isEmpty()) {
                this.myExpireCondition = Conditions.alwaysTrue();
            }
            return command;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "list";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "expireCondition";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/wm/impl/CommandProcessor$CommandGroup";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

