/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.RemoteDesktopService;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.InternalDecorator;
import com.intellij.openapi.wm.impl.Stripe;
import com.intellij.openapi.wm.impl.StripeButton;
import com.intellij.openapi.wm.impl.Surface;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.openapi.wm.impl.WindowInfoImpl;
import com.intellij.openapi.wm.impl.commands.FinalizableCommand;
import com.intellij.reference.SoftReference;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ToolWindowsPane
extends JBLayeredPane
implements UISettingsListener,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.wm.impl.ToolWindowsPane");
    private final IdeFrameImpl myFrame;
    private final HashMap<String, StripeButton> myId2Button;
    private final HashMap<String, InternalDecorator> myId2Decorator;
    private final HashMap<StripeButton, WindowInfoImpl> myButton2Info;
    private final HashMap<InternalDecorator, WindowInfoImpl> myDecorator2Info;
    private final HashMap<String, Float> myId2SplitProportion;
    private Pair<ToolWindow, Integer> myMaximizedProportion;
    private final MyLayeredPane myLayeredPane;
    private final ThreeComponentsSplitter myVerticalSplitter;
    private final ThreeComponentsSplitter myHorizontalSplitter;
    private final Stripe myLeftStripe;
    private final Stripe myRightStripe;
    private final Stripe myBottomStripe;
    private final Stripe myTopStripe;
    private final List<Stripe> myStripes;
    private final ToolWindowManagerImpl myManager;
    private boolean myStripesOverlayed;
    private boolean myWidescreen;
    private boolean myLeftHorizontalSplit;
    private boolean myRightHorizontalSplit;

    ToolWindowsPane(@NotNull IdeFrameImpl frame, @NotNull ToolWindowManagerImpl manager) {
        if (frame == null) {
            ToolWindowsPane.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            ToolWindowsPane.$$$reportNull$$$0(1);
        }
        this.myId2Button = new HashMap();
        this.myId2Decorator = new HashMap();
        this.myButton2Info = new HashMap();
        this.myDecorator2Info = new HashMap();
        this.myId2SplitProportion = new HashMap();
        this.myStripes = new ArrayList<Stripe>();
        this.myManager = manager;
        this.setOpaque(false);
        this.myFrame = frame;
        this.myVerticalSplitter = new ThreeComponentsSplitter(true);
        Disposer.register((Disposable)this, (Disposable)this.myVerticalSplitter);
        this.myVerticalSplitter.setDividerWidth(0);
        this.myVerticalSplitter.setDividerMouseZoneSize(Registry.intValue((String)"ide.splitter.mouseZone"));
        this.myVerticalSplitter.setBackground(Color.gray);
        this.myHorizontalSplitter = new ThreeComponentsSplitter(false);
        Disposer.register((Disposable)this, (Disposable)this.myHorizontalSplitter);
        this.myHorizontalSplitter.setDividerWidth(0);
        this.myHorizontalSplitter.setDividerMouseZoneSize(Registry.intValue((String)"ide.splitter.mouseZone"));
        this.myHorizontalSplitter.setBackground(Color.gray);
        this.myWidescreen = UISettings.getInstance().getWideScreenSupport();
        this.myLeftHorizontalSplit = UISettings.getInstance().getLeftHorizontalSplit();
        this.myRightHorizontalSplit = UISettings.getInstance().getRightHorizontalSplit();
        if (this.myWidescreen) {
            this.myHorizontalSplitter.setInnerComponent((JComponent)this.myVerticalSplitter);
        } else {
            this.myVerticalSplitter.setInnerComponent((JComponent)this.myHorizontalSplitter);
        }
        this.myTopStripe = new Stripe(1, manager);
        this.myStripes.add(this.myTopStripe);
        this.myLeftStripe = new Stripe(2, manager);
        this.myStripes.add(this.myLeftStripe);
        this.myBottomStripe = new Stripe(3, manager);
        this.myStripes.add(this.myBottomStripe);
        this.myRightStripe = new Stripe(4, manager);
        this.myStripes.add(this.myRightStripe);
        this.updateToolStripesVisibility();
        this.myLayeredPane = new MyLayeredPane((JComponent)(this.myWidescreen ? this.myHorizontalSplitter : this.myVerticalSplitter));
        this.add(this.myTopStripe, JLayeredPane.POPUP_LAYER);
        this.add(this.myLeftStripe, JLayeredPane.POPUP_LAYER);
        this.add(this.myBottomStripe, JLayeredPane.POPUP_LAYER);
        this.add(this.myRightStripe, JLayeredPane.POPUP_LAYER);
        this.add((Component)((Object)this.myLayeredPane), JLayeredPane.DEFAULT_LAYER);
    }

    public void doLayout() {
        Dimension size = this.getSize();
        if (!this.myTopStripe.isVisible()) {
            this.myTopStripe.setBounds(0, 0, 0, 0);
            this.myBottomStripe.setBounds(0, 0, 0, 0);
            this.myLeftStripe.setBounds(0, 0, 0, 0);
            this.myRightStripe.setBounds(0, 0, 0, 0);
            this.myLayeredPane.setBounds(0, 0, this.getWidth(), this.getHeight());
        } else {
            Dimension topSize = this.myTopStripe.getPreferredSize();
            Dimension bottomSize = this.myBottomStripe.getPreferredSize();
            Dimension leftSize = this.myLeftStripe.getPreferredSize();
            Dimension rightSize = this.myRightStripe.getPreferredSize();
            this.myTopStripe.setBounds(0, 0, size.width, topSize.height);
            this.myLeftStripe.setBounds(0, topSize.height, leftSize.width, size.height - topSize.height - bottomSize.height);
            this.myRightStripe.setBounds(size.width - rightSize.width, topSize.height, rightSize.width, size.height - topSize.height - bottomSize.height);
            this.myBottomStripe.setBounds(0, size.height - bottomSize.height, size.width, bottomSize.height);
            if (UISettings.getInstance().getHideToolStripes() || UISettings.getInstance().getPresentationMode()) {
                this.myLayeredPane.setBounds(0, 0, size.width, size.height);
            } else {
                this.myLayeredPane.setBounds(leftSize.width, topSize.height, size.width - leftSize.width - rightSize.width, size.height - topSize.height - bottomSize.height);
            }
        }
    }

    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
    }

    public final void addNotify() {
        super.addNotify();
    }

    public Project getProject() {
        return this.myFrame.getProject();
    }

    public final void uiSettingsChanged(UISettings uiSettings) {
        this.updateToolStripesVisibility();
        this.updateLayout();
    }

    @NotNull
    final FinalizableCommand createAddButtonCmd(StripeButton button, @NotNull WindowInfoImpl info, @NotNull Comparator<StripeButton> comparator2, @NotNull Runnable finishCallBack) {
        if (info == null) {
            ToolWindowsPane.$$$reportNull$$$0(2);
        }
        if (comparator2 == null) {
            ToolWindowsPane.$$$reportNull$$$0(3);
        }
        if (finishCallBack == null) {
            ToolWindowsPane.$$$reportNull$$$0(4);
        }
        WindowInfoImpl copiedInfo = info.copy();
        this.myId2Button.put((Object)copiedInfo.getId(), (Object)button);
        this.myButton2Info.put((Object)button, (Object)copiedInfo);
        AddToolStripeButtonCmd addToolStripeButtonCmd = new AddToolStripeButtonCmd(button, copiedInfo, comparator2, finishCallBack);
        if (addToolStripeButtonCmd == null) {
            ToolWindowsPane.$$$reportNull$$$0(5);
        }
        return addToolStripeButtonCmd;
    }

    @NotNull
    final FinalizableCommand createAddDecoratorCmd(@NotNull InternalDecorator decorator, @NotNull WindowInfoImpl info, boolean dirtyMode, @NotNull Runnable finishCallBack) {
        if (decorator == null) {
            ToolWindowsPane.$$$reportNull$$$0(6);
        }
        if (info == null) {
            ToolWindowsPane.$$$reportNull$$$0(7);
        }
        if (finishCallBack == null) {
            ToolWindowsPane.$$$reportNull$$$0(8);
        }
        WindowInfoImpl copiedInfo = info.copy();
        String id = copiedInfo.getId();
        this.myDecorator2Info.put((Object)decorator, (Object)copiedInfo);
        this.myId2Decorator.put((Object)id, (Object)decorator);
        if (info.isDocked()) {
            WindowInfoImpl sideInfo = this.getDockedInfoAt(info.getAnchor(), !info.isSplit());
            if (sideInfo == null) {
                AddDockedComponentCmd addDockedComponentCmd = new AddDockedComponentCmd(decorator, info, dirtyMode, finishCallBack);
                if (addDockedComponentCmd == null) {
                    ToolWindowsPane.$$$reportNull$$$0(9);
                }
                return addDockedComponentCmd;
            }
            AddAndSplitDockedComponentCmd addAndSplitDockedComponentCmd = new AddAndSplitDockedComponentCmd(decorator, info, dirtyMode, finishCallBack);
            if (addAndSplitDockedComponentCmd == null) {
                ToolWindowsPane.$$$reportNull$$$0(10);
            }
            return addAndSplitDockedComponentCmd;
        }
        if (info.isSliding()) {
            AddSlidingComponentCmd addSlidingComponentCmd = new AddSlidingComponentCmd(decorator, info, dirtyMode, finishCallBack);
            if (addSlidingComponentCmd == null) {
                ToolWindowsPane.$$$reportNull$$$0(11);
            }
            return addSlidingComponentCmd;
        }
        throw new IllegalArgumentException("Unknown window type: " + info.getType());
    }

    @NotNull
    final FinalizableCommand createRemoveButtonCmd(@NotNull String id, @NotNull Runnable finishCallBack) {
        if (id == null) {
            ToolWindowsPane.$$$reportNull$$$0(12);
        }
        if (finishCallBack == null) {
            ToolWindowsPane.$$$reportNull$$$0(13);
        }
        StripeButton button = this.getButtonById(id);
        WindowInfoImpl info = this.getButtonInfoById(id);
        this.myButton2Info.remove((Object)button);
        this.myId2Button.remove((Object)id);
        RemoveToolStripeButtonCmd removeToolStripeButtonCmd = new RemoveToolStripeButtonCmd(button, info, finishCallBack);
        if (removeToolStripeButtonCmd == null) {
            ToolWindowsPane.$$$reportNull$$$0(14);
        }
        return removeToolStripeButtonCmd;
    }

    @NotNull
    final FinalizableCommand createRemoveDecoratorCmd(@NotNull String id, boolean dirtyMode, @NotNull Runnable finishCallBack) {
        if (id == null) {
            ToolWindowsPane.$$$reportNull$$$0(15);
        }
        if (finishCallBack == null) {
            ToolWindowsPane.$$$reportNull$$$0(16);
        }
        Component decorator = this.getDecoratorById(id);
        WindowInfoImpl info = this.getDecoratorInfoById(id);
        this.myDecorator2Info.remove((Object)decorator);
        this.myId2Decorator.remove((Object)id);
        WindowInfoImpl sideInfo = this.getDockedInfoAt(info.getAnchor(), !info.isSplit());
        if (info.isDocked()) {
            if (sideInfo == null) {
                RemoveDockedComponentCmd removeDockedComponentCmd = new RemoveDockedComponentCmd(info, dirtyMode, finishCallBack);
                if (removeDockedComponentCmd == null) {
                    ToolWindowsPane.$$$reportNull$$$0(17);
                }
                return removeDockedComponentCmd;
            }
            RemoveSplitAndDockedComponentCmd removeSplitAndDockedComponentCmd = new RemoveSplitAndDockedComponentCmd(info, dirtyMode, finishCallBack);
            if (removeSplitAndDockedComponentCmd == null) {
                ToolWindowsPane.$$$reportNull$$$0(18);
            }
            return removeSplitAndDockedComponentCmd;
        }
        if (info.isSliding()) {
            RemoveSlidingComponentCmd removeSlidingComponentCmd = new RemoveSlidingComponentCmd(decorator, info, dirtyMode, finishCallBack);
            if (removeSlidingComponentCmd == null) {
                ToolWindowsPane.$$$reportNull$$$0(19);
            }
            return removeSlidingComponentCmd;
        }
        throw new IllegalArgumentException("Unknown window type");
    }

    @NotNull
    final FinalizableCommand createSetEditorComponentCmd(JComponent component, @NotNull Runnable finishCallBack) {
        if (finishCallBack == null) {
            ToolWindowsPane.$$$reportNull$$$0(20);
        }
        SetEditorComponentCmd setEditorComponentCmd = new SetEditorComponentCmd(component, finishCallBack);
        if (setEditorComponentCmd == null) {
            ToolWindowsPane.$$$reportNull$$$0(21);
        }
        return setEditorComponentCmd;
    }

    @NotNull
    final FinalizableCommand createUpdateButtonPositionCmd(@NotNull String id, @NotNull Runnable finishCallback) {
        if (id == null) {
            ToolWindowsPane.$$$reportNull$$$0(22);
        }
        if (finishCallback == null) {
            ToolWindowsPane.$$$reportNull$$$0(23);
        }
        UpdateButtonPositionCmd updateButtonPositionCmd = new UpdateButtonPositionCmd(id, finishCallback);
        if (updateButtonPositionCmd == null) {
            ToolWindowsPane.$$$reportNull$$$0(24);
        }
        return updateButtonPositionCmd;
    }

    @NotNull
    public final JComponent getMyLayeredPane() {
        MyLayeredPane myLayeredPane = this.myLayeredPane;
        if (myLayeredPane == null) {
            ToolWindowsPane.$$$reportNull$$$0(25);
        }
        return myLayeredPane;
    }

    @Nullable
    private StripeButton getButtonById(String id) {
        return (StripeButton)this.myId2Button.get((Object)id);
    }

    private Component getDecoratorById(String id) {
        return (Component)this.myId2Decorator.get((Object)id);
    }

    private WindowInfoImpl getButtonInfoById(String id) {
        return (WindowInfoImpl)this.myButton2Info.get(this.myId2Button.get((Object)id));
    }

    private WindowInfoImpl getDecoratorInfoById(String id) {
        return (WindowInfoImpl)this.myDecorator2Info.get(this.myId2Decorator.get((Object)id));
    }

    private void setComponent(JComponent component, @NotNull ToolWindowAnchor anchor, float weight) {
        if (anchor == null) {
            ToolWindowsPane.$$$reportNull$$$0(26);
        }
        if (ToolWindowAnchor.TOP == anchor) {
            this.myVerticalSplitter.setFirstComponent(component);
            this.myVerticalSplitter.setFirstSize((int)((float)this.myLayeredPane.getHeight() * weight));
        } else if (ToolWindowAnchor.LEFT == anchor) {
            this.myHorizontalSplitter.setFirstComponent(component);
            this.myHorizontalSplitter.setFirstSize((int)((float)this.myLayeredPane.getWidth() * weight));
        } else if (ToolWindowAnchor.BOTTOM == anchor) {
            this.myVerticalSplitter.setLastComponent(component);
            this.myVerticalSplitter.setLastSize((int)((float)this.myLayeredPane.getHeight() * weight));
        } else if (ToolWindowAnchor.RIGHT == anchor) {
            this.myHorizontalSplitter.setLastComponent(component);
            this.myHorizontalSplitter.setLastSize((int)((float)this.myLayeredPane.getWidth() * weight));
        } else {
            LOG.error("unknown anchor: " + anchor);
        }
    }

    private JComponent getComponentAt(@NotNull ToolWindowAnchor anchor) {
        if (anchor == null) {
            ToolWindowsPane.$$$reportNull$$$0(27);
        }
        if (ToolWindowAnchor.TOP == anchor) {
            return this.myVerticalSplitter.getFirstComponent();
        }
        if (ToolWindowAnchor.LEFT == anchor) {
            return this.myHorizontalSplitter.getFirstComponent();
        }
        if (ToolWindowAnchor.BOTTOM == anchor) {
            return this.myVerticalSplitter.getLastComponent();
        }
        if (ToolWindowAnchor.RIGHT == anchor) {
            return this.myHorizontalSplitter.getLastComponent();
        }
        LOG.error("unknown anchor: " + anchor);
        return null;
    }

    private float getPreferredSplitProportion(@NotNull String id, float defaultValue) {
        Float f;
        if (id == null) {
            ToolWindowsPane.$$$reportNull$$$0(28);
        }
        return (f = (Float)this.myId2SplitProportion.get((Object)id)) == null ? defaultValue : f.floatValue();
    }

    private WindowInfoImpl getDockedInfoAt(@NotNull ToolWindowAnchor anchor, boolean side) {
        if (anchor == null) {
            ToolWindowsPane.$$$reportNull$$$0(29);
        }
        for (WindowInfoImpl info : this.myDecorator2Info.values()) {
            if (!info.isVisible() || !info.isDocked() || info.getAnchor() != anchor || side != info.isSplit()) continue;
            return info;
        }
        return null;
    }

    private void setDocumentComponent(JComponent component) {
        (this.myWidescreen ? this.myVerticalSplitter : this.myHorizontalSplitter).setInnerComponent(component);
    }

    private void updateToolStripesVisibility() {
        boolean oldVisible = this.myLeftStripe.isVisible();
        boolean showButtons = !UISettings.getInstance().getHideToolStripes() && !UISettings.getInstance().getPresentationMode();
        boolean visible = showButtons || this.myStripesOverlayed;
        this.myLeftStripe.setVisible(visible);
        this.myRightStripe.setVisible(visible);
        this.myTopStripe.setVisible(visible);
        this.myBottomStripe.setVisible(visible);
        boolean overlayed = !showButtons && this.myStripesOverlayed;
        this.myLeftStripe.setOverlayed(overlayed);
        this.myRightStripe.setOverlayed(overlayed);
        this.myTopStripe.setOverlayed(overlayed);
        this.myBottomStripe.setOverlayed(overlayed);
        if (oldVisible != visible) {
            this.revalidate();
            this.repaint();
        }
    }

    public int getBottomHeight() {
        return this.myBottomStripe.isVisible() ? this.myBottomStripe.getHeight() : 0;
    }

    public boolean isBottomSideToolWindowsVisible() {
        return this.getComponentAt(ToolWindowAnchor.BOTTOM) != null;
    }

    @Nullable
    Stripe getStripeFor(String id) {
        ToolWindow window = this.myManager.getToolWindow(id);
        if (window == null) {
            return null;
        }
        ToolWindowAnchor anchor = this.myManager.getToolWindow(id).getAnchor();
        if (ToolWindowAnchor.TOP == anchor) {
            return this.myTopStripe;
        }
        if (ToolWindowAnchor.BOTTOM == anchor) {
            return this.myBottomStripe;
        }
        if (ToolWindowAnchor.LEFT == anchor) {
            return this.myLeftStripe;
        }
        if (ToolWindowAnchor.RIGHT == anchor) {
            return this.myRightStripe;
        }
        throw new IllegalArgumentException("Anchor=" + anchor);
    }

    @Nullable
    Stripe getStripeFor(@NotNull Rectangle screenRec, @NotNull Stripe preferred) {
        if (screenRec == null) {
            ToolWindowsPane.$$$reportNull$$$0(30);
        }
        if (preferred == null) {
            ToolWindowsPane.$$$reportNull$$$0(31);
        }
        if (preferred.containsScreen(screenRec)) {
            return this.myStripes.get(this.myStripes.indexOf(preferred));
        }
        for (Stripe each : this.myStripes) {
            if (!each.containsScreen(screenRec)) continue;
            return this.myStripes.get(this.myStripes.indexOf(each));
        }
        return null;
    }

    void startDrag() {
        for (Stripe each : this.myStripes) {
            each.startDrag();
        }
    }

    void stopDrag() {
        for (Stripe each : this.myStripes) {
            each.stopDrag();
        }
    }

    void stretchWidth(@NotNull ToolWindow wnd, int value2) {
        if (wnd == null) {
            ToolWindowsPane.$$$reportNull$$$0(32);
        }
        this.stretch(wnd, value2);
    }

    void stretchHeight(@NotNull ToolWindow wnd, int value2) {
        if (wnd == null) {
            ToolWindowsPane.$$$reportNull$$$0(33);
        }
        this.stretch(wnd, value2);
    }

    private void stretch(@NotNull ToolWindow wnd, int value2) {
        Pair<Resizer, Component> pair2;
        if (wnd == null) {
            ToolWindowsPane.$$$reportNull$$$0(34);
        }
        if ((pair2 = this.findResizerAndComponent(wnd)) == null) {
            return;
        }
        boolean vertical = wnd.getAnchor() == ToolWindowAnchor.TOP || wnd.getAnchor() == ToolWindowAnchor.BOTTOM;
        int actualSize = (vertical ? ((Component)pair2.second).getHeight() : ((Component)pair2.second).getWidth()) + value2;
        boolean first = wnd.getAnchor() == ToolWindowAnchor.LEFT || wnd.getAnchor() == ToolWindowAnchor.TOP;
        int maxValue = vertical ? this.myVerticalSplitter.getMaxSize(first) : this.myHorizontalSplitter.getMaxSize(first);
        int minValue = vertical ? this.myVerticalSplitter.getMinSize(first) : this.myHorizontalSplitter.getMinSize(first);
        ((Resizer)pair2.first).setSize(Math.max(minValue, Math.min(maxValue, actualSize)));
    }

    @Nullable
    private Pair<Resizer, Component> findResizerAndComponent(@NotNull ToolWindow wnd) {
        if (wnd == null) {
            ToolWindowsPane.$$$reportNull$$$0(35);
        }
        if (!wnd.isVisible()) {
            return null;
        }
        Resizer resizer = null;
        Container cmp = null;
        if (wnd.getType() == ToolWindowType.DOCKED) {
            cmp = this.getComponentAt(wnd.getAnchor());
            if (cmp != null) {
                resizer = wnd.getAnchor().isHorizontal() ? (this.myVerticalSplitter.getFirstComponent() == cmp ? new Resizer.Splitter.FirstComponent(this.myVerticalSplitter) : new Resizer.Splitter.LastComponent(this.myVerticalSplitter)) : (this.myHorizontalSplitter.getFirstComponent() == cmp ? new Resizer.Splitter.FirstComponent(this.myHorizontalSplitter) : new Resizer.Splitter.LastComponent(this.myHorizontalSplitter));
            }
        } else if (wnd.getType() == ToolWindowType.SLIDING) {
            for (cmp = wnd.getComponent(); cmp != null && cmp.getParent() != this.myLayeredPane; cmp = cmp.getParent()) {
            }
            if (cmp != null) {
                if (wnd.getAnchor() == ToolWindowAnchor.TOP) {
                    resizer = new Resizer.LayeredPane.Top(cmp);
                } else if (wnd.getAnchor() == ToolWindowAnchor.BOTTOM) {
                    resizer = new Resizer.LayeredPane.Bottom(cmp);
                } else if (wnd.getAnchor() == ToolWindowAnchor.LEFT) {
                    resizer = new Resizer.LayeredPane.Left(cmp);
                } else if (wnd.getAnchor() == ToolWindowAnchor.RIGHT) {
                    resizer = new Resizer.LayeredPane.Right(cmp);
                }
            }
        }
        return resizer != null ? Pair.create(resizer, (Object)cmp) : null;
    }

    private void updateLayout() {
        InternalDecorator second;
        InternalDecorator first;
        Splitter splitter;
        JComponent component;
        UISettings uiSettings = UISettings.getInstance();
        if (this.myWidescreen != uiSettings.getWideScreenSupport()) {
            JComponent documentComponent = (this.myWidescreen ? this.myVerticalSplitter : this.myHorizontalSplitter).getInnerComponent();
            this.myWidescreen = uiSettings.getWideScreenSupport();
            if (this.myWidescreen) {
                this.myVerticalSplitter.setInnerComponent(null);
                this.myHorizontalSplitter.setInnerComponent((JComponent)this.myVerticalSplitter);
            } else {
                this.myHorizontalSplitter.setInnerComponent(null);
                this.myVerticalSplitter.setInnerComponent((JComponent)this.myHorizontalSplitter);
            }
            this.myLayeredPane.remove((Component)(this.myWidescreen ? this.myVerticalSplitter : this.myHorizontalSplitter));
            this.myLayeredPane.add((Component)(this.myWidescreen ? this.myHorizontalSplitter : this.myVerticalSplitter), DEFAULT_LAYER);
            this.setDocumentComponent(documentComponent);
        }
        if (this.myLeftHorizontalSplit != uiSettings.getLeftHorizontalSplit()) {
            component = this.getComponentAt(ToolWindowAnchor.LEFT);
            if (component instanceof Splitter) {
                splitter = (Splitter)component;
                first = (InternalDecorator)splitter.getFirstComponent();
                second = (InternalDecorator)splitter.getSecondComponent();
                this.setComponent((JComponent)splitter, ToolWindowAnchor.LEFT, ToolWindowAnchor.LEFT.isSplitVertically() ? first.getWindowInfo().getWeight() : first.getWindowInfo().getWeight() + second.getWindowInfo().getWeight());
            }
            this.myLeftHorizontalSplit = uiSettings.getLeftHorizontalSplit();
        }
        if (this.myRightHorizontalSplit != uiSettings.getRightHorizontalSplit()) {
            component = this.getComponentAt(ToolWindowAnchor.RIGHT);
            if (component instanceof Splitter) {
                splitter = (Splitter)component;
                first = (InternalDecorator)splitter.getFirstComponent();
                second = (InternalDecorator)splitter.getSecondComponent();
                this.setComponent((JComponent)splitter, ToolWindowAnchor.RIGHT, ToolWindowAnchor.RIGHT.isSplitVertically() ? first.getWindowInfo().getWeight() : first.getWindowInfo().getWeight() + second.getWindowInfo().getWeight());
            }
            this.myRightHorizontalSplit = uiSettings.getRightHorizontalSplit();
        }
    }

    public boolean isMaximized(@NotNull ToolWindow wnd) {
        if (wnd == null) {
            ToolWindowsPane.$$$reportNull$$$0(36);
        }
        return this.myMaximizedProportion != null && this.myMaximizedProportion.first == wnd;
    }

    void setMaximized(@NotNull ToolWindow wnd, boolean maximized) {
        Pair<Resizer, Component> resizerAndComponent;
        if (wnd == null) {
            ToolWindowsPane.$$$reportNull$$$0(37);
        }
        if ((resizerAndComponent = this.findResizerAndComponent(wnd)) == null) {
            return;
        }
        if (!maximized) {
            ToolWindow maximizedWindow = (ToolWindow)this.myMaximizedProportion.first;
            assert (maximizedWindow == wnd);
            ((Resizer)resizerAndComponent.first).setSize((Integer)this.myMaximizedProportion.second);
            this.myMaximizedProportion = null;
        } else {
            int size = wnd.getAnchor().isHorizontal() ? ((Component)resizerAndComponent.second).getHeight() : ((Component)resizerAndComponent.second).getWidth();
            this.stretch(wnd, Short.MAX_VALUE);
            this.myMaximizedProportion = Pair.create((Object)wnd, (Object)size);
        }
        this.doLayout();
    }

    void setStripesOverlayed(boolean stripesOverlayed) {
        this.myStripesOverlayed = stripesOverlayed;
        this.updateToolStripesVisibility();
    }

    public void dispose() {
    }

    private static float normalizeWeigh(float weight) {
        if (weight <= 0.0f) {
            return 0.33f;
        }
        if (weight >= 1.0f) {
            return 0.66999996f;
        }
        return weight;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 4: 
            case 8: 
            case 13: 
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finishCallBack";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/ToolWindowsPane";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
            case 12: 
            case 15: 
            case 22: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finishCallback";
                break;
            }
            case 26: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenRec";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferred";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wnd";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/ToolWindowsPane";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createAddButtonCmd";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createAddDecoratorCmd";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createRemoveButtonCmd";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createRemoveDecoratorCmd";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createSetEditorComponentCmd";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createUpdateButtonPositionCmd";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getMyLayeredPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createAddButtonCmd";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 24: 
            case 25: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createAddDecoratorCmd";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createRemoveButtonCmd";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createRemoveDecoratorCmd";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createSetEditorComponentCmd";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createUpdateButtonPositionCmd";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setComponent";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getComponentAt";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getPreferredSplitProportion";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getDockedInfoAt";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getStripeFor";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "stretchWidth";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "stretchHeight";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "stretch";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "findResizerAndComponent";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isMaximized";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "setMaximized";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class MyLayeredPane
    extends JBLayeredPane {
        private Reference<BufferedImage> myBottomImageRef;
        private Reference<BufferedImage> myTopImageRef;

        public MyLayeredPane(JComponent splitter) {
            if (splitter == null) {
                MyLayeredPane.$$$reportNull$$$0(0);
            }
            this.setOpaque(false);
            this.add(splitter, JLayeredPane.DEFAULT_LAYER);
        }

        final Image getBottomImage() {
            Pair<BufferedImage, Reference<BufferedImage>> result2 = this.getImage(this.myBottomImageRef);
            this.myBottomImageRef = (Reference)result2.second;
            return (Image)result2.first;
        }

        final Image getTopImage() {
            Pair<BufferedImage, Reference<BufferedImage>> result2 = this.getImage(this.myTopImageRef);
            this.myTopImageRef = (Reference)result2.second;
            return (Image)result2.first;
        }

        @NotNull
        private Pair<BufferedImage, Reference<BufferedImage>> getImage(@Nullable Reference<BufferedImage> imageRef) {
            LOG.assertTrue(UISettings.getInstance().getAnimateWindows());
            BufferedImage image = (BufferedImage)SoftReference.dereference(imageRef);
            if (image == null || image.getWidth(null) < this.getWidth() || image.getHeight(null) < this.getHeight()) {
                int width = Math.max(Math.max(1, this.getWidth()), ToolWindowsPane.this.myFrame.getWidth());
                int height = Math.max(Math.max(1, this.getHeight()), ToolWindowsPane.this.myFrame.getHeight());
                image = SystemInfo.isWindows ? ToolWindowsPane.this.myFrame.getGraphicsConfiguration().createCompatibleImage(width, height) : UIUtil.createImage((Graphics)this.getGraphics(), (int)width, (int)height, (int)1);
                imageRef = new SoftReference((Object)image);
            }
            Pair pair2 = Pair.create((Object)image, imageRef);
            if (pair2 == null) {
                MyLayeredPane.$$$reportNull$$$0(1);
            }
            return pair2;
        }

        public void doLayout() {
            int width = this.getWidth();
            int height = this.getHeight();
            if (width < 0 || height < 0) {
                return;
            }
            Component[] components = this.getComponentsInLayer(JLayeredPane.DEFAULT_LAYER);
            LOG.assertTrue(components.length <= 1);
            for (Component component : components) {
                component.setBounds(0, 0, this.getWidth(), this.getHeight());
            }
            for (Component component : components = this.getComponentsInLayer(JLayeredPane.PALETTE_LAYER)) {
                WindowInfoImpl info;
                if (!(component instanceof InternalDecorator) || (info = (WindowInfoImpl)ToolWindowsPane.this.myDecorator2Info.get((Object)component)) == null) continue;
                float weight = info.getAnchor().isHorizontal() ? (float)component.getHeight() / (float)this.getHeight() : (float)component.getWidth() / (float)this.getWidth();
                this.setBoundsInPaletteLayer(component, info.getAnchor(), weight);
            }
        }

        final void setBoundsInPaletteLayer(@NotNull Component component, @NotNull ToolWindowAnchor anchor, float weight) {
            if (component == null) {
                MyLayeredPane.$$$reportNull$$$0(2);
            }
            if (anchor == null) {
                MyLayeredPane.$$$reportNull$$$0(3);
            }
            if (weight < 0.0f) {
                weight = 0.33f;
            } else if (weight > 1.0f) {
                weight = 1.0f;
            }
            if (ToolWindowAnchor.TOP == anchor) {
                component.setBounds(0, 0, this.getWidth(), (int)((float)this.getHeight() * weight + 0.5f));
            } else if (ToolWindowAnchor.LEFT == anchor) {
                component.setBounds(0, 0, (int)((float)this.getWidth() * weight + 0.5f), this.getHeight());
            } else if (ToolWindowAnchor.BOTTOM == anchor) {
                int height = (int)((float)this.getHeight() * weight + 0.5f);
                component.setBounds(0, this.getHeight() - height, this.getWidth(), height);
            } else if (ToolWindowAnchor.RIGHT == anchor) {
                int width = (int)((float)this.getWidth() * weight + 0.5f);
                component.setBounds(this.getWidth() - width, 0, width, this.getHeight());
            } else {
                LOG.error("unknown anchor " + anchor);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "splitter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/wm/impl/ToolWindowsPane$MyLayeredPane";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/wm/impl/ToolWindowsPane$MyLayeredPane";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getImage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setBoundsInPaletteLayer";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class UpdateButtonPositionCmd
    extends FinalizableCommand {
        private final String myId;

        private UpdateButtonPositionCmd(@NotNull String id, Runnable finishCallBack) {
            if (id == null) {
                UpdateButtonPositionCmd.$$$reportNull$$$0(0);
            }
            if (finishCallBack == null) {
                UpdateButtonPositionCmd.$$$reportNull$$$0(1);
            }
            super(finishCallBack);
            this.myId = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                StripeButton stripeButton = ToolWindowsPane.this.getButtonById(this.myId);
                if (stripeButton == null) {
                    return;
                }
                WindowInfoImpl info = stripeButton.getWindowInfo();
                ToolWindowAnchor anchor = info.getAnchor();
                if (ToolWindowAnchor.TOP == anchor) {
                    ToolWindowsPane.this.myTopStripe.revalidate();
                } else if (ToolWindowAnchor.LEFT == anchor) {
                    ToolWindowsPane.this.myLeftStripe.revalidate();
                } else if (ToolWindowAnchor.BOTTOM == anchor) {
                    ToolWindowsPane.this.myBottomStripe.revalidate();
                } else if (ToolWindowAnchor.RIGHT == anchor) {
                    ToolWindowsPane.this.myRightStripe.revalidate();
                } else {
                    LOG.error("unknown anchor: " + anchor);
                }
            }
            finally {
                this.finish();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "id";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "finishCallBack";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/wm/impl/ToolWindowsPane$UpdateButtonPositionCmd";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class SetEditorComponentCmd
    extends FinalizableCommand {
        private final JComponent myComponent;

        public SetEditorComponentCmd(@NotNull JComponent component, Runnable finishCallBack) {
            if (finishCallBack == null) {
                SetEditorComponentCmd.$$$reportNull$$$0(0);
            }
            super(finishCallBack);
            this.myComponent = component;
        }

        @Override
        public void run() {
            try {
                ToolWindowsPane.this.setDocumentComponent(this.myComponent);
                ToolWindowsPane.this.myLayeredPane.validate();
                ToolWindowsPane.this.myLayeredPane.repaint();
            }
            finally {
                this.finish();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "finishCallBack", "com/intellij/openapi/wm/impl/ToolWindowsPane$SetEditorComponentCmd", "<init>"));
        }
    }

    private final class RemoveSlidingComponentCmd
    extends FinalizableCommand {
        private final Component myComponent;
        private final WindowInfoImpl myInfo;
        private final boolean myDirtyMode;

        public RemoveSlidingComponentCmd(@NotNull Component component, WindowInfoImpl info, @NotNull boolean dirtyMode, Runnable finishCallBack) {
            if (info == null) {
                RemoveSlidingComponentCmd.$$$reportNull$$$0(0);
            }
            if (finishCallBack == null) {
                RemoveSlidingComponentCmd.$$$reportNull$$$0(1);
            }
            super(finishCallBack);
            this.myComponent = component;
            this.myInfo = info;
            this.myDirtyMode = dirtyMode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            try {
                UISettings uiSettings = UISettings.getInstance();
                if (!this.myDirtyMode && uiSettings.getAnimateWindows() && !RemoteDesktopService.isRemoteSession()) {
                    Rectangle bounds = this.myComponent.getBounds();
                    Image topImage = ToolWindowsPane.this.myLayeredPane.getTopImage();
                    Graphics topGraphics = topImage.getGraphics();
                    try {
                        this.myComponent.paint(topGraphics);
                    }
                    finally {
                        topGraphics.dispose();
                    }
                    Image bottomImage = ToolWindowsPane.this.myLayeredPane.getBottomImage();
                    Graphics bottomGraphics = bottomImage.getGraphics();
                    try {
                        ToolWindowsPane.this.myLayeredPane.remove(this.myComponent);
                        bottomGraphics.clipRect(0, 0, bounds.width, bounds.height);
                        bottomGraphics.translate(-bounds.x, -bounds.y);
                        ToolWindowsPane.this.myLayeredPane.paint(bottomGraphics);
                    }
                    finally {
                        bottomGraphics.dispose();
                    }
                    Surface surface = new Surface(topImage, bottomImage, -1, this.myInfo.getAnchor(), 300);
                    ToolWindowsPane.this.myLayeredPane.add(surface, JLayeredPane.PALETTE_LAYER);
                    surface.setBounds(bounds);
                    ToolWindowsPane.this.myLayeredPane.validate();
                    ToolWindowsPane.this.myLayeredPane.repaint();
                    surface.runMovement();
                    ToolWindowsPane.this.myLayeredPane.remove(surface);
                } else {
                    ToolWindowsPane.this.myLayeredPane.remove(this.myComponent);
                }
                if (!this.myDirtyMode) {
                    ToolWindowsPane.this.myLayeredPane.validate();
                    ToolWindowsPane.this.myLayeredPane.repaint();
                }
            }
            finally {
                this.finish();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "info";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "finishCallBack";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/wm/impl/ToolWindowsPane$RemoveSlidingComponentCmd";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class RemoveSplitAndDockedComponentCmd
    extends FinalizableCommand {
        private final WindowInfoImpl myInfo;
        private final boolean myDirtyMode;

        private RemoveSplitAndDockedComponentCmd(WindowInfoImpl info, @NotNull boolean dirtyMode, Runnable finishCallBack) {
            if (info == null) {
                RemoveSplitAndDockedComponentCmd.$$$reportNull$$$0(0);
            }
            if (finishCallBack == null) {
                RemoveSplitAndDockedComponentCmd.$$$reportNull$$$0(1);
            }
            super(finishCallBack);
            this.myInfo = info;
            this.myDirtyMode = dirtyMode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ToolWindowAnchor anchor = this.myInfo.getAnchor();
                JComponent c = ToolWindowsPane.this.getComponentAt(anchor);
                if (c instanceof Splitter) {
                    InternalDecorator component;
                    Splitter splitter = (Splitter)c;
                    InternalDecorator internalDecorator = component = this.myInfo.isSplit() ? (InternalDecorator)splitter.getFirstComponent() : (InternalDecorator)splitter.getSecondComponent();
                    if (this.myInfo.isSplit() && component != null) {
                        ToolWindowsPane.this.myId2SplitProportion.put((Object)component.getWindowInfo().getId(), (Object)Float.valueOf(splitter.getProportion()));
                    }
                    ToolWindowsPane.this.setComponent(component, anchor, component != null ? component.getWindowInfo().getWeight() : 0.0f);
                } else {
                    ToolWindowsPane.this.setComponent(null, anchor, 0.0f);
                }
                if (!this.myDirtyMode) {
                    ToolWindowsPane.this.myLayeredPane.validate();
                    ToolWindowsPane.this.myLayeredPane.repaint();
                }
            }
            finally {
                this.finish();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "info";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "finishCallBack";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/wm/impl/ToolWindowsPane$RemoveSplitAndDockedComponentCmd";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class RemoveDockedComponentCmd
    extends FinalizableCommand {
        private final WindowInfoImpl myInfo;
        private final boolean myDirtyMode;

        public RemoveDockedComponentCmd(WindowInfoImpl info, @NotNull boolean dirtyMode, Runnable finishCallBack) {
            if (info == null) {
                RemoveDockedComponentCmd.$$$reportNull$$$0(0);
            }
            if (finishCallBack == null) {
                RemoveDockedComponentCmd.$$$reportNull$$$0(1);
            }
            super(finishCallBack);
            this.myInfo = info;
            this.myDirtyMode = dirtyMode;
        }

        @Override
        public final void run() {
            try {
                ToolWindowsPane.this.setComponent(null, this.myInfo.getAnchor(), 0.0f);
                if (!this.myDirtyMode) {
                    ToolWindowsPane.this.myLayeredPane.validate();
                    ToolWindowsPane.this.myLayeredPane.repaint();
                }
            }
            finally {
                this.finish();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "info";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "finishCallBack";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/wm/impl/ToolWindowsPane$RemoveDockedComponentCmd";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class RemoveToolStripeButtonCmd
    extends FinalizableCommand {
        private final StripeButton myButton;
        private final WindowInfoImpl myInfo;

        public RemoveToolStripeButtonCmd(@NotNull StripeButton button, @NotNull WindowInfoImpl info, Runnable finishCallBack) {
            if (button == null) {
                RemoveToolStripeButtonCmd.$$$reportNull$$$0(0);
            }
            if (info == null) {
                RemoveToolStripeButtonCmd.$$$reportNull$$$0(1);
            }
            if (finishCallBack == null) {
                RemoveToolStripeButtonCmd.$$$reportNull$$$0(2);
            }
            super(finishCallBack);
            this.myButton = button;
            this.myInfo = info;
        }

        @Override
        public final void run() {
            try {
                ToolWindowAnchor anchor = this.myInfo.getAnchor();
                if (ToolWindowAnchor.TOP == anchor) {
                    ToolWindowsPane.this.myTopStripe.removeButton(this.myButton);
                } else if (ToolWindowAnchor.LEFT == anchor) {
                    ToolWindowsPane.this.myLeftStripe.removeButton(this.myButton);
                } else if (ToolWindowAnchor.BOTTOM == anchor) {
                    ToolWindowsPane.this.myBottomStripe.removeButton(this.myButton);
                } else if (ToolWindowAnchor.RIGHT == anchor) {
                    ToolWindowsPane.this.myRightStripe.removeButton(this.myButton);
                } else {
                    LOG.error("unknown anchor: " + anchor);
                }
                ToolWindowsPane.this.validate();
                ToolWindowsPane.this.repaint();
            }
            finally {
                this.finish();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "button";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "info";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "finishCallBack";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/wm/impl/ToolWindowsPane$RemoveToolStripeButtonCmd";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class AddToolStripeButtonCmd
    extends FinalizableCommand {
        private final StripeButton myButton;
        private final WindowInfoImpl myInfo;
        private final Comparator<StripeButton> myComparator;

        public AddToolStripeButtonCmd(@NotNull StripeButton button, @NotNull WindowInfoImpl info, @NotNull Comparator<StripeButton> comparator2, Runnable finishCallBack) {
            if (info == null) {
                AddToolStripeButtonCmd.$$$reportNull$$$0(0);
            }
            if (comparator2 == null) {
                AddToolStripeButtonCmd.$$$reportNull$$$0(1);
            }
            if (finishCallBack == null) {
                AddToolStripeButtonCmd.$$$reportNull$$$0(2);
            }
            super(finishCallBack);
            this.myButton = button;
            this.myInfo = info;
            this.myComparator = comparator2;
        }

        @Override
        public final void run() {
            try {
                ToolWindowAnchor anchor = this.myInfo.getAnchor();
                if (ToolWindowAnchor.TOP == anchor) {
                    ToolWindowsPane.this.myTopStripe.addButton(this.myButton, this.myComparator);
                } else if (ToolWindowAnchor.LEFT == anchor) {
                    ToolWindowsPane.this.myLeftStripe.addButton(this.myButton, this.myComparator);
                } else if (ToolWindowAnchor.BOTTOM == anchor) {
                    ToolWindowsPane.this.myBottomStripe.addButton(this.myButton, this.myComparator);
                } else if (ToolWindowAnchor.RIGHT == anchor) {
                    ToolWindowsPane.this.myRightStripe.addButton(this.myButton, this.myComparator);
                } else {
                    LOG.error("unknown anchor: " + anchor);
                }
                ToolWindowsPane.this.validate();
                ToolWindowsPane.this.repaint();
            }
            finally {
                this.finish();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "info";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "comparator";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "finishCallBack";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/wm/impl/ToolWindowsPane$AddToolStripeButtonCmd";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class AddSlidingComponentCmd
    extends FinalizableCommand {
        private final Component myComponent;
        private final WindowInfoImpl myInfo;
        private final boolean myDirtyMode;

        public AddSlidingComponentCmd(@NotNull Component component, WindowInfoImpl info, @NotNull boolean dirtyMode, Runnable finishCallBack) {
            if (component == null) {
                AddSlidingComponentCmd.$$$reportNull$$$0(0);
            }
            if (info == null) {
                AddSlidingComponentCmd.$$$reportNull$$$0(1);
            }
            if (finishCallBack == null) {
                AddSlidingComponentCmd.$$$reportNull$$$0(2);
            }
            super(finishCallBack);
            this.myComponent = component;
            this.myInfo = info;
            this.myDirtyMode = dirtyMode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            try {
                if (!this.myDirtyMode && UISettings.getInstance().getAnimateWindows() && !RemoteDesktopService.isRemoteSession()) {
                    Rectangle bounds;
                    Image topImage = ToolWindowsPane.this.myLayeredPane.getTopImage();
                    Graphics topGraphics = topImage.getGraphics();
                    try {
                        ToolWindowsPane.this.myLayeredPane.add(this.myComponent, JLayeredPane.PALETTE_LAYER);
                        ToolWindowsPane.this.myLayeredPane.moveToFront(this.myComponent);
                        ToolWindowsPane.this.myLayeredPane.setBoundsInPaletteLayer(this.myComponent, this.myInfo.getAnchor(), this.myInfo.getWeight());
                        bounds = this.myComponent.getBounds();
                        this.myComponent.paint(topGraphics);
                        ToolWindowsPane.this.myLayeredPane.remove(this.myComponent);
                    }
                    finally {
                        topGraphics.dispose();
                    }
                    Image bottomImage = ToolWindowsPane.this.myLayeredPane.getBottomImage();
                    Graphics bottomGraphics = bottomImage.getGraphics();
                    try {
                        bottomGraphics.setClip(0, 0, bounds.width, bounds.height);
                        bottomGraphics.translate(-bounds.x, -bounds.y);
                        ToolWindowsPane.this.myLayeredPane.paint(bottomGraphics);
                    }
                    finally {
                        bottomGraphics.dispose();
                    }
                    Surface surface = new Surface(topImage, bottomImage, 1, this.myInfo.getAnchor(), 300);
                    ToolWindowsPane.this.myLayeredPane.add(surface, JLayeredPane.PALETTE_LAYER);
                    surface.setBounds(bounds);
                    ToolWindowsPane.this.myLayeredPane.validate();
                    ToolWindowsPane.this.myLayeredPane.repaint();
                    surface.runMovement();
                    ToolWindowsPane.this.myLayeredPane.remove(surface);
                    ToolWindowsPane.this.myLayeredPane.add(this.myComponent, JLayeredPane.PALETTE_LAYER);
                } else {
                    ToolWindowsPane.this.myLayeredPane.add(this.myComponent, JLayeredPane.PALETTE_LAYER);
                    ToolWindowsPane.this.myLayeredPane.setBoundsInPaletteLayer(this.myComponent, this.myInfo.getAnchor(), this.myInfo.getWeight());
                }
                if (!this.myDirtyMode) {
                    ToolWindowsPane.this.myLayeredPane.validate();
                    ToolWindowsPane.this.myLayeredPane.repaint();
                }
            }
            finally {
                this.finish();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "component";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "info";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "finishCallBack";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/wm/impl/ToolWindowsPane$AddSlidingComponentCmd";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class AddAndSplitDockedComponentCmd
    extends FinalizableCommand {
        private final JComponent myNewComponent;
        private final WindowInfoImpl myInfo;
        private final boolean myDirtyMode;

        private AddAndSplitDockedComponentCmd(@NotNull JComponent newComponent, WindowInfoImpl info, @NotNull boolean dirtyMode, Runnable finishCallBack) {
            if (newComponent == null) {
                AddAndSplitDockedComponentCmd.$$$reportNull$$$0(0);
            }
            if (info == null) {
                AddAndSplitDockedComponentCmd.$$$reportNull$$$0(1);
            }
            if (finishCallBack == null) {
                AddAndSplitDockedComponentCmd.$$$reportNull$$$0(2);
            }
            super(finishCallBack);
            this.myNewComponent = newComponent;
            this.myInfo = info;
            this.myDirtyMode = dirtyMode;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                float newWeight;
                JComponent c;
                final ToolWindowAnchor anchor = this.myInfo.getAnchor();
                class MySplitter
                extends Splitter
                implements UISettingsListener {
                    MySplitter() {
                    }

                    public void uiSettingsChanged(UISettings uiSettings) {
                        if (anchor == ToolWindowAnchor.LEFT) {
                            this.setOrientation(!uiSettings.getLeftHorizontalSplit());
                        } else if (anchor == ToolWindowAnchor.RIGHT) {
                            this.setOrientation(!uiSettings.getRightHorizontalSplit());
                        }
                    }
                }
                MySplitter splitter = new MySplitter();
                splitter.setOrientation(anchor.isSplitVertically());
                if (!anchor.isHorizontal()) {
                    splitter.setAllowSwitchOrientationByMouseClick(true);
                    splitter.addPropertyChangeListener(evt -> {
                        if (!"orientation".equals(evt.getPropertyName())) {
                            return;
                        }
                        boolean isSplitterHorizontalNow = !splitter.isVertical();
                        UISettings settings = UISettings.getInstance();
                        if (anchor == ToolWindowAnchor.LEFT && settings.getLeftHorizontalSplit() != isSplitterHorizontalNow) {
                            settings.setLeftHorizontalSplit(isSplitterHorizontalNow);
                            settings.fireUISettingsChanged();
                        }
                        if (anchor == ToolWindowAnchor.RIGHT && settings.getRightHorizontalSplit() != isSplitterHorizontalNow) {
                            settings.setRightHorizontalSplit(isSplitterHorizontalNow);
                            settings.fireUISettingsChanged();
                        }
                    });
                }
                if ((c = ToolWindowsPane.this.getComponentAt(anchor)) instanceof InternalDecorator) {
                    InternalDecorator oldComponent = (InternalDecorator)c;
                    if (this.myInfo.isSplit()) {
                        splitter.setFirstComponent(oldComponent);
                        splitter.setSecondComponent(this.myNewComponent);
                        float proportion = ToolWindowsPane.this.getPreferredSplitProportion(oldComponent.getWindowInfo().getId(), ToolWindowsPane.normalizeWeigh(oldComponent.getWindowInfo().getSideWeight() / (oldComponent.getWindowInfo().getSideWeight() + this.myInfo.getSideWeight())));
                        splitter.setProportion(proportion);
                        newWeight = !anchor.isHorizontal() && !anchor.isSplitVertically() ? ToolWindowsPane.normalizeWeigh(oldComponent.getWindowInfo().getWeight() + this.myInfo.getWeight()) : ToolWindowsPane.normalizeWeigh(oldComponent.getWindowInfo().getWeight());
                    } else {
                        splitter.setFirstComponent(this.myNewComponent);
                        splitter.setSecondComponent(oldComponent);
                        splitter.setProportion(ToolWindowsPane.normalizeWeigh(this.myInfo.getSideWeight()));
                        newWeight = !anchor.isHorizontal() && !anchor.isSplitVertically() ? ToolWindowsPane.normalizeWeigh(oldComponent.getWindowInfo().getWeight() + this.myInfo.getWeight()) : ToolWindowsPane.normalizeWeigh(this.myInfo.getWeight());
                    }
                } else {
                    newWeight = ToolWindowsPane.normalizeWeigh(this.myInfo.getWeight());
                }
                ToolWindowsPane.this.setComponent((JComponent)((Object)splitter), anchor, newWeight);
                if (!this.myDirtyMode) {
                    ToolWindowsPane.this.myLayeredPane.validate();
                    ToolWindowsPane.this.myLayeredPane.repaint();
                }
            }
            finally {
                this.finish();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "newComponent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "info";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "finishCallBack";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/wm/impl/ToolWindowsPane$AddAndSplitDockedComponentCmd";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class AddDockedComponentCmd
    extends FinalizableCommand {
        private final JComponent myComponent;
        private final WindowInfoImpl myInfo;
        private final boolean myDirtyMode;

        public AddDockedComponentCmd(@NotNull JComponent component, WindowInfoImpl info, @NotNull boolean dirtyMode, Runnable finishCallBack) {
            if (component == null) {
                AddDockedComponentCmd.$$$reportNull$$$0(0);
            }
            if (info == null) {
                AddDockedComponentCmd.$$$reportNull$$$0(1);
            }
            if (finishCallBack == null) {
                AddDockedComponentCmd.$$$reportNull$$$0(2);
            }
            super(finishCallBack);
            this.myComponent = component;
            this.myInfo = info;
            this.myDirtyMode = dirtyMode;
        }

        @Override
        public final void run() {
            try {
                ToolWindowAnchor anchor = this.myInfo.getAnchor();
                ToolWindowsPane.this.setComponent(this.myComponent, anchor, ToolWindowsPane.normalizeWeigh(this.myInfo.getWeight()));
                if (!this.myDirtyMode) {
                    ToolWindowsPane.this.myLayeredPane.validate();
                    ToolWindowsPane.this.myLayeredPane.repaint();
                }
            }
            finally {
                this.finish();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "component";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "info";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "finishCallBack";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/wm/impl/ToolWindowsPane$AddDockedComponentCmd";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @FunctionalInterface
    static interface Resizer {
        public void setSize(int var1);

        public static abstract class LayeredPane
        implements Resizer {
            Component myComponent;

            LayeredPane(@NotNull Component component) {
                if (component == null) {
                    LayeredPane.$$$reportNull$$$0(0);
                }
                this.myComponent = component;
            }

            @Override
            public final void setSize(int size) {
                this._setSize(size);
                if (this.myComponent.getParent() instanceof JComponent) {
                    JComponent parent = (JComponent)this.myComponent;
                    parent.revalidate();
                    parent.repaint();
                }
            }

            abstract void _setSize(int var1);

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/wm/impl/ToolWindowsPane$Resizer$LayeredPane", "<init>"));
            }

            static class Bottom
            extends LayeredPane {
                Bottom(@NotNull Component component) {
                    if (component == null) {
                        Bottom.$$$reportNull$$$0(0);
                    }
                    super(component);
                }

                @Override
                public void _setSize(int size) {
                    Rectangle bounds = this.myComponent.getBounds();
                    int delta = size - bounds.height;
                    bounds.y -= delta;
                    bounds.height += delta;
                    this.myComponent.setBounds(bounds);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/wm/impl/ToolWindowsPane$Resizer$LayeredPane$Bottom", "<init>"));
                }
            }

            static class Top
            extends LayeredPane {
                Top(@NotNull Component component) {
                    if (component == null) {
                        Top.$$$reportNull$$$0(0);
                    }
                    super(component);
                }

                @Override
                public void _setSize(int size) {
                    this.myComponent.setSize(this.myComponent.getWidth(), size);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/wm/impl/ToolWindowsPane$Resizer$LayeredPane$Top", "<init>"));
                }
            }

            static class Right
            extends LayeredPane {
                Right(@NotNull Component component) {
                    if (component == null) {
                        Right.$$$reportNull$$$0(0);
                    }
                    super(component);
                }

                @Override
                public void _setSize(int size) {
                    Rectangle bounds = this.myComponent.getBounds();
                    int delta = size - bounds.width;
                    bounds.x -= delta;
                    bounds.width += delta;
                    this.myComponent.setBounds(bounds);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/wm/impl/ToolWindowsPane$Resizer$LayeredPane$Right", "<init>"));
                }
            }

            static class Left
            extends LayeredPane {
                Left(@NotNull Component component) {
                    if (component == null) {
                        Left.$$$reportNull$$$0(0);
                    }
                    super(component);
                }

                @Override
                public void _setSize(int size) {
                    this.myComponent.setSize(size, this.myComponent.getHeight());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/wm/impl/ToolWindowsPane$Resizer$LayeredPane$Left", "<init>"));
                }
            }
        }

        public static abstract class Splitter
        implements Resizer {
            ThreeComponentsSplitter mySplitter;

            Splitter(@NotNull ThreeComponentsSplitter splitter) {
                if (splitter == null) {
                    Splitter.$$$reportNull$$$0(0);
                }
                this.mySplitter = splitter;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "splitter", "com/intellij/openapi/wm/impl/ToolWindowsPane$Resizer$Splitter", "<init>"));
            }

            static class LastComponent
            extends Splitter {
                LastComponent(@NotNull ThreeComponentsSplitter splitter) {
                    if (splitter == null) {
                        LastComponent.$$$reportNull$$$0(0);
                    }
                    super(splitter);
                }

                @Override
                public void setSize(int size) {
                    this.mySplitter.setLastSize(size);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "splitter", "com/intellij/openapi/wm/impl/ToolWindowsPane$Resizer$Splitter$LastComponent", "<init>"));
                }
            }

            static class FirstComponent
            extends Splitter {
                FirstComponent(@NotNull ThreeComponentsSplitter splitter) {
                    if (splitter == null) {
                        FirstComponent.$$$reportNull$$$0(0);
                    }
                    super(splitter);
                }

                @Override
                public void setSize(int size) {
                    this.mySplitter.setFirstSize(size);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "splitter", "com/intellij/openapi/wm/impl/ToolWindowsPane$Resizer$Splitter$FirstComponent", "<init>"));
                }
            }
        }
    }
}

