/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.encoding.ChangeFileEncodingAction;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingUtil;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedWidget;
import com.intellij.openapi.wm.impl.status.TextPanel;
import com.intellij.ui.ClickListener;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EncodingPanel
extends EditorBasedWidget
implements StatusBarWidget.Multiframe,
CustomStatusBarWidget {
    private final TextPanel myComponent;
    private boolean actionEnabled;
    private final Alarm update;
    private volatile Reference<Editor> myEditor;

    public EncodingPanel(@NotNull Project project2) {
        if (project2 == null) {
            EncodingPanel.$$$reportNull$$$0(0);
        }
        super(project2);
        this.myEditor = new WeakReference<Object>(null);
        this.update = new Alarm((Disposable)this);
        this.myComponent = new TextPanel.ExtraSize(){

            @Override
            protected void paintComponent(@NotNull Graphics g) {
                if (g == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.paintComponent(g);
                if (EncodingPanel.this.actionEnabled && this.getText() != null) {
                    Rectangle r = this.getBounds();
                    Insets insets = this.getInsets();
                    Icon arrows = AllIcons.Ide.Statusbar_arrows;
                    arrows.paintIcon(this, g, r.width - insets.right - arrows.getIconWidth() - 2, r.height / 2 - arrows.getIconHeight() / 2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/wm/impl/status/EncodingPanel$1", "paintComponent"));
            }
        };
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                EncodingPanel.this.update();
                EncodingPanel.this.showPopup(e);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/status/EncodingPanel$2", "onClick"));
            }
        }.installOn((Component)this.myComponent);
        this.myComponent.setBorder(StatusBarWidget.WidgetBorder.WIDE);
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        if (event == null) {
            EncodingPanel.$$$reportNull$$$0(1);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        VirtualFile newFile = event.getNewFile();
        this.fileChanged(newFile);
    }

    private void fileChanged(VirtualFile newFile) {
        FileEditor fileEditor = newFile == null ? null : FileEditorManager.getInstance((Project)this.getProject()).getSelectedEditor(newFile);
        Editor editor = fileEditor instanceof TextEditor ? ((TextEditor)fileEditor).getEditor() : null;
        this.myEditor = new WeakReference<Editor>(editor);
        this.update();
    }

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
        if (source == null) {
            EncodingPanel.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            EncodingPanel.$$$reportNull$$$0(3);
        }
        this.fileChanged(file2);
    }

    public StatusBarWidget copy() {
        return new EncodingPanel(this.getProject());
    }

    @NotNull
    public String ID() {
        if ("Encoding" == null) {
            EncodingPanel.$$$reportNull$$$0(4);
        }
        return "Encoding";
    }

    public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type2) {
        if (type2 == null) {
            EncodingPanel.$$$reportNull$$$0(5);
        }
        return null;
    }

    @Override
    public void install(@NotNull StatusBar statusBar) {
        if (statusBar == null) {
            EncodingPanel.$$$reportNull$$$0(6);
        }
        super.install(statusBar);
        EncodingManager.getInstance().addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().equals("cachedEncoding")) {
                Document document = evt.getSource() instanceof Document ? (Document)evt.getSource() : null;
                this.updateForDocument(document);
            }
        }, (Disposable)this);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkVirtualFileListenerAdapter(new VirtualFileListener(){

            public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ("encoding".equals(event.getPropertyName())) {
                    EncodingPanel.this.updateForFile(event.getFile());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/wm/impl/status/EncodingPanel$3", "propertyChanged"));
            }
        }));
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent e) {
                Document document = e.getDocument();
                EncodingPanel.this.updateForDocument(document);
            }
        }, (Disposable)this);
    }

    private void updateForDocument(@Nullable(value="null means update anyway") Document document) {
        Editor selectedEditor = this.myEditor.get();
        if (document != null && (selectedEditor == null || selectedEditor.getDocument() != document)) {
            return;
        }
        this.update();
    }

    private void updateForFile(@Nullable(value="null means update anyway") VirtualFile file2) {
        if (file2 == null) {
            this.update();
        } else {
            this.updateForDocument(FileDocumentManager.getInstance().getCachedDocument(file2));
        }
    }

    private void showPopup(@NotNull MouseEvent e) {
        if (e == null) {
            EncodingPanel.$$$reportNull$$$0(7);
        }
        if (!this.actionEnabled) {
            return;
        }
        DataContext dataContext = this.getContext();
        ListPopup popup2 = new ChangeFileEncodingAction().createPopup(dataContext);
        if (popup2 != null) {
            Dimension dimension = popup2.getContent().getPreferredSize();
            Point at = new Point(0, -dimension.height);
            popup2.show(new RelativePoint(e.getComponent(), at));
            Disposer.register((Disposable)this, (Disposable)popup2);
        }
    }

    @NotNull
    private DataContext getContext() {
        Editor editor = this.getEditor();
        DataContext parent = DataManager.getInstance().getDataContext((Component)this.myStatusBar);
        DataContext dataContext = SimpleDataContext.getSimpleContext(ContainerUtil.immutableMapBuilder().put((Object)CommonDataKeys.VIRTUAL_FILE.getName(), (Object)this.getSelectedFile()).put((Object)CommonDataKeys.PROJECT.getName(), (Object)this.getProject()).put((Object)PlatformDataKeys.CONTEXT_COMPONENT.getName(), (Object)(editor == null ? null : editor.getComponent())).build(), parent);
        if (dataContext == null) {
            EncodingPanel.$$$reportNull$$$0(8);
        }
        return dataContext;
    }

    private void update() {
        if (this.update.isDisposed()) {
            return;
        }
        this.update.cancelAllRequests();
        this.update.addRequest(() -> {
            String charsetName;
            String toolTipText;
            if (this.isDisposed()) {
                return;
            }
            VirtualFile file2 = this.getSelectedFile();
            this.actionEnabled = false;
            if (file2 == null) {
                toolTipText = "";
                charsetName = "";
            } else {
                Pair<Charset, String> check = EncodingUtil.getCharsetAndTheReasonTooltip(file2);
                String failReason = check == null ? null : (String)check.second;
                this.actionEnabled = failReason == null;
                Charset charset = (Charset)ObjectUtils.notNull((Object)(check == null ? null : (Charset)check.first), (Object)file2.getCharset());
                charsetName = (String)ObjectUtils.notNull((Object)charset.displayName(), (Object)"n/a");
                if (failReason == null) {
                    toolTipText = "File Encoding: " + charsetName;
                    this.myComponent.setForeground(UIUtil.getActiveTextColor());
                    this.myComponent.setTextAlignment(0.0f);
                } else {
                    toolTipText = StringUtil.capitalize((String)failReason) + ".";
                    this.myComponent.setForeground(UIUtil.getInactiveTextColor());
                    this.myComponent.setTextAlignment(0.5f);
                }
            }
            this.myComponent.setToolTipText(toolTipText);
            this.myComponent.setText(charsetName);
            if (this.myStatusBar != null) {
                this.myStatusBar.updateWidget(this.ID());
            }
        }, 200, ModalityState.any());
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/status/EncodingPanel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusBar";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/status/EncodingPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "ID";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "selectionChanged";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fileOpened";
                break;
            }
            case 4: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "install";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "showPopup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

