/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.DependencyUISettings;
import com.intellij.packageDependencies.ui.DependenciesPanel;
import com.intellij.packageDependencies.ui.DirectoryNode;
import com.intellij.packageDependencies.ui.FileNode;
import com.intellij.packageDependencies.ui.FileTreeModelBuilder;
import com.intellij.packageDependencies.ui.Marker;
import com.intellij.packageDependencies.ui.ModuleGroupNode;
import com.intellij.packageDependencies.ui.ModuleNode;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.packageDependencies.ui.PatternDialectProvider;
import com.intellij.packageDependencies.ui.TreeModel;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.scope.packageSet.FilePatternPackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectPatternProvider
extends PatternDialectProvider {
    @NonNls
    public static final String FILE = "file";
    private static final Logger LOG = Logger.getInstance(ProjectPatternProvider.class);

    @Override
    public TreeModel createTreeModel(Project project2, Marker marker) {
        return FileTreeModelBuilder.createTreeModel(project2, false, marker);
    }

    @Override
    public TreeModel createTreeModel(Project project2, Set<PsiFile> deps, Marker marker, DependenciesPanel.DependencyPanelSettings settings) {
        return FileTreeModelBuilder.createTreeModel(project2, false, deps, marker, settings);
    }

    @Override
    public String getDisplayName() {
        return IdeBundle.message((String)"title.project", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public String getShortName() {
        if (FILE == null) {
            ProjectPatternProvider.$$$reportNull$$$0(0);
        }
        return FILE;
    }

    @Override
    public AnAction[] createActions(Project project2, Runnable update2) {
        if (ProjectViewDirectoryHelper.getInstance(project2).supportsHideEmptyMiddlePackages()) {
            return new AnAction[]{new CompactEmptyMiddlePackagesAction(update2)};
        }
        return AnAction.EMPTY_ARRAY;
    }

    @Override
    @Nullable
    public PackageSet createPackageSet(PackageDependenciesNode node, boolean recursively) {
        if (node instanceof ModuleGroupNode) {
            if (!recursively) {
                return null;
            }
            String modulePattern = "group:" + ((ModuleGroupNode)node).getModuleGroup().toString();
            return new FilePatternPackageSet(modulePattern, "*//*");
        }
        if (node instanceof ModuleNode) {
            if (!recursively) {
                return null;
            }
            String modulePattern = ((ModuleNode)node).getModuleName();
            return new FilePatternPackageSet(modulePattern, "*/");
        }
        if (node instanceof DirectoryNode) {
            String pattern = ((DirectoryNode)node).getFQName();
            if (pattern != null) {
                pattern = pattern.length() > 0 ? pattern + (recursively ? "//*" : "/*") : pattern + (recursively ? "*/" : "*");
            }
            VirtualFile vDir = ((DirectoryNode)node).getDirectory();
            PsiElement psiElement = node.getPsiElement();
            Module module2 = psiElement != null ? ModuleUtilCore.findModuleForFile((VirtualFile)vDir, (Project)psiElement.getProject()) : null;
            return new FilePatternPackageSet(module2 != null ? module2.getName() : null, pattern);
        }
        if (node instanceof FileNode) {
            if (recursively) {
                return null;
            }
            FileNode fNode = (FileNode)node;
            PsiFile file2 = (PsiFile)fNode.getPsiElement();
            if (file2 == null) {
                return null;
            }
            VirtualFile virtualFile = file2.getVirtualFile();
            LOG.assertTrue(virtualFile != null);
            VirtualFile contentRoot = ProjectRootManager.getInstance((Project)file2.getProject()).getFileIndex().getContentRootForFile(virtualFile);
            if (contentRoot == null) {
                return null;
            }
            String fqName = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)contentRoot, (char)'/');
            if (fqName != null) {
                return new FilePatternPackageSet(ProjectPatternProvider.getModulePattern(node), fqName);
            }
        }
        return null;
    }

    @Override
    public Icon getIcon() {
        return AllIcons.General.ProjectTab;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packageDependencies/ui/ProjectPatternProvider", "getShortName"));
    }

    private static final class CompactEmptyMiddlePackagesAction
    extends ToggleAction {
        private final Runnable myUpdate;

        CompactEmptyMiddlePackagesAction(Runnable update2) {
            super(IdeBundle.message((String)"action.compact.empty.middle.packages", (Object[])new Object[0]), IdeBundle.message((String)"action.compact.empty.middle.packages", (Object[])new Object[0]), AllIcons.ObjectBrowser.CompactEmptyPackages);
            this.myUpdate = update2;
        }

        public boolean isSelected(AnActionEvent event) {
            return DependencyUISettings.getInstance().UI_COMPACT_EMPTY_MIDDLE_PACKAGES;
        }

        public void setSelected(AnActionEvent event, boolean flag) {
            DependencyUISettings.getInstance().UI_COMPACT_EMPTY_MIDDLE_PACKAGES = flag;
            this.myUpdate.run();
        }
    }
}

