/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.packaging.elements.ComplexPackagingElementType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.elements.ArtifactPackagingElement;
import com.intellij.packaging.ui.ArtifactEditorContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ArtifactElementType
extends ComplexPackagingElementType<ArtifactPackagingElement> {
    public static final ArtifactElementType ARTIFACT_ELEMENT_TYPE = new ArtifactElementType();

    ArtifactElementType() {
        super("artifact", CompilerBundle.message((String)"element.type.name.artifact", (Object[])new Object[0]));
    }

    public Icon getCreateElementIcon() {
        return AllIcons.Nodes.Artifact;
    }

    public boolean canCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact) {
        if (context == null) {
            ArtifactElementType.$$$reportNull$$$0(0);
        }
        if (artifact == null) {
            ArtifactElementType.$$$reportNull$$$0(1);
        }
        return !ArtifactElementType.getAvailableArtifacts(context, artifact, false).isEmpty();
    }

    @NotNull
    public List<? extends ArtifactPackagingElement> chooseAndCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact, @NotNull CompositePackagingElement<?> parent) {
        if (context == null) {
            ArtifactElementType.$$$reportNull$$$0(2);
        }
        if (artifact == null) {
            ArtifactElementType.$$$reportNull$$$0(3);
        }
        if (parent == null) {
            ArtifactElementType.$$$reportNull$$$0(4);
        }
        Project project2 = context.getProject();
        List artifacts = context.chooseArtifacts(ArtifactElementType.getAvailableArtifacts(context, artifact, false), CompilerBundle.message((String)"dialog.title.choose.artifacts", (Object[])new Object[0]));
        ArrayList<ArtifactPackagingElement> elements = new ArrayList<ArtifactPackagingElement>();
        for (Artifact selected : artifacts) {
            elements.add(new ArtifactPackagingElement(project2, ArtifactPointerManager.getInstance((Project)project2).createPointer(selected, context.getArtifactModel())));
        }
        ArrayList<ArtifactPackagingElement> arrayList = elements;
        if (arrayList == null) {
            ArtifactElementType.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    public static List<? extends Artifact> getAvailableArtifacts(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact, boolean notIncludedOnly) {
        if (context == null) {
            ArtifactElementType.$$$reportNull$$$0(6);
        }
        if (artifact == null) {
            ArtifactElementType.$$$reportNull$$$0(7);
        }
        HashSet<Artifact> result2 = new HashSet<Artifact>(Arrays.asList(context.getArtifactModel().getArtifacts()));
        if (notIncludedOnly) {
            ArtifactUtil.processPackagingElements(artifact, ARTIFACT_ELEMENT_TYPE, artifactPackagingElement -> {
                if (context == null) {
                    ArtifactElementType.$$$reportNull$$$0(12);
                }
                result2.remove(artifactPackagingElement.findArtifact((PackagingElementResolvingContext)context));
                return true;
            }, (PackagingElementResolvingContext)context, true);
        }
        result2.remove(artifact);
        Iterator iterator = result2.iterator();
        while (iterator.hasNext()) {
            Artifact another = (Artifact)iterator.next();
            boolean notContainThis = ArtifactUtil.processPackagingElements(another, ARTIFACT_ELEMENT_TYPE, element -> {
                if (artifact == null) {
                    ArtifactElementType.$$$reportNull$$$0(11);
                }
                return !artifact.getName().equals(element.getArtifactName());
            }, (PackagingElementResolvingContext)context, true);
            if (notContainThis) continue;
            iterator.remove();
        }
        ArrayList<Artifact> list2 = new ArrayList<Artifact>(result2);
        Collections.sort(list2, ArtifactManager.ARTIFACT_COMPARATOR);
        ArrayList<Artifact> arrayList = list2;
        if (arrayList == null) {
            ArtifactElementType.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    public ArtifactPackagingElement createEmpty(@NotNull Project project2) {
        if (project2 == null) {
            ArtifactElementType.$$$reportNull$$$0(9);
        }
        ArtifactPackagingElement artifactPackagingElement = new ArtifactPackagingElement(project2);
        if (artifactPackagingElement == null) {
            ArtifactElementType.$$$reportNull$$$0(10);
        }
        return artifactPackagingElement;
    }

    public String getShowContentActionText() {
        return "Show Content of Included Artifacts";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/packaging/impl/elements/ArtifactElementType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/packaging/impl/elements/ArtifactElementType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseAndCreate";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableArtifacts";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmpty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canCreate";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "chooseAndCreate";
                break;
            }
            case 5: 
            case 8: 
            case 10: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableArtifacts";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createEmpty";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getAvailableArtifacts$1";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getAvailableArtifacts$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

