/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.ui.actions;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.deployment.DeploymentUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.ArtifactRootElement;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.artifacts.PackagingElementPath;
import com.intellij.packaging.impl.elements.ArchivePackagingElement;
import com.intellij.util.PathUtil;
import com.intellij.util.io.zip.JBZipEntry;
import com.intellij.util.io.zip.JBZipFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PackageFileWorker {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.packaging.impl.ui.actions.PackageFileWorker");
    private final File myFile;
    private final String myRelativeOutputPath;
    private final boolean myPackIntoArchives;

    private PackageFileWorker(File file2, String relativeOutputPath, boolean packIntoArchives) {
        this.myFile = file2;
        this.myRelativeOutputPath = relativeOutputPath;
        this.myPackIntoArchives = packIntoArchives;
    }

    public static void startPackagingFiles(Project project2, List<VirtualFile> files, Artifact[] artifacts, @NotNull Runnable onFinishedInAwt) {
        if (onFinishedInAwt == null) {
            PackageFileWorker.$$$reportNull$$$0(0);
        }
        PackageFileWorker.startPackagingFiles(project2, files, artifacts, true).doWhenProcessed(() -> {
            if (onFinishedInAwt == null) {
                PackageFileWorker.$$$reportNull$$$0(3);
            }
            ApplicationManager.getApplication().invokeLater(onFinishedInAwt);
        });
    }

    public static ActionCallback startPackagingFiles(final Project project2, final List<VirtualFile> files, final Artifact[] artifacts, final boolean packIntoArchives) {
        final ActionCallback callback = new ActionCallback();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project2, "Packaging Files"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    for (final VirtualFile file2 : files) {
                        indicator.checkCanceled();
                        new ReadAction(){

                            protected void run(@NotNull Result result2) {
                                if (result2 == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                try {
                                    PackageFileWorker.packageFile(file2, project2, artifacts, packIntoArchives);
                                }
                                catch (IOException e) {
                                    String message2 = CompilerBundle.message((String)"message.tect.package.file.io.error", (Object[])new Object[]{e.toString()});
                                    Notifications.Bus.notify((Notification)new Notification("Package File", "Cannot package file", message2, NotificationType.ERROR));
                                }
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/packaging/impl/ui/actions/PackageFileWorker$1$1", "run"));
                            }
                        }.execute();
                        callback.setDone();
                    }
                }
                finally {
                    if (!callback.isDone()) {
                        callback.setRejected();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/packaging/impl/ui/actions/PackageFileWorker$1", "run"));
            }
        });
        return callback;
    }

    public static void packageFile(@NotNull VirtualFile file2, @NotNull Project project2, Artifact[] artifacts, boolean packIntoArchives) throws IOException {
        if (file2 == null) {
            PackageFileWorker.$$$reportNull$$$0(1);
        }
        if (project2 == null) {
            PackageFileWorker.$$$reportNull$$$0(2);
        }
        LOG.debug("Start packaging file: " + file2.getPath());
        Collection<Trinity<Artifact, PackagingElementPath, String>> items = ArtifactUtil.findContainingArtifactsWithOutputPaths(file2, project2, artifacts);
        File ioFile = VfsUtilCore.virtualToIoFile((VirtualFile)file2);
        for (Trinity<Artifact, PackagingElementPath, String> item : items) {
            Artifact artifact = (Artifact)item.getFirst();
            String outputPath = artifact.getOutputPath();
            if (StringUtil.isEmpty((String)outputPath)) continue;
            PackageFileWorker worker = new PackageFileWorker(ioFile, (String)item.getThird(), packIntoArchives);
            LOG.debug(" package to " + outputPath);
            worker.packageFile(outputPath, ((PackagingElementPath)item.getSecond()).getParents());
        }
    }

    private void packageFile(String outputPath, List<CompositePackagingElement<?>> parents2) throws IOException {
        List<Object> parentsList = new ArrayList(parents2);
        Collections.reverse(parentsList);
        if (!parentsList.isEmpty() && parentsList.get(0) instanceof ArtifactRootElement) {
            parentsList = parentsList.subList(1, parentsList.size());
        }
        this.copyFile(outputPath, parentsList);
    }

    private void copyFile(String outputPath, List<CompositePackagingElement<?>> parents2) throws IOException {
        if (parents2.isEmpty()) {
            String fullOutputPath = DeploymentUtil.appendToPath((String)outputPath, (String)this.myRelativeOutputPath);
            File target2 = new File(fullOutputPath);
            if (FileUtil.filesEqual((File)this.myFile, (File)target2)) {
                LOG.debug("  skipping copying file to itself");
            } else {
                LOG.debug("  copying to " + fullOutputPath);
                FileUtil.copy((File)this.myFile, (File)target2);
            }
            return;
        }
        CompositePackagingElement<?> element = parents2.get(0);
        String nextOutputPath = outputPath + "/" + element.getName();
        List<CompositePackagingElement<?>> parentsTrail = parents2.subList(1, parents2.size());
        if (element instanceof ArchivePackagingElement) {
            if (this.myPackIntoArchives) {
                this.packFile(nextOutputPath, "", parentsTrail);
            }
        } else {
            this.copyFile(nextOutputPath, parentsTrail);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void packFile(String archivePath, String pathInArchive, List<CompositePackagingElement<?>> parents2) throws IOException {
        File archiveFile = new File(archivePath);
        if (parents2.isEmpty()) {
            LOG.debug("  adding to archive " + archivePath);
            try (JBZipFile file2 = PackageFileWorker.getOrCreateZipFile(archiveFile);){
                String fullPathInArchive = DeploymentUtil.trimForwardSlashes((String)DeploymentUtil.appendToPath((String)pathInArchive, (String)this.myRelativeOutputPath));
                JBZipEntry entry = file2.getOrCreateEntry(fullPathInArchive);
                entry.setData(FileUtil.loadFileBytes((File)this.myFile));
            }
            return;
        }
        CompositePackagingElement<?> element = parents2.get(0);
        String nextPathInArchive = DeploymentUtil.trimForwardSlashes((String)DeploymentUtil.appendToPath((String)pathInArchive, (String)element.getName()));
        List<CompositePackagingElement<?>> parentsTrail = parents2.subList(1, parents2.size());
        if (element instanceof ArchivePackagingElement) {
            try (JBZipFile zipFile = PackageFileWorker.getOrCreateZipFile(archiveFile);){
                JBZipEntry entry = zipFile.getOrCreateEntry(nextPathInArchive);
                LOG.debug("  extracting to temp file: " + nextPathInArchive + " from " + archivePath);
                File tempFile = FileUtil.createTempFile((String)("packageFile" + FileUtil.sanitizeFileName((String)nextPathInArchive)), (String)FileUtilRt.getExtension((String)PathUtil.getFileName((String)nextPathInArchive)));
                if (entry.getSize() != -1L) {
                    FileUtil.writeToFile((File)tempFile, (byte[])entry.getData());
                }
                this.packFile(FileUtil.toSystemIndependentName((String)tempFile.getAbsolutePath()), "", parentsTrail);
                entry.setData(FileUtil.loadFileBytes((File)tempFile));
                FileUtil.delete((File)tempFile);
            }
        } else {
            this.packFile(archivePath, nextPathInArchive, parentsTrail);
        }
    }

    private static JBZipFile getOrCreateZipFile(File archiveFile) throws IOException {
        FileUtil.createIfDoesntExist((File)archiveFile);
        try {
            return new JBZipFile(archiveFile);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onFinishedInAwt";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/packaging/impl/ui/actions/PackageFileWorker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "startPackagingFiles";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "packageFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$startPackagingFiles$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

