/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ModuleAttachProcessor;
import com.intellij.platform.ModuleAttachProcessorKt;
import com.intellij.projectImport.ProjectOpenedCallback;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=2, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0003H\u0002\u001a\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002\u001a\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002\u001a\u0018\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\nH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "addPrimaryModuleDependency", "Lcom/intellij/openapi/module/Module;", "project", "Lcom/intellij/openapi/project/Project;", "newModule", "attachModule", "", "imlFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "callback", "Lcom/intellij/projectImport/ProjectOpenedCallback;", "findMainModule", "", "projectDir", "Ljava/nio/file/Path;", "updateVcsMapping", "primaryModule", "addedModuleContentRoot", "lang-impl"})
public final class ModuleAttachProcessorKt {
    private static final Logger LOG = Logger.getInstance(ModuleAttachProcessor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final boolean findMainModule(Project project, Path projectDir, ProjectOpenedCallback callback) {
        var3_3 = projectDir;
        filter$iv = findMainModule.1.INSTANCE;
        try {
            block10: {
                var5_5 = Files.newDirectoryStream((Path)$receiver$iv, (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(filter$iv){
                    final /* synthetic */ Function1 $filter;
                    {
                        this.$filter = function1;
                    }

                    public final boolean accept(Path it) {
                        Path path = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"it");
                        return (Boolean)this.$filter.invoke((Object)path);
                    }
                });
                var6_7 = false;
                try {
                    it = (DirectoryStream)var5_5;
                    for (Path file : it) {
                        v0 = LocalFileSystem.getInstance().refreshAndFindFileByPath(PathKt.getSystemIndependentPath((Path)file));
                        if (v0 == null) continue;
                        v1 = it = (var10_14 = v0);
                        Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                        ModuleAttachProcessorKt.attachModule(project, v1, callback);
                        var15_16 = true;
                        v2 = var5_5;
                        break block10;
                    }
                    ** GOTO lbl-1000
                }
                catch (Exception var7_9) {
                    try {
                        var6_7 = true;
                        try {
                            v3 = var5_5;
                            if (v3 == null) throw (Throwable)var7_9;
                            v3.close();
                            throw (Throwable)var7_9;
                        }
                        catch (Exception var8_12) {
                            // empty catch block
                        }
                        throw (Throwable)var7_9;
                    }
                    catch (Throwable var7_10) {
                        if (var6_7 != false) throw var7_10;
                        v4 = var5_5;
                        if (v4 == null) throw var7_10;
                        v4.close();
                        throw var7_10;
                    }
                }
            }
            if (v2 == null) return var15_16;
            v2.close();
            return var15_16;
lbl-1000:
            // 1 sources

            {
                var7_8 = Unit.INSTANCE;
                v5 = var5_5;
            }
            if (v5 == null) return false;
            v5.close();
            return false;
        }
        catch (NoSuchFileException var5_6) {
        }
        return false;
    }

    private static final void attachModule(Project project2, VirtualFile imlFile, ProjectOpenedCallback callback) {
        try {
            VirtualFile dotIdeaDir;
            Module newModule;
            ModifiableModuleModel model$iv;
            Project $receiver$iv = project2;
            ModifiableModuleModel $receiver = model$iv = ModuleManager.getInstance((Project)$receiver$iv).getModifiableModel();
            Module result$iv = $receiver.loadModule(imlFile.getPath());
            ApplicationManager.getApplication().runWriteAction(new Computable<T>(model$iv){
                final /* synthetic */ ModifiableModuleModel $model$inlined;
                {
                    this.$model$inlined = modifiableModuleModel;
                }

                public final T compute() {
                    this.$model$inlined.commit();
                    return (T)Unit.INSTANCE;
                }
            });
            Module module2 = result$iv;
            Module module3 = ModuleManager.getInstance((Project)project2).findModuleByName(module2.getName());
            if (module3 == null) {
                Intrinsics.throwNpe();
            }
            Module module4 = newModule = module3;
            Intrinsics.checkExpressionValueIsNotNull((Object)module4, (String)"newModule");
            Module primaryModule = ModuleAttachProcessorKt.addPrimaryModuleDependency(project2, module4);
            if (primaryModule != null && (dotIdeaDir = imlFile.getParent()) != null) {
                VirtualFile virtualFile = dotIdeaDir.getParent();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"dotIdeaDir.parent");
                ModuleAttachProcessorKt.updateVcsMapping(primaryModule, virtualFile);
            }
            ProjectOpenedCallback projectOpenedCallback = callback;
            if (projectOpenedCallback != null) {
                projectOpenedCallback.projectOpened(project2, newModule);
            }
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            Messages.showErrorDialog((Project)project2, (String)("Cannot attach project: " + e.getMessage()), (String)CommonBundle.getErrorTitle());
        }
    }

    private static final void updateVcsMapping(Module primaryModule, VirtualFile addedModuleContentRoot) {
        AbstractVcs vcs;
        VirtualFile[] contentRoots;
        Project project2 = primaryModule.getProject();
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project2);
        List mappings = vcsManager.getDirectoryMappings();
        if (mappings.size() == 1 && ((Object[])(contentRoots = ModuleRootManager.getInstance((Module)primaryModule).getContentRoots())).length == 1 && FileUtil.filesEqual((File)new File(contentRoots[0].getPath()), (File)new File(((VcsDirectoryMapping)mappings.get(0)).getDirectory())) && (vcs = vcsManager.findVersioningVcs(addedModuleContentRoot)) != null && Intrinsics.areEqual((Object)vcs.getName(), (Object)((VcsDirectoryMapping)mappings.get(0)).getVcs())) {
            vcsManager.setDirectoryMappings(CollectionsKt.listOf((Object)new VcsDirectoryMapping("", vcs.getName())));
            return;
        }
        AbstractVcs vcs2 = vcsManager.findVersioningVcs(addedModuleContentRoot);
        if (vcs2 != null) {
            ArrayList<VcsDirectoryMapping> newMappings = new ArrayList<VcsDirectoryMapping>(mappings);
            newMappings.add(new VcsDirectoryMapping(addedModuleContentRoot.getPath(), vcs2.getName()));
            vcsManager.setDirectoryMappings((List)newMappings);
        }
    }

    private static final Module addPrimaryModuleDependency(Project project2, Module newModule) {
        Module module2 = ModuleAttachProcessor.Companion.getPrimaryModule(project2);
        if (module2 != null && module2 != newModule) {
            ModuleRootModificationUtil.addDependency((Module)module2, (Module)newModule);
            return module2;
        }
        return null;
    }

    public static final /* synthetic */ boolean access$findMainModule(@NotNull Project project2, @NotNull Path projectDir, @Nullable ProjectOpenedCallback callback) {
        return ModuleAttachProcessorKt.findMainModule(project2, projectDir, callback);
    }
}

