/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates;

import com.intellij.icons.AllIcons;
import com.intellij.ide.fileTemplates.impl.UrlUtil;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.ProjectTemplate;
import com.intellij.platform.ProjectTemplatesFactory;
import com.intellij.platform.templates.LocalArchivedTemplate;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArchivedTemplatesFactory
extends ProjectTemplatesFactory {
    private static final Logger LOG = Logger.getInstance(ArchivedTemplatesFactory.class);
    static final String ZIP = ".zip";

    @NotNull
    private static URL getCustomTemplatesURL() {
        URL uRL;
        try {
            uRL = new File(ArchivedTemplatesFactory.getCustomTemplatesPath()).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        if (uRL == null) {
            ArchivedTemplatesFactory.$$$reportNull$$$0(0);
        }
        return uRL;
    }

    @NotNull
    static String getCustomTemplatesPath() {
        String string = PathManager.getConfigPath() + "/projectTemplates";
        if (string == null) {
            ArchivedTemplatesFactory.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static Path getTemplateFile(String name2) {
        Path path = Paths.get(ArchivedTemplatesFactory.getCustomTemplatesPath(), name2 + ZIP);
        if (path == null) {
            ArchivedTemplatesFactory.$$$reportNull$$$0(2);
        }
        return path;
    }

    @Override
    @NotNull
    public String[] getGroups() {
        String[] stringArray = new String[]{"User-defined"};
        if (stringArray == null) {
            ArchivedTemplatesFactory.$$$reportNull$$$0(3);
        }
        return stringArray;
    }

    @Override
    @NotNull
    public ProjectTemplate[] createTemplates(@Nullable String group, WizardContext context) {
        if (!"User-defined".equals(group)) {
            if (ProjectTemplate.EMPTY_ARRAY == null) {
                ArchivedTemplatesFactory.$$$reportNull$$$0(4);
            }
            return ProjectTemplate.EMPTY_ARRAY;
        }
        List templates = null;
        URL url = ArchivedTemplatesFactory.getCustomTemplatesURL();
        try {
            for (String child : UrlUtil.getChildrenRelativePaths(url)) {
                if (!child.endsWith(ZIP)) continue;
                if (templates == null) {
                    templates = new SmartList();
                }
                templates.add(new LocalArchivedTemplate(new URL(url.toExternalForm() + '/' + child), ClassLoader.getSystemClassLoader()));
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        ProjectTemplate[] projectTemplateArray = ContainerUtil.isEmpty(templates) ? ProjectTemplate.EMPTY_ARRAY : templates.toArray(new ProjectTemplate[templates.size()]);
        if (projectTemplateArray == null) {
            ArchivedTemplatesFactory.$$$reportNull$$$0(5);
        }
        return projectTemplateArray;
    }

    @Override
    public int getGroupWeight(String group) {
        return "User-defined".equals(group) ? -2 : 0;
    }

    @Override
    public Icon getGroupIcon(String group) {
        return "User-defined".equals(group) ? AllIcons.Modules.Types.UserDefined : super.getGroupIcon(group);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/platform/templates/ArchivedTemplatesFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomTemplatesURL";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomTemplatesPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroups";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemplates";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

