/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.google.common.util.concurrent.Atomics;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.PersistentFSConstants;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleRootFileViewProvider
extends AbstractFileViewProvider
implements FileViewProvider {
    private static final Key<Boolean> OUR_NO_SIZE_LIMIT_KEY = Key.create((String)"no.size.limit");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.SingleRootFileViewProvider");
    private final AtomicReference<PsiFile> myPsiFile;
    @NotNull
    private final Language myBaseLanguage;

    public SingleRootFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile file2) {
        if (manager == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(1);
        }
        this(manager, file2, true);
    }

    public SingleRootFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean eventSystemEnabled) {
        if (manager == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(2);
        }
        if (virtualFile == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(3);
        }
        this(manager, virtualFile, eventSystemEnabled, virtualFile.getFileType());
    }

    public SingleRootFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean eventSystemEnabled, @NotNull FileType fileType) {
        if (manager == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(4);
        }
        if (virtualFile == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(5);
        }
        if (fileType == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(6);
        }
        this(manager, virtualFile, eventSystemEnabled, SingleRootFileViewProvider.calcBaseLanguage(virtualFile, manager.getProject(), fileType), fileType);
    }

    protected SingleRootFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean eventSystemEnabled, @NotNull Language language) {
        if (manager == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(7);
        }
        if (virtualFile == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(8);
        }
        if (language == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(9);
        }
        this(manager, virtualFile, eventSystemEnabled, language, virtualFile.getFileType());
    }

    protected SingleRootFileViewProvider(@NotNull PsiManager manager, @NotNull VirtualFile virtualFile, boolean eventSystemEnabled, @NotNull Language language, @NotNull FileType type2) {
        if (manager == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(10);
        }
        if (virtualFile == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(11);
        }
        if (language == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(12);
        }
        if (type2 == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(13);
        }
        super(manager, virtualFile, eventSystemEnabled, type2);
        this.myPsiFile = Atomics.newReference();
        this.myBaseLanguage = language;
    }

    @NotNull
    public Language getBaseLanguage() {
        Language language = this.myBaseLanguage;
        if (language == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(14);
        }
        return language;
    }

    private static Language calcBaseLanguage(@NotNull VirtualFile file2, @NotNull Project project2, @NotNull FileType fileType) {
        if (file2 == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(15);
        }
        if (project2 == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(16);
        }
        if (fileType == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(17);
        }
        if (fileType.isBinary()) {
            return Language.ANY;
        }
        if (SingleRootFileViewProvider.isTooLargeForIntelligence(file2)) {
            return PlainTextLanguage.INSTANCE;
        }
        Language language = LanguageUtil.getLanguageForPsi((Project)project2, (VirtualFile)file2);
        return language != null ? language : PlainTextLanguage.INSTANCE;
    }

    @NotNull
    public Set<Language> getLanguages() {
        Set<Language> set2 = Collections.singleton(this.getBaseLanguage());
        if (set2 == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(18);
        }
        return set2;
    }

    @NotNull
    public List<PsiFile> getAllFiles() {
        List list2 = ContainerUtil.createMaybeSingletonList((Object)this.getPsi(this.getBaseLanguage()));
        if (list2 == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(19);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    protected PsiFile getPsiInner(@NotNull Language target2) {
        if (target2 == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(20);
        }
        if (target2 != this.getBaseLanguage()) {
            return null;
        }
        PsiFile psiFile = this.myPsiFile.get();
        if (psiFile == null) {
            boolean set2;
            psiFile = this.createFile();
            if (psiFile == null) {
                psiFile = PsiUtilCore.NULL_PSI_FILE;
            }
            if (!(set2 = this.myPsiFile.compareAndSet(null, psiFile)) && psiFile != PsiUtilCore.NULL_PSI_FILE) {
                PsiFile alreadyCreated = this.myPsiFile.get();
                if (alreadyCreated == psiFile) {
                    LOG.error((Object)((Object)this) + ".createFile() must create new file instance but got the same: " + psiFile);
                }
                if (psiFile instanceof PsiFileEx) {
                    DebugUtil.startPsiModification("invalidating throw-away copy");
                    try {
                        ((PsiFileEx)psiFile).markInvalidated();
                    }
                    finally {
                        DebugUtil.finishPsiModification();
                    }
                }
                psiFile = alreadyCreated;
            }
        }
        return psiFile == PsiUtilCore.NULL_PSI_FILE ? null : psiFile;
    }

    @Override
    public final PsiFile getCachedPsi(@NotNull Language target2) {
        if (target2 == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(21);
        }
        if (target2 != this.getBaseLanguage()) {
            return null;
        }
        PsiFile file2 = this.myPsiFile.get();
        return file2 == PsiUtilCore.NULL_PSI_FILE ? null : file2;
    }

    @Override
    public final List<PsiFile> getCachedPsiFiles() {
        return ContainerUtil.createMaybeSingletonList((Object)this.getCachedPsi(this.getBaseLanguage()));
    }

    @Override
    @NotNull
    public final List<FileElement> getKnownTreeRoots() {
        PsiFile psiFile = this.getCachedPsi(this.getBaseLanguage());
        if (!(psiFile instanceof PsiFileImpl)) {
            List<FileElement> list2 = Collections.emptyList();
            if (list2 == null) {
                SingleRootFileViewProvider.$$$reportNull$$$0(22);
            }
            return list2;
        }
        FileElement element = ((PsiFileImpl)psiFile).getTreeElement();
        List list3 = ContainerUtil.createMaybeSingletonList((Object)element);
        if (list3 == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(23);
        }
        return list3;
    }

    private PsiFile createFile() {
        try {
            VirtualFile vFile = this.getVirtualFile();
            if (vFile.isDirectory()) {
                return null;
            }
            if (this.isIgnored()) {
                return null;
            }
            Project project2 = this.getManager().getProject();
            if (this.isPhysical() && vFile.isInLocalFileSystem()) {
                FileIndexFacade indexFacade;
                VirtualFile parent = vFile.getParent();
                if (parent == null) {
                    return null;
                }
                PsiDirectory psiDir = this.getManager().findDirectory(parent);
                if (psiDir == null && !(indexFacade = FileIndexFacade.getInstance((Project)project2)).isInLibrarySource(vFile) && !indexFacade.isInLibraryClasses(vFile)) {
                    return null;
                }
            }
            return this.createFile(project2, vFile, this.getFileType());
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
            return null;
        }
    }

    @Deprecated
    public static boolean isTooLarge(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(24);
        }
        return SingleRootFileViewProvider.isTooLargeForIntelligence(vFile);
    }

    public static boolean isTooLargeForIntelligence(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(25);
        }
        if (!SingleRootFileViewProvider.checkFileSizeLimit(vFile)) {
            return false;
        }
        return SingleRootFileViewProvider.fileSizeIsGreaterThan(vFile, PersistentFSConstants.getMaxIntellisenseFileSize());
    }

    public static boolean isTooLargeForContentLoading(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(26);
        }
        return SingleRootFileViewProvider.fileSizeIsGreaterThan(vFile, PersistentFSConstants.FILE_LENGTH_TO_CACHE_THRESHOLD);
    }

    private static boolean checkFileSizeLimit(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(27);
        }
        return !Boolean.TRUE.equals(vFile.getUserData(OUR_NO_SIZE_LIMIT_KEY));
    }

    public static void doNotCheckFileSizeLimit(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(28);
        }
        vFile.putUserData(OUR_NO_SIZE_LIMIT_KEY, (Object)Boolean.TRUE);
    }

    public static boolean isTooLargeForIntelligence(@NotNull VirtualFile vFile, long contentSize) {
        if (vFile == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(29);
        }
        if (!SingleRootFileViewProvider.checkFileSizeLimit(vFile)) {
            return false;
        }
        return contentSize > (long)PersistentFSConstants.getMaxIntellisenseFileSize();
    }

    public static boolean isTooLargeForContentLoading(@NotNull VirtualFile vFile, long contentSize) {
        if (vFile == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(30);
        }
        return contentSize > PersistentFSConstants.FILE_LENGTH_TO_CACHE_THRESHOLD;
    }

    public static boolean fileSizeIsGreaterThan(@NotNull VirtualFile vFile, long maxBytes) {
        if (vFile == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(31);
        }
        if (vFile instanceof LightVirtualFile) {
            int lengthInChars = ((LightVirtualFile)vFile).getContent().length();
            if ((long)lengthInChars < maxBytes / 2L) {
                return false;
            }
            if ((long)lengthInChars > maxBytes) {
                return true;
            }
        }
        return vFile.getLength() > maxBytes;
    }

    @NotNull
    public SingleRootFileViewProvider createCopy(@NotNull VirtualFile copy) {
        if (copy == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(32);
        }
        SingleRootFileViewProvider singleRootFileViewProvider = new SingleRootFileViewProvider((PsiManager)this.getManager(), copy, false, this.getBaseLanguage());
        if (singleRootFileViewProvider == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(33);
        }
        return singleRootFileViewProvider;
    }

    public PsiReference findReferenceAt(int offset) {
        PsiFile psiFile = this.getPsi(this.getBaseLanguage());
        return SingleRootFileViewProvider.findReferenceAt(psiFile, offset);
    }

    public PsiElement findElementAt(int offset) {
        return SingleRootFileViewProvider.findElementAt((PsiElement)this.getPsi(this.getBaseLanguage()), offset);
    }

    public PsiElement findElementAt(int offset, @NotNull Class<? extends Language> lang) {
        if (lang == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(34);
        }
        if (!ReflectionUtil.isAssignable(lang, this.getBaseLanguage().getClass())) {
            return null;
        }
        return this.findElementAt(offset);
    }

    public final void forceCachedPsi(@NotNull PsiFile psiFile) {
        PsiFile prev;
        if (psiFile == null) {
            SingleRootFileViewProvider.$$$reportNull$$$0(35);
        }
        if ((prev = this.myPsiFile.getAndSet(psiFile)) != null && prev != psiFile && prev instanceof PsiFileEx) {
            ((PsiFileEx)prev).markInvalidated();
        }
        this.getManager().getFileManager().setViewProvider(this.getVirtualFile(), this);
    }

    @Override
    public final void markInvalidated() {
        PsiFile psiFile = this.getCachedPsi(this.getBaseLanguage());
        if (psiFile instanceof PsiFileEx) {
            ((PsiFileEx)psiFile).markInvalidated();
        }
        super.markInvalidated();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 6: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 14: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/SingleRootFileViewProvider";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copy";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lang";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/SingleRootFileViewProvider";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseLanguage";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguages";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFiles";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getKnownTreeRoots";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createCopy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 14: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 33: {
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "calcBaseLanguage";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPsiInner";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getCachedPsi";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isTooLarge";
                break;
            }
            case 25: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isTooLargeForIntelligence";
                break;
            }
            case 26: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isTooLargeForContentLoading";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "checkFileSizeLimit";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "doNotCheckFileSizeLimit";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "fileSizeIsGreaterThan";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createCopy";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findElementAt";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "forceCachedPsi";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

