/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters.getters;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInsight.completion.JavaSmartCompletionParameters;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.filters.getters.ClassLiteralLookupElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassLiteralGetter {
    public static void addCompletions(@NotNull JavaSmartCompletionParameters parameters2, @NotNull Consumer<LookupElement> result2, PrefixMatcher matcher) {
        PsiType expectedType;
        if (parameters2 == null) {
            ClassLiteralGetter.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            ClassLiteralGetter.$$$reportNull$$$0(1);
        }
        if (!InheritanceUtil.isInheritor((PsiType)(expectedType = parameters2.getDefaultType()), (String)"java.lang.Class") && !InheritanceUtil.isInheritor((PsiType)(expectedType = parameters2.getExpectedType()), (String)"java.lang.Class")) {
            return;
        }
        PsiType classParameter = PsiUtil.substituteTypeParameter((PsiType)expectedType, (String)"java.lang.Class", (int)0, (boolean)false);
        boolean addInheritors = false;
        PsiElement position = parameters2.getPosition();
        if (classParameter instanceof PsiWildcardType) {
            PsiWildcardType wildcardType = (PsiWildcardType)classParameter;
            classParameter = wildcardType.isSuper() ? wildcardType.getSuperBound() : wildcardType.getExtendsBound();
            addInheritors = wildcardType.isExtends() && classParameter instanceof PsiClassType;
        } else if (!matcher.getPrefix().isEmpty()) {
            addInheritors = true;
            classParameter = PsiType.getJavaLangObject((PsiManager)position.getManager(), (GlobalSearchScope)position.getResolveScope());
        }
        if (classParameter != null) {
            PsiFile file2 = position.getContainingFile();
            ClassLiteralGetter.addClassLiteralLookupElement(classParameter, result2, file2);
            if (addInheritors) {
                ClassLiteralGetter.addInheritorClassLiterals(file2, classParameter, result2, matcher);
            }
        }
    }

    private static void addInheritorClassLiterals(PsiFile context, PsiType classParameter, Consumer<LookupElement> result2, PrefixMatcher matcher) {
        String canonicalText = classParameter.getCanonicalText();
        if ("java.lang.Object".equals(canonicalText) && StringUtil.isEmpty((String)matcher.getPrefix())) {
            return;
        }
        CodeInsightUtil.processSubTypes(classParameter, (PsiElement)context, true, matcher, (Consumer<PsiType>)((Consumer)type2 -> ClassLiteralGetter.addClassLiteralLookupElement(type2, result2, context)));
    }

    private static void addClassLiteralLookupElement(@Nullable PsiType type2, Consumer<LookupElement> resultSet, PsiFile context) {
        if (type2 instanceof PsiClassType && PsiUtil.resolveClassInType((PsiType)type2) != null && !((PsiClassType)type2).hasParameters() && !(((PsiClassType)type2).resolve() instanceof PsiTypeParameter)) {
            try {
                resultSet.consume((Object)AutoCompletionPolicy.NEVER_AUTOCOMPLETE.applyPolicy((LookupElement)new ClassLiteralLookupElement((PsiClassType)type2, (PsiElement)context)));
            }
            catch (IncorrectOperationException incorrectOperationException) {
                // empty catch block
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/filters/getters/ClassLiteralGetter";
        objectArray[2] = "addCompletions";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

