/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter;

import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.formatter.WhiteSpaceFormattingStrategy;
import com.intellij.psi.formatter.WhiteSpaceFormattingStrategyFactory;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiDocumentManagerImpl;
import com.intellij.psi.impl.PsiToDocumentSynchronizer;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormattingDocumentModelImpl
implements FormattingDocumentModel {
    private final WhiteSpaceFormattingStrategy myWhiteSpaceStrategy;
    @NotNull
    private final Document myDocument;
    private final PsiFile myFile;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.formatter.FormattingDocumentModelImpl");
    private final CodeStyleSettings mySettings;

    public FormattingDocumentModelImpl(@NotNull Document document, PsiFile file2) {
        if (document == null) {
            FormattingDocumentModelImpl.$$$reportNull$$$0(0);
        }
        this.myDocument = document;
        this.myFile = file2;
        if (file2 != null) {
            Language language = file2.getLanguage();
            this.myWhiteSpaceStrategy = WhiteSpaceFormattingStrategyFactory.getStrategy(language);
        } else {
            this.myWhiteSpaceStrategy = WhiteSpaceFormattingStrategyFactory.getStrategy();
        }
        this.mySettings = CodeStyleSettingsManager.getSettings((Project)(file2 != null ? file2.getProject() : null));
    }

    public static FormattingDocumentModelImpl createOn(PsiFile file2) {
        Document document = FormattingDocumentModelImpl.getDocumentToBeUsedFor(file2);
        if (document != null) {
            FormattingDocumentModelImpl.checkDocument(file2, document);
            return new FormattingDocumentModelImpl(document, file2);
        }
        return new FormattingDocumentModelImpl(new DocumentImpl(file2.getViewProvider().getContents(), true), file2);
    }

    private static void checkDocument(PsiFile file2, Document document) {
        if (file2.getTextLength() != document.getTextLength()) {
            LOG.error(DebugUtil.diagnosePsiDocumentInconsistency((PsiElement)file2, document));
        }
    }

    @Nullable
    public static Document getDocumentToBeUsedFor(PsiFile file2) {
        Project project2 = file2.getProject();
        if (!file2.isPhysical()) {
            return FormattingDocumentModelImpl.getDocumentForNonPhysicalFile(file2);
        }
        Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(file2);
        if (document != null) {
            if (PsiDocumentManager.getInstance((Project)project2).isUncommited(document)) {
                return null;
            }
            PsiToDocumentSynchronizer synchronizer = ((PsiDocumentManagerImpl)PsiDocumentManager.getInstance((Project)project2)).getSynchronizer();
            if (synchronizer.isDocumentAffectedByTransactions(document)) {
                return null;
            }
        }
        return document;
    }

    @NotNull
    private static Document getDocumentForNonPhysicalFile(PsiFile file2) {
        Document document = file2.getViewProvider().getDocument();
        if (document != null && document.getTextLength() == file2.getTextLength()) {
            Document document2 = document;
            if (document2 == null) {
                FormattingDocumentModelImpl.$$$reportNull$$$0(1);
            }
            return document2;
        }
        DocumentImpl documentImpl = new DocumentImpl(file2.getText(), true);
        if (documentImpl == null) {
            FormattingDocumentModelImpl.$$$reportNull$$$0(2);
        }
        return documentImpl;
    }

    public int getLineNumber(int offset) {
        if (offset > this.myDocument.getTextLength()) {
            LOG.error(String.format("Invalid offset detected (%d). Document length: %d. Target file: %s", offset, this.myDocument.getTextLength(), this.myFile));
        }
        return this.myDocument.getLineNumber(offset);
    }

    public int getLineStartOffset(int line) {
        return this.myDocument.getLineStartOffset(line);
    }

    public CharSequence getText(TextRange textRange) {
        if (textRange.getStartOffset() < 0 || textRange.getEndOffset() > this.myDocument.getTextLength()) {
            LOG.error(String.format("Please submit a ticket to the tracker and attach current source file to it!%nInvalid processing detected: given text range (%s) targets non-existing regions (the boundaries are [0; %d)). File's language: %s", textRange, this.myDocument.getTextLength(), this.myFile.getLanguage()));
        }
        return this.myDocument.getCharsSequence().subSequence(textRange.getStartOffset(), textRange.getEndOffset());
    }

    public int getTextLength() {
        return this.myDocument.getTextLength();
    }

    @NotNull
    public Document getDocument() {
        Document document = this.myDocument;
        if (document == null) {
            FormattingDocumentModelImpl.$$$reportNull$$$0(3);
        }
        return document;
    }

    public PsiFile getFile() {
        return this.myFile;
    }

    public boolean containsWhiteSpaceSymbolsOnly(int startOffset, int endOffset) {
        WhiteSpaceFormattingStrategy localStrategy;
        Language injectedLanguage;
        PsiElement injectedElement;
        WhiteSpaceFormattingStrategy strategy = this.myWhiteSpaceStrategy;
        if (strategy.check(this.myDocument.getCharsSequence(), startOffset, endOffset) >= endOffset) {
            return true;
        }
        PsiElement psiElement = injectedElement = this.myFile != null ? InjectedLanguageUtil.findElementAtNoCommit(this.myFile, startOffset) : null;
        if (injectedElement != null && !(injectedLanguage = injectedElement.getLanguage()).equals(this.myFile.getLanguage()) && (localStrategy = WhiteSpaceFormattingStrategyFactory.getStrategy(injectedLanguage)) != null) {
            String unescapedText = InjectedLanguageUtil.getUnescapedLeafText(injectedElement, true);
            if (unescapedText != null) {
                return localStrategy.check(unescapedText, 0, unescapedText.length()) >= unescapedText.length();
            }
            return localStrategy.check(this.myDocument.getCharsSequence(), startOffset, endOffset) >= endOffset;
        }
        return false;
    }

    @NotNull
    public CharSequence adjustWhiteSpaceIfNecessary(@NotNull CharSequence whiteSpaceText, int startOffset, int endOffset, ASTNode nodeAfter, boolean changedViaPsi) {
        if (whiteSpaceText == null) {
            FormattingDocumentModelImpl.$$$reportNull$$$0(4);
        }
        if (!changedViaPsi) {
            CharSequence charSequence = this.myWhiteSpaceStrategy.adjustWhiteSpaceIfNecessary(whiteSpaceText, this.myDocument.getCharsSequence(), startOffset, endOffset, this.mySettings, nodeAfter);
            if (charSequence == null) {
                FormattingDocumentModelImpl.$$$reportNull$$$0(5);
            }
            return charSequence;
        }
        PsiElement element = this.myFile.findElementAt(startOffset);
        if (element == null) {
            CharSequence charSequence = whiteSpaceText;
            if (charSequence == null) {
                FormattingDocumentModelImpl.$$$reportNull$$$0(6);
            }
            return charSequence;
        }
        CharSequence charSequence = this.myWhiteSpaceStrategy.adjustWhiteSpaceIfNecessary(whiteSpaceText, element, startOffset, endOffset, this.mySettings);
        if (charSequence == null) {
            FormattingDocumentModelImpl.$$$reportNull$$$0(7);
        }
        return charSequence;
    }

    public static boolean canUseDocumentModel(@NotNull Document document, @NotNull PsiFile file2) {
        PsiDocumentManager psiDocumentManager;
        if (document == null) {
            FormattingDocumentModelImpl.$$$reportNull$$$0(8);
        }
        if (file2 == null) {
            FormattingDocumentModelImpl.$$$reportNull$$$0(9);
        }
        return !(psiDocumentManager = PsiDocumentManager.getInstance((Project)file2.getProject())).isUncommited(document) && !psiDocumentManager.isDocumentBlockedByPsi(document) && file2.getText().equals(document.getText());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/formatter/FormattingDocumentModelImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whiteSpaceText";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/formatter/FormattingDocumentModelImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentForNonPhysicalFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustWhiteSpaceIfNecessary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "adjustWhiteSpaceIfNecessary";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "canUseDocumentModel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

