/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.alignment.AlignmentStrategy;
import com.intellij.lang.ASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.formatter.java.AbstractJavaBlock;
import com.intellij.psi.formatter.java.ChildAlignmentStrategyProvider;
import com.intellij.psi.formatter.java.SyntheticCodeBlock;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.StdTokenSets;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeBlockBlock
extends AbstractJavaBlock {
    private static final int BEFORE_FIRST = 0;
    private static final int BEFORE_LBRACE = 1;
    private static final int INSIDE_BODY = 2;
    private final int myChildrenIndent;

    public CodeBlockBlock(ASTNode node, Wrap wrap, Alignment alignment, Indent indent, CommonCodeStyleSettings settings, JavaCodeStyleSettings javaSettings) {
        super(node, wrap, CodeBlockBlock.getAlignmentStrategy(alignment, node, settings), indent, settings, javaSettings);
        this.myChildrenIndent = this.isSwitchCodeBlock() && !settings.INDENT_CASE_FROM_SWITCH ? 0 : 1;
    }

    private static AlignmentStrategy getAlignmentStrategy(Alignment alignment, ASTNode baseNode, @NotNull CommonCodeStyleSettings settings) {
        if (settings == null) {
            CodeBlockBlock.$$$reportNull$$$0(0);
        }
        if (baseNode.getElementType() != JavaElementType.CLASS || !settings.ALIGN_MULTILINE_EXTENDS_LIST) {
            return AlignmentStrategy.wrap(alignment, new IElementType[0]);
        }
        ASTNode node = baseNode.getLastChildNode();
        while (node != null) {
            if (node.getElementType() == JavaElementType.IMPLEMENTS_LIST) {
                ASTNode lastChildNode = node.getLastChildNode();
                if (lastChildNode == null || lastChildNode.getElementType() != TokenType.ERROR_ELEMENT) break;
                Alignment alignmentToUse = alignment;
                if (alignment == null) {
                    alignmentToUse = Alignment.createAlignment();
                }
                return AlignmentStrategy.wrap(alignmentToUse, false, JavaTokenType.LBRACE, JavaElementType.JAVA_CODE_REFERENCE, node.getElementType());
            }
            node = FormatterUtil.getPreviousNonWhitespaceSibling(node);
        }
        return AlignmentStrategy.wrap(alignment, new IElementType[0]);
    }

    private boolean isSwitchCodeBlock() {
        return this.myNode.getTreeParent().getElementType() == JavaElementType.SWITCH_STATEMENT;
    }

    @Override
    protected List<Block> buildChildren() {
        ArrayList<Block> result2 = new ArrayList<Block>();
        Alignment childAlignment = this.createChildAlignment();
        Wrap childWrap = this.createChildWrap();
        this.buildChildren(result2, childAlignment, childWrap);
        return result2;
    }

    private void buildChildren(List<Block> result2, Alignment childAlignment, Wrap childWrap) {
        ASTNode child = this.myNode.getFirstChildNode();
        int state = 0;
        if (this.myNode.getPsi() instanceof PsiSyntheticClass) {
            state = 2;
        }
        ChildAlignmentStrategyProvider provider = this.getStrategyProvider();
        while (child != null) {
            if (!FormatterUtil.containsWhiteSpacesOnly(child) && child.getTextLength() > 0) {
                AlignmentStrategy alignmentStrategy = provider.getNextChildStrategy(child);
                Indent indent = this.calcCurrentIndent(child, state);
                state = CodeBlockBlock.calcNewState(child, state);
                child = child.getElementType() == JavaElementType.SWITCH_LABEL_STATEMENT ? this.processCaseAndStatementAfter(result2, child, childAlignment, childWrap, indent) : ((this.myNode.getPsi() instanceof PsiClass || this.myNode.getPsi() instanceof PsiJavaModule) && child.getElementType() == JavaTokenType.LBRACE ? this.composeCodeBlock(result2, child, this.getCodeBlockExternalIndent(), this.myChildrenIndent, null) : (this.myNode.getElementType() == JavaElementType.CODE_BLOCK && child.getElementType() == JavaTokenType.LBRACE && this.myNode.getTreeParent().getElementType() == JavaElementType.METHOD ? this.composeCodeBlock(result2, child, indent, this.myChildrenIndent, childWrap) : this.processChild(result2, child, alignmentStrategy, childWrap, indent)));
            }
            if (child == null) continue;
            child = child.getTreeNext();
        }
    }

    @Nullable
    private ASTNode processCaseAndStatementAfter(List<Block> result2, ASTNode child, Alignment childAlignment, Wrap childWrap, Indent indent) {
        ArrayList<Block> localResult = new ArrayList<Block>();
        this.processChild(localResult, child, AlignmentStrategy.getNullStrategy(), null, Indent.getNoneIndent());
        Indent childIndent = Indent.getNormalIndent();
        for (child = child.getTreeNext(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() == JavaElementType.SWITCH_LABEL_STATEMENT || CodeBlockBlock.isRBrace(child)) {
                result2.add(this.createCaseSectionBlock(localResult, childAlignment, indent, childWrap));
                return child.getTreePrev();
            }
            if (FormatterUtil.containsWhiteSpacesOnly(child)) continue;
            if (child.getElementType() == JavaElementType.BLOCK_STATEMENT) {
                childIndent = Indent.getNoneIndent();
            }
            boolean breakOrReturn = CodeBlockBlock.isBreakOrReturn(child);
            this.processChild(localResult, child, AlignmentStrategy.getNullStrategy(), null, childIndent);
            if (!breakOrReturn) continue;
            result2.add(this.createCaseSectionBlock(localResult, childAlignment, indent, childWrap));
            return child;
        }
        result2.add(this.createCaseSectionBlock(localResult, childAlignment, indent, childWrap));
        return null;
    }

    private static boolean isBreakOrReturn(ASTNode child) {
        IElementType elementType = child.getElementType();
        return JavaElementType.BREAK_STATEMENT == elementType || JavaElementType.RETURN_STATEMENT == elementType;
    }

    private SyntheticCodeBlock createCaseSectionBlock(List<Block> localResult, Alignment childAlignment, Indent indent, Wrap childWrap) {
        SyntheticCodeBlock result2 = new SyntheticCodeBlock(localResult, childAlignment, this.getSettings(), this.myJavaSettings, indent, childWrap){

            @Override
            @NotNull
            public ChildAttributes getChildAttributes(int newChildIndex) {
                Block previousBlock;
                IElementType prevElementType = null;
                if (newChildIndex > 0 && (previousBlock = this.getSubBlocks().get(newChildIndex - 1)) instanceof AbstractBlock) {
                    prevElementType = ((AbstractBlock)previousBlock).getNode().getElementType();
                }
                if (prevElementType == JavaElementType.BLOCK_STATEMENT || prevElementType == JavaElementType.BREAK_STATEMENT || prevElementType == JavaElementType.RETURN_STATEMENT) {
                    ChildAttributes childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
                    if (childAttributes == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return childAttributes;
                }
                ChildAttributes childAttributes = super.getChildAttributes(newChildIndex);
                if (childAttributes == null) {
                    1.$$$reportNull$$$0(1);
                }
                return childAttributes;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/formatter/java/CodeBlockBlock$1", "getChildAttributes"));
            }
        };
        result2.setChildAttributes(new ChildAttributes(Indent.getNormalIndent(), null));
        result2.setIsIncomplete(true);
        return result2;
    }

    private static int calcNewState(ASTNode child, int state) {
        switch (state) {
            case 0: {
                if (StdTokenSets.COMMENT_BIT_SET.contains(child.getElementType())) {
                    return 0;
                }
                if (child.getElementType() == JavaTokenType.LBRACE) {
                    return 2;
                }
                return 1;
            }
            case 1: {
                if (child.getElementType() == JavaTokenType.LBRACE) {
                    return 2;
                }
                return 1;
            }
        }
        return 2;
    }

    private Indent calcCurrentIndent(ASTNode child, int state) {
        IElementType elementType = child.getElementType();
        if (CodeBlockBlock.isRBrace(child) || elementType == JavaTokenType.AT) {
            return Indent.getNoneIndent();
        }
        if (state == 0) {
            return Indent.getNoneIndent();
        }
        if (elementType == JavaElementType.SWITCH_LABEL_STATEMENT) {
            return this.getCodeBlockInternalIndent(this.myChildrenIndent);
        }
        if (state == 1) {
            if (elementType == JavaTokenType.LBRACE || elementType == JavaTokenType.CLASS_KEYWORD || elementType == JavaTokenType.INTERFACE_KEYWORD || elementType == JavaTokenType.IDENTIFIER || elementType == JavaTokenType.ENUM_KEYWORD || elementType == JavaTokenType.MODULE_KEYWORD || elementType == JavaElementType.MODULE_REFERENCE) {
                return Indent.getNoneIndent();
            }
            return Indent.getContinuationIndent((boolean)this.myIndentSettings.USE_RELATIVE_INDENTS);
        }
        return this.getCodeBlockInternalIndent(this.myChildrenIndent);
    }

    @Override
    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        if (this.isAfter(newChildIndex, new IElementType[]{JavaDocElementType.DOC_COMMENT, JavaElementType.MODIFIER_LIST})) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
            if (childAttributes == null) {
                CodeBlockBlock.$$$reportNull$$$0(1);
            }
            return childAttributes;
        }
        if (this.getSubBlocks().size() == newChildIndex) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
            if (childAttributes == null) {
                CodeBlockBlock.$$$reportNull$$$0(2);
            }
            return childAttributes;
        }
        ChildAttributes childAttributes = new ChildAttributes(this.getCodeBlockInternalIndent(this.myChildrenIndent), null);
        if (childAttributes == null) {
            CodeBlockBlock.$$$reportNull$$$0(3);
        }
        return childAttributes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/formatter/java/CodeBlockBlock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/formatter/java/CodeBlockBlock";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAlignmentStrategy";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

